/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeEvaluator
extends ES6TypeEvaluator {
    private static final Condition<PsiElement> HAS_DECLARATIONS = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return TypeScriptTypeEvaluator.hasInnerDeclarations(element);
        }
    };

    public TypeScriptTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor, boolean ecma) {
        super(context, processor, ecma);
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptPropertySignature) {
            JSTypeDeclaration propertyType = ((TypeScriptPropertySignature)resolveResult).getTypeDeclaration();
            if (propertyType instanceof JSFunction) {
                this.processFunction((JSFunction)propertyType);
            } else if (propertyType != null) {
                JSType jsType = TypeScriptTypeParser.buildTypeFromTypeScript(propertyType);
                this.addType(jsType, resolveResult);
            }
            return true;
        }
        if (resolveResult instanceof TypeScriptModule) {
            this.addTypeFromModule((TypeScriptModule)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptImportStatement) {
            this.addTypeFromImportStatement((TypeScriptImportStatement)resolveResult);
            return true;
        }
        if (resolveResult instanceof TypeScriptCallSignature) {
            JSElement peek = this.myContext.peekJSElementToApply();
            if (peek instanceof JSCallExpression) {
                this.myContext.popJSElementToApply();
                this.addType(((TypeScriptCallSignature)resolveResult).getReturnType(), resolveResult);
                this.myContext.pushJSElementToApply(peek);
            }
            return true;
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    private void addTypeFromModule(TypeScriptModule resolveResult) {
        boolean isJavaScriptContext;
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        boolean hasType = false;
        String name = resolveResult.getName();
        if (name != null && this.myTypeProcessor instanceof PsiScopeProcessor) {
            Collection<? extends PsiElement> elements = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)expression).getElements();
            for (PsiElement psiElement : elements) {
                if (psiElement.isEquivalentTo((PsiElement)resolveResult)) continue;
                if (TypeScriptTypeEvaluator.hasInnerDeclarations(psiElement)) {
                    hasType = true;
                    continue;
                }
                this.addTypeFromResolveResult(psiElement, false);
            }
        }
        if (this.shouldAddLocalModule(hasType, isJavaScriptContext = DialectDetector.isJavaScript((PsiElement)expression))) {
            this.addTypeFromLocalModule((JSQualifiedNamedElement)resolveResult, isJavaScriptContext);
        }
    }

    private boolean shouldAddLocalModule(boolean hasType, boolean isJavaScriptContext) {
        return !(this.myTypeProcessor instanceof PsiScopeProcessor) || isJavaScriptContext || hasType || !this.isPrototypeOrNewExpression() && !(this.myContext.peekJSElementToApply() instanceof JSCallExpression);
    }

    private void addTypeFromLocalModule(@NotNull JSQualifiedNamedElement resolveResult, boolean isJavaScriptContext) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromLocalModule"));
        }
        String name = resolveResult.getQualifiedName();
        if (!StringUtil.isEmpty((String)name)) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult.getParent(), true);
            JSType jsType = JSNamedType.createType(name, source, isJavaScriptContext ? JSContext.UNKNOWN : JSContext.STATIC);
            this.addType(jsType, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromImportStatement(TypeScriptImportStatement resolveResult) {
        if (this.myContext.isAlreadyProcessingItem((PsiElement)resolveResult)) {
            return;
        }
        this.myContext.addProcessingItem((PsiElement)resolveResult);
        TypeScriptEntityName internalModuleReference = resolveResult.getInternalModuleReference();
        TypeScriptExternalModuleReference externalModuleReference = resolveResult.getExternalModuleReference();
        if (internalModuleReference != null) {
            Collection<PsiElement> elements = JSResolveResult.toElements(internalModuleReference.multiResolve(false));
            this.addTypeFromInternalModules(elements);
        } else if (externalModuleReference != null) {
            Collection elements = externalModuleReference.multiResolve();
            for (PsiElement element : elements) {
                this.addTypeFromExternalModuleReferenceResolveResult(element);
            }
        }
        this.myContext.removeProcessingItem((PsiElement)resolveResult);
    }

    private void addTypeFromInternalModules(Collection<PsiElement> elements) {
        boolean isJavaScriptContext;
        boolean hasType;
        JSReferenceExpression expression;
        if (elements.size() == 0) {
            return;
        }
        if (elements.size() == 1) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            assert (item != null);
            this.addTypeFromResolveResult(item, false);
        }
        if ((expression = this.myContext.getProcessedExpression()) == null) {
            return;
        }
        List modules = ContainerUtil.filter(elements, TypeScriptPsiUtil.IS_TS_MODULE);
        if (modules.size() > 0 && this.shouldAddLocalModule(hasType = ContainerUtil.filter(elements, HAS_DECLARATIONS).size() > 0, isJavaScriptContext = DialectDetector.isJavaScript((PsiElement)expression))) {
            JSQualifiedNamedElement module = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((List)modules);
            assert (module != null);
            this.addTypeFromLocalModule(module, isJavaScriptContext);
        }
        for (PsiElement element : elements) {
            if (element instanceof TypeScriptModule) continue;
            this.addTypeFromResolveResult(element, false);
        }
    }

    @Override
    protected boolean qualifierTypeIsExplicitlyDeclared(@Nullable JSExpression qualifier) {
        if (qualifier == null || !DialectDetector.isTypeScript((PsiElement)qualifier)) {
            return true;
        }
        return TypeScriptUtil.qualifierTypeIsExplicitlyDeclared(qualifier);
    }

    @Override
    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve != null && DialectDetector.isTypeScript(resolve)) {
            PsiFile file = resolve.getContainingFile();
            if (file == null) {
                return;
            }
            TypeScriptExportAssignment exportAssignment = TypeScriptPsiUtil.findExportAssignment(resolve);
            if (resolve instanceof JSFile) {
                if (exportAssignment == null) {
                    this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
                }
            } else if (resolve instanceof TypeScriptModule && exportAssignment == null) {
                this.addTypeFromResolveResult(resolve, true);
            }
            if (exportAssignment != null) {
                this.evaluateExportAssignment((JSExportAssignment)exportAssignment);
            }
        } else {
            super.addTypeFromExternalModuleReferenceResolveResult(resolve);
        }
    }

    @Override
    protected void evaluateExportAssignment(JSExportAssignment assignment) {
        String reference;
        if (assignment instanceof TypeScriptExportAssignment && (reference = assignment.getInitializerReference()) != null) {
            List<PsiElement> elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)assignment);
            for (PsiElement element : elements) {
                this.addTypeFromResolveResult(element, false);
            }
            if (!elements.isEmpty()) {
                return;
            }
        }
        super.evaluateExportAssignment(assignment);
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawQualifier) {
        if (rawQualifier instanceof TypeScriptCastExpression) {
            TypeScriptType typeScriptType = ((TypeScriptCastExpression)rawQualifier).getType();
            if (typeScriptType != null) {
                JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)typeScriptType);
                this.addType(type, (PsiElement)rawQualifier);
                return true;
            }
        } else if (rawQualifier instanceof TypeScriptNotNullExpression) {
            this.evaluateTypes(((TypeScriptNotNullExpression)rawQualifier).getExpression());
            return true;
        }
        return super.evaluateDialectSpecificTypes(rawQualifier);
    }

    @Override
    protected void addTypeFromClassExpression(@NotNull JSClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromClassExpression"));
        }
        if (DialectDetector.isTypeScript((PsiElement)aClass)) {
            this.addTypeFromClass((PsiElement)aClass, null);
            return;
        }
        super.addTypeFromClassExpression(aClass);
    }

    @Override
    protected void addTypeFromClass(@NotNull PsiElement resolveResult, @Nullable PsiElement constructor) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromClass"));
        }
        if (!DialectDetector.isTypeScript(resolveResult)) {
            super.addTypeFromClass(resolveResult, constructor);
            return;
        }
        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
        if (resolveResult instanceof TypeScriptInterface && processedExpression != null) {
            this.processAllIdenticallyNamedElements((PsiElement)processedExpression, resolveResult);
        } else if (resolveResult instanceof JSClass) {
            JSRecordType type;
            JSClass jsClass = (JSClass)resolveResult;
            String qName = jsClass.getQualifiedName();
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            if (qName == null) {
                type = TypeScriptTypeParser.buildTypeFromClass(jsClass, true);
            } else {
                JSContext staticOrInstance = this.isPrototypeOrNewExpression() ? JSContext.INSTANCE : JSContext.STATIC;
                type = JSNamedType.createType(qName, typeSource, staticOrInstance);
            }
            PsiElement source = this.getSourceForTypeContext(resolveResult, processedExpression);
            type = this.applyGenericsFromConstructorCall((PsiElement)jsClass, (JSType)type, constructor);
            this.addType((JSType)type, source);
        } else if (resolveResult instanceof JSFunction) {
            JSType returnType;
            if (resolveResult.getParent() instanceof TypeScriptInterface && (returnType = ((JSFunction)resolveResult).getReturnType()) != null) {
                this.addType(returnType, resolveResult);
            } else {
                this.addTypeFromClass(resolveResult.getParent(), resolveResult);
            }
        }
    }

    protected JSType applyGenericsFromConstructorCall(@NotNull PsiElement typeOwner, @NotNull JSType type, @Nullable PsiElement callFunction) {
        JSElement element;
        TypeScriptTypeParameter[] parameters;
        if (typeOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeOwner", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "applyGenericsFromConstructorCall"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "applyGenericsFromConstructorCall"));
        }
        if (callFunction == null || !(typeOwner instanceof TypeScriptTypeParameterListOwner)) {
            return type;
        }
        TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)typeOwner).getTypeParameterList();
        if (list != null && (parameters = list.getTypeParameters()).length > 0 && !this.myContext.isJSElementsToApplyEmpty() && (element = this.myContext.peekJSElementToApply()) instanceof TypeScriptNewExpression && !JSTypeUtils.hasTypeArguments((JSCallExpression)((TypeScriptNewExpression)element))) {
            ArrayList generics = ContainerUtil.newArrayList();
            for (TypeScriptTypeParameter parameter : parameters) {
                String name;
                TypeScriptType constraint = parameter.getTypeConstraint();
                JSType constraintType = null;
                if (constraint != null) {
                    constraintType = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)constraint);
                }
                if ((name = parameter.getName()) == null) continue;
                generics.add(new JSGenericParameterImpl(name, JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true), constraintType));
            }
            JSGenericTypeImpl resultType = new JSGenericTypeImpl(type.getSource(), type, generics);
            resultType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(resultType, (JSExpression)this.myContext.getProcessedExpression(), callFunction);
            return resultType;
        }
        return type;
    }

    private PsiElement getSourceForTypeContext(PsiElement resolveResult, JSReferenceExpression processedExpression) {
        return processedExpression != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)this.myContext.targetFile) ? processedExpression : resolveResult;
    }

    private void processAllIdenticallyNamedElements(@NotNull PsiElement expression, @NotNull PsiElement resolveResult) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processAllIdenticallyNamedElements"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "processAllIdenticallyNamedElements"));
        }
        if (!(this.myTypeProcessor instanceof PsiScopeProcessor)) {
            return;
        }
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            ((ResolveProcessor)((Object)this.myTypeProcessor)).prefixResolved();
        }
        boolean result = true;
        if (!this.skipCallContextIfModule(resolveResult) && TypeScriptTypeEvaluator.hasInnerDeclarations(resolveResult)) {
            result = JSResolveUtil.processDeclarationsInScope((JSElement)((JSQualifiedNamedElement)resolveResult), (PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), resolveResult, expression);
        }
        if (result && resolveResult.getContainingFile() == expression.getContainingFile()) {
            String name = ((JSQualifiedNamedElement)resolveResult).getQualifiedName();
            if (name == null) {
                return;
            }
            this.addIdenticalNameElements(expression, resolveResult, name);
        }
    }

    private void addIdenticalNameElements(@NotNull PsiElement expression, @Nullable PsiElement resolveResult, String name) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addIdenticalNameElements"));
        }
        Collection<? extends PsiElement> elements = TypeScriptImportHandler.getInstance().resolveName(name, expression).getElements();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || psiElement.equals(resolveResult) || this.skipCallContextIfModule(psiElement)) continue;
            if (!TypeScriptTypeEvaluator.hasInnerDeclarations(psiElement)) {
                this.addTypeFromResolveResult(psiElement, false);
                continue;
            }
            if (!(this.myTypeProcessor instanceof PsiScopeProcessor) || psiElement.processDeclarations((PsiScopeProcessor)this.myTypeProcessor, ResolveState.initial(), psiElement, expression)) continue;
            break;
        }
    }

    private static boolean hasInnerDeclarations(PsiElement element) {
        return !(element instanceof JSVariable) && !(element instanceof JSFunction);
    }

    private boolean skipCallContextIfModule(PsiElement resolveResult) {
        return resolveResult instanceof TypeScriptModule && !this.myContext.isJSElementsToApplyEmpty() && !(this.myContext.peekJSElementToApply() instanceof JSNewExpression);
    }

    @Override
    protected void addTypeFromES6ImportBindingReference(PsiElement referencedElement) {
        if (referencedElement instanceof TypeScriptModule) {
            this.addTypeFromLocalModule((JSQualifiedNamedElement)((TypeScriptModule)referencedElement), false);
        } else if (referencedElement instanceof ES6ExportDefaultAssignment) {
            if (((ES6ExportDefaultAssignment)referencedElement).getStubSafeExpression() instanceof TypeScriptClass) {
                TypeScriptClass tsClass = (TypeScriptClass)((ES6ExportDefaultAssignment)referencedElement).getStubSafeExpression();
                if (tsClass != null) {
                    this.myTypeProcessor.processResolvedElement((PsiElement)tsClass.getContainingFile(), this.myContext);
                    this.addTypeFromResolveResult((PsiElement)tsClass, false);
                }
            } else {
                super.addTypeFromES6ImportBindingReference(referencedElement);
            }
        } else {
            super.addTypeFromES6ImportBindingReference(referencedElement);
        }
    }

    @Override
    @Nullable
    protected JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSArrayType || type == null) {
            return super.addComponentTypeFromProcessor(rawqualifier, type);
        }
        if (!(rawqualifier instanceof JSIndexedPropertyAccessExpression)) {
            return super.addComponentTypeFromProcessor(rawqualifier, type);
        }
        JSRecordType recordType = type.asRecordType();
        if (recordType.getTypeMembers().isEmpty()) {
            return super.addComponentTypeFromProcessor(rawqualifier, type);
        }
        ArrayList indexSignatures = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
            if (!(member instanceof JSRecordType.IndexSignature)) continue;
            indexSignatures.add((JSRecordType.IndexSignature)member);
        }
        JSAnyType result = null;
        if (indexSignatures.size() > 0) {
            JSType expressionTypeType;
            JSTypeEvaluationResult expressionTypeResult;
            JSExpression expression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression();
            JSTypeEvaluationResult jSTypeEvaluationResult = expressionTypeResult = expression != null ? JSTypeEvaluator.getExpressionType(expression) : null;
            if (expressionTypeResult != null && (expressionTypeType = expressionTypeResult.getType()) != null) {
                for (JSRecordType.IndexSignature signature : indexSignatures) {
                    if (!JSResolveUtil.isAssignableJSType(signature.getParameterType(), expressionTypeType)) continue;
                    result = signature.getType();
                    break;
                }
            }
        }
        if (result == null) {
            result = JSAnyType.get((PsiElement)rawqualifier, false);
        }
        this.addType(result, (PsiElement)rawqualifier);
        return result;
    }

    @Override
    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromLiteralExpression"));
        }
        if (DialectDetector.isTypeScript((PsiElement)rawqualifier) && rawqualifier instanceof JSXmlLiteralExpressionImpl) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, true), (PsiElement)rawqualifier);
            return;
        }
        super.addTypeFromLiteralExpression(rawqualifier);
    }

    @Override
    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        ResolveResult[] resolveResult = super.getResolveResultsFromQualifier(qualifier);
        boolean hasModules = false;
        for (ResolveResult result : resolveResult) {
            if (!(result.getElement() instanceof TypeScriptModule)) continue;
            hasModules = true;
            break;
        }
        if (!hasModules) {
            if (resolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
            }
            return resolveResult;
        }
        ArrayList newResults = ContainerUtil.newArrayListWithCapacity((int)resolveResult.length);
        HashSet visitedQualifiers = ContainerUtil.newHashSet();
        for (ResolveResult result : resolveResult) {
            PsiElement element = result.getElement();
            if (!(element instanceof TypeScriptModule)) {
                newResults.add(result);
                continue;
            }
            TypeScriptModule module = (TypeScriptModule)element;
            if (!visitedQualifiers.add(module.getQualifiedName())) continue;
            newResults.add(result);
        }
        ResolveResult[] resolveResultArray = newResults.size() == resolveResult.length ? resolveResult : (ResolveResult[])ContainerUtil.toArray((List)newResults, (Object[])new ResolveResult[newResults.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        return resolveResultArray;
    }

    @Override
    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator", "addTypeFromAmdModuleReference"));
        }
        return !DialectDetector.isTypeScript((PsiElement)parameter) && super.addTypeFromAmdModuleReference(parameter);
    }

    @Override
    protected void addModuleFromRequire(PsiElement module, JSCallExpression callExpression) {
        if (DialectDetector.isTypeScript((PsiElement)callExpression) && !DialectDetector.isTypeScript(module)) {
            return;
        }
        super.addModuleFromRequire(module, callExpression);
    }

    @Override
    protected JSType substituteThisType(JSType type, JSVariable jsVariable) {
        JSType parentType;
        if (!JSTypeUtils.hasThisGenericType(type)) {
            return type;
        }
        final JSClass context = JSResolveUtil.getClassOfContext((PsiElement)jsVariable);
        JSTypeSource source = type.getSource();
        if (context == null) {
            return type;
        }
        String name = context.getQualifiedName();
        JSType jSType = parentType = name == null ? null : JSNamedType.createType(name, source, JSContext.INSTANCE);
        if (parentType == null) {
            return type;
        }
        return type.transformTypeHierarchy((Function)new Function<JSType, JSType>(){

            public JSType fun(JSType jsType) {
                JSTypeSource currentSource;
                if (jsType instanceof TypeScriptGenericThisTypeImpl && (currentSource = jsType.getSource()).getSourceElement() != context) {
                    JSTypeSource newSource = JSTypeSourceFactory.createTypeSource((PsiElement)context, currentSource.isExplicitlyDeclared());
                    return new TypeScriptGenericThisTypeImpl(newSource, parentType);
                }
                return jsType;
            }
        }, null);
    }
}

