/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSSuperExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptUtil {
    public static final FileType[] TYPESCRIPT_FILE_TYPES_ARRAY = new FileType[]{TypeScriptFileType.INSTANCE, TypeScriptJSXFileType.INSTANCE};
    public static final Collection<FileType> TYPESCRIPT_FILE_TYPES = ContainerUtil.newArrayList((Object[])TYPESCRIPT_FILE_TYPES_ARRAY);
    public static final String TYPESCRIPT_FILE_EXTENSION = ".ts";
    public static final String TYPESCRIPT_JSX_FILE_EXTENSION = ".tsx";
    public static final String TYPESCRIPT_DECLARATIONS_FILE_EXTENSION = ".d.ts";
    public static final String TYPESCRIPT_DECLARATIONS_JSX_FILE_EXTENSION = ".d.tsx";
    public static final String[] TYPESCRIPT_EXTENSIONS = new String[]{".ts", ".tsx", ".d.ts"};
    public static final String COMPILER_DIRECTORY_NAME = "typescriptCompiler";
    public static final Function<PsiElement, TypeScriptInterface> TYPESCRIPT_INTERFACE_FILTER = new Function<PsiElement, TypeScriptInterface>(){

        public TypeScriptInterface fun(PsiElement element) {
            return element instanceof TypeScriptInterface ? (TypeScriptInterface)element : null;
        }
    };

    @NotNull
    public static ResolveResult resolveConstructorMatchingArguments(@NotNull JSClass clazz, @NotNull PsiElement methodExpression) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
        }
        TypeScriptResolveProcessor processor = new TypeScriptResolveProcessor("constructor", methodExpression.getContainingFile(), methodExpression);
        processor.setCheckArgumentTypes(true);
        THashSet visitedClasses = new THashSet();
        ArrayDeque<JSClass> classQueue = new ArrayDeque<JSClass>();
        PsiElement parent = methodExpression.getParent();
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            PsiElement element;
            ResolveResult[] results;
            JSClass currentClass = (JSClass)classQueue.poll();
            if (!visitedClasses.add(currentClass.getQualifiedName())) continue;
            JSResolveUtil.processDeclarationsInScope((JSElement)currentClass, processor, ResolveState.initial(), null, methodExpression);
            for (ResolveResult resolveResult : results = ((SinkResolveProcessor)processor).getResultsAsResolveResults()) {
                if (!resolveResult.isValidResult() || !(resolveResult.getElement() instanceof JSFunction)) continue;
                PsiElementResolveResult psiElementResolveResult = new PsiElementResolveResult(resolveResult.getElement(), true);
                if (psiElementResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
                }
                return psiElementResolveResult;
            }
            if (results.length >= 1) {
                ResolveResult resolveResult = results[0];
                if (resolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
                }
                return resolveResult;
            }
            if (currentClass instanceof TypeScriptClass && parent instanceof JSNewExpression && (element = JSSuperExpressionImpl.matchTypeScriptSuperConstructor((JSCallExpression)((JSNewExpression)parent), (TypeScriptClass)currentClass)) != null) {
                PsiElementResolveResult psiElementResolveResult = new PsiElementResolveResult(element, true);
                if (psiElementResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
                }
                return psiElementResolveResult;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        if (parent instanceof JSNewExpression && ((JSNewExpression)parent).getArguments().length == 0) {
            PsiElementResolveResult psiElementResolveResult = new PsiElementResolveResult((PsiElement)clazz, true);
            if (psiElementResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
            }
            return psiElementResolveResult;
        }
        JSFunction[] functions = clazz.getFunctions();
        JSClass resolveResult = clazz;
        boolean constructorFound = false;
        for (JSFunction function : functions) {
            if (!"constructor".equals(function.getName())) continue;
            if (constructorFound) {
                resolveResult = clazz;
                break;
            }
            resolveResult = function;
            constructorFound = true;
        }
        PsiElementResolveResult psiElementResolveResult = new PsiElementResolveResult((PsiElement)resolveResult, false);
        if (psiElementResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveConstructorMatchingArguments"));
        }
        return psiElementResolveResult;
    }

    @Nullable
    public static VirtualFile findFileByReferencePath(final @NotNull PsiFile file, @NotNull String referencePath, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findFileByReferencePath"));
        }
        if (referencePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePath", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findFileByReferencePath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findFileByReferencePath"));
        }
        ConcurrentMap refPathToVirtualFile = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)new CachedValueProvider<ConcurrentMap<String, Object>>(){

            @Nullable
            public CachedValueProvider.Result<ConcurrentMap<String, Object>> compute() {
                ConcurrentMap result = ContainerUtil.newConcurrentMap();
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{file, JSProjectUtil.FILE_SYSTEM_STRUCTURE_MODIFICATION_TRACKER});
            }
        });
        Object value = refPathToVirtualFile.get(referencePath);
        if (value == null) {
            VirtualFile result = TypeScriptUtil.calcFileByReferencePath(file, referencePath);
            refPathToVirtualFile.put(referencePath, result == null ? ObjectUtils.NULL : result);
            return result;
        }
        return TypeScriptUtil.getValue(value);
    }

    @Nullable
    private static VirtualFile getValue(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getValue"));
        }
        if (object instanceof VirtualFile) {
            return (VirtualFile)object;
        }
        return null;
    }

    @Nullable
    private static VirtualFile calcFileByReferencePath(@NotNull PsiFile file, @NotNull String referencePath) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "calcFileByReferencePath"));
        }
        if (referencePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePath", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "calcFileByReferencePath"));
        }
        VirtualFile result = null;
        referencePath = StringUtil.replaceChar((String)referencePath, (char)'\\', (char)'/');
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile dir = virtualFile.getParent();
        if (referencePath.startsWith(".")) {
            if (dir != null) {
                result = TypeScriptUtil.getFileByRelativePath(referencePath, dir);
            }
        } else {
            Project project = file.getProject();
            VirtualFile contentRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(virtualFile, true);
            VirtualFile imported = TypeScriptUtil.findForContentRoot(referencePath, contentRootForFile, dir);
            if (imported == null) {
                for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                    if (!contentRoot.equals(contentRootForFile) && (imported = TypeScriptUtil.findForContentRoot(referencePath, contentRoot, contentRoot)) != null) break;
                }
            }
            result = imported;
        }
        return result;
    }

    @Nullable
    private static VirtualFile findForContentRoot(@NotNull String referencePath, VirtualFile contentRoot, VirtualFile startFrom) {
        VirtualFile contentRootParent;
        if (referencePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePath", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findForContentRoot"));
        }
        VirtualFile imported = null;
        VirtualFile virtualFile = contentRootParent = contentRoot != null ? contentRoot.getParent() : null;
        while (imported == null && startFrom != null && startFrom.isInLocalFileSystem()) {
            imported = TypeScriptUtil.getFileByRelativePath(referencePath, startFrom);
            if (contentRootParent != null && startFrom.equals(contentRootParent)) break;
            startFrom = startFrom.getParent();
        }
        return imported;
    }

    private static VirtualFile getFileByRelativePath(@NotNull String referencePath, VirtualFile currentParent) {
        if (referencePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencePath", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getFileByRelativePath"));
        }
        VirtualFile imported = currentParent.findFileByRelativePath(referencePath);
        if (imported == null || imported.isDirectory()) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_DECLARATIONS_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_JSX_FILE_EXTENSION);
        }
        return imported;
    }

    @NotNull
    public static ResolveResult[] findExternalModule(@NotNull PsiFile refFile, @NotNull String moduleReference, @NotNull Project project) {
        if (refFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refFile", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
        }
        if (moduleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReference", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
        }
        String unquotedModuleName = StringUtil.unquoteString((String)moduleReference);
        String quotedModuleName = TypeScriptUtil.unifyModuleName("\"" + unquotedModuleName + "\"");
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)refFile);
        Collection<JSQualifiedNamedElement> modules = TypeScriptClassResolver.getInstance().findElementsByQName(quotedModuleName, scope);
        if (!modules.isEmpty()) {
            ArrayList result = ContainerUtil.newArrayList();
            for (JSQualifiedNamedElement module : modules) {
                if (!(module instanceof TypeScriptModule) || TypeScriptAugmentationUtil.isExternalModuleAugmentation((TypeScriptModule)module)) continue;
                result.add(new JSResolveResult((PsiElement)module));
            }
            if (!ContainerUtil.isEmpty((Collection)result)) {
                ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
                }
                return resolveResultArray;
            }
        }
        VirtualFile referencedFile = TypeScriptUtil.findFileByReferencePath(refFile, unquotedModuleName, project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (JavaScriptIndex.isAcceptableFile(referencedFile)) {
            assert (referencedFile != null);
            PsiFile psiFile = psiManager.findFile(referencedFile);
            if (psiFile instanceof JSFile && ((JSFile)psiFile).isCommonJSModule()) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)psiFile)};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
                }
                return resolveResultArray;
            }
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "findExternalModule"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static boolean hasExternalModuleWithNameInFileContext(@Nullable String name, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "hasExternalModuleWithNameInFileContext"));
        }
        JSFile file = (JSFile)context.getContainingFile();
        if (file == null || StringUtil.isEmpty((String)name)) {
            return false;
        }
        for (JSSourceElement statement : JSResolveUtil.getSourceElements((PsiElement)file)) {
            TypeScriptModule module;
            String moduleName;
            if (!(statement instanceof TypeScriptModule) || StringUtil.isEmpty((String)(moduleName = (module = (TypeScriptModule)statement).getName())) || !StringUtil.equals((CharSequence)name, (CharSequence)StringUtil.unquoteString((String)moduleName)) || module.isInternal()) continue;
            return true;
        }
        return false;
    }

    public static Collection<TypeScriptModule> getAllExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getAllExternalModules"));
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"", (Project)project, (GlobalSearchScope)JSResolveUtil.getResolveScope(owner), TypeScriptModule.class);
    }

    public static Collection<TypeScriptModule> getMainExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getMainExternalModules"));
        }
        Collection<TypeScriptModule> elements = TypeScriptUtil.getAllExternalModules(project, owner);
        ArrayList result = ContainerUtil.newArrayList();
        for (JSElement jSElement : elements) {
            if (!(jSElement instanceof TypeScriptModule) || ((TypeScriptModule)jSElement).isInternal() || TypeScriptAugmentationUtil.isExternalModuleAugmentation((TypeScriptModule)jSElement)) continue;
            result.add((TypeScriptModule)jSElement);
        }
        return result;
    }

    public static String unifyModuleName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        return StringUtil.replaceChar((String)qualifiedName, (char)'\'', (char)'\"');
    }

    public static JSQualifiedName unifyModuleName(JSQualifiedName qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        boolean containsSingleQuote = false;
        for (JSQualifiedName component = qualifiedName; component != null; component = component.getParent()) {
            if (!StringUtil.containsChar((String)component.getName(), (char)'\'')) continue;
            containsSingleQuote = true;
            break;
        }
        if (containsSingleQuote) {
            String[] components = ((JSQualifiedNameImpl)qualifiedName).toComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i] = StringUtil.replaceChar((String)components[i], (char)'\'', (char)'\"');
            }
        }
        return qualifiedName;
    }

    @NotNull
    public static Collection<JSClass<?>> getNonStrictParents(@NotNull JSClass<?> clazz, boolean includeInterfaces) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNonStrictParents"));
        }
        final ArrayList result = new ArrayList();
        TypeScriptUtil.processClassesInHierarchy(clazz, includeInterfaces, new JSClassHierarchyProcessor(){

            @Override
            public boolean process(JSClass<?> aClass, JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                result.add(aClass);
                return true;
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNonStrictParents"));
        }
        return arrayList;
    }

    public static boolean processClassesInHierarchy(@NotNull JSClass<?> clazz, boolean includeInterfaces, @NotNull JSClassHierarchyProcessor processor) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "processClassesInHierarchy"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "processClassesInHierarchy"));
        }
        return TypeScriptUtil.processClassesInHierarchy(clazz, includeInterfaces, processor, JSTypeSubstitutor.EMPTY, null, ContainerUtil.newHashSet());
    }

    private static boolean processClassesInHierarchy(@NotNull JSClass<?> clazz, boolean includeInterfaces, @NotNull JSClassHierarchyProcessor processor, JSTypeSubstitutor typeSubstitutor, @Nullable Boolean fromImplements, Set<JSClass> visited) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "processClassesInHierarchy"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "processClassesInHierarchy"));
        }
        if (!visited.add(clazz)) {
            return true;
        }
        if (!processor.process(clazz, typeSubstitutor, fromImplements != null && fromImplements != false)) {
            return false;
        }
        ArrayList superReferences = ContainerUtil.newArrayList();
        JSReferenceList extendsList = clazz.getExtendsList();
        JSReferenceList implementsList = includeInterfaces ? clazz.getImplementsList() : null;
        int extendsListElementsLeft = 0;
        if (extendsList != null) {
            superReferences.addAll(extendsList.getResolvedExpressions());
            extendsListElementsLeft = superReferences.size();
        }
        if (implementsList != null) {
            superReferences.addAll(implementsList.getResolvedExpressions());
        }
        for (Pair superReference : superReferences) {
            List<JSType> typeArguments = TypeScriptUtil.buildTypeArguments((JSReferenceListMember)superReference.first);
            boolean currentFromImplements = fromImplements == null ? extendsListElementsLeft-- <= 0 : fromImplements;
            Collection classes = (Collection)superReference.second;
            if (classes == null) continue;
            for (JSClass superClass : classes) {
                JSTypeSubstitutor combinedSubstitutor = TypeScriptUtil.combineSubstitutor(typeSubstitutor, typeArguments, superClass);
                if (includeInterfaces && superClass instanceof TypeScriptTypeAlias) {
                    ArrayList<JSClass> aliasResolves = new ArrayList<JSClass>();
                    TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)superClass, aliasResolves, null);
                    for (JSClass aliasResolve : aliasResolves) {
                        if (!TypeScriptUtil.canInclude(includeInterfaces, aliasResolve) || TypeScriptUtil.processClassesInHierarchy(aliasResolve, includeInterfaces, processor, JSTypeSubstitutor.EMPTY, currentFromImplements, visited)) continue;
                        return false;
                    }
                    continue;
                }
                if (!TypeScriptUtil.canInclude(includeInterfaces, superClass) || TypeScriptUtil.processClassesInHierarchy(superClass, includeInterfaces, processor, combinedSubstitutor, currentFromImplements, visited)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canInclude(boolean includeInterfaces, JSClass superClass) {
        return (includeInterfaces || !(superClass instanceof TypeScriptInterface)) && !"Object".equals(superClass.getName());
    }

    private static List<JSType> buildTypeArguments(@NotNull JSReferenceListMember referenceListMember) {
        if (referenceListMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceListMember", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "buildTypeArguments"));
        }
        JSTypeDeclaration[] typeArgumentDeclarations = referenceListMember.getTypeArguments();
        ArrayList typeArguments = ContainerUtil.newArrayListWithCapacity((int)typeArgumentDeclarations.length);
        for (JSTypeDeclaration typeArgumentDeclaration : typeArgumentDeclarations) {
            typeArguments.add(TypeScriptTypeParser.buildTypeFromTypeScript(typeArgumentDeclaration));
        }
        return typeArguments;
    }

    private static JSTypeSubstitutor combineSubstitutor(JSTypeSubstitutor typeSubstitutor, List<JSType> typeArguments, JSClass superClass) {
        JSTypeSubstitutor combinedSubstitutor;
        TypeScriptTypeParameterList typeParameterList = superClass instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)superClass).getTypeParameterList() : null;
        JSTypeSubstitutor superClassSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterList, typeArguments);
        if (superClassSubstitutor != null) {
            combinedSubstitutor = new JSTypeSubstitutor();
            for (Map.Entry entry : superClassSubstitutor.entrySet()) {
                combinedSubstitutor.put(entry.getKey(), (Object)JSTypeUtils.applyGenericArguments((JSType)entry.getValue(), (Map<String, JSType>)typeSubstitutor));
            }
        } else {
            combinedSubstitutor = JSTypeSubstitutor.EMPTY;
        }
        return combinedSubstitutor;
    }

    @NotNull
    public static Collection<JSClass> resolveAliasesToClass(@NotNull JSClass[] classes, boolean includeInterfaces) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasesToClass"));
        }
        if (classes.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasesToClass"));
            }
            return list;
        }
        if (!includeInterfaces) {
            List list = ContainerUtil.newSmartList((Object[])classes);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasesToClass"));
            }
            return list;
        }
        List result = ContainerUtil.newSmartList();
        for (JSClass currentClass : classes) {
            if (currentClass instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)currentClass, result, null);
                continue;
            }
            result.add(currentClass);
        }
        List list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasesToClass"));
        }
        return list;
    }

    public static void resolveNameToClassesOverAliases(@Nullable String name, @NotNull PsiElement context, @NotNull Collection<JSClass> resultCollection, Collection<JSClass> visitedAliases) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveNameToClassesOverAliases"));
        }
        if (resultCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultCollection", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveNameToClassesOverAliases"));
        }
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveTypeName(name, context);
        for (PsiElement psiElement : result.getElements()) {
            if (!(psiElement instanceof JSClass)) continue;
            if (psiElement instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)psiElement, resultCollection, visitedAliases);
                continue;
            }
            resultCollection.add((JSClass)psiElement);
        }
    }

    private static void resolveAliasToClass(TypeScriptTypeAlias alias, @NotNull Collection<JSClass> resultCollection, Collection<JSClass> visitedAliases) {
        if (resultCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultCollection", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveAliasToClass"));
        }
        JSTypeDeclaration declaration = alias.getTypeDeclaration();
        if (declaration instanceof TypeScriptSingleType) {
            if (visitedAliases == null) {
                visitedAliases = ContainerUtil.newHashSet();
            }
            if (!visitedAliases.add(alias)) {
                return;
            }
            TypeScriptSingleType singleType = (TypeScriptSingleType)declaration;
            TypeScriptUtil.resolveNameToClassesOverAliases(singleType.getQualifiedTypeName(), (PsiElement)alias, resultCollection, visitedAliases);
        }
    }

    @NotNull
    public static Iterable<JSNamedElement> getNamedMembers(@NotNull JSClass<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNamedMembers"));
        }
        Iterable members = aClass.getMembers();
        ArrayList<JSNamedElement> namedElements = new ArrayList<JSNamedElement>();
        for (JSElement member : members) {
            if (!(member instanceof JSNamedElement)) continue;
            namedElements.add((JSNamedElement)member);
        }
        ArrayList<JSNamedElement> arrayList = namedElements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getNamedMembers"));
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyGenericsToType(@NotNull JSType typeInParentClass, @Nullable JSClass surroundClass, @Nullable JSClass parentClass) {
        if (typeInParentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInParentClass", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "applyGenericsToType"));
        }
        if (parentClass != null && surroundClass != null && DialectDetector.isTypeScript((PsiElement)surroundClass)) {
            Ref ref = new Ref((Object)typeInParentClass);
            TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(surroundClass, ContainerUtil.emptyList(), parentClass, (Ref<JSType>)ref);
            JSType jSType = ref.get() == null ? typeInParentClass : (JSType)ref.get();
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "applyGenericsToType"));
            }
            return jSType;
        }
        JSType jSType = typeInParentClass;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "applyGenericsToType"));
        }
        return jSType;
    }

    @NotNull
    public static String buildParameterTypeListStringWithApplyingGenerics(TypeScriptFunction function, final @Nullable JSClass surroundClass) {
        TypeScriptTypeParameterList list;
        final JSClass classOfContext = JSResolveUtil.getClassOfContext((PsiElement)function);
        if (classOfContext != null && (list = function.getTypeParameterList()) != null) {
            String join = StringUtil.join((Object[])list.getTypeParameters(), (Function)new Function<TypeScriptTypeParameter, String>(){

                public String fun(TypeScriptTypeParameter parameter) {
                    if (parameter.getTypeConstraint() != null) {
                        JSType type = TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)parameter.getTypeConstraint());
                        if (JSTypeUtils.hasGenericParameter(type)) {
                            type = TypeScriptUtil.applyGenericsToType(type, surroundClass, classOfContext);
                        }
                        return parameter.getName() + " extends " + type.getTypeText(JSType.TypeTextFormat.CODE);
                    }
                    return parameter.getName();
                }
            }, (String)", ");
            String string = StringUtil.isEmpty((String)join) ? "" : "<" + join + ">";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "buildParameterTypeListStringWithApplyingGenerics"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "buildParameterTypeListStringWithApplyingGenerics"));
        }
        return "";
    }

    @NotNull
    public static Map<JSNamedElement, JSClass> getUnimplementedMembers(JSClass jsClass, final boolean includeOptional) {
        final ArrayList implementedInterfaces = new ArrayList();
        final HashMap typeSubstitutors = ContainerUtil.newHashMap();
        TypeScriptUtil.processClassesInHierarchy(jsClass, true, new JSClassHierarchyProcessor(){

            @Override
            public boolean process(JSClass<?> aClass, JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                JSAttributeList attributeList = aClass.getAttributeList();
                if (includeOptional || fromImplements || attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
                    implementedInterfaces.add(aClass);
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }
        });
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)jsClass);
        LinkedHashMap<Pair, JSClass> membersToImplement = new LinkedHashMap<Pair, JSClass>();
        for (JSClass implementedInterface : implementedInterfaces) {
            ArrayList<Pair> implementedMembers = new ArrayList<Pair>();
            if (implementedInterface instanceof TypeScriptInterface) {
                TypeScriptObjectType body = ((TypeScriptInterface)implementedInterface).getBody();
                if (body == null) continue;
                for (TypeScriptTypeMember typeMember : body.getTypeMembers()) {
                    JSRecordType.TypeMember interfaceTypeMember;
                    if (typeMember instanceof TypeScriptIndexSignature || (interfaceTypeMember = TypeScriptTypeParser.buildTypeMember(typeMember, source)) == null) continue;
                    implementedMembers.add(Pair.create((Object)interfaceTypeMember, (Object)((JSNamedElement)typeMember)));
                }
            } else if (implementedInterface instanceof TypeScriptClass) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)implementedInterface, true);
                for (JSNamedElement classMember : TypeScriptUtil.getNamedMembers(implementedInterface)) {
                    JSRecordType.TypeMember member;
                    if (classMember instanceof TypeScriptIndexSignature || (member = TypeScriptTypeParser.buildTypeMemberFromClassMember(implementedInterface, false, typeSource, (JSElement)classMember, (JSTypeSubstitutor)typeSubstitutors.get(implementedInterface))) == null) continue;
                    implementedMembers.add(Pair.create((Object)member, (Object)classMember));
                }
            }
            JSRecordType classType = TypeScriptTypeParser.buildTypeFromClass(jsClass, false, true, false);
            JSRecordTypeImpl objectType = null;
            ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
            for (Pair implementedMember : implementedMembers) {
                boolean memberIsAlreadyAdded = false;
                for (Pair member : membersToImplement.keySet()) {
                    if (member == null || !((JSRecordType.TypeMember)member.first).isEquivalentTo((JSRecordType.TypeMember)implementedMember.first)) continue;
                    memberIsAlreadyAdded = true;
                    break;
                }
                if (memberIsAlreadyAdded) continue;
                typeMembers.clear();
                typeMembers.add(includeOptional ? TypeScriptUtil.overrideOptionalFlagForTypeMember((JSRecordType.TypeMember)implementedMember.first) : (JSRecordType.TypeMember)implementedMember.first);
                JSRecordTypeImpl type = new JSRecordTypeImpl(source, typeMembers);
                if ((type = type.transformTypeHierarchy((Function)new Function<JSType, JSType>(){

                    public JSType fun(JSType type) {
                        return TypeScriptUtil.setCallEnvironmentIfGenericParameterType(type);
                    }
                }, null)).isDirectlyAssignableType((JSType)classType, null)) continue;
                if (objectType == null) {
                    List<JSClass> objectClasses = TypeScriptClassResolver.getInstance().findObjectClasses(jsClass);
                    for (JSClass objectClass : objectClasses) {
                        JSRecordType currentObjectType = TypeScriptTypeParser.buildTypeFromClass(objectClass, false, false, false);
                        if (objectType == null) {
                            objectType = currentObjectType;
                            continue;
                        }
                        List objectTypeMembers = ContainerUtil.concat((List)objectType.getTypeMembers(), (List)currentObjectType.getTypeMembers());
                        objectType = new JSRecordTypeImpl(objectType.getSource(), objectTypeMembers);
                    }
                    if (objectType == null) {
                        objectType = new JSRecordTypeImpl(source, Collections.emptyList());
                    }
                }
                if (type.isDirectlyAssignableType(objectType, null)) continue;
                membersToImplement.put(implementedMember, implementedInterface);
            }
        }
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (Map.Entry entry : membersToImplement.entrySet()) {
            result.put(((Pair)entry.getKey()).second, entry.getValue());
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getUnimplementedMembers"));
        }
        return linkedHashMap;
    }

    private static JSRecordType.TypeMember overrideOptionalFlagForTypeMember(JSRecordType.TypeMember member) {
        JSRecordType.PropertySignature propertySignature;
        if (member instanceof JSRecordType.PropertySignature && (propertySignature = (JSRecordType.PropertySignature)member).isOptional()) {
            return new JSRecordTypeImpl.PropertySignatureImpl(propertySignature.getName(), propertySignature.getType(), false, propertySignature.getSource());
        }
        return member;
    }

    public static boolean isTypeScriptMethod(PsiElement element) {
        return element instanceof JSFunction && !(element instanceof TypeScriptCallSignature);
    }

    public static boolean isTypeScriptProperty(PsiElement element) {
        return element instanceof TypeScriptPropertySignature || element instanceof JSVariable;
    }

    public static JSType setCallEnvironmentIfGenericParameterType(JSType type) {
        if (type instanceof JSGenericParameterImpl) {
            return JSGenericParameterImpl.cloneWithEnvironment((JSGenericParameterImpl)type, true);
        }
        return type;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        JSType type = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(context), JSContext.INSTANCE);
        String string = TypeScriptUtil.getShortestTypeNameInContext(type, context);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        return string;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull JSType type, @Nullable PsiElement context) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        if (!((type = JSTypeUtils.getValuableType(type)) instanceof JSNamedType) || context == null || type instanceof JSPrimitiveType) {
            String string = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
            }
            return string;
        }
        String text = type.getResolvedTypeText();
        String string = TypeScriptUtil.getShortestTypeNameInContextForQualifiedName(context, text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContext"));
        }
        return string;
    }

    @NotNull
    public static String getShortestTypeNameInContextForQualifiedName(@NotNull PsiElement context, @NotNull String startQName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
        }
        if (startQName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startQName", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
        }
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(startQName);
        if (name.getParent() == null) {
            String string = startQName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
            }
            return string;
        }
        String result = null;
        String qName = null;
        for (JSQualifiedNameImpl current = name; current != null && (StringUtil.isEmpty(result) || !StringUtil.equals((CharSequence)startQName, result)); current = current.getParent()) {
            String currentName = StringUtil.unquoteString((String)current.getName());
            qName = qName == null ? currentName : currentName + "." + qName;
            result = TypeScriptImportHandler.getInstance().getQualifiedNameResolvedType(qName, context);
        }
        if (result != null && StringUtil.equals((CharSequence)startQName, result)) {
            String string = qName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
            }
            return string;
        }
        String string = startQName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getShortestTypeNameInContextForQualifiedName"));
        }
        return string;
    }

    public static boolean hasAmbientExternalModuleInQName(@Nullable String value) {
        return value != null && (value.contains("'") || value.contains("\""));
    }

    public static File getTypeScriptCompilerFolderFile() {
        try {
            String jarPath = PathUtil.getJarPathForClass(TypeScriptUtil.class);
            if (!jarPath.endsWith(".jar")) {
                URL resource = TypeScriptUtil.class.getClassLoader().getResource(COMPILER_DIRECTORY_NAME);
                if (resource == null) {
                    throw new RuntimeException("Cannot find file compiler implementation");
                }
                return new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
            }
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, COMPILER_DIRECTORY_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean resolveIsStrict(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "resolveIsStrict"));
        }
        JSExpression qualifier = node.getQualifier();
        return TypeScriptUtil.qualifierTypeIsExplicitlyDeclared(qualifier);
    }

    public static boolean qualifierTypeIsExplicitlyDeclared(@Nullable JSExpression qualifier) {
        JSType jsType;
        if (qualifier instanceof JSThisExpression && JSContextResolver.findContextElement((JSThisExpression)qualifier) instanceof JSClass || qualifier instanceof JSSuperExpression || qualifier == null) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult result : results = ((JSReferenceExpression)qualifier).multiResolve(false)) {
                PsiElement resolve = result.getElement();
                if (!(resolve instanceof TypeScriptModule) && !(resolve instanceof TypeScriptImportStatement) && !(resolve instanceof ES6ImportedBinding) && !(resolve instanceof ES6ImportSpecifierAlias) && !(resolve instanceof JSFile)) continue;
                return true;
            }
        }
        return TypeScriptUtil.isStrictType(jsType = JSResolveUtil.getExpressionJSType(qualifier));
    }

    public static ProblemHighlightType getProblemHighlightTypeForType(@Nullable JSType type) {
        if (TypeScriptUtil.isStrictType(type)) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    public static boolean isStrictType(JSType jsType) {
        return jsType != null && jsType.getSource().isExplicitlyDeclared() && !JSTypeUtils.hasAnyType(jsType) && !(jsType instanceof JSNullType);
    }

    public static boolean shouldUseES6Lib(@Nullable VirtualFile file, Project project) {
        Collection<TypeScriptConfig> includes;
        if (file != null && !(includes = TypeScriptConfigService.Provider.getConfigInclude(project, file)).isEmpty()) {
            boolean targetES6 = true;
            for (TypeScriptConfig config : includes) {
                targetES6 &= config.getLanguageTarget() == TypeScriptConfig.LanguageTarget.ES6;
            }
            if (targetES6) {
                return true;
            }
        }
        return JSRootConfiguration.getInstance(project).getLanguageLevel().isES6Compatible();
    }

    @Nullable
    public static JSExpression getComputedExpression(@NotNull JSNamedElement element) {
        ASTNode next;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "getComputedExpression"));
        }
        if (element.getName() != null) {
            return null;
        }
        ASTNode lbracket = element.getNode().findChildByType(JSTokenTypes.LBRACKET);
        if (lbracket != null && (next = lbracket.getTreeNext()) != null && JSElementTypes.EXPRESSIONS.contains(next.getElementType())) {
            return (JSExpression)next.getPsi();
        }
        return null;
    }

    public static boolean isNodeModulesDefinition(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isNodeModulesDefinition"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isNodeModulesDefinition"));
        }
        return TypeScriptUtil.isDefinitionFile(file) && TypeScriptUtil.isUnderNodeModules(file, project);
    }

    public static boolean isUnderNodeModules(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isUnderNodeModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isUnderNodeModules"));
        }
        return JSLibraryUtil.isProbableLibraryFile(file, project.getBaseDir());
    }

    public static boolean isDefinitionFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil", "isDefinitionFile"));
        }
        return file.getName().endsWith(TYPESCRIPT_DECLARATIONS_FILE_EXTENSION) || file.getName().endsWith(TYPESCRIPT_DECLARATIONS_JSX_FILE_EXTENSION);
    }

    public static interface JSClassHierarchyProcessor {
        public boolean process(JSClass<?> var1, JSTypeSubstitutor var2, boolean var3);
    }
}

