/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.types.ES6FunctionPropertyElementType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptFunctionParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;

public class TypeScriptExpressionParser
extends ES6ExpressionParser<TypeScriptParser> {
    TypeScriptExpressionParser(TypeScriptParser parser) {
        super(parser);
    }

    @Override
    protected boolean parseUnaryExpression() {
        PsiBuilder.Marker expr = this.builder.mark();
        boolean b = this.parseUnaryExpressionInner();
        if (!b) {
            expr.drop();
            return false;
        }
        while (this.builder.getTokenType() == JSTokenTypes.AS_KEYWORD && this.parseCustomPostfixExpression(expr)) {
            expr = expr.precede();
        }
        expr.drop();
        return true;
    }

    private boolean parseUnaryExpressionInner() {
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            boolean canBeArrow = this.checkCanBeArrowForJSX();
            if (canBeArrow && ((TypeScriptFunctionParser)((TypeScriptParser)this.myJavaScriptParser).getFunctionParser()).parseArrowFunction()) {
                return true;
            }
            if (this.isRegularTypeScript()) {
                PsiBuilder.Marker expr = this.builder.mark();
                this.builder.advanceLexer();
                ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).parseType();
                if (this.builder.getTokenType() != JSTokenTypes.GT) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.gt", (Object[])new Object[0]));
                } else {
                    this.builder.advanceLexer();
                }
                if (!this.parseUnaryExpression()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                expr.done(JSElementTypes.TYPE_ASSERTION);
                return true;
            }
        }
        return super.parseUnaryExpression();
    }

    private boolean checkCanBeArrowForJSX() {
        boolean canBeArrow = true;
        if (!this.isRegularTypeScript() && this.isIdentifierToken(this.builder.lookAhead(1))) {
            IElementType head2 = this.builder.lookAhead(2);
            if (head2 == JSTokenTypes.EXTENDS_KEYWORD) {
                IElementType head3 = this.builder.lookAhead(3);
                if (head3 == JSTokenTypes.EQ || head3 == JSTokenTypes.GT) {
                    canBeArrow = false;
                }
            } else {
                canBeArrow = head2 == JSTokenTypes.COMMA;
            }
        }
        return canBeArrow;
    }

    public boolean isRegularTypeScript() {
        JSLanguageDialect dialect = ((TypeScriptParser)this.myJavaScriptParser).getDialect();
        if (dialect == null) {
            return true;
        }
        return !dialect.getOptionHolder().hasFeature(JSLanguageFeature.E4X);
    }

    @Override
    public boolean parsePrimaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.parseParenthesizedExpression();
            if (this.builder.getTokenType() == JSTokenTypes.LT) {
                this.tryParseTypeArgumentList(true, (IElementType)TypeScriptElementTypes.TYPE_ARGUMENT_LIST);
            }
            return true;
        }
        return super.parsePrimaryExpression();
    }

    @Override
    protected boolean parseQualifiedTypeNameTail(PsiBuilder.Marker expr) {
        expr.drop();
        if (this.builder.getTokenType() == JSTokenTypes.LT && !TypeScriptExpressionParser.hasSemanticLinefeedBefore(this.builder)) {
            return this.tryParseTypeArgumentList(false, (IElementType)TypeScriptElementTypes.TYPE_ARGUMENT_LIST);
        }
        return true;
    }

    @Override
    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef) {
        PsiBuilder.Marker marker;
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            marker = this.builder.mark();
            if (this.tryParseTypeArgumentList(true, (IElementType)TypeScriptElementTypes.TYPE_ARGUMENT_LIST) && this.builder.getTokenType() == JSTokenTypes.LPAR) {
                marker.drop();
                return true;
            }
            marker.rollbackTo();
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXCL && !TypeScriptExpressionParser.hasSemanticLinefeedBefore(this.builder)) {
            this.builder.advanceLexer();
            marker = (PsiBuilder.Marker)markerRef.get();
            marker.done(JSElementTypes.NOT_NULL_EXPRESSION);
            markerRef.set((Object)marker.precede());
            return true;
        }
        return false;
    }

    @Override
    protected IElementType getNewExpressionElementType() {
        return JSElementTypes.TYPESCRIPT_NEW_EXPRESSION;
    }

    @Override
    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.IS_KEYWORD || tokenType == JSTokenTypes.AS_KEYWORD) {
            return -1;
        }
        int x = TypeScriptExpressionParser.getUncollapsedComparisonOperatorsPriority(advance, this.builder);
        if (x > 0) {
            return x;
        }
        return super.getCurrentBinarySignPriority(allowIn, advance);
    }

    @Override
    protected boolean isFunctionPropertyStart() {
        return JSKeywordSets.PROPERTY_NAMES.contains(this.builder.getTokenType()) && this.builder.lookAhead(1) == JSTokenTypes.LT || super.isFunctionPropertyStart();
    }

    @Override
    protected ES6FunctionPropertyElementType getFunctionPropertyElementType() {
        return JSStubElementTypes.TYPESCRIPT_FUNCTION_PROPERTY;
    }

    protected boolean parseCustomPostfixExpression(PsiBuilder.Marker expr) {
        if (this.builder.getTokenType() == JSTokenTypes.AS_KEYWORD && !TypeScriptExpressionParser.hasSemanticLinefeedBefore(this.builder)) {
            this.builder.advanceLexer();
            ((TypeScriptPsiTypeParser)((TypeScriptParser)this.myJavaScriptParser).getTypeParser()).parseType();
            expr.done(JSElementTypes.TYPE_AS_EXPRESSION);
            return true;
        }
        return false;
    }
}

