/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6PsiTypeParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class TypeScriptPsiTypeParser<P extends ES6Parser>
extends ES6PsiTypeParser<P> {
    private static final TokenSet NON_REFERENCE_PRIMITIVE_TYPES = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.VOID_KEYWORD, JSTokenTypes.ANY_KEYWORD, JSTokenTypes.SYMBOL_KEYWORD, JSTokenTypes.MIXED_KEYWORD, JSTokenTypes.NULL_KEYWORD});

    protected TypeScriptPsiTypeParser(P parser) {
        super(parser);
    }

    @Override
    public boolean parseType() {
        return this.parseInUnionOrIntersectionType(true, true);
    }

    private boolean parseInUnionOrIntersectionType(boolean expectedUnion, boolean parentStartParsing) {
        boolean result;
        int typeCounter = 0;
        PsiBuilder.Marker unionTypeMarker = this.builder.mark();
        do {
            if (typeCounter > 0) {
                this.builder.advanceLexer();
            }
            boolean bl = expectedUnion ? this.parseInUnionOrIntersectionType(false, typeCounter == 1) : (result = this.parseDistinctType(parentStartParsing && ++typeCounter == 1));
        } while (result && this.builder.getTokenType() == (expectedUnion ? JSTokenTypes.OR : JSTokenTypes.AND));
        if (typeCounter == 1) {
            unionTypeMarker.drop();
        } else {
            unionTypeMarker.done(TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE);
        }
        return result;
    }

    protected boolean parseDistinctType(boolean regularType) {
        boolean result;
        IElementType type = this.builder.getTokenType();
        PsiBuilder.Marker typeMarker = this.builder.mark();
        boolean expectClosePar = false;
        if (type == JSTokenTypes.LPAR) {
            boolean isFunctionType;
            boolean bl = isFunctionType = regularType && this.isFunctionTypeExpected();
            if (isFunctionType) {
                result = this.parseFunctionType();
            } else {
                expectClosePar = true;
                this.builder.advanceLexer();
                result = this.parseType();
            }
        } else if (type == JSTokenTypes.NEW_KEYWORD || type == JSTokenTypes.LT) {
            result = this.parseFunctionType();
        } else if (type == JSTokenTypes.LBRACE) {
            result = this.parseObjectType();
        } else if (type == JSTokenTypes.LBRACKET) {
            result = this.parseTupleType();
        } else if (NON_REFERENCE_PRIMITIVE_TYPES.contains(type)) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.SINGLE_TYPE);
            result = true;
        } else if (type == JSTokenTypes.TYPEOF_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (!((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            marker.done(TypeScriptElementTypes.TYPEOF_TYPE);
            result = true;
        } else if (type == JSTokenTypes.THIS_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.IS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.THIS_TYPE);
            result = true;
        } else if (type == JSTokenTypes.THIS_KEYWORD || this.isIdentifierToken(type)) {
            if (this.builder.lookAhead(1) == JSTokenTypes.IS_KEYWORD) {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                if (!TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder)) {
                    result = this.parseTypePredicate(marker);
                } else {
                    marker.rollbackTo();
                    result = this.parserSingleType();
                }
            } else {
                result = this.parserSingleType();
            }
        } else if (JSTokenTypes.STRING_LITERALS.contains(type)) {
            ((ES6Parser)this.myJavaScriptParser).buildTokenElement((IElementType)TypeScriptElementTypes.STRING_LITERAL_TYPE);
            result = true;
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.typename", (Object[])new Object[0]));
            result = false;
        }
        if (expectClosePar) {
            if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
                result = false;
            }
        }
        while (this.builder.getTokenType() == JSTokenTypes.LBRACKET && !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder)) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                result = false;
                break;
            }
            this.builder.advanceLexer();
            typeMarker.done(TypeScriptElementTypes.ARRAY_TYPE);
            typeMarker = typeMarker.precede();
        }
        typeMarker.drop();
        return result;
    }

    private boolean parserSingleType() {
        PsiBuilder.Marker marker = this.builder.mark();
        boolean result = ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName();
        marker.done(TypeScriptElementTypes.SINGLE_TYPE);
        return result;
    }

    private boolean parseTypePredicate(PsiBuilder.Marker marker) {
        this.builder.advanceLexer();
        boolean result = this.parseType();
        marker.done(TypeScriptElementTypes.TYPE_PREDICATE);
        return result;
    }

    private boolean isFunctionTypeExpected() {
        IElementType elementTypeAfterRPar;
        IElementType elementTypeAfterLPar = this.builder.lookAhead(1);
        if (elementTypeAfterLPar == null || elementTypeAfterLPar == JSTokenTypes.RPAR) {
            return true;
        }
        if (elementTypeAfterLPar == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        if (!this.isIdentifierToken(elementTypeAfterLPar)) {
            return false;
        }
        IElementType elementTypeAfterIdentifier = this.builder.lookAhead(2);
        if (elementTypeAfterIdentifier == JSTokenTypes.COMMA || elementTypeAfterIdentifier == JSTokenTypes.COLON || elementTypeAfterIdentifier == JSTokenTypes.QUEST) {
            return true;
        }
        return elementTypeAfterIdentifier == JSTokenTypes.RPAR && (elementTypeAfterRPar = this.builder.lookAhead(3)) == JSTokenTypes.EQGT;
    }

    private boolean parseFunctionType() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        boolean result = !((FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterList(true).hasErrors();
        result &= TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.EQGT, "javascript.parser.message.expected.eqgt");
        marker.done(TypeScriptElementTypes.FUNCTION_TYPE);
        return result &= this.parseType();
    }

    private boolean parseTupleType() {
        boolean result = true;
        PsiBuilder.Marker marker = this.builder.mark();
        assert (this.builder.getTokenType() == JSTokenTypes.LBRACKET);
        this.builder.advanceLexer();
        boolean commaExpected = false;
        while (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
            if (this.builder.eof()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                marker.done(TypeScriptElementTypes.TUPLE_TYPE);
                return false;
            }
            if (commaExpected && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.tuple.comma.or.rbracket")) {
                result = false;
                break;
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.typename", (Object[])new Object[0]));
                while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                }
            }
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET && this.allowLastCommaInTupleType()) break;
            if (!this.parseType()) {
                result = false;
                break;
            }
            commaExpected = true;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            result = false;
        }
        marker.done(TypeScriptElementTypes.TUPLE_TYPE);
        return result;
    }

    protected boolean allowLastCommaInTupleType() {
        return false;
    }

    public boolean parseObjectType() {
        PsiBuilder.Marker marker = this.builder.mark();
        assert (this.builder.getTokenType() == JSTokenTypes.LBRACE);
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (this.builder.eof()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
                marker.done(TypeScriptElementTypes.OBJECT_TYPE);
                return false;
            }
            this.parseTypeMember();
        }
        this.builder.advanceLexer();
        marker.done(TypeScriptElementTypes.OBJECT_TYPE);
        return true;
    }

    private boolean parseTypeMember() {
        boolean result;
        IElementType type;
        PsiBuilder.Marker typeMember = this.builder.mark();
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.READONLY_KEYWORD && (type = this.builder.lookAhead(1)) != null && type != JSTokenTypes.COMMA && type != JSTokenTypes.SEMICOLON && type != JSTokenTypes.COLON && type != JSTokenTypes.LPAR) {
            PsiBuilder.Marker attrList = this.builder.mark();
            this.builder.advanceLexer();
            if (!TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder)) {
                attrList.done(JSStubElementTypes.ATTRIBUTE_LIST);
                firstToken = this.builder.getTokenType();
            } else {
                attrList.rollbackTo();
            }
        }
        if (this.isFunctionHeaderStart(firstToken) || firstToken == JSTokenTypes.NEW_KEYWORD && this.isFunctionHeaderStart(this.builder.lookAhead(1))) {
            result = this.parseFunctionHeaderNoMarker(typeMember, (IElementType)JSStubElementTypes.CALL_SIGNATURE);
        } else if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
            this.builder.advanceLexer();
            result = this.parseInterfaceSimplePropertyOrFunction(typeMember);
        } else if (firstToken == JSTokenTypes.LBRACKET) {
            if (this.isIndexSignatureProperty()) {
                return this.parseIndexSignatureNoMarker(typeMember);
            }
            ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
            result = this.parseInterfaceSimplePropertyOrFunction(typeMember);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type.member", (Object[])new Object[0]));
            this.builder.advanceLexer();
            typeMember.drop();
            result = false;
        }
        this.forceCheckForSemicolonOrComma();
        return result;
    }

    protected boolean isFunctionHeaderStart(IElementType token) {
        return token == JSTokenTypes.LPAR || token == JSTokenTypes.LT;
    }

    private void forceCheckForSemicolonOrComma() {
        boolean checkForComma;
        boolean checkForSemicolon = ((StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).checkForSemicolon();
        if (!(checkForSemicolon || (checkForComma = this.checkForComma()) || TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder))) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.newline.or.semicolon", (Object[])new Object[0]));
        }
    }

    private boolean checkForComma() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    private boolean parseInterfaceSimplePropertyOrFunction(PsiBuilder.Marker typeMember) {
        return TypeScriptPsiTypeParser.parseInterfaceSimplePropertyOrFunction(typeMember, this.builder, this);
    }

    public static boolean parseInterfaceSimplePropertyOrFunction(PsiBuilder.Marker typeMember, PsiBuilder builder, TypeScriptPsiTypeParser<?> typeParser) {
        boolean result;
        if (builder.getTokenType() == JSTokenTypes.QUEST) {
            builder.advanceLexer();
        }
        if (typeParser.isFunctionHeaderStart(builder.getTokenType())) {
            result = super.parseFunctionHeaderNoMarker(typeMember, (IElementType)JSStubElementTypes.FUNCTION_SIGNATURE);
        } else {
            result = typeParser.tryParseType();
            typeMember.done(TypeScriptElementTypes.PROPERTY_SIGNATURE);
            typeMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
        return result;
    }

    public boolean isIndexSignatureProperty() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType secondToken = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(secondToken)) {
            return false;
        }
        IElementType thirdToken = this.builder.lookAhead(2);
        return thirdToken == JSTokenTypes.COLON;
    }

    private boolean parseFunctionHeaderNoMarker(PsiBuilder.Marker marker, IElementType elementType) {
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        assert (this.isFunctionHeaderStart(this.builder.getTokenType()));
        boolean result = !((FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterList(false).hasErrors();
        marker.done(elementType);
        return result &= this.tryParseType();
    }

    public boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker) {
        return TypeScriptPsiTypeParser.parseIndexSignatureNoMarker(marker, this.builder, (ES6Parser)this.myJavaScriptParser);
    }

    public static boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, PsiBuilder builder, ES6Parser parser) {
        assert (builder.getTokenType() == JSTokenTypes.LBRACKET);
        builder.advanceLexer();
        ((FunctionParser)parser.getFunctionParser()).parseAttributesList();
        if (!parser.isIdentifierToken(builder.getTokenType())) {
            builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            marker.drop();
            return false;
        }
        builder.advanceLexer();
        boolean result = ((JSPsiTypeParser)parser.getTypeParser()).tryParseType();
        if (builder.getTokenType() != JSTokenTypes.RBRACKET) {
            builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
            marker.drop();
            return false;
        }
        builder.advanceLexer();
        ((StatementParser)parser.getStatementParser()).forceCheckForSemicolon();
        marker.done(TypeScriptElementTypes.INDEX_SIGNATURE);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return result &= ((JSPsiTypeParser)parser.getTypeParser()).tryParseType();
    }

    public boolean isRegularTypeScript() {
        JSLanguageDialect dialect = ((ES6Parser)this.myJavaScriptParser).getDialect();
        if (dialect == null) {
            return true;
        }
        return !dialect.getOptionHolder().hasFeature(JSLanguageFeature.E4X);
    }

    @Override
    public boolean tryParseTypeParameterList() {
        boolean result = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            PsiBuilder.Marker typeParameterList = this.builder.mark();
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                    typeParameterList.drop();
                    return false;
                }
                boolean typeParameterParsed = this.parseTypeParameter();
                result &= typeParameterParsed;
                if (!typeParameterParsed) {
                    this.builder.advanceLexer();
                }
                first = false;
            }
            this.builder.advanceLexer();
            typeParameterList.done(TypeScriptElementTypes.TYPE_PARAMETER_LIST);
        }
        return result;
    }

    protected boolean parseTypeParameter() {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            return false;
        }
        PsiBuilder.Marker typeParameter = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            this.builder.advanceLexer();
            this.parseType();
        }
        typeParameter.done(TypeScriptElementTypes.TYPE_PARAMETER);
        return true;
    }
}

