/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFileLinkReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    private final String myPath;
    private final String[] myExtensions;

    public TypeScriptFileLinkReference(PsiElement context, TextRange range, String filePath, String[] extensions) {
        super(context, range);
        this.myPath = filePath;
        this.myExtensions = extensions;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (this.myPath != null) {
            VirtualFile path = LocalFileSystem.getInstance().findFileByPath(this.myPath);
            if (path == null || path.isDirectory()) {
                for (String extension : this.myExtensions) {
                    VirtualFile pathWithExtension = LocalFileSystem.getInstance().findFileByPath(this.myPath + extension);
                    if (pathWithExtension == null || pathWithExtension.isDirectory()) continue;
                    path = pathWithExtension;
                    break;
                }
            }
            if (path != null) {
                PsiManager manager = this.getElement().getManager();
                ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)manager.findFile(path))};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptFileLinkReference", "multiResolve"));
                }
                return resolveResultArray;
            }
        }
        ResolveResult[] resolveResultArray = new ResolveResult[]{};
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptFileLinkReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptFileLinkReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

