/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.javascript.JSModuleReference;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModuleReferenceContributor;
import com.intellij.lang.javascript.frameworks.amd.TypeScriptFileModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleFileReferenceSet
extends FileReferenceSet {
    public TypeScriptModuleFileReferenceSet(String reference, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/TypeScriptModuleFileReferenceSet", "<init>"));
        }
        super(reference, element, startInElement, provider, false, true, TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        VirtualFile path;
        PsiElement host = this.getElement();
        String requiredModuleName = this.getPathString();
        boolean isRelative = requiredModuleName.startsWith(".");
        Project project = host.getProject();
        PsiFile file = host.getContainingFile().getOriginalFile();
        HashSet altResolveModules = ContainerUtil.newHashSet();
        if (!isRelative) {
            this.addBaseUrlContext(project, file, altResolveModules);
        }
        JSAmdModuleReferenceContributor.addPackageJsonContexts(project, host, altResolveModules, this.getReference(0));
        if (!isRelative && (path = TypeScriptUtil.findFileByReferencePath(file, requiredModuleName, project)) != null) {
            String s = StringUtil.replaceChar((String)requiredModuleName, (char)'/', (char)'\\');
            for (int i = StringUtil.countChars((CharSequence)s, (char)'\\'); i > 0; --i) {
                path = path.getParent();
            }
            PsiDirectory directory = this.getElement().getManager().findDirectory(path.getParent());
            if (directory != null) {
                altResolveModules.add(directory);
                HashSet hashSet = altResolveModules;
                if (hashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptModuleFileReferenceSet", "computeDefaultContexts"));
                }
                return hashSet;
            }
        }
        altResolveModules.addAll(super.computeDefaultContexts());
        HashSet hashSet = altResolveModules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptModuleFileReferenceSet", "computeDefaultContexts"));
        }
        return hashSet;
    }

    public void addBaseUrlContext(Project project, PsiFile file, Collection<PsiFileSystemItem> altResolveModules) {
        PsiDirectory urlPsiFile;
        VirtualFile url;
        TypeScriptConfig config;
        VirtualFile currentVirtualFile = file.getVirtualFile();
        if (currentVirtualFile != null && (config = TypeScriptConfigUtil.getConfigForFile(project, currentVirtualFile)) != null && (url = config.getBaseUrl()) != null && (urlPsiFile = file.getManager().findDirectory(url)) != null) {
            altResolveModules.add((PsiFileSystemItem)urlPsiFile);
        }
    }

    public FileReference createFileReference(TextRange textRange, int i, String text) {
        return TypeScriptModuleFileReferenceSet.createModuleReference(this, textRange, i, text);
    }

    @NotNull
    public static JSModuleReference createModuleReference(FileReferenceSet refSet, TextRange textRange, int i, String text) {
        TypeScriptFileModuleReference typeScriptFileModuleReference = new TypeScriptFileModuleReference(text, i, textRange, refSet);
        if (typeScriptFileModuleReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptModuleFileReferenceSet", "createModuleReference"));
        }
        return typeScriptFileModuleReference;
    }
}

