/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.google.gson.stream.JsonReader;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptNodeReference
extends NodeFileModulePsiReferenceBase {
    public static final String[] EXTENSION = new String[]{".d.ts", ".ts", ".tsx"};
    public static final ParameterizedCachedValueProvider<String, PsiFile> TS_NODE_PACKAGE_JSON_INFO_PROVIDER = new ParameterizedCachedValueProvider<String, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<String> compute(PsiFile param) {
            VirtualFile virtualFile = param.getVirtualFile();
            return CachedValueProvider.Result.create((Object)TypeScriptNodeReference.getMainFileValue(virtualFile), (Object[])new Object[]{param});
        }
    };
    public static final Key<ParameterizedCachedValue<String, PsiFile>> TS_NODE_PACKAGE_JSON_INFO_KEY = Key.create((String)"typescript.node.modules.cache.value");
    private static final Function<CompletionModuleInfo, CompletionModuleInfo> MAP_COMPLETION_MODULE = new Function<CompletionModuleInfo, CompletionModuleInfo>(){

        public CompletionModuleInfo fun(CompletionModuleInfo info) {
            return new CompletionModuleInfo(info.getName(), info.getVirtualFile(), info.getType()){

                @Override
                @Nullable
                public String getPresentablePath(@Nullable VirtualFile requester) {
                    VirtualFile file = this.getVirtualFile();
                    assert (file != null);
                    return file.getName();
                }
            };
        }
    };

    public TypeScriptNodeReference(@NotNull PsiElement literalExpression, @NotNull String requiredModuleName) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/frameworks/amd/TypeScriptNodeReference", "<init>"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/lang/javascript/frameworks/amd/TypeScriptNodeReference", "<init>"));
        }
        super(literalExpression, requiredModuleName);
    }

    @Override
    @Nullable
    public ResolvedModuleInfo resolveModule() {
        VirtualFile requester = this.getContainingFile();
        if (requester != null) {
            String requiredModuleName = this.getRequiredModuleName();
            return TypeScriptNodeReference.resolveModuleInfoFromNodeModulesDir(this.getElement().getProject(), requester, requiredModuleName);
        }
        return null;
    }

    public static ResolvedModuleInfo resolveModuleInfoFromNodeModulesDir(Project project, @NotNull VirtualFile requester, @NotNull String requiredModuleName) {
        if (requester == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requester", "com/intellij/lang/javascript/frameworks/amd/TypeScriptNodeReference", "resolveModuleInfoFromNodeModulesDir"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/intellij/lang/javascript/frameworks/amd/TypeScriptNodeReference", "resolveModuleInfoFromNodeModulesDir"));
        }
        return NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(requester, requiredModuleName, new TypeScriptNodeModuleDirectorySearchProcessor(project));
    }

    @Override
    @NotNull
    protected CompletionModuleInfo[] getModuleInfos(VirtualFile requester) {
        HashMap modules = ContainerUtil.newHashMap();
        final Project project = this.getElement().getProject();
        Condition<CompletionModuleInfo> condition = new Condition<CompletionModuleInfo>(){

            public boolean value(CompletionModuleInfo info) {
                VirtualFile file = info.getVirtualFile();
                if (file != null) {
                    VirtualFile packageJson = null;
                    for (VirtualFile virtualFile : file.getChildren()) {
                        if (TypeScriptUtil.isDefinitionFile(virtualFile)) {
                            return true;
                        }
                        if (!"package.json".equals(virtualFile.getName())) continue;
                        packageJson = virtualFile;
                    }
                    if (packageJson != null) {
                        return null != TypeScriptNodeReference.findInPackageJsonMainFile(project, packageJson);
                    }
                }
                return false;
            }
        };
        Collection<CompletionModuleInfo> collection = NodeModuleSearchUtil.collectVisibleNodeModules(modules, project, requester, null);
        List infos = ContainerUtil.filter(collection, (Condition)condition);
        CompletionModuleInfo[] completionModuleInfoArray = (CompletionModuleInfo[])ContainerUtil.map2Array((Collection)infos, (Object[])new CompletionModuleInfo[infos.size()], MAP_COMPLETION_MODULE);
        if (completionModuleInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptNodeReference", "getModuleInfos"));
        }
        return completionModuleInfoArray;
    }

    private static String findInPackageJsonMainFile(Project project, VirtualFile packageJson) {
        PsiManager instance = PsiManager.getInstance((Project)project);
        PsiFile file = instance.findFile(packageJson);
        if (file != null) {
            return (String)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)file, TS_NODE_PACKAGE_JSON_INFO_KEY, TS_NODE_PACKAGE_JSON_INFO_PROVIDER, false, (Object)file);
        }
        return TypeScriptNodeReference.getMainFileValue(packageJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getMainFileValue(VirtualFile packageJson) {
        JsonReader jsonReader = null;
        try {
            String text = VfsUtilCore.loadText((VirtualFile)packageJson);
            jsonReader = new JsonReader((Reader)new StringReader(text));
            String typings = JsonUtil.getChildAsString((JsonReader)jsonReader, (String)"typings");
            if (typings != null) {
                String string = typings;
                return string;
            }
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static class TypeScriptNodeModuleDirectorySearchProcessor
    extends NodeModuleDirectorySearchProcessor {
        private final Project myProject;

        public TypeScriptNodeModuleDirectorySearchProcessor(Project project) {
            this.myProject = project;
        }

        @Override
        protected String[] getExtensions() {
            return EXTENSION;
        }

        @Override
        protected String findPathInPackageJson(@NotNull VirtualFile packageJson) {
            if (packageJson == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/frameworks/amd/TypeScriptNodeReference$TypeScriptNodeModuleDirectorySearchProcessor", "findPathInPackageJson"));
            }
            return TypeScriptNodeReference.findInPackageJsonMainFile(this.myProject, packageJson);
        }
    }
}

