/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.amd.TypeScriptFileLinkReference;
import com.intellij.lang.javascript.frameworks.amd.TypeScriptModuleFileReferenceSet;
import com.intellij.lang.javascript.frameworks.amd.TypeScriptPathMappingReference;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPathSubstitutionReferenceContributor
implements JSModuleReferenceContributor {
    public static PsiReference[] getReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getReferences"));
        }
        boolean isRelative = unquotedRefText.startsWith(".");
        if (isRelative) {
            return PsiReference.EMPTY_ARRAY;
        }
        Project project = host.getProject();
        VirtualFile file = host.getContainingFile().getOriginalFile().getVirtualFile();
        if (file == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        TypeScriptConfig configForFile = TypeScriptConfigUtil.getConfigForFile(project, file);
        if (configForFile == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        VirtualFile url = configForFile.getBaseUrl();
        if (url == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        Collection<TypeScriptConfig.PathSubstitution> paths = configForFile.getPaths();
        if (paths.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        int longestMatchPrefixLength = -1;
        TypeScriptConfig.PathSubstitution matchedPattern = null;
        String matchedStar = null;
        for (TypeScriptConfig.PathSubstitution path : paths) {
            String pattern = path.getPattern();
            int indexOfStar = pattern.indexOf("*");
            if (indexOfStar != -1) {
                String prefix = pattern.substring(0, indexOfStar);
                String suffix = pattern.substring(indexOfStar + 1);
                if (unquotedRefText.length() < prefix.length() + suffix.length() || !unquotedRefText.startsWith(prefix) || !unquotedRefText.endsWith(suffix) || prefix.length() <= longestMatchPrefixLength) continue;
                longestMatchPrefixLength = prefix.length();
                matchedPattern = path;
                matchedStar = unquotedRefText.substring(prefix.length(), unquotedRefText.length() - suffix.length());
                continue;
            }
            if (!pattern.equals(unquotedRefText)) continue;
            matchedPattern = path;
            matchedStar = null;
            break;
        }
        if (matchedPattern == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList refs = ContainerUtil.newArrayList();
        String pattern = matchedPattern.getPattern();
        boolean endsWithStar = matchedStar != null && TypeScriptConfigUtil.isPatternOrMappingEndsWithStar(pattern);
        boolean needPathMappingRef = false;
        for (String mapping : matchedPattern.getMappings()) {
            if (endsWithStar && TypeScriptConfigUtil.isPatternOrMappingEndsWithStar(mapping)) {
                needPathMappingRef = true;
                final String pathToFolder = TypeScriptPathSubstitutionReferenceContributor.getStringPathRelativeBaseUrl(url, TypeScriptConfigUtil.getPatternOrMappingWithoutStar(mapping));
                refs.addAll(ContainerUtil.newArrayList((Object[])new FileReferenceSet(matchedStar, host, offset + pattern.length() - 1, provider, false, true, TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY){

                    public FileReference createFileReference(TextRange range, int index, String text) {
                        return TypeScriptModuleFileReferenceSet.createModuleReference(this, range, index, text);
                    }

                    @NotNull
                    public Collection<PsiFileSystemItem> computeDefaultContexts() {
                        String systemIndependentName = FileUtil.toSystemIndependentName((String)pathToFolder);
                        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(systemIndependentName);
                        if (path != null) {
                            List list = ContainerUtil.createMaybeSingletonList((Object)this.getElement().getManager().findDirectory(path));
                            if (list == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor$1", "computeDefaultContexts"));
                            }
                            return list;
                        }
                        List list = ContainerUtil.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor$1", "computeDefaultContexts"));
                        }
                        return list;
                    }
                }.getAllReferences()));
                continue;
            }
            String currentEl = matchedStar != null ? mapping.replace("*", matchedStar) : mapping;
            TextRange range = TextRange.create((int)offset, (int)(offset + unquotedRefText.length()));
            String path = TypeScriptPathSubstitutionReferenceContributor.getStringPathRelativeBaseUrl(url, currentEl);
            refs.add(new TypeScriptFileLinkReference(host, range, path, TypeScriptUtil.TYPESCRIPT_EXTENSIONS));
        }
        if (needPathMappingRef) {
            String patternWithoutStar = TypeScriptConfigUtil.getPatternOrMappingWithoutStar(pattern);
            TextRange range = new TextRange(offset, offset + patternWithoutStar.length());
            refs.add(new TypeScriptPathMappingReference(host, range, matchedPattern, patternWithoutStar));
        }
        return refs.toArray(new PsiReference[0]);
    }

    private static String getStringPathRelativeBaseUrl(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getStringPathRelativeBaseUrl"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getStringPathRelativeBaseUrl"));
        }
        if (FileUtil.isAbsolute((String)mapping)) {
            return mapping;
        }
        String canonicalUrl = FileUtil.toCanonicalPath((String)baseUrl.getCanonicalPath());
        String canonicalMapping = FileUtil.toCanonicalPath((String)mapping);
        return canonicalUrl + "/" + (canonicalMapping.startsWith("/") ? canonicalMapping.substring(1) : canonicalMapping);
    }

    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getCommonJSModuleReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getAllReferences"));
        }
        PsiReference[] psiReferenceArray = TypeScriptPathSubstitutionReferenceContributor.getReferences(unquotedRefText, host, offset, provider);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "getAllReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/amd/TypeScriptPathSubstitutionReferenceContributor", "isApplicable"));
        }
        return DialectDetector.isTypeScript(host);
    }
}

