/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jquery;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementCustomProvider;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.text.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JQueryFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    private static final String[] INTERESTED_METHOD_NAMES = new String[]{"widget"};

    @Override
    @NotNull
    public String[] interestedMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler", "interestedMethodNames"));
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledMethodName", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler", "createLiteralImplicitElementProvider"));
        }
        if ("widget".equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                @Override
                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    JSQualifiedName qualifiedName;
                    JSExpression[] jsExpressions;
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler$1", "fillIndexingData"));
                    }
                    if (callExpression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler$1", "fillIndexingData"));
                    }
                    if (outIndexingData == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler$1", "fillIndexingData"));
                    }
                    JSExpression methodExpression = callExpression.getMethodExpression();
                    assert (methodExpression instanceof JSReferenceExpression);
                    if (((JSReferenceExpression)methodExpression).getQualifier() != null && (jsExpressions = callExpression.getArguments()).length > 1 && jsExpressions[0] == argument && (qualifiedName = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
                        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(qualifiedName, (PsiElement)argument).setType(JSImplicitElement.Type.Variable);
                        outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(builder));
                    }
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }

    @Override
    @Nullable
    public JSLiteralImplicitElementCustomProvider createLiteralImplicitElementCustomProvider() {
        return new JSLiteralImplicitElementCustomProvider(){

            @Override
            public boolean checkIfCandidate(@NotNull ASTNode expressionNode) {
                if (expressionNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionNode", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler$2", "checkIfCandidate"));
                }
                ASTNode arrayLiteral = expressionNode.getTreeParent();
                if (arrayLiteral == null || arrayLiteral.getElementType() != JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
                    return false;
                }
                ASTNode outerArrayLiteral = arrayLiteral.getTreeParent();
                if (outerArrayLiteral == null || outerArrayLiteral.getElementType() != JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
                    return false;
                }
                ASTNode jsVariable = outerArrayLiteral.getTreeParent();
                if (jsVariable == null || jsVariable.getElementType() != JSStubElementTypes.VARIABLE || !"tuples".equals(JSTreeUtil.getName(jsVariable))) {
                    return false;
                }
                ASTNode jsVarStatement = jsVariable.getTreeParent();
                if (jsVarStatement == null || jsVarStatement.getElementType() != JSStubElementTypes.VAR_STATEMENT) {
                    return false;
                }
                ASTNode jsBlock = jsVarStatement.getTreeParent();
                if (jsBlock == null || jsBlock.getElementType() != JSElementTypes.BLOCK_STATEMENT) {
                    return false;
                }
                ASTNode functionExpression = jsBlock.getTreeParent();
                if (functionExpression == null || functionExpression.getElementType() != JSStubElementTypes.FUNCTION_EXPRESSION) {
                    return false;
                }
                ASTNode jsProperty = functionExpression.getTreeParent();
                return jsProperty != null && JSExtendedLanguagesTokenSetProvider.PROPERTIES.contains(jsProperty.getElementType()) && "Deferred".equals(JSTreeUtil.getName(jsProperty));
            }

            @Override
            public void fillIndexingDataForCandidate(@NotNull JSLiteralExpression candidate, @NotNull JSElementIndexingData outIndexingData) {
                String text;
                if (candidate == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler$2", "fillIndexingDataForCandidate"));
                }
                if (outIndexingData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler$2", "fillIndexingDataForCandidate"));
                }
                PsiElement parent = candidate.getParent();
                if (!(parent instanceof JSArrayLiteralExpression)) {
                    return;
                }
                JSExpression[] expressions = ((JSArrayLiteralExpression)parent).getExpressions();
                if (expressions.length >= 2) {
                    for (int i = 0; i < 2; ++i) {
                        String text2;
                        if (expressions[i] != candidate || !StringUtil.isQuotedString((String)(text2 = expressions[i].getText()))) continue;
                        String propertyName = StringUtil.stripQuotesAroundValue((String)text2);
                        outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl((JSImplicitFunctionImpl.Builder)new JSImplicitFunctionImpl.Builder(propertyName, (PsiElement)candidate).setNamespaceExplicitlyDeclared(false)));
                        if (i != 0) continue;
                        outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl((JSImplicitFunctionImpl.Builder)new JSImplicitFunctionImpl.Builder(propertyName + "With", (PsiElement)candidate).setNamespaceExplicitlyDeclared(false)));
                    }
                }
                if (expressions.length >= 4 && expressions[3] == candidate && StringUtil.isQuotedString((String)(text = candidate.getText()))) {
                    outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl((JSImplicitFunctionImpl.Builder)new JSImplicitFunctionImpl.Builder("is" + StringUtil.capitalize((String)StringUtil.stripQuotesAroundValue((String)text)), (PsiElement)candidate).setNamespaceExplicitlyDeclared(false)));
                }
            }
        };
    }

    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode methodExpression = node.getFirstChildNode();
        if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        ASTNode qualifier = methodExpression.getFirstChildNode();
        return "each".equals(referencedNameElement.getText()) && "jQuery".equals(qualifier.getText());
    }

    @Override
    public void processCallExpression(JSCallExpression callExpression, final @NotNull JSElementIndexingData outData) {
        block10: {
            JSExpression qualifier;
            String calledMethodName;
            block9: {
                JSExpression[] jsExpressions;
                block12: {
                    block11: {
                        JSReferenceExpression expr;
                        if (outData == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/jquery/JQueryFrameworkIndexingHandler", "processCallExpression"));
                        }
                        JSExpression expression = callExpression.getMethodExpression();
                        if (!(expression instanceof JSReferenceExpression)) {
                            return;
                        }
                        calledMethodName = ((JSReferenceExpression)expression).getReferencedName();
                        qualifier = ((JSReferenceExpression)expression).getQualifier();
                        if (!"each".equals(calledMethodName) || qualifier == null || !"jQuery".equals(qualifier.getText())) break block9;
                        jsExpressions = callExpression.getArguments();
                        if (jsExpressions.length != 2 || !(jsExpressions[1] instanceof JSFunctionExpression)) break block10;
                        if (!(jsExpressions[0] instanceof JSCallExpression)) break block11;
                        JSExpression methodExpr = ((JSCallExpression)jsExpressions[0]).getMethodExpression();
                        if (!(methodExpr instanceof JSReferenceExpression) || !"split".equals((expr = (JSReferenceExpression)methodExpr).getReferencedName())) break block10;
                        JSExpression qualifier1 = expr.getQualifier();
                        if (qualifier1 instanceof JSParenthesizedExpression) {
                            qualifier1 = ((JSParenthesizedExpression)qualifier1).getInnerExpression();
                        }
                        if (qualifier1 != null) {
                            qualifier1.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                                public void visitJSLiteralExpression(JSLiteralExpression node) {
                                    StringTokenizer tokenizer = new StringTokenizer(StringUtil.stripQuotesAroundValue((String)node.getText()), ", ");
                                    while (tokenizer.hasMoreElements()) {
                                        String s = tokenizer.nextElement().trim();
                                        if (s.length() <= 0) continue;
                                        JSImplicitElementImpl.Builder builder = new JSImplicitFunctionImpl.Builder(s, (PsiElement)node).setNamespace(JSQualifiedNameImpl.create("jQuery", null)).setType(JSImplicitElement.Type.Function);
                                        outData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl((JSImplicitFunctionImpl.Builder)builder));
                                    }
                                }
                            });
                        }
                        break block10;
                    }
                    if (!(jsExpressions[0] instanceof JSArrayLiteralExpression)) break block12;
                    for (JSExpression e : ((JSArrayLiteralExpression)jsExpressions[0]).getExpressions()) {
                        JSImplicitElementImpl.Builder builder;
                        String s;
                        if (!(e instanceof JSLiteralExpression) || (s = StringUtil.stripQuotesAroundValue((String)e.getText())).length() <= 0 || !StringUtil.isJavaIdentifier((String)s)) continue;
                        if ("Width".equals(s) || "Height".equals(s)) {
                            builder = new JSImplicitFunctionImpl.Builder("inner" + s, (PsiElement)e).setNamespace(JSQualifiedNameImpl.create("jQuery", null)).setType(JSImplicitElement.Type.Function);
                            outData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl((JSImplicitFunctionImpl.Builder)builder));
                            s = "outer" + s;
                        }
                        if (!Character.isLowerCase(s.charAt(0))) continue;
                        builder = new JSImplicitFunctionImpl.Builder(s, (PsiElement)e).setNamespace(JSQualifiedNameImpl.create("jQuery", null)).setType(JSImplicitElement.Type.Function);
                        outData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl((JSImplicitFunctionImpl.Builder)builder));
                    }
                    break block10;
                }
                if (!(jsExpressions[0] instanceof JSObjectLiteralExpression)) break block10;
                for (JSProperty property : ((JSObjectLiteralExpression)jsExpressions[0]).getProperties()) {
                    String propertyName = property.getName();
                    if (!"Height".equals(propertyName) && !"Width".equals(propertyName)) continue;
                    JSImplicitFunctionImpl.Builder builder = (JSImplicitFunctionImpl.Builder)new JSImplicitFunctionImpl.Builder("", (PsiElement)property).setNamespace(JSQualifiedNameImpl.create("jQuery", null)).setType(JSImplicitElement.Type.Function);
                    builder.setName(StringUtil.decapitalize((String)propertyName));
                    outData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl(builder));
                    builder.setName("outer" + propertyName);
                    outData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl(builder));
                    builder.setName("inner" + propertyName);
                    outData.addImplicitElement((JSImplicitElement)new JSImplicitFunctionImpl(builder));
                }
                break block10;
            }
            if ("extend".equals(calledMethodName) && qualifier instanceof JSReferenceExpression && ("jQuery".equals(qualifier.getText()) || "$".equals(qualifier.getText()))) {
                JSExpression[] arguments = callExpression.getArguments();
                int targetObjectIndex = arguments.length > 0 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isBooleanLiteral() ? 1 : 0;
                for (int i = targetObjectIndex + 1; i < arguments.length; ++i) {
                    if (!(arguments[targetObjectIndex] instanceof JSReferenceExpression) || !(arguments[i] instanceof JSReferenceExpression)) continue;
                    JSStubIndexingUtils.processExtendCall((JSReferenceExpression)arguments[targetObjectIndex], (JSReferenceExpression)arguments[i], JSContext.STATIC, outData);
                }
            }
        }
    }
}

