/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactXmlElementDescriptor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.xml.HtmlXmlExtension;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import icons.JavaScriptLanguageIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlExtension
extends HtmlXmlExtension
implements XmlTagNameProvider {
    private static final ResolveCache.AbstractResolver<ReactTagNameReference, PsiElement> RESOLVER = new ResolveCache.AbstractResolver<ReactTagNameReference, PsiElement>(){

        public PsiElement resolve(@NotNull ReactTagNameReference reference, boolean incompleteCode) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$1", "resolve"));
            }
            XmlTag tag = reference.getTagElement();
            assert (tag != null);
            PsiElement var = ReactXmlExtension.resolveTag(tag);
            if (var != null) {
                return var;
            }
            return null;
        }
    };

    @Nullable
    private static PsiElement resolveTag(XmlTag tag) {
        PsiElement clazz;
        final Ref var = Ref.create();
        final String tagName = tag.getName();
        JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)tag, null, new ResolveProcessor(tagName, (PsiElement)tag){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$2", "execute"));
                }
                PsiElement candidate = ReactXmlExtension.getElementByImport(element);
                String name = ReactXmlExtension.getEffectiveName(element, candidate);
                if (StringUtil.equals((CharSequence)tagName, (CharSequence)name) && ReactXmlExtension.isPossibleReactComponent(candidate)) {
                    var.setIfNull((Object)ReactXmlExtension.getElementForResolve(element, candidate));
                }
                return var.isNull();
            }
        }, false, false, null);
        if (!var.isNull()) {
            return (PsiElement)var.get();
        }
        if (!DialectDetector.isTypeScript((PsiElement)tag) && (clazz = ReactXmlExtension.resolveClassComponent(tag, tagName)) != null) {
            return clazz;
        }
        return null;
    }

    private static PsiElement getElementForResolve(PsiElement element, PsiElement candidate) {
        if (element instanceof ES6ImportedBinding) {
            return element;
        }
        if (element instanceof ES6ImportSpecifier) {
            return ((ES6ImportSpecifier)element).resolve();
        }
        return candidate;
    }

    @Nullable
    private static PsiElement resolveClassComponent(XmlTag tag, String tagName) {
        final Ref result = Ref.create();
        if (ReactXmlExtension.isComponentName(tagName)) {
            JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)tag).getClassResolver();
            resolver.processElementsByQNameIncludingImplicit(tagName, JSResolveUtil.getResolveScope((PsiElement)tag), new Processor<JSPsiElementBase>(){

                public boolean process(JSPsiElementBase clazz) {
                    JSExpression initializer;
                    if ((clazz instanceof JSVariable || clazz instanceof JSDefinitionExpression) && JSXHarmonyLanguageDialect.isReactComponent(initializer = ReactXmlExtension.getInitializer((PsiElement)clazz))) {
                        result.set((Object)clazz);
                        return false;
                    }
                    return true;
                }
            });
        }
        return (PsiElement)result.get();
    }

    public static boolean isComponentName(String tagName) {
        return StringUtil.isCapitalized((String)tagName);
    }

    protected static JSExpression getInitializer(PsiElement clazz) {
        return clazz instanceof JSVariable ? ((JSVariable)clazz).getInitializerOrStub() : ((JSDefinitionExpression)clazz).getInitializerOrStub();
    }

    public boolean isAvailable(PsiFile file) {
        return file instanceof JSFile || file instanceof HtmlFileImpl && JSRootConfiguration.getInstance(file.getProject()).getLanguageLevel() == JSLanguageLevel.JSX;
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return nameElement.getTreeParent() instanceof JSXmlLiteralExpressionImpl ? new ReactTagNameReference(nameElement, startTagFlag) : super.createTagNameReference(nameElement, startTagFlag);
    }

    private static boolean isPossibleReactComponent(@NotNull PsiElement candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "isPossibleReactComponent"));
        }
        if (ReactXmlExtension.isReactComponent(candidate)) {
            return true;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression) {
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            JSType type = JSResolveUtil.getExpressionJSType(initializer);
            return !(type instanceof JSPrimitiveType) && !(type instanceof JSRecordType);
        }
        if (candidate instanceof JSClass) {
            return ((JSClass)candidate).getExtendsList() != null;
        }
        if (candidate instanceof ES6ImportedBinding) {
            return true;
        }
        if (candidate instanceof JSCallExpression) {
            JSType type = JSResolveUtil.getExpressionJSType((JSExpression)candidate);
            return !(type instanceof JSPrimitiveType) && !(type instanceof JSRecordType);
        }
        return false;
    }

    private static boolean isReactComponent(PsiElement candidate) {
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression) {
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            if (initializer instanceof JSXmlLiteralExpressionImpl) {
                return true;
            }
            if (JSXHarmonyLanguageDialect.isReactComponent(initializer)) {
                return true;
            }
        }
        if (candidate instanceof JSCallExpression && JSXHarmonyLanguageDialect.isReactComponent((JSExpression)((JSCallExpression)candidate))) {
            return true;
        }
        return candidate instanceof ES6ImportedBinding;
    }

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "addTagNameVariants"));
        }
        if (ReactXmlExtension.nonJsxTag(tag)) {
            return;
        }
        HashSet<String> collectedNames = new HashSet<String>();
        ReactXmlExtension.addLocalVariants(elements, tag, collectedNames, DialectDetector.isTypeScript((PsiElement)tag));
        if (StringUtil.isEmpty((String)prefix) || ReactXmlExtension.isComponentName(prefix)) {
            ReactXmlExtension.addTypeScriptComponents(elements, tag, collectedNames);
        }
    }

    private static void addTypeScriptComponents(List<LookupElement> elements, @NotNull XmlTag tag, Set<String> collectedNames) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "addTypeScriptComponents"));
        }
        for (JSClass aClass : TypeScriptReactComponentUtil.getReactComponents((PsiElement)tag)) {
            String name;
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || collectedNames.contains(name = TypeScriptUtil.getShortestTypeNameInContextForQualifiedName((PsiElement)tag, qualifiedName))) continue;
            ReactXmlExtension.addLookupElement((PsiElement)aClass, name, elements);
            collectedNames.add(name);
        }
    }

    private static void addLocalVariants(final List<LookupElement> elements, @NotNull XmlTag tag, final Set<String> collectedNames, final boolean isStrict) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "addLocalVariants"));
        }
        JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)tag, null, new ResolveProcessor(null, (PsiElement)tag){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$4", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$4", "execute"));
                }
                PsiElement candidate = ReactXmlExtension.getElementByImport(element);
                String name = ReactXmlExtension.getEffectiveName(element, candidate);
                if (name != null && !collectedNames.contains(name)) {
                    boolean isComponent;
                    boolean bl = isComponent = isStrict ? ReactXmlExtension.isReactComponent(candidate) : ReactXmlExtension.isPossibleReactComponent(candidate);
                    if (isComponent) {
                        ReactXmlExtension.addLookupElement(candidate, name, elements);
                        collectedNames.add(name);
                    }
                }
                return true;
            }
        }, false, true, null);
    }

    private static void addLookupElement(PsiElement candidate, String name, List<LookupElement> elements) {
        ItemPresentation presentation = candidate instanceof JSNamedElement ? ((JSNamedElement)candidate).getPresentation() : null;
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)candidate, (String)name).withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE).withTypeText(presentation != null ? presentation.getLocationString() : null, true).withIcon(JavaScriptLanguageIcons.Logos.Jsx_16);
        elements.add((LookupElement)lookup);
    }

    @Nullable
    private static String getEffectiveName(PsiElement element, PsiElement candidate) {
        if (element instanceof ES6ImportedBinding) {
            return ((ES6ImportedBinding)element).getName();
        }
        if (element instanceof ES6ImportSpecifier) {
            return ((ES6ImportSpecifier)element).getDeclaredName();
        }
        JSPsiNamedElementBase jsElement = (JSPsiNamedElementBase)ObjectUtils.tryCast((Object)candidate, JSPsiNamedElementBase.class);
        return jsElement != null ? jsElement.getName() : null;
    }

    private static PsiElement getElementByImport(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension", "getElementByImport"));
        }
        if (element instanceof ES6ImportSpecifier) {
            Object[] results = ((ES6ImportSpecifier)element).resolveOverAliases();
            return results.length == 0 ? element : ((ResolveResult)ArrayUtil.getFirstElement((Object[])results)).getElement();
        }
        if (element instanceof ES6ImportedBinding) {
            return JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element);
        }
        return element;
    }

    public static boolean nonJsxTag(@Nullable XmlTag tag) {
        return !(tag instanceof JSXmlLiteralExpressionImpl) || DialectDetector.dialectOfElement((PsiElement)tag) == DialectOptionHolder.ECMA_4;
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        XmlElementDescriptor elementDescriptor = element.getDescriptor();
        if (elementDescriptor instanceof TypeScriptReactXmlElementDescriptor) {
            return elementDescriptor.getNSDescriptor();
        }
        return super.getNSDescriptor(element, namespace, strict);
    }

    static class ReactTagNameReference
    extends TagNameReference {
        public ReactTagNameReference(ASTNode nameElement, boolean startTagFlag) {
            super(nameElement, startTagFlag);
        }

        public PsiElement resolve() {
            PsiElement declaration;
            XmlTag tag = this.getTagElement();
            if (ReactXmlExtension.nonJsxTag(tag)) {
                return super.resolve();
            }
            XmlElementDescriptor descriptor = tag.getDescriptor();
            PsiElement element = (PsiElement)ResolveCache.getInstance((Project)tag.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
            if (element instanceof ES6ImportedBinding) {
                PsiElement topLevelContainer = TypeScriptPsiUtil.getTopLevelContainer(element);
                PsiElement currentContainer = TypeScriptPsiUtil.getTopLevelContainer((PsiElement)tag);
                if (topLevelContainer != null && topLevelContainer.isEquivalentTo(currentContainer)) {
                    return element;
                }
            }
            if (descriptor instanceof TypeScriptReactXmlElementDescriptor && (declaration = descriptor.getDeclaration()) != null) {
                return declaration;
            }
            return element != null ? element : super.resolve();
        }

        @Nullable
        public XmlTag getTagElement() {
            return super.getTagElement();
        }
    }
}

