/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class JSNamedElementNode
extends PsiElementMemberChooserObject
implements ClassMember {
    public JSNamedElementNode(JSPsiNamedElementBase node) {
        super((PsiElement)node, JSNamedElementNode.buildTextFor(node), JSNamedElementNode.buildIcon(node));
    }

    private static Icon buildIcon(JSPsiNamedElementBase node) {
        JSFunction function;
        Icon accessIcon;
        Icon icon = node.getIcon(1);
        if (node instanceof JSFunction && (accessIcon = (function = (JSFunction)node).isGetProperty() ? PlatformIcons.VARIABLE_READ_ACCESS : (function.isSetProperty() ? PlatformIcons.VARIABLE_WRITE_ACCESS : null)) != null) {
            LayeredIcon layeredIcon = new LayeredIcon(1);
            layeredIcon.setIcon(accessIcon, 0, 1, 3);
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon((Icon)layeredIcon, 1);
            rowIcon.setIcon(icon, 0);
            icon = rowIcon;
        }
        return icon;
    }

    private static String buildTextFor(JSPsiNamedElementBase node) {
        String text = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)node);
        if (node instanceof JSFunction) {
            JSFunction function = (JSFunction)node;
            text = text + "(";
            JSParameterList parameterList = function.getParameterList();
            if (parameterList != null) {
                boolean first = true;
                for (JSParameter p : parameterList.getParameters()) {
                    if (!first) {
                        text = text + ", ";
                    }
                    first = false;
                    text = text + JSParameterInfoHandler.getSignatureForParameter((JSParameterItem)p);
                }
            }
            text = text + ")";
            JSType type = function.getReturnType();
            if (type != null) {
                text = text + ":" + type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
        } else if (node instanceof JSVariable) {
            JSVariable var = (JSVariable)node;
            JSType type = var.getType();
            String typeString = null;
            if (type != null) {
                typeString = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
            if (typeString != null) {
                text = text + ":" + typeString;
            }
        }
        return text;
    }

    public MemberChooserObject getParentNodeDelegate() {
        PsiElement element = this.getPsiElement();
        PsiElement parent = JSResolveUtil.findParent(element);
        return new JSNamedElementNode((JSPsiNamedElementBase)((JSNamedElement)parent));
    }
}

