/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntentionAndInspectionFilter {
    public static final LanguageExtension<IntentionAndInspectionFilter> INSTANCE = new LanguageExtension("JavaScript.intentionAndInspectionFilter");

    public boolean isSupportedIntention(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/highlighting/IntentionAndInspectionFilter", "isSupportedIntention"));
        }
        return true;
    }

    public boolean isSupportedInspection(String inspectionToolId) {
        return true;
    }

    @NotNull
    public static List<IntentionAndInspectionFilter> findFilterForElement(@Nullable PsiElement element) {
        PsiElement container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
        Language language = null;
        if (container instanceof PsiFile) {
            PsiFile psiFile = (PsiFile)container;
            language = psiFile.getViewProvider().getBaseLanguage();
        } else if (container != null) {
            language = container.getLanguage();
        }
        List list = language != null ? INSTANCE.allForLanguage(language) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/IntentionAndInspectionFilter", "findFilterForElement"));
        }
        return list;
    }

    public static boolean isIntentionSupportedForElement(@NotNull Class clazz, @NotNull PsiElement element) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/highlighting/IntentionAndInspectionFilter", "isIntentionSupportedForElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/IntentionAndInspectionFilter", "isIntentionSupportedForElement"));
        }
        List<IntentionAndInspectionFilter> filters = IntentionAndInspectionFilter.findFilterForElement(element);
        if (!filters.isEmpty()) {
            for (IntentionAndInspectionFilter filter : filters) {
                if (!filter.isSupportedIntention(clazz)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isInspectionSupportedForElement(@NotNull String toolID, @NotNull PsiElement element) {
        if (toolID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolID", "com/intellij/lang/javascript/highlighting/IntentionAndInspectionFilter", "isInspectionSupportedForElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/IntentionAndInspectionFilter", "isInspectionSupportedForElement"));
        }
        List<IntentionAndInspectionFilter> filters = IntentionAndInspectionFilter.findFilterForElement(element);
        if (!filters.isEmpty()) {
            for (IntentionAndInspectionFilter filter : filters) {
                if (!filter.isSupportedInspection(toolID)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

