/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.DefaultJSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.ECMAL4Highlighter;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSTextAttributeKeysProvider;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSemanticHighlightingUtil {
    @NonNls
    public static final String INSTANCE_FIELD = "instance field";
    @NonNls
    public static final String INSTANCE_METHOD = "instance method";
    @NonNls
    public static final String PARAMETER_MESSAGE = "parameter";
    private static boolean debug = ApplicationManager.getApplication().isUnitTestMode();

    private JSSemanticHighlightingUtil() {
    }

    private static boolean isClass(PsiElement element) {
        if (element instanceof JSClass) {
            return true;
        }
        return element instanceof JSFile && element.getContext() != null;
    }

    private static boolean isTypeScriptInterfaceReference(PsiElement element) {
        return element instanceof TypeScriptObjectType && JSSemanticHighlightingUtil.isClass(element.getParent());
    }

    private static JSTextAttributeKeysProvider getTextAttributeKeysProvider(PsiElement element) {
        Language lang;
        JSTextAttributeKeysProvider attributeKeysProvider;
        JSTextAttributeKeysProvider result = DefaultJSTextAttributeKeysProvider.getInstance();
        if (element != null && (attributeKeysProvider = (JSTextAttributeKeysProvider)JSTextAttributeKeysProvider.INSTANCE.forLanguage(lang = DialectDetector.languageOfElement(element))) != null) {
            result = attributeKeysProvider;
        }
        return result;
    }

    public static void highlight(JSPsiReferenceElement node, JSHighlighter highlighter, AnnotationHolder holder) {
        TextAttributeKeyInfo info;
        PsiElement resolve;
        if (node instanceof JSReferenceExpression && ((JSReferenceExpression)node).getQualifier() == null && node.getNode().findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter) != null && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)node)) {
            return;
        }
        ResolveResult[] results = node.multiResolve(false);
        if (results.length == 0) {
            return;
        }
        PsiElement selectedVariant = null;
        TextAttributeKeyInfo selectedHighlighting = null;
        for (ResolveResult r : results) {
            resolve = r.getElement();
            if (resolve == null || resolve.getContainingFile() == null || !DialectDetector.isTypeScriptDefinitionFile(resolve.getContainingFile()) || (info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, (PsiElement)node, highlighter)) == null || info.type == null) continue;
            selectedHighlighting = info;
            selectedVariant = resolve;
            break;
        }
        if (selectedHighlighting == null) {
            for (ResolveResult r : results) {
                resolve = r.getElement();
                if (resolve == null || resolve.getContainingFile() != null && DialectDetector.isTypeScriptDefinitionFile(resolve.getContainingFile()) || (info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, (PsiElement)node, highlighter)) == null || info.type == null) continue;
                selectedHighlighting = info;
                selectedVariant = resolve;
                break;
            }
        }
        if (selectedHighlighting == null || selectedVariant == null) {
            return;
        }
        if (highlighter.getDialectOptionsHolder() == DialectOptionHolder.ECMA_4 && selectedVariant instanceof JSClass) {
            ASTNode genericSignature = node.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
            JSSemanticHighlightingUtil.justLineMarker((PsiElement)(genericSignature == null ? node : node.getReferenceNameElement()), selectedHighlighting.getType(), selectedHighlighting.getText(), holder);
        } else {
            JSSemanticHighlightingUtil.lineMarker((PsiElement)node, selectedHighlighting.type, selectedHighlighting.text, holder);
        }
    }

    public static void highlight(@NotNull PsiElement place, @NotNull PsiElement resolve, JSHighlighter highlighter, AnnotationHolder holder) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "highlight"));
        }
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "highlight"));
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(resolve, place, highlighter);
        if (info != null && info.type != null) {
            JSSemanticHighlightingUtil.lineMarker(place, info.type, info.text, holder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static TextAttributeKeyInfo buildHighlightForResolveResult(@NotNull PsiElement resolve, @NotNull PsiElement place, JSHighlighter highlighter) {
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForResolveResult"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForResolveResult"));
        }
        boolean isStatic = false;
        boolean isMethod = false;
        boolean isFunction = false;
        boolean isField = false;
        TextAttributeKeyInfo info = new TextAttributeKeyInfo();
        if (resolve instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolve;
            JSImplicitElement.Type type = implicitElement.getType();
            switch (type) {
                case Class: {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                }
                case Interface: {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, true, highlighter);
                }
                case Function: {
                    if (implicitElement.getNamespace() == null) {
                        isFunction = true;
                    } else {
                        isMethod = true;
                    }
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                    break;
                }
                case Namespace: {
                    info.type = highlighter.getMappedKey(JSHighlighter.JS_GLOBAL_VARIABLE);
                    info.text = "global variable";
                    break;
                }
                case Variable: {
                    if (implicitElement.getNamespace() == null && implicitElement.isNamespaceExplicitlyDeclared()) {
                        info.type = highlighter.getMappedKey(JSHighlighter.JS_GLOBAL_VARIABLE);
                        info.text = "global variable";
                        break;
                    }
                }
                case Property: 
                case Tag: {
                    isField = true;
                    isStatic = implicitElement.getJSContext() == JSContext.STATIC;
                }
            }
        } else {
            if (resolve instanceof JSProperty) {
                return JSSemanticHighlightingUtil.buildHighlightForProperty((JSProperty)resolve, place, highlighter);
            }
            if (resolve instanceof JSAttributeListOwner) {
                if (resolve instanceof JSVariable) {
                    return JSSemanticHighlightingUtil.buildHighlightForVariable(resolve, place, highlighter);
                }
                if (resolve instanceof JSClass) {
                    return JSSemanticHighlightingUtil.buildHighlightForClass(place, ((JSClass)resolve).isInterface(), highlighter);
                }
                JSAttributeList attributeList = ((JSAttributeListOwner)resolve).getAttributeList();
                if (attributeList != null) {
                    isStatic = attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
                }
                DialectOptionHolder dialect = DialectDetector.dialectOfFile(resolve.getContainingFile());
                boolean bl = isMethod = resolve instanceof JSFunction && (!((JSFunction)resolve).isConstructor() || dialect != null && dialect.isJavaScript());
                if (isMethod && !JSSemanticHighlightingUtil.isClass(resolve.getParent()) && !JSSemanticHighlightingUtil.isTypeScriptInterfaceReference(resolve.getParent())) {
                    isMethod = false;
                    isFunction = true;
                }
                if (resolve instanceof JSFunction && ((JSFunction)resolve).isConstructor()) {
                    if (place != resolve) return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                    if (!"constructor".equals(((JSFunction)resolve).getName())) return JSSemanticHighlightingUtil.buildHighlightForClass(place, false, highlighter);
                    info.type = highlighter.getMappedKey(JSHighlighter.JS_KEYWORD);
                    info.text = "constructor";
                }
            } else if (resolve instanceof JSDefinitionExpression) {
                if (JSPsiImplUtils.calculatePossibleFunction(resolve) != null) {
                    isMethod = true;
                } else {
                    isField = true;
                }
            }
        }
        JSTextAttributeKeysProvider attributesKeyProvider = JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place);
        if (isMethod) {
            if (isStatic) {
                info.type = highlighter.getMappedKey(JSHighlighter.JS_STATIC_MEMBER_FUNCTION);
                info.text = "static method";
            } else {
                info.type = highlighter.getMappedKey(JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForInstanceMethod());
                info.text = INSTANCE_METHOD;
            }
        } else if (isFunction) {
            info.type = highlighter.getMappedKey(JSHighlighter.JS_GLOBAL_FUNCTION);
            info.text = "global function";
        } else if (isField) {
            info.type = highlighter.getMappedKey(attributesKeyProvider.getTextAttributesKeyForInstanceField());
            info.text = INSTANCE_FIELD;
        }
        if (info.type != null) return info;
        return attributesKeyProvider.getTextAttributeKeyInfoForResolveResult(resolve, highlighter);
    }

    private static TextAttributeKeyInfo buildHighlightForClass(@NotNull PsiElement place, boolean isInterface, JSHighlighter highlighter) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForClass"));
        }
        TextAttributesKey type = isInterface ? highlighter.getMappedKey(JSHighlighter.JS_INTERFACE) : highlighter.getMappedKey(JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForClass());
        return new TextAttributeKeyInfo(type, isInterface ? "interface" : "class");
    }

    private static TextAttributeKeyInfo buildHighlightForVariable(@NotNull PsiElement element, @NotNull PsiElement place, JSHighlighter highlighter) {
        String text;
        TextAttributesKey type;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForVariable"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "buildHighlightForVariable"));
        }
        JSTextAttributeKeysProvider attributesKeyProvider = JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place);
        if (element instanceof JSParameter) {
            type = highlighter.getMappedKey(attributesKeyProvider.getAttributesKeyForParameter());
            text = PARAMETER_MESSAGE;
        } else if (element instanceof JSVariable && ((JSVariable)element).tryGetFunctionExpressionInitializer() != null) {
            type = highlighter.getMappedKey(JSHighlighter.JS_GLOBAL_FUNCTION);
            text = "global function";
        } else if (JSSemanticHighlightingUtil.isClass(element.getParent().getParent())) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            boolean isStatic = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
            type = isStatic ? highlighter.getMappedKey(JSHighlighter.JS_STATIC_MEMBER_VARIABLE) : highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
            text = (isStatic ? "static " : "") + "field";
        } else {
            ImplicitJSVariableImpl implicitVariable;
            boolean localVariable = false;
            if (element instanceof JSVariable && ((JSVariable)element).isLocal()) {
                localVariable = true;
            } else if (element instanceof ImplicitJSVariableImpl && "Arguments".equals((implicitVariable = (ImplicitJSVariableImpl)element).getTypeString())) {
                localVariable = true;
            }
            if (localVariable) {
                type = highlighter.getMappedKey(attributesKeyProvider.getAttributesKeyForLocalVariable());
                text = "local variable";
            } else {
                type = highlighter.getMappedKey(attributesKeyProvider.getAttributesKeyForGlobalVariable());
                text = "global variable";
            }
        }
        return new TextAttributeKeyInfo(type, text);
    }

    public static void highlight(JSAttribute attribute, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)attribute, ECMAL4Highlighter.ECMAL4_METADATA, "attribute", holder);
    }

    public static void highlight(JSLabeledStatement labeledStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    public static void highlight(JSBreakStatement labeledStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = labeledStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    public static void highlight(JSContinueStatement continueStatement, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement labelIdentifier = continueStatement.getLabelIdentifier();
        if (labelIdentifier != null) {
            JSSemanticHighlightingUtil.lineMarker(labelIdentifier, highlighter.getMappedKey(JSHighlighter.JS_LABEL), "label", holder);
        }
    }

    public static void highlightKeyword(ASTNode keyword, AnnotationHolder holder) {
        Annotation anno = holder.createInfoAnnotation(keyword, null);
        anno.setTextAttributes(JSHighlighter.JS_KEYWORD);
    }

    private static void lineMarker(@NotNull PsiElement element, TextAttributesKey attrKey, String debugName, AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil", "lineMarker"));
        }
        if (attrKey == null) {
            return;
        }
        PsiElement markedNode = element.getLastChild();
        if (markedNode == null) {
            markedNode = element;
        }
        while (markedNode.getNode().getElementType() != JSTokenTypes.IDENTIFIER && markedNode.getPrevSibling() != null) {
            markedNode = markedNode.getPrevSibling();
        }
        if (element instanceof JSAttribute) {
            markedNode = element;
        } else if (element instanceof JSNamedElement) {
            PsiElement nameElement = ((JSNamedElement)element).getNameIdentifier();
            if (nameElement != null) {
                markedNode = nameElement;
            } else if (element instanceof ES6Property) {
                markedNode = null;
            }
        }
        if (markedNode == null) {
            return;
        }
        JSSemanticHighlightingUtil.justLineMarker(markedNode, attrKey, debugName, holder);
    }

    private static void justLineMarker(PsiElement markedNode, TextAttributesKey attrKey, String debugName, AnnotationHolder holder) {
        holder.createInfoAnnotation(markedNode, debug ? debugName : null).setTextAttributes(attrKey);
    }

    public static void highlight(JSProperty node, JSHighlighter highlighter, AnnotationHolder holder) {
        if (node instanceof ES6Property && ((ES6Property)node).isShorthanded()) {
            return;
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForProperty(node, (PsiElement)node, highlighter);
        JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
    }

    private static TextAttributeKeyInfo buildHighlightForProperty(JSProperty node, PsiElement place, JSHighlighter highlighter) {
        String text;
        TextAttributesKey type;
        if (JSPsiImplUtils.calculatePossibleFunction((PsiElement)node) != null) {
            type = highlighter.getMappedKey(JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForInstanceMethod());
            text = INSTANCE_METHOD;
        } else {
            type = highlighter.getMappedKey(JSSemanticHighlightingUtil.getTextAttributeKeysProvider(place).getTextAttributesKeyForInstanceField());
            text = INSTANCE_FIELD;
        }
        return new TextAttributeKeyInfo(type, text);
    }

    public static void highlight(JSVariable node, JSHighlighter highlighter, AnnotationHolder holder) {
        ASTNode nameIdentifier;
        if (!(node instanceof JSParameter) && ((nameIdentifier = node.findNameIdentifier()) == null || nameIdentifier.getPsi() instanceof JSReferenceExpression)) {
            return;
        }
        TextAttributeKeyInfo info = JSSemanticHighlightingUtil.buildHighlightForVariable((PsiElement)node, (PsiElement)node, highlighter);
        JSSemanticHighlightingUtil.lineMarker((PsiElement)node, info.getType(), info.getText(), holder);
    }

    public static void highlight(TypeScriptPropertySignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript property signature", holder);
    }

    public static void highlight(TypeScriptFunctionSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)signature, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), "TypeScript function signature", holder);
    }

    public static void highlight(TypeScriptTypeParameter parameter, JSHighlighter highlighter, AnnotationHolder holder) {
        JSSemanticHighlightingUtil.lineMarker((PsiElement)parameter, highlighter.getMappedKey(TypeScriptHighlighter.TS_TYPE_PARAMETER), "TypeScript type parameter", holder);
    }

    public static void highlight(TypeScriptIndexSignature signature, JSHighlighter highlighter, AnnotationHolder holder) {
        PsiElement element = signature.getParameterNameElement();
        if (element != null) {
            JSSemanticHighlightingUtil.lineMarker(element, highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), "TypeScript function signature", holder);
        }
    }

    public static final class TextAttributeKeyInfo {
        private TextAttributesKey type;
        private String text;

        public TextAttributeKeyInfo(@NotNull TextAttributesKey type, @NotNull String text) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/highlighting/JSSemanticHighlightingUtil$TextAttributeKeyInfo", "<init>"));
            }
            this.type = type;
            this.text = text;
        }

        public TextAttributeKeyInfo() {
        }

        @Nullable
        public TextAttributesKey getType() {
            return this.type;
        }

        @Nullable
        public String getText() {
            return this.text;
        }
    }
}

