/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSCustomIndexer;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Key;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIndexContent {
    public static final String REQUIRE_DATA_MAIN_KEY = "js.require.data.main";
    private static final Key<JSIndexContent> ourJSIndexContent = Key.create((String)"js.index.content");
    @NotNull
    public final Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> myImplicitElements;
    @NotNull
    public final Map<String, String> myCustomSingleEntries;
    @NotNull
    private final Map<Key, Object> myAdditionalData;

    public JSIndexContent(@NotNull JSIndexContentBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/index/JSIndexContent", "<init>"));
        }
        this.myImplicitElements = builder.myImplicitElements;
        this.myCustomSingleEntries = builder.myCustomSingleEntries;
        this.myAdditionalData = builder.myAdditionalData;
    }

    @NotNull
    public Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> getImplicitElements() {
        Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> map = this.myImplicitElements;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSIndexContent", "getImplicitElements"));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static JSIndexContent indexFile(FileContent content) {
        JSIndexContent indexContent = (JSIndexContent)content.getUserData(ourJSIndexContent);
        if (indexContent != null) {
            JSIndexContent jSIndexContent = indexContent;
            if (jSIndexContent != null) return jSIndexContent;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSIndexContent", "indexFile"));
        }
        FileContent fileContent = content;
        // MONITORENTER : fileContent
        indexContent = (JSIndexContent)content.getUserData(ourJSIndexContent);
        if (indexContent != null) {
            JSIndexContent jSIndexContent = indexContent;
            // MONITOREXIT : fileContent
            if (jSIndexContent != null) return jSIndexContent;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSIndexContent", "indexFile"));
        }
        indexContent = JSIndexContent.get(JSIndexContent.getPsiFileForIndexing(content));
        content.putUserData(ourJSIndexContent, (Object)indexContent);
        JSIndexContent jSIndexContent = indexContent;
        // MONITOREXIT : fileContent
        if (jSIndexContent != null) return jSIndexContent;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSIndexContent", "indexFile"));
    }

    @NotNull
    private static PsiFile getPsiFileForIndexing(FileContent content) {
        PsiFile psiFile = content.getPsiFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSIndexContent", "getPsiFileForIndexing"));
        }
        return psiFile;
    }

    @NotNull
    private static JSIndexContent createFromFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSIndexContent", "createFromFile"));
        }
        JSIndexContentBuilder indexBuilder = new JSIndexContentBuilder();
        JSCustomIndexer indexer = JSDialectSpecificHandlersFactory.forElement((PsiElement)file).createCustomIndexer(file, indexBuilder);
        JSIndexContent.acceptChildren(file, indexer);
        if (file instanceof JSFile) {
            indexer.processJsFile((JSFile)file);
        }
        JSIndexContent jSIndexContent = new JSIndexContent(indexBuilder);
        if (jSIndexContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSIndexContent", "createFromFile"));
        }
        return jSIndexContent;
    }

    private static void acceptChildren(PsiFile file, JSCustomIndexer indexer) {
        if (file instanceof JSFile) {
            return;
        }
        if (file instanceof XmlFile) {
            file.acceptChildren((PsiElementVisitor)indexer);
            return;
        }
        FileViewProvider provider = file.getViewProvider();
        if (!(provider instanceof TemplateLanguageFileViewProvider) || !JSImplicitElementsIndex.Holder.containFileType(file.getFileType())) {
            PsiFile psiFile = provider.getPsi((Language)HTMLLanguage.INSTANCE);
            if (psiFile != null) {
                psiFile.acceptChildren((PsiElementVisitor)indexer);
            }
            return;
        }
        for (PsiFile psiFile : provider.getAllFiles()) {
            psiFile.acceptChildren((PsiElementVisitor)indexer);
        }
    }

    @Nullable
    public <T> T getAdditionalData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/javascript/index/JSIndexContent", "getAdditionalData"));
        }
        return (T)key.get(this.myAdditionalData);
    }

    @NotNull
    public static JSIndexContent get(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSIndexContent", "get"));
        }
        JSIndexContent jSIndexContent = (JSIndexContent)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)new CachedValueProvider<JSIndexContent>(){

            @Nullable
            public CachedValueProvider.Result<JSIndexContent> compute() {
                return new CachedValueProvider.Result((Object)JSIndexContent.createFromFile(file), new Object[]{file});
            }
        });
        if (jSIndexContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSIndexContent", "get"));
        }
        return jSIndexContent;
    }
}

