/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6Type;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.ecma6.ES7Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ES6ValidationInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6Type(ES6Type node) {
                if (DialectDetector.dialectOfElement((PsiElement)node) != DialectOptionHolder.ECMA_6) {
                    return;
                }
                PsiElement parent = node.getParent();
                if (!(parent instanceof ES6Type)) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"es6.validation.elements.are.not.supported", (Object[])new Object[]{JSLanguageFeature.TYPES}), new LocalQuickFix[0]);
                }
            }

            public void visitES7Decorator(ES7Decorator decorator) {
                if (DialectDetector.dialectOfElement((PsiElement)decorator) != DialectOptionHolder.ECMA_6) {
                    return;
                }
                PsiElement nameIdentifier = decorator.getNameIdentifier();
                holder.registerProblem((PsiElement)(nameIdentifier != null ? nameIdentifier : decorator), JSBundle.message((String)"es6.validation.elements.are.not.supported", (Object[])new Object[]{JSLanguageFeature.DECORATORS}), new LocalQuickFix[0]);
            }

            public void visitJSAttributeList(JSAttributeList attributeList) {
                if (DialectDetector.dialectOfElement((PsiElement)attributeList) != DialectOptionHolder.ECMA_6 || DialectDetector.isJSX((PsiElement)attributeList)) {
                    return;
                }
                PsiElement async = attributeList.findModifierElement(JSAttributeList.ModifierType.ASYNC);
                if (async != null) {
                    holder.registerProblem(async, JSBundle.message((String)"es6.validation.elements.are.not.supported", (Object[])new Object[]{JSLanguageFeature.ASYNC_AWAIT}), new LocalQuickFix[0]);
                }
            }

            public void visitJSPrefixExpression(JSPrefixExpression node) {
                if (DialectDetector.dialectOfElement((PsiElement)node) != DialectOptionHolder.ECMA_6) {
                    return;
                }
                ASTNode await = node.getNode().findChildByType(JSTokenTypes.AWAIT_KEYWORD);
                if (await != null) {
                    holder.registerProblem(await.getPsi(), JSBundle.message((String)"es6.validation.elements.are.not.supported", (Object[])new Object[]{JSLanguageFeature.ASYNC_AWAIT}), new LocalQuickFix[0]);
                }
            }

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                IElementType type;
                if (DialectDetector.dialectOfElement((PsiElement)node) != DialectOptionHolder.ECMA_6) {
                    return;
                }
                ASTNode signNode = JSBinaryExpressionImpl.getOperationSignNode(node.getNode());
                if (signNode != null && ((type = signNode.getElementType()) == JSTokenTypes.MULTMULT || type == JSTokenTypes.MULTMULTEQ)) {
                    String message = JSBundle.message((String)"es6.validation.elements.are.not.supported", (Object[])new Object[]{JSLanguageFeature.EXPONENTIAL_OPERATORS});
                    holder.registerProblem(signNode.getPsi(), message, new LocalQuickFix[0]);
                }
                super.visitJSBinaryExpression(node);
            }

            public void visitJSParameterList(JSParameterList parameterList) {
                ASTNode node = parameterList.getNode();
                ASTNode lastComma = TreeUtil.findChildBackward((ASTNode)node, (IElementType)JSTokenTypes.COMMA);
                if (lastComma != null && node.findChildByType(JSExtendedLanguagesTokenSetProvider.PARAMETERS, lastComma) == null && node.findChildByType(JSStubElementTypes.DESTRUCTURING_PARAMETER, lastComma) == null && DialectDetector.isES6((PsiElement)parameterList)) {
                    holder.registerProblem(lastComma.getPsi(), JSBundle.message((String)"es6.validation.elements.are.not.supported", (Object[])new Object[]{"Trailing commas in parameter list"}), new LocalQuickFix[0]);
                }
                super.visitJSParameterList(parameterList);
            }

            public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
                ASTNode exportedDefaultBinding;
                ASTNode node = exportDeclaration.getNode();
                ASTNode nsExport = node.findChildByType(ES6ElementTypes.NAMESPACE_EXPORT);
                if (nsExport != null) {
                    holder.registerProblem(nsExport.getPsi(), JSBundle.message((String)"es6.validation.elements.are.not.supported", (Object[])new Object[]{"Namespace exports"}), new LocalQuickFix[0]);
                }
                if ((exportedDefaultBinding = node.findChildByType(ES6ElementTypes.EXPORTED_DEFAULT_BINDING)) != null) {
                    holder.registerProblem(exportedDefaultBinding.getPsi(), JSBundle.message((String)"es6.validation.elements.are.not.supported", (Object[])new Object[]{"Exported default bindings"}), new LocalQuickFix[0]);
                }
                super.visitES6ExportDeclaration(exportDeclaration);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ValidationInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }
}

