/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public class JSConvertToForEachIntention
extends JavaScriptIntention {
    private static final String ELEMENT_NAME = "element";
    private static final String OTHER_VARIABLE_NAME = "OtherVariable";
    private String varName;

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_NAME, "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention", "isAvailable"));
        }
        JSStatement parent = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSForInStatement.class, JSBlockStatement.class});
        if (!(parent instanceof JSForInStatement)) {
            return false;
        }
        JSForInStatement forInStatement = (JSForInStatement)parent;
        if (forInStatement.isForEach()) {
            return false;
        }
        JSVarStatement varStatement = forInStatement.getDeclarationStatement();
        if (varStatement != null && varStatement.getVariables().length == 1) {
            this.varName = varStatement.getVariables()[0].getName();
        } else {
            JSExpression variableExpression = forInStatement.getVariableExpression();
            if (!(variableExpression instanceof JSReferenceExpression) || ((JSReferenceExpression)variableExpression).getQualifier() != null) {
                return false;
            }
            this.varName = variableExpression.getText();
        }
        if (this.varName == null) {
            return false;
        }
        final JSExpression collectionExpression = forInStatement.getCollectionExpression();
        final Ref allUsagesArePropertyAccess = Ref.create((Object)Boolean.TRUE);
        JSStatement body = forInStatement.getBody();
        if (body == null) {
            return false;
        }
        new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() != null || !JSConvertToForEachIntention.this.varName.equals(node.getReferenceName())) {
                    return;
                }
                PsiElement referenceParent = node.getParent();
                if (!(referenceParent instanceof JSIndexedPropertyAccessExpression)) {
                    allUsagesArePropertyAccess.set((Object)Boolean.FALSE);
                    return;
                }
                JSExpression qualifier = ((JSIndexedPropertyAccessExpression)referenceParent).getQualifier();
                if (qualifier != null && collectionExpression != null && !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)collectionExpression)) {
                    allUsagesArePropertyAccess.set((Object)Boolean.FALSE);
                }
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
            }
        }.visitElement((PsiElement)body);
        return (Boolean)allUsagesArePropertyAccess.get();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_NAME, "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention", "invoke"));
        }
        JSStatement parent = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSForInStatement.class, JSBlockStatement.class});
        if (!(parent instanceof JSForInStatement)) {
            return;
        }
        JSForInStatement forInStatement = (JSForInStatement)parent;
        final TIntArrayList occurrences = new TIntArrayList();
        final StringBuilder stringBuilder = new StringBuilder(forInStatement.getCollectionExpression().getText());
        stringBuilder.append(".forEach(function(");
        occurrences.add(stringBuilder.length() + 2);
        stringBuilder.append(ELEMENT_NAME).append(") ");
        final JSStatement body = forInStatement.getBody();
        final Ref processedBody = Ref.create((Object)0);
        final String bodyText = body.getText();
        new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() != null || !JSConvertToForEachIntention.this.varName.equals(node.getReferenceName())) {
                    return;
                }
                PsiElement referenceParent = node.getParent();
                assert (referenceParent instanceof JSIndexedPropertyAccessExpression);
                stringBuilder.append(bodyText.substring((Integer)processedBody.get(), referenceParent.getTextRange().getStartOffset() - body.getTextRange().getStartOffset()));
                occurrences.add(stringBuilder.length() + 2);
                stringBuilder.append(JSConvertToForEachIntention.ELEMENT_NAME);
                processedBody.set((Object)(referenceParent.getTextRange().getEndOffset() - body.getTextRange().getStartOffset()));
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
            }
        }.visitElement((PsiElement)body);
        stringBuilder.append(bodyText.substring((Integer)processedBody.get(), bodyText.length()));
        stringBuilder.append(");\n");
        PsiElement forEachOrphan = JSChangeUtil.createStatementFromText(project, stringBuilder.toString(), JSUtils.getDialect(element.getContainingFile())).getPsi();
        PsiElement forEach = forInStatement.replace(forEachOrphan);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(forEach.getTextOffset());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(forEach);
        PsiElement at = forEach.findElementAt(occurrences.get(0));
        builder.replaceElement(at, ELEMENT_NAME, (Expression)new ConstantNode(ELEMENT_NAME), true);
        for (int i = 1; i < occurrences.size(); ++i) {
            builder.replaceElement(forEach.findElementAt(occurrences.get(i) + 1), OTHER_VARIABLE_NAME, ELEMENT_NAME, false);
        }
        Template template = builder.buildInlineTemplate();
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.foreach.intention.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.to.foreach.intention.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention", "getText"));
        }
        return string;
    }
}

