/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterBaseView<T extends JSLinterState> {
    private final boolean myFullModeDialog;
    private final JCheckBox myEnableCheckBox;
    private volatile ExtendedLinterState<T> myDeferredState;
    private Ref<Component> myTopRightComponentRef;
    private Component myCenterComponent;
    private JComponent myComponent;

    protected JSLinterBaseView() {
        this(false);
    }

    protected JSLinterBaseView(boolean fullModeDialog) {
        this.myFullModeDialog = fullModeDialog;
        this.myEnableCheckBox = new JBCheckBox("Enable");
        this.myEnableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSLinterBaseView.this.onEnableChanged();
            }
        });
    }

    public boolean isFullModeDialog() {
        return this.myFullModeDialog;
    }

    @Nullable
    protected abstract Component createTopRightComponent();

    @NotNull
    protected abstract Component createCenterComponent();

    protected abstract void handleEnableStatusChanged(boolean var1);

    @NotNull
    protected abstract T getState();

    protected abstract void setState(@NotNull T var1);

    @NotNull
    public final JComponent getComponent() {
        if (this.myComponent == null) {
            Component topRightComponent = this.getTopRightComponent();
            JPanel topPanel = JSLinterBaseView.createTopPanel(this.myEnableCheckBox, topRightComponent);
            Component centerPanel = this.getCenterComponent();
            this.myComponent = JSLinterBaseView.createRootComponent(topPanel, centerPanel);
        }
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterBaseView", "getComponent"));
        }
        return jComponent;
    }

    private static JComponent createRootComponent(@NotNull Component top, @NotNull Component center) {
        if (top == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "top", "com/intellij/lang/javascript/linter/JSLinterBaseView", "createRootComponent"));
        }
        if (center == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "center", "com/intellij/lang/javascript/linter/JSLinterBaseView", "createRootComponent"));
        }
        JPanel root = new JPanel(new GridBagLayout());
        root.add(top, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        root.add(center, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        return root;
    }

    public final void setExtendedState(final @NotNull ExtendedLinterState<T> extendedState) {
        if (extendedState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedState", "com/intellij/lang/javascript/linter/JSLinterBaseView", "setExtendedState"));
        }
        this.myDeferredState = extendedState;
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                JSLinterBaseView.this.myEnableCheckBox.setSelected(extendedState.isEnabled());
                JSLinterBaseView.this.setState(extendedState.getState());
                JSLinterBaseView.this.onEnableChanged();
                JSLinterBaseView.this.myDeferredState = null;
            }
        });
    }

    @NotNull
    public final ExtendedLinterState<T> getExtendedState() {
        if (this.myDeferredState != null) {
            ExtendedLinterState<T> extendedLinterState = this.myDeferredState;
            if (extendedLinterState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterBaseView", "getExtendedState"));
            }
            return extendedLinterState;
        }
        T state = this.getState();
        ExtendedLinterState<T> extendedLinterState = ExtendedLinterState.create(this.myEnableCheckBox.isSelected(), state);
        if (extendedLinterState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterBaseView", "getExtendedState"));
        }
        return extendedLinterState;
    }

    @Nullable
    private Component getTopRightComponent() {
        if (this.myTopRightComponentRef == null) {
            Component c = this.createTopRightComponent();
            this.myTopRightComponentRef = Ref.create((Object)c);
        }
        return (Component)this.myTopRightComponentRef.get();
    }

    @NotNull
    private Component getCenterComponent() {
        if (this.myCenterComponent == null) {
            this.myCenterComponent = this.createCenterComponent();
        }
        Component component = this.myCenterComponent;
        if (component == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterBaseView", "getCenterComponent"));
        }
        return component;
    }

    @NotNull
    private static JPanel createTopPanel(@NotNull JCheckBox enableCheckBox, @Nullable Component topRightComponent) {
        if (enableCheckBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enableCheckBox", "com/intellij/lang/javascript/linter/JSLinterBaseView", "createTopPanel"));
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)enableCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (topRightComponent != null) {
            panel.add(topRightComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterBaseView", "createTopPanel"));
        }
        return jPanel;
    }

    private void onEnableChanged() {
        boolean enabled = this.myEnableCheckBox.isSelected();
        Component topRightComponent = this.getTopRightComponent();
        if (topRightComponent != null) {
            UIUtil.setEnabled((Component)topRightComponent, (boolean)enabled, (boolean)true);
        }
        Component centerComponent = this.getCenterComponent();
        UIUtil.setEnabled((Component)centerComponent, (boolean)enabled, (boolean)true);
        this.handleEnableStatusChanged(enabled);
    }

    public void disposeResources() {
    }
}

