/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterConfigurable<T extends JSLinterState>
implements SearchableConfigurable {
    private final Project myProject;
    private final Class<? extends JSLinterConfiguration<T>> myConfigurationClass;
    private final boolean myFullModeDialog;
    private volatile boolean myUpdateEnabledStatus;
    @Nullable
    private JSLinterBaseView<T> myView;

    protected JSLinterConfigurable(@NotNull Project project, @NotNull Class<? extends JSLinterConfiguration<T>> configurationClass, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterConfigurable", "<init>"));
        }
        if (configurationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationClass", "com/intellij/lang/javascript/linter/JSLinterConfigurable", "<init>"));
        }
        this.myProject = project;
        this.myConfigurationClass = configurationClass;
        this.myFullModeDialog = fullModeDialog;
        this.myUpdateEnabledStatus = true;
    }

    public String getHelpTopic() {
        return this.getId();
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myView != null) {
            this.myView.disposeResources();
        }
        this.myView = this.createView();
        return this.myView.getComponent();
    }

    @NotNull
    protected abstract JSLinterBaseView<T> createView();

    public boolean isModified() {
        ExtendedLinterState<T> newState;
        if (this.myView == null) {
            return false;
        }
        ExtendedLinterState<T> oldState = this.getExtendedState();
        return !oldState.equals(newState = this.myView.getExtendedState());
    }

    public void apply() throws ConfigurationException {
        if (this.myView != null) {
            this.setExtendedState(this.myView.getExtendedState());
        }
    }

    public void reset() {
        if (this.myView != null) {
            this.myView.setExtendedState(this.getExtendedState());
            this.resizeDialogToFitPreferredSize(this.myView);
        }
    }

    public void disposeUIResources() {
        if (this.myView != null) {
            this.myView.disposeResources();
            this.myView = null;
        }
    }

    @NotNull
    public final ExtendedLinterState<T> getExtendedState() {
        JSLinterConfiguration<T> configuration = JSLinterConfiguration.getInstance(this.myProject, this.myConfigurationClass);
        boolean updateEnableStatus = this.myUpdateEnabledStatus;
        if (updateEnableStatus) {
            this.myUpdateEnabledStatus = false;
        }
        ExtendedLinterState<T> extendedLinterState = configuration.getExtendedState(updateEnableStatus);
        if (extendedLinterState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterConfigurable", "getExtendedState"));
        }
        return extendedLinterState;
    }

    public void setExtendedState(@NotNull ExtendedLinterState<T> state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/JSLinterConfigurable", "setExtendedState"));
        }
        JSLinterConfiguration<T> configuration = JSLinterConfiguration.getInstance(this.myProject, this.myConfigurationClass);
        configuration.setExtendedState(state);
    }

    private void resizeDialogToFitPreferredSize(@NotNull JSLinterBaseView<T> view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/lang/javascript/linter/JSLinterConfigurable", "resizeDialogToFitPreferredSize"));
        }
        if (this.myFullModeDialog) {
            final JComponent component = view.getComponent();
            new UiNotifyConnector.Once((Component)component, (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    final DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
                    if (dialogWrapper instanceof SettingsDialog || dialogWrapper instanceof SingleConfigurableEditor) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper);
                            }
                        });
                    }
                }
            });
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterConfigurable", "getProject"));
        }
        return project;
    }

    public boolean isFullModeDialog() {
        return this.myFullModeDialog;
    }

    public void showEditDialog() {
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)this);
    }
}

