/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.google.common.base.Charsets;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JsqtViewProcessOutputAction;
import com.intellij.lang.javascript.linter.eslint.EslintCheckstyleProblems;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintInspection;
import com.intellij.lang.javascript.linter.eslint.EslintPackage;
import com.intellij.lang.javascript.linter.eslint.EslintSessionData;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUnsavedConfigManager;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileChangeTracker;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.webcore.util.ProcessOutputCatcher;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintExternalAnnotator
extends JSLinterExternalAnnotator<EslintState> {
    private static final Logger LOG = Logger.getInstance(EslintExternalAnnotator.class);
    private static final EslintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new EslintExternalAnnotator(false);

    @NotNull
    public static EslintExternalAnnotator getInstanceForBatchInspection() {
        EslintExternalAnnotator eslintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (eslintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "getInstanceForBatchInspection"));
        }
        return eslintExternalAnnotator;
    }

    public EslintExternalAnnotator() {
        this(true);
    }

    public EslintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<EslintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSettingsConfigurable"));
        }
        EslintConfigurable eslintConfigurable = new EslintConfigurable(project, true);
        if (eslintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSettingsConfigurable"));
        }
        return eslintConfigurable;
    }

    @Override
    protected Class<EslintConfiguration> getConfigurationClass() {
        return EslintConfiguration.class;
    }

    @Override
    protected Class<EslintInspection> getInspectionClass() {
        return EslintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "acceptPsiFile"));
        }
        if (file instanceof JSFile) {
            FileType fileType = file.getFileType();
            return DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType);
        }
        return false;
    }

    @Override
    @Nullable
    public Icon getFileLevelAnnotationDefaultIcon() {
        return JavaScriptLanguageIcons.FileTypes.Eslint;
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<EslintState> annotate(final @NotNull JSLinterInput<EslintState> input) {
        VirtualFile specifiedConfigFile;
        File additionalRulesDir;
        EslintPackage eslintPackage;
        NodeJsLocalInterpreter localInterpreter;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "annotate"));
        }
        final VirtualFile fileToLint = input.getVirtualFile();
        if (!fileToLint.isValid()) {
            return null;
        }
        VirtualFile fileDir = fileToLint.getParent();
        if (fileDir == null) {
            return null;
        }
        final EslintState state = input.getState();
        try {
            NodeJsInterpreter interpreter = state.getInterpreterRef().resolve(input.getProject());
            localInterpreter = NodeJsLocalInterpreter.castAndValidate(interpreter);
        }
        catch (ExecutionException e) {
            return input.createFileLevelWarningResult("ESLint: " + StringUtil.decapitalize((String)e.getMessage()), new IntentionAction[0]);
        }
        try {
            eslintPackage = new EslintPackage(state.getEslintPackagePath());
            additionalRulesDir = EslintExternalAnnotator.getAdditionalRulesDir(state.getAdditionalRulesDirPath());
        }
        catch (IOException e) {
            return input.createFileLevelWarningResult(e.getMessage(), new IntentionAction[0]);
        }
        if (state.isCustomConfigFileUsed()) {
            specifiedConfigFile = JSLinterConfigFileUtil.findLocalFileByPath(state.getCustomConfigFilePath());
            if (specifiedConfigFile == null || !specifiedConfigFile.isValid()) {
                return input.createFileLevelWarningResult("ESLint: please correct path to ESLint configuration file", new IntentionAction[0]);
            }
        } else {
            specifiedConfigFile = null;
        }
        final Project project = input.getProject();
        final EslintSessionData sessionData = (EslintSessionData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<EslintSessionData>(){

            public EslintSessionData compute() {
                if (project.isDisposed()) {
                    return null;
                }
                if (EslintExternalAnnotator.this.isOnTheFly()) {
                    EslintConfigFileChangeTracker.getInstance(project).startIfNeeded();
                }
                return EslintExternalAnnotator.createSessionData(project, localInterpreter, eslintPackage, fileToLint, input.getFileContent(), specifiedConfigFile, additionalRulesDir, state.getExtraOptions());
            }
        });
        if (sessionData == null) {
            return null;
        }
        boolean runGranted = true;
        if (this.isOnTheFly()) {
            runGranted = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    if (project.isDisposed()) {
                        return false;
                    }
                    EslintUnsavedConfigManager unsavedConfigsManager = EslintUnsavedConfigManager.getInstance(project);
                    if (unsavedConfigsManager.requestRun(sessionData.findConfigs())) {
                        return true;
                    }
                    LOG.info("ESLint postponed because of unsaved configs");
                    return false;
                }
            });
        }
        if (runGranted) {
            return EslintExternalAnnotator.eslint(input, sessionData);
        }
        return null;
    }

    @Nullable
    private static File getAdditionalRulesDir(@NotNull String additionalRulesDirPath) throws IOException {
        if (additionalRulesDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalRulesDirPath", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "getAdditionalRulesDir"));
        }
        if (additionalRulesDirPath.isEmpty()) {
            return null;
        }
        File dir = new File(additionalRulesDirPath);
        if (!dir.isDirectory() || !dir.isAbsolute()) {
            throw new IOException("ESLint: please correct path to additional rules directory");
        }
        return dir;
    }

    @Nullable
    public static EslintSessionData createSessionData(@NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter, @NotNull EslintPackage eslintPackage, @NotNull VirtualFile fileToLint, @NotNull String fileContentToLint, @Nullable VirtualFile specifiedConfigurationFile, @Nullable File additionalRulesDir, @NotNull String extraOptions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSessionData"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSessionData"));
        }
        if (eslintPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintPackage", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSessionData"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSessionData"));
        }
        if (fileContentToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContentToLint", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSessionData"));
        }
        if (extraOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraOptions", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createSessionData"));
        }
        VirtualFile workingDir = EslintExternalAnnotator.guessWorkingDirectory(project, fileToLint);
        if (workingDir == null) {
            LOG.info("No working directory detected, setting to file's parent directory");
            VirtualFile fileDir = fileToLint.getParent();
            if (fileDir == null) {
                LOG.warn("No parent directory");
                return null;
            }
            workingDir = fileDir;
        }
        return new EslintSessionData(interpreter, eslintPackage, workingDir, fileToLint, fileContentToLint, specifiedConfigurationFile, additionalRulesDir, extraOptions);
    }

    @Nullable
    private static VirtualFile guessWorkingDirectory(@NotNull Project project, @NotNull VirtualFile fileToLint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "guessWorkingDirectory"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "guessWorkingDirectory"));
        }
        VirtualFile eslintIgnoreFile = JSLinterConfigFileUtil.findFileUpFileSystemRoot(fileToLint, ".eslintignore");
        VirtualFile eslintIgnoreFileDir = eslintIgnoreFile != null ? eslintIgnoreFile.getParent() : null;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(fileToLint, false);
        if (eslintIgnoreFileDir == null) {
            return contentRoot;
        }
        if (contentRoot == null) {
            return eslintIgnoreFileDir;
        }
        return VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)eslintIgnoreFileDir, (boolean)true) ? eslintIgnoreFileDir : contentRoot;
    }

    @Nullable
    private static JSLinterAnnotationResult<EslintState> eslint(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "eslint"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "eslint"));
        }
        long startNanoTime = System.nanoTime();
        JSLinterAnnotationResult<EslintState> result = EslintExternalAnnotator.runProcess(input, sessionData);
        long durationMillis = TimeoutUtil.getDurationMillis((long)startNanoTime);
        String report = result == null ? "results skipped" : "found " + result.getErrors().size() + " problems";
        LOG.info(String.format("Done in %d ms, %s", durationMillis, report));
        return result;
    }

    @Nullable
    private static JSLinterAnnotationResult<EslintState> runProcess(@NotNull JSLinterInput<EslintState> input, @NotNull EslintSessionData sessionData) {
        KillableColoredProcessHandler processHandler;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "runProcess"));
        }
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "runProcess"));
        }
        GeneralCommandLine commandLine = EslintExternalAnnotator.createCommandLine(sessionData);
        EslintPackage eslintPackage = sessionData.getEslintPackage();
        VirtualFile fileToLint = sessionData.getFileToLint();
        LOG.info("Running eslint@" + eslintPackage.getVersionStr() + " at " + sessionData.getWorkingDirectory().getPath() + "$ " + commandLine.getCommandLineString());
        try {
            processHandler = new KillableColoredProcessHandler(commandLine, false);
        }
        catch (ExecutionException e) {
            return input.createFileLevelWarningResult("ESLint failed: " + e.getMessage(), new IntentionAction[0]);
        }
        if (sessionData.getEslintPackage().isStdinSupported()) {
            String content = FilesMirror.convertLineSeparatorsToFileOriginal(input.getFileContent(), input.getVirtualFile());
            byte[] bytes = content.getBytes(commandLine.getCharset());
            try {
                OutputStream stdin = (OutputStream)ObjectUtils.assertNotNull((Object)processHandler.getProcessInput());
                stdin.write(bytes);
                stdin.flush();
                stdin.close();
            }
            catch (IOException e) {
                String message = "Failed to write " + bytes.length + " bytes to stdin";
                LOG.warn(message, (Throwable)e);
                ProcessOutput output = EslintExternalAnnotator.captureOutput((BaseOSProcessHandler)processHandler);
                output.appendStderr("\n" + message + "\n");
                IntentionAction action = EslintExternalAnnotator.createDetailsAction(input.getProject(), fileToLint, commandLine, (ProcessHandler)processHandler, output);
                return input.createFileLevelWarningResult("Failed to run ESLint", action);
            }
        }
        ProcessOutput output = EslintExternalAnnotator.captureOutput((BaseOSProcessHandler)processHandler);
        String stdout = output.getStdout();
        if (input.getProject().isDisposed()) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)stdout)) {
            IntentionAction action = EslintExternalAnnotator.createDetailsAction(input.getProject(), fileToLint, commandLine, (ProcessHandler)processHandler, output);
            return input.createFileLevelWarningResult("Failed to run ESLint", action);
        }
        EslintCheckstyleProblems checkstyleProblems = EslintCheckstyleProblems.parse(stdout, eslintPackage.isOneBasedColumn());
        if (checkstyleProblems.getFailMessage() != null) {
            IntentionAction action = EslintExternalAnnotator.createDetailsAction(input.getProject(), fileToLint, commandLine, (ProcessHandler)processHandler, output);
            return input.createFileLevelWarningResult("ESLint failed: " + checkstyleProblems.getFailMessage(), action);
        }
        return JSLinterAnnotationResult.createLinterResult(input, checkstyleProblems.getErrors(), null);
    }

    @NotNull
    private static IntentionAction createDetailsAction(@NotNull Project project, @NotNull VirtualFile fileToLint, @NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler processHandler, @NotNull ProcessOutput output) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createDetailsAction"));
        }
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createDetailsAction"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createDetailsAction"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createDetailsAction"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createDetailsAction"));
        }
        JsqtViewProcessOutputAction jsqtViewProcessOutputAction = new JsqtViewProcessOutputAction("Failed to lint " + EslintUtil.getAbsoluteOrRelativePathToProjectRoot(project, fileToLint), JavaScriptLanguageIcons.FileTypes.Eslint, commandLine, processHandler, output);
        if (jsqtViewProcessOutputAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createDetailsAction"));
        }
        return jsqtViewProcessOutputAction;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull EslintSessionData sessionData) {
        if (sessionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionData", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(Charsets.UTF_8);
        EnvironmentVariablesData.DEFAULT.configureCommandLine(commandLine, true);
        commandLine.withWorkDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)sessionData.getWorkingDirectory()));
        commandLine.setExePath(sessionData.getInterpreter().getInterpreterSystemDependentPath());
        commandLine.addParameter(sessionData.getEslintPackage().getBin().getAbsolutePath());
        if (sessionData.getAdditionalRulesDir() != null) {
            commandLine.addParameter("--rulesdir=" + sessionData.getAdditionalRulesDir().getAbsolutePath());
        }
        commandLine.addParameter("--format=checkstyle");
        if (sessionData.getSpecifiedConfigFile() != null) {
            commandLine.addParameter("--config");
            commandLine.addParameter(FileUtil.toSystemDependentName((String)sessionData.getSpecifiedConfigFile().getPath()));
        }
        if (StringUtil.isNotEmpty((String)sessionData.getExtraOptions())) {
            commandLine.addParameters(ParametersList.parse((String)sessionData.getExtraOptions()));
        }
        if (sessionData.getEslintPackage().isStdinSupported()) {
            commandLine.addParameter("--stdin");
            commandLine.addParameter("--stdin-filename");
            commandLine.addParameter(sessionData.getFileToLintRelativePath());
        } else if (FileDocumentManager.getInstance().isFileModified(sessionData.getFileToLint())) {
            File file;
            if (sessionData.getSpecifiedConfigFile() == null) {
                VirtualFile config = JSLinterConfigFileUtil.findFileUpFileSystemRoot(sessionData.getFileToLint(), ".eslintrc");
                if (config == null) {
                    config = JSLinterConfigFileUtil.findFileUpFileSystemRoot(sessionData.getFileToLint(), "package.json");
                }
                if (config != null) {
                    commandLine.addParameter("--config");
                    commandLine.addParameter(FileUtil.toSystemDependentName((String)config.getPath()));
                }
            }
            if ((file = MirrorHolder.INSTANCE.getOrCreateFileWithActualContent(sessionData.getFileToLint(), sessionData.getFileToLintContent())) == null) {
                LOG.warn("Cannot mirror " + sessionData.getFileToLint().getPath());
                file = VfsUtilCore.virtualToIoFile((VirtualFile)sessionData.getFileToLint());
            }
            commandLine.addParameter(file.getAbsolutePath());
        } else {
            commandLine.addParameter(sessionData.getFileToLintRelativePath());
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static ProcessOutput captureOutput(@NotNull BaseOSProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "captureOutput"));
        }
        ProcessOutputCatcher catcher = new ProcessOutputCatcher(processHandler);
        catcher.startNotify();
        catcher.run();
        ProcessOutput processOutput = catcher.getOutput();
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "captureOutput"));
        }
        return processOutput;
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<EslintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator", "apply"));
        }
        new JSLinterAnnotationsBuilder<EslintState>(file, annotationResult, holder, EslintInspection.getHighlightDisplayKey(), new EslintConfigurable(file.getProject(), true), "ESLint: ").apply();
    }

    private static class MirrorHolder {
        private static final FilesMirror INSTANCE = new FilesMirror("intellij-eslint-mirror");

        private MirrorHolder() {
        }
    }
}

