/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.config;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintConfigLangSubstitutor
extends LanguageSubstitutor {
    private static final Logger LOG = Logger.getInstance(EslintConfigLangSubstitutor.class);
    private static final Key<TimestampedData> ESLINT_CONFIG_TYPE_KEY = Key.create((String)"ESLINT_CONFIG_TYPE_KEY");

    @Nullable
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/config/EslintConfigLangSubstitutor", "getLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/config/EslintConfigLangSubstitutor", "getLanguage"));
        }
        if (file.getFileType() != EslintConfigFileType.INSTANCE) {
            return null;
        }
        TimestampedData data = (TimestampedData)ESLINT_CONFIG_TYPE_KEY.get((UserDataHolder)file);
        long fileTimeStamp = file.getTimeStamp();
        if (data == null || data.getTimestamp() != fileTimeStamp) {
            data = new TimestampedData(fileTimeStamp, EslintConfigLangSubstitutor.isJsonDetected(file));
            ESLINT_CONFIG_TYPE_KEY.set((UserDataHolder)file, (Object)data);
        }
        return data.isJsonDetected() ? JsonLanguage.INSTANCE : YamlLanguageHolder.INSTANCE;
    }

    private static boolean isJsonDetected(@NotNull VirtualFile file) {
        byte[] buffer;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/config/EslintConfigLangSubstitutor", "isJsonDetected"));
        }
        try {
            buffer = FileUtil.loadFirst((InputStream)file.getInputStream(), (int)64);
        }
        catch (IOException e) {
            LOG.warn("Failed to read first 64 bytes of " + file.getPath(), (Throwable)e);
            return true;
        }
        String str = new String(buffer, file.getCharset());
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch <= ' ') continue;
            return ch == '[' || ch == '{' || ch == '/';
        }
        return true;
    }

    private static class TimestampedData {
        private final long myTimestamp;
        private final boolean myJsonDetected;

        public TimestampedData(long timestamp, boolean jsonDetected) {
            this.myTimestamp = timestamp;
            this.myJsonDetected = jsonDetected;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        public boolean isJsonDetected() {
            return this.myJsonDetected;
        }
    }

    public static class YamlLanguageHolder {
        public static final Language INSTANCE = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)"yaml"), (Object)PlainTextLanguage.INSTANCE);
    }
}

