/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.importer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.importer.CompositeImportRule;
import com.intellij.lang.javascript.linter.jscs.importer.ImportRule;
import com.intellij.lang.javascript.linter.jscs.importer.PairImportRule;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JscsRulesForCodeStyle {
    public static void fillRules(Map<JscsOption, ImportRule> map, Map<JscsOption, PairImportRule> pairMap) {
        map.put(JscsOption.requireCurlyBraces, new AboutCurlyBraces(3));
        map.put(JscsOption.disallowCurlyBraces, new AboutCurlyBraces(0));
        map.put(JscsOption.maximumLineLength, new MaxLineLen());
        map.put(JscsOption.requireSpaceAfterKeywords, new AboutSpaceAfterKeywords(true));
        map.put(JscsOption.disallowSpaceAfterKeywords, new AboutSpaceAfterKeywords(false));
        map.put(JscsOption.requireSpaceBeforeBlockStatements, new AboutBraceBeforeBlock(true));
        map.put(JscsOption.disallowSpaceBeforeBlockStatements, new AboutBraceBeforeBlock(false));
        map.put(JscsOption.requireSpacesInConditionalExpression, new AboutSpacesInConditionalExpression(true));
        map.put(JscsOption.disallowSpacesInConditionalExpression, new AboutSpacesInConditionalExpression(false));
        map.put(JscsOption.requireSpacesInFunctionDeclaration, new AboutSpacesInFunctionDeclaration(true));
        map.put(JscsOption.disallowSpacesInFunctionDeclaration, new AboutSpacesInFunctionDeclaration(false));
        map.put(JscsOption.requireSpacesInFunctionExpression, new AboutSpacesInFunctionExpression(true));
        map.put(JscsOption.disallowSpacesInFunctionExpression, new AboutSpacesInFunctionExpression(false));
        map.put(JscsOption.requireSpacesInFunction, new CompositeImportRule(new AboutSpacesInFunctionDeclaration(true), new AboutSpacesInFunctionExpression(true)));
        map.put(JscsOption.disallowSpacesInFunction, new CompositeImportRule(new AboutSpacesInFunctionDeclaration(false), new AboutSpacesInFunctionExpression(false)));
        map.put(JscsOption.validateIndentation, new ValidateIndentation());
        map.put(JscsOption.requireSpacesInsideArrayBrackets, new AboutSpacesInsideArrayBrackets(true));
        map.put(JscsOption.disallowSpacesInsideArrayBrackets, new AboutSpacesInsideArrayBrackets(false));
        map.put(JscsOption.validateQuoteMarks, new QuoteMarksRule());
        pairMap.put(JscsOption.requireSpaceBeforeBinaryOperators, new AboutAroundBinaryOperators(true));
        pairMap.put(JscsOption.disallowSpaceBeforeBinaryOperators, new AboutAroundBinaryOperators(false));
        pairMap.put(JscsOption.requireSpacesInAnonymousFunctionExpression, new AboutSpacesInAnonymousAndNamedFunctionExpressions(true));
        pairMap.put(JscsOption.disallowSpacesInAnonymousFunctionExpression, new AboutSpacesInAnonymousAndNamedFunctionExpressions(false));
    }

    private static boolean isTrue(JsonElement element) {
        return element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean() && element.getAsBoolean();
    }

    private static String getStringValue(JsonElement element) {
        return element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isString() ? element.getAsString() : null;
    }

    private static Integer isInteger(JsonElement element) {
        return element != null && element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber() ? Integer.valueOf(element.getAsInt()) : null;
    }

    private static boolean processOption(JsonObject object, String name, Runnable action) {
        if (JscsRulesForCodeStyle.isOptionSet(object, name)) {
            action.run();
            return true;
        }
        return false;
    }

    private static boolean isOptionSet(@NotNull JsonObject object, @NotNull String name) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/linter/jscs/importer/JscsRulesForCodeStyle", "isOptionSet"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/jscs/importer/JscsRulesForCodeStyle", "isOptionSet"));
        }
        JsonElement element = object.get(name);
        return element != null && JscsRulesForCodeStyle.isTrue(element);
    }

    private static class QuoteMarksRule
    extends ImportRule {
        private QuoteMarksRule() {
        }

        @Override
        protected boolean applyImpl(JsonElement element, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            JsonElement mark;
            String value = JscsRulesForCodeStyle.getStringValue(element);
            if (value == null && element.isJsonObject() && (mark = element.getAsJsonObject().get("mark")) != null) {
                value = JscsRulesForCodeStyle.getStringValue(mark);
            }
            Boolean isDouble = null;
            if ("\"".equals(value)) {
                isDouble = true;
            }
            if ("'".equals(value)) {
                isDouble = false;
            }
            if (isDouble != null) {
                jsCodeStyleSettings.USE_DOUBLE_QUOTES = isDouble;
                return true;
            }
            return false;
        }
    }

    private static class AboutSpacesInAnonymousAndNamedFunctionExpressions
    extends PairImportRule {
        @NonNls
        public static final String BEFORE_OPENING_ROUND_BRACE = "beforeOpeningRoundBrace";
        @NonNls
        public static final String BEFORE_OPENING_CURLY_BRACE = "beforeOpeningCurlyBrace";
        private final boolean myValue;

        public AboutSpacesInAnonymousAndNamedFunctionExpressions(boolean value) {
            this.myValue = value;
        }

        @Override
        public JscsOption getPairRule() {
            return this.myValue ? JscsOption.requireSpacesInNamedFunctionExpression : JscsOption.disallowSpacesInNamedFunctionExpression;
        }

        @Override
        protected boolean applyImpl(JsonElement element1, JsonElement element2, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (element1.isJsonObject() && element2.isJsonObject()) {
                JsonObject object1 = element1.getAsJsonObject();
                JsonObject object2 = element2.getAsJsonObject();
                if (JscsRulesForCodeStyle.isOptionSet(object1, BEFORE_OPENING_ROUND_BRACE) && JscsRulesForCodeStyle.isOptionSet(object2, BEFORE_OPENING_ROUND_BRACE)) {
                    jsCodeStyleSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = this.myValue;
                    this.append("Spaces -> Before Parentheses -> In function expression = " + this.myValue);
                }
                if (JscsRulesForCodeStyle.isOptionSet(object1, BEFORE_OPENING_CURLY_BRACE) && JscsRulesForCodeStyle.isOptionSet(object2, BEFORE_OPENING_CURLY_BRACE)) {
                    settings.SPACE_BEFORE_METHOD_LBRACE = this.myValue;
                    this.append("Spaces -> Before Left Brace -> Function left brace = " + this.myValue);
                }
            }
            return false;
        }
    }

    private static class AboutAroundBinaryOperators
    extends PairImportRule {
        private final boolean myValue;

        public AboutAroundBinaryOperators(boolean value) {
            this.myValue = value;
        }

        @Override
        public JscsOption getPairRule() {
            return this.myValue ? JscsOption.requireSpaceAfterBinaryOperators : JscsOption.disallowSpaceAfterBinaryOperators;
        }

        @Override
        protected boolean applyImpl(JsonElement element1, JsonElement element2, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (JscsRulesForCodeStyle.isTrue(element1) && JscsRulesForCodeStyle.isTrue(element2)) {
                settings.SPACE_AROUND_ASSIGNMENT_OPERATORS = this.myValue;
                settings.SPACE_AROUND_LOGICAL_OPERATORS = this.myValue;
                settings.SPACE_AROUND_EQUALITY_OPERATORS = this.myValue;
                settings.SPACE_AROUND_RELATIONAL_OPERATORS = this.myValue;
                settings.SPACE_AROUND_BITWISE_OPERATORS = this.myValue;
                settings.SPACE_AROUND_ADDITIVE_OPERATORS = this.myValue;
                settings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = this.myValue;
                settings.SPACE_AROUND_SHIFT_OPERATORS = this.myValue;
                this.append("Spaces -> Around Operators -> (all binary) = " + this.myValue);
                return true;
            }
            return false;
        }
    }

    private static class AboutSpacesInsideArrayBrackets
    extends ImportRule {
        private final boolean myValue;

        public AboutSpacesInsideArrayBrackets(boolean value) {
            this.myValue = value;
        }

        @Override
        protected boolean applyImpl(JsonElement element, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() && "all".equals(element.getAsString())) {
                settings.SPACE_WITHIN_BRACKETS = this.myValue;
            }
            return false;
        }
    }

    private static class ValidateIndentation
    extends ImportRule {
        private ValidateIndentation() {
        }

        @Override
        protected boolean applyImpl(JsonElement element, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (this.doValue(element, settings)) {
                return true;
            }
            if (this.isTab(element)) {
                settings.getIndentOptions().USE_TAB_CHARACTER = true;
                this.append("Tabs and Indents -> Use tab character = true");
                return true;
            }
            if (element.isJsonObject()) {
                JsonElement emptyLines;
                JsonObject object = element.getAsJsonObject();
                boolean applied = false;
                JsonElement value = object.get("value");
                if (value != null) {
                    applied = this.doValue(value, settings);
                }
                if (JscsRulesForCodeStyle.isTrue(emptyLines = object.get("includeEmptyLines"))) {
                    settings.getIndentOptions().KEEP_INDENTS_ON_EMPTY_LINES = true;
                    this.append("Tabs and Indents -> Keep indents on empty lines = true");
                    applied = true;
                }
                return applied;
            }
            return false;
        }

        private boolean isTab(JsonElement element) {
            return element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() && "\t".equals(element.getAsString());
        }

        private boolean doValue(JsonElement element, CommonCodeStyleSettings settings) {
            Integer integer = JscsRulesForCodeStyle.isInteger(element);
            if (integer != null) {
                settings.getIndentOptions().INDENT_SIZE = integer;
                this.append("Tabs and Indents -> Indent = " + integer);
                return true;
            }
            if (this.isTab(element)) {
                settings.getIndentOptions().USE_TAB_CHARACTER = true;
                this.append("Tabs and Indents -> Use tab character = true");
                return true;
            }
            return false;
        }
    }

    private static class AboutSpacesInFunctionExpression
    extends ImportRule {
        private final boolean myValue;

        public AboutSpacesInFunctionExpression(boolean value) {
            this.myValue = value;
        }

        @Override
        protected boolean applyImpl(JsonElement element, final CommonCodeStyleSettings settings, final JSCodeStyleSettings jsCodeStyleSettings) {
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                boolean applied = JscsRulesForCodeStyle.processOption(object, "beforeOpeningRoundBrace", new Runnable(){

                    @Override
                    public void run() {
                        jsCodeStyleSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = myValue;
                        this.append("Spaces -> Before Parentheses -> In function expression = " + myValue);
                    }
                });
                return applied |= JscsRulesForCodeStyle.processOption(object, "beforeOpeningCurlyBrace", new Runnable(){

                    @Override
                    public void run() {
                        settings.SPACE_BEFORE_METHOD_LBRACE = myValue;
                        this.append("Spaces -> Before Left Brace -> Function left brace = " + myValue);
                    }
                });
            }
            return false;
        }
    }

    private static class AboutSpacesInFunctionDeclaration
    extends ImportRule {
        private final boolean myValue;

        private AboutSpacesInFunctionDeclaration(boolean value) {
            this.myValue = value;
        }

        @Override
        protected boolean applyImpl(JsonElement element, final CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                boolean applied = JscsRulesForCodeStyle.processOption(object, "beforeOpeningRoundBrace", new Runnable(){

                    @Override
                    public void run() {
                        settings.SPACE_BEFORE_METHOD_PARENTHESES = myValue;
                        this.append("Spaces -> Before Parentheses -> Function declaration parentheses = " + myValue);
                    }
                });
                return applied |= JscsRulesForCodeStyle.processOption(object, "beforeOpeningCurlyBrace", new Runnable(){

                    @Override
                    public void run() {
                        settings.SPACE_BEFORE_METHOD_LBRACE = myValue;
                        this.append("Spaces -> Before Left Brace -> Function left brace = " + myValue);
                    }
                });
            }
            return false;
        }
    }

    private static class AboutSpacesInConditionalExpression
    extends ImportRule {
        private final boolean myValue;

        public AboutSpacesInConditionalExpression(boolean value) {
            this.myValue = value;
        }

        @Override
        protected boolean applyImpl(JsonElement element, final CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (JscsRulesForCodeStyle.isTrue(element)) {
                this.doBeforeQ(settings);
                this.doAfterQ(settings);
                this.doBeforeColon(settings);
                this.doAfterColon(settings);
                return true;
            }
            if (element.isJsonObject()) {
                JsonObject object = element.getAsJsonObject();
                boolean applied = JscsRulesForCodeStyle.processOption(object, "afterTest", new Runnable(){

                    @Override
                    public void run() {
                        this.doBeforeQ(settings);
                    }
                });
                applied |= JscsRulesForCodeStyle.processOption(object, "beforeConsequent", new Runnable(){

                    @Override
                    public void run() {
                        this.doAfterQ(settings);
                    }
                });
                applied |= JscsRulesForCodeStyle.processOption(object, "afterConsequent", new Runnable(){

                    @Override
                    public void run() {
                        this.doBeforeColon(settings);
                    }
                });
                return applied |= JscsRulesForCodeStyle.processOption(object, "beforeAlternate", new Runnable(){

                    @Override
                    public void run() {
                        this.doAfterColon(settings);
                    }
                });
            }
            return false;
        }

        private void doAfterColon(CommonCodeStyleSettings settings) {
            settings.SPACE_AFTER_COLON = this.myValue;
            this.append("Spaces -> In Ternary Operator (?:) -> After ':' = " + this.myValue);
        }

        private void doBeforeColon(CommonCodeStyleSettings settings) {
            settings.SPACE_BEFORE_COLON = this.myValue;
            this.append("Spaces -> In Ternary Operator (?:) -> Before ':' = " + this.myValue);
        }

        private void doAfterQ(CommonCodeStyleSettings settings) {
            settings.SPACE_AFTER_QUEST = this.myValue;
            this.append("Spaces -> In Ternary Operator (?:) -> After '?' = " + this.myValue);
        }

        private void doBeforeQ(CommonCodeStyleSettings settings) {
            settings.SPACE_BEFORE_QUEST = this.myValue;
            this.append("Spaces -> In Ternary Operator (?:) -> Before '?' = " + this.myValue);
        }
    }

    private static class AboutBraceBeforeBlock
    extends ImportRule {
        private final boolean myValue;

        public AboutBraceBeforeBlock(boolean value) {
            this.myValue = value;
        }

        @Override
        protected boolean applyImpl(JsonElement element, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (JscsRulesForCodeStyle.isTrue(element)) {
                settings.SPACE_BEFORE_METHOD_LBRACE = this.myValue;
                settings.SPACE_BEFORE_IF_LBRACE = this.myValue;
                settings.SPACE_BEFORE_ELSE_LBRACE = this.myValue;
                settings.SPACE_BEFORE_FOR_LBRACE = this.myValue;
                settings.SPACE_BEFORE_WHILE_LBRACE = this.myValue;
                settings.SPACE_BEFORE_DO_LBRACE = this.myValue;
                settings.SPACE_BEFORE_SWITCH_LBRACE = this.myValue;
                settings.SPACE_BEFORE_TRY_LBRACE = this.myValue;
                settings.SPACE_BEFORE_CATCH_LBRACE = this.myValue;
                settings.SPACE_BEFORE_FINALLY_LBRACE = this.myValue;
                this.append("Spaces -> Before Left Brace -> (all values) = " + this.myValue);
                return true;
            }
            return false;
        }
    }

    private static class AboutSpaceAfterKeywords
    extends ImportRule {
        private final boolean myValue;

        public AboutSpaceAfterKeywords(boolean value) {
            this.myValue = value;
        }

        @Override
        protected boolean applyImpl(JsonElement element, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (JscsRulesForCodeStyle.isTrue(element)) {
                this.doIf(settings);
                this.doFor(settings);
                this.doWhile(settings);
                this.doSwitch(settings);
                this.doCatch(settings);
                this.doFunctionExpr(settings);
                return true;
            }
            if (element.isJsonArray()) {
                JsonArray value = element.getAsJsonArray();
                boolean applied = false;
                for (int i = 0; i < value.size(); ++i) {
                    JsonElement arrElement = value.get(i);
                    if (!arrElement.isJsonPrimitive()) continue;
                    boolean locallyApplied = true;
                    if ("if".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doIf(settings);
                    } else if ("for".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doFor(settings);
                    } else if ("while".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doWhile(settings);
                    } else if ("switch".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doSwitch(settings);
                    } else if ("catch".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doCatch(settings);
                    } else if ("function".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doFunctionExpr(settings);
                    } else {
                        locallyApplied = false;
                    }
                    applied |= locallyApplied;
                }
                return applied;
            }
            return false;
        }

        private void doIf(CommonCodeStyleSettings settings) {
            settings.SPACE_BEFORE_IF_PARENTHESES = this.myValue;
            this.append("Spaces -> Before Parentheses -> 'if' parentheses = " + this.myValue);
        }

        private void doFor(CommonCodeStyleSettings settings) {
            settings.SPACE_BEFORE_FOR_PARENTHESES = this.myValue;
            this.append("Spaces -> Before Parentheses -> 'for' parentheses = " + this.myValue);
        }

        private void doWhile(CommonCodeStyleSettings settings) {
            settings.SPACE_BEFORE_WHILE_PARENTHESES = this.myValue;
            this.append("Spaces -> Before Parentheses -> 'while' parentheses = " + this.myValue);
        }

        private void doSwitch(CommonCodeStyleSettings settings) {
            settings.SPACE_BEFORE_SWITCH_PARENTHESES = this.myValue;
            this.append("Spaces -> Before Parentheses -> 'switch' parentheses = " + this.myValue);
        }

        private void doCatch(CommonCodeStyleSettings settings) {
            settings.SPACE_BEFORE_CATCH_PARENTHESES = this.myValue;
            this.append("Spaces -> Before Parentheses -> 'catch' parentheses = " + this.myValue);
        }

        private void doFunctionExpr(CommonCodeStyleSettings settings) {
            settings.SPACE_BEFORE_METHOD_PARENTHESES = this.myValue;
            this.append("Spaces -> Before Parentheses -> In function expression = " + this.myValue);
        }
    }

    private static class MaxLineLen
    extends ImportRule {
        private MaxLineLen() {
        }

        @Override
        protected boolean applyImpl(JsonElement element, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            JsonElement valueElement;
            if (this.isValueContainer(element, settings)) {
                return true;
            }
            return element.isJsonObject() && (valueElement = element.getAsJsonObject().get("value")) != null && this.isValueContainer(valueElement, settings);
        }

        private boolean isValueContainer(JsonElement element, CommonCodeStyleSettings settings) {
            Integer value = JscsRulesForCodeStyle.isInteger(element);
            if (value != null) {
                settings.RIGHT_MARGIN = value;
                this.rightMarginSet(value);
                return true;
            }
            return false;
        }

        private void rightMarginSet(Integer value) {
            this.append("Wrapping and Braces -> Right margin (columns): = " + value);
        }
    }

    private static class AboutCurlyBraces
    extends ImportRule {
        private final int myDesiredOption;

        private AboutCurlyBraces(int option) {
            this.myDesiredOption = option;
        }

        @Override
        protected boolean applyImpl(JsonElement element, CommonCodeStyleSettings settings, JSCodeStyleSettings jsCodeStyleSettings) {
            if (JscsRulesForCodeStyle.isTrue(element)) {
                this.doIf(settings);
                this.doDoWhile(settings);
                this.doWhile(settings);
                this.doFor(settings);
                return true;
            }
            if (element.isJsonArray()) {
                JsonArray value = element.getAsJsonArray();
                boolean applied = false;
                for (int i = 0; i < value.size(); ++i) {
                    JsonElement arrElement = value.get(i);
                    if (!arrElement.isJsonPrimitive()) continue;
                    boolean locallyApplied = true;
                    if ("if".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doIf(settings);
                    } else if ("do".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doDoWhile(settings);
                    } else if ("while".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doWhile(settings);
                    } else if ("for".equals(JscsRulesForCodeStyle.getStringValue(arrElement))) {
                        this.doFor(settings);
                    } else {
                        locallyApplied = false;
                    }
                    applied |= locallyApplied;
                }
                return applied;
            }
            return false;
        }

        private void doFor(CommonCodeStyleSettings settings) {
            settings.FOR_BRACE_FORCE = this.myDesiredOption;
            this.append("Wrapping and Braces -> 'for()' statement = " + this.optionText());
        }

        private void doWhile(CommonCodeStyleSettings settings) {
            settings.WHILE_BRACE_FORCE = this.myDesiredOption;
            this.append("Wrapping and Braces -> 'while()' statement = " + this.optionText());
        }

        private void doDoWhile(CommonCodeStyleSettings settings) {
            settings.DOWHILE_BRACE_FORCE = this.myDesiredOption;
            this.append("Wrapping and Braces -> 'do ... while()' statement = " + this.optionText());
        }

        private void doIf(CommonCodeStyleSettings settings) {
            settings.IF_BRACE_FORCE = this.myDesiredOption;
            this.append("Wrapping and Braces -> 'if()' statement = " + this.optionText());
        }

        @NotNull
        private String optionText() {
            String string = this.myDesiredOption == 3 ? "Always" : "Do not force";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/importer/JscsRulesForCodeStyle$AboutCurlyBraces", "optionText"));
            }
            return string;
        }
    }
}

