/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JSHintDocumentation {
    private static final Logger LOG = Logger.getInstance(JSHintDocumentation.class);
    private final List<JSHintOptionGroup> myGroups;
    private final Map<JSHintOption, String> myNonGroupOptions;
    private final ImmutableMap<JSHintOption, String> myDescriptionByOption;

    private JSHintDocumentation(@NotNull List<JSHintOptionGroup> groups) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "<init>"));
        }
        this.myGroups = groups;
        this.myNonGroupOptions = ContainerUtil.newHashMap();
        this.myNonGroupOptions.put(JSHintOption.PREDEF, "Specifies global variables and their assignable status:<pre>DISQUS:true, jQuery:false</pre><p/>Here JSHint will allow you to override DISQUS, but complain if you try to override jQuery.");
        HashMap builder = Maps.newHashMap();
        for (JSHintOptionGroup group : groups) {
            for (JSHintOption option : group.getOptions()) {
                builder.put(option, group.getHtmlDescriptionByOption(option));
            }
        }
        builder.putAll(this.myNonGroupOptions);
        this.myDescriptionByOption = ImmutableMap.copyOf((Map)builder);
    }

    @NotNull
    public List<JSHintOptionGroup> getGroups() {
        List<JSHintOptionGroup> list = this.myGroups;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getGroups"));
        }
        return list;
    }

    @Nullable
    public String getHtmlDescriptionForNonGroupOption(@NotNull JSHintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getHtmlDescriptionForNonGroupOption"));
        }
        return this.myNonGroupOptions.get(option);
    }

    @Nullable
    public String getHtmlDescriptionByOption(@NotNull JSHintOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getHtmlDescriptionByOption"));
        }
        return (String)this.myDescriptionByOption.get((Object)option);
    }

    @NotNull
    public static JSHintDocumentation getInstance() {
        JSHintDocumentation jSHintDocumentation = Holder.INSTANCE;
        if (jSHintDocumentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getInstance"));
        }
        return jSHintDocumentation;
    }

    @NotNull
    private static JSHintDocumentation parseFromXml() {
        JSHintDocumentation jSHintDocumentation;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            String content = JSHintDocumentation.loadXmlContent();
            InputSource source = new InputSource(new StringReader(content));
            Document document = db.parse(source);
            jSHintDocumentation = JSHintDocumentation.fromDocument(document);
        }
        catch (Exception e) {
            LOG.error("Can't parse jshint documentation :(", (Throwable)e);
            JSHintDocumentation jSHintDocumentation2 = new JSHintDocumentation(Collections.emptyList());
            if (jSHintDocumentation2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "parseFromXml"));
            }
            return jSHintDocumentation2;
        }
        if (jSHintDocumentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "parseFromXml"));
        }
        return jSHintDocumentation;
    }

    @NotNull
    private static JSHintDocumentation fromDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "fromDocument"));
        }
        ArrayList groups = ContainerUtil.newArrayList();
        Element groupsElement = JSHintDocumentation.getTheOnlyChildElementWithTagName(document, "groups");
        List<Element> groupChildren = JSHintDocumentation.getChildElementsByTagName(groupsElement, "group");
        for (Element groupElement : groupChildren) {
            groups.add(JSHintDocumentation.createGroup(groupElement));
        }
        JSHintDocumentation jSHintDocumentation = new JSHintDocumentation(groups);
        if (jSHintDocumentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "fromDocument"));
        }
        return jSHintDocumentation;
    }

    @NotNull
    private static Element getTheOnlyChildElementWithTagName(@NotNull Node parentNode, @NotNull String childTagName) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getTheOnlyChildElementWithTagName"));
        }
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getTheOnlyChildElementWithTagName"));
        }
        List<Element> children = JSHintDocumentation.getChildElementsByTagName(parentNode, childTagName);
        if (children.size() != 1) {
            throw new RuntimeException("The only child is expected, but found: " + children.size());
        }
        Element element = children.get(0);
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getTheOnlyChildElementWithTagName"));
        }
        return element;
    }

    @NotNull
    private static List<Element> getChildElementsByTagName(@NotNull Node parentNode, @NotNull String childTagName) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getChildElementsByTagName"));
        }
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getChildElementsByTagName"));
        }
        ArrayList children = ContainerUtil.newArrayList();
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement = (Element)ObjectUtils.tryCast((Object)nodeList.item(i), Element.class);
            if (childElement == null || !childTagName.equals(childElement.getTagName())) continue;
            children.add(childElement);
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getChildElementsByTagName"));
        }
        return arrayList;
    }

    @NotNull
    private static JSHintOptionGroup createGroup(@NotNull Element groupElement) {
        if (groupElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupElement", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "createGroup"));
        }
        String title = JSHintDocumentation.getMandatoryAttribute(groupElement, "title");
        Element descriptionElement = JSHintDocumentation.getTheOnlyChildElementWithTagName(groupElement, "description");
        String description = descriptionElement.getTextContent();
        Element optionsElement = JSHintDocumentation.getTheOnlyChildElementWithTagName(groupElement, "options");
        List<Element> optionElements = JSHintDocumentation.getChildElementsByTagName(optionsElement, "option");
        JSHintOptionGroup group = new JSHintOptionGroup(title, description);
        for (Element optionElement : optionElements) {
            String optionKey = JSHintDocumentation.getMandatoryAttribute(optionElement, "key");
            Element optionDescriptionElement = JSHintDocumentation.getTheOnlyChildElementWithTagName(optionElement, "description");
            String optionDescription = optionDescriptionElement.getTextContent();
            JSHintOption option = JSHintOption.findByName(optionKey);
            if (option == null) {
                throw new RuntimeException("Option not found: " + optionKey);
            }
            group.add(option, optionDescription);
        }
        JSHintOptionGroup jSHintOptionGroup = group;
        if (jSHintOptionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "createGroup"));
        }
        return jSHintOptionGroup;
    }

    private static String getMandatoryAttribute(@NotNull Element element, @NotNull String attrName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getMandatoryAttribute"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "getMandatoryAttribute"));
        }
        String value = element.getAttribute(attrName);
        if (StringUtil.isEmpty((String)value)) {
            throw new RuntimeException("No '" + attrName + "' attribute!");
        }
        return value;
    }

    @NotNull
    private static String loadXmlContent() throws IOException {
        InputStream in = JSHintDocumentation.class.getResourceAsStream("jshint-documentation.xml");
        InputStreamReader reader = new InputStreamReader(in, Charsets.UTF_8);
        String string = FileUtil.loadTextAndClose((Reader)reader);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintDocumentation", "loadXmlContent"));
        }
        return string;
    }

    public String toString() {
        return this.myGroups.toString();
    }

    static /* synthetic */ JSHintDocumentation access$100() {
        return JSHintDocumentation.parseFromXml();
    }

    private static class Holder {
        private static JSHintDocumentation INSTANCE = JSHintDocumentation.access$100();

        private Holder() {
        }
    }
}

