/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfigChangeTracker;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintConfiguration;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class JSHintConfigFileChangeTracker
extends JSLinterConfigChangeTracker {
    public JSHintConfigFileChangeTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileChangeTracker", "<init>"));
        }
        super(project, (FileType)JSHintConfigFileType.INSTANCE);
    }

    @NotNull
    public static JSHintConfigFileChangeTracker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileChangeTracker", "getInstance"));
        }
        JSHintConfigFileChangeTracker jSHintConfigFileChangeTracker = (JSHintConfigFileChangeTracker)ServiceManager.getService((Project)project, JSHintConfigFileChangeTracker.class);
        if (jSHintConfigFileChangeTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileChangeTracker", "getInstance"));
        }
        return jSHintConfigFileChangeTracker;
    }

    @Override
    protected boolean isAnalyzerRestartNeeded(@NotNull Project project, @NotNull VirtualFile changedFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileChangeTracker", "isAnalyzerRestartNeeded"));
        }
        if (changedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFile", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigFileChangeTracker", "isAnalyzerRestartNeeded"));
        }
        ExtendedLinterState extendedState = JSHintConfiguration.getInstance(project).getExtendedState();
        JSHintState state = (JSHintState)extendedState.getState();
        if (!extendedState.isEnabled() || !state.isConfigFileUsed()) {
            return false;
        }
        if (state.isCustomConfigFileUsed()) {
            return changedFile.equals(JSLinterConfigFileUtil.findLocalFileByPath(state.getCustomConfigFilePath()));
        }
        return true;
    }
}

