/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.ui;

import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.Function;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterConfigFileView {
    private static final String EMPTY_ERROR_TEXT = " ";
    private final FileType myConfigFileType;
    private final JPanel myComponent;
    private final JRadioButton mySearchRadioButton;
    private final JRadioButton myConfigRadioButton;
    private final TextFieldWithHistoryWithBrowseButton myConfigFileField;
    private final List<Pair<JRadioButton, JComponent>> myRadioButtonWithContentList;
    private final JLabel myConfigFileErrorLabel;
    private NotNullProducer<List<VirtualFile>> myAdditionalConfigFilesGetter;

    public JSLinterConfigFileView(@NotNull Project project, @NotNull JSLinterConfigFileTexts texts, @NotNull FileType configFileType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "<init>"));
        }
        if (texts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "texts", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "<init>"));
        }
        if (configFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFileType", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "<init>"));
        }
        this.myConfigFileType = configFileType;
        this.mySearchRadioButton = new JBRadioButton(texts.getSearchOptionTitle());
        JEditorPane searchDescriptionEditor = JSLinterUtil.createHtmlViewer(texts.getSearchOptionDescription(), UIUtil.getTitledBorderFont());
        JPanel searchDescriptionPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)searchDescriptionEditor);
        this.myConfigRadioButton = new JBRadioButton("\u001bConfiguration file:");
        this.myConfigFileField = this.createCustomConfigField(project, texts.getConfigFileBrowseDialogTitle());
        this.myConfigFileErrorLabel = new JLabel(EMPTY_ERROR_TEXT);
        this.myConfigFileErrorLabel.setFont(UIUtil.getTitledBorderFont());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mySearchRadioButton);
        buttonGroup.add(this.myConfigRadioButton);
        this.myRadioButtonWithContentList = ContainerUtil.newArrayList((Object[])new Pair[]{Pair.create((Object)this.mySearchRadioButton, (Object)searchDescriptionPanel), Pair.create((Object)this.myConfigRadioButton, (Object)this.myConfigFileField)});
        this.selectOption(this.mySearchRadioButton, true);
        ((TextFieldWithHistory)this.myConfigFileField.getChildComponent()).getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                JSLinterConfigFileView.this.updateCustomErrorMessage();
            }
        });
        this.myComponent = this.createResultPanel(this.myRadioButtonWithContentList, texts.getFooterHtmlDescription());
    }

    public void setAdditionalConfigFilesGetter(@NotNull NotNullProducer<List<VirtualFile>> additionalConfigFilesGetter) {
        if (additionalConfigFilesGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalConfigFilesGetter", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "setAdditionalConfigFilesGetter"));
        }
        this.myAdditionalConfigFilesGetter = additionalConfigFilesGetter;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "getComponent"));
        }
        return jPanel;
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (enabled) {
            this.selectOption(this.mySearchRadioButton, this.mySearchRadioButton.isSelected());
        }
        this.updateCustomErrorMessage();
    }

    private void selectOption(@NotNull JRadioButton radioButton, boolean selected) {
        if (radioButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "radioButton", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "selectOption"));
        }
        for (Pair<JRadioButton, JComponent> pair : this.myRadioButtonWithContentList) {
            boolean pairSelected = pair.getFirst() == radioButton ? selected : !selected;
            ((JRadioButton)pair.getFirst()).setSelected(pairSelected);
            UIUtil.setEnabled((Component)((Component)pair.getSecond()), (boolean)pairSelected, (boolean)true);
        }
        this.updateCustomErrorMessage();
    }

    public boolean isCustomConfigFileUsed() {
        return this.myConfigRadioButton.isSelected();
    }

    @NotNull
    public String getCustomConfigFilePath() {
        String string = this.myConfigFileField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "getCustomConfigFilePath"));
        }
        return string;
    }

    public void setCustomConfigFileUsed(boolean customConfigFileUsed) {
        this.selectOption(this.myConfigRadioButton, customConfigFileUsed);
    }

    public void setCustomConfigFilePath(@NotNull String customConfigFilePath) {
        if (customConfigFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customConfigFilePath", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "setCustomConfigFilePath"));
        }
        TextFieldWithHistory history = (TextFieldWithHistory)this.myConfigFileField.getChildComponent();
        history.setText(customConfigFilePath);
        history.addCurrentTextToHistory();
    }

    private void updateCustomErrorMessage() {
        if (this.myConfigRadioButton.isSelected() && this.myConfigRadioButton.isEnabled()) {
            String errorMessage = JSLinterConfigFileView.formatErrorMessage(((TextFieldWithHistory)this.myConfigFileField.getChildComponent()).getText());
            if (errorMessage != null) {
                String html = XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>" + errorMessage + "</font>"));
                this.myConfigFileErrorLabel.setText(html);
            } else {
                this.myConfigFileErrorLabel.setText(EMPTY_ERROR_TEXT);
            }
        } else {
            this.myConfigFileErrorLabel.setText(EMPTY_ERROR_TEXT);
        }
    }

    @Nullable
    private static String formatErrorMessage(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "formatErrorMessage"));
        }
        if (path.trim().isEmpty()) {
            return "Empty path";
        }
        File file = new File(path);
        if (!file.isAbsolute() || !file.isFile()) {
            return "No such file";
        }
        return null;
    }

    @NotNull
    private JPanel createResultPanel(@NotNull List<Pair<JRadioButton, JComponent>> contentByRadioButton, @Nullable String footerHtmlDescription) {
        if (contentByRadioButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentByRadioButton", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "createResultPanel"));
        }
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            final JRadioButton jRadioButton = (JRadioButton)pair.getFirst();
            jRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JSLinterConfigFileView.this.selectOption(jRadioButton, jRadioButton.isSelected());
                }
            });
        }
        ArrayList components = ContainerUtil.newArrayList();
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            JRadioButton radioButton;
            if (!components.isEmpty()) {
                components.add(Box.createVerticalStrut(8));
            }
            if ((radioButton = (JRadioButton)pair.getFirst()) == this.myConfigRadioButton) {
                components.add(this.createCustomConfigFilePanel());
                continue;
            }
            components.add(radioButton);
            int leftMargin = radioButton.getInsets().left + radioButton.getMargin().left + JSLinterUtil.getRadioIconWidth() + radioButton.getIconTextGap();
            JPanel wrap = SwingHelper.wrapWithHorizontalStretch((JComponent)((JComponent)pair.getSecond()));
            wrap.setBorder(BorderFactory.createEmptyBorder(0, leftMargin, 0, 0));
            components.add(wrap);
        }
        if (footerHtmlDescription != null) {
            components.add(JSLinterUtil.createHtmlViewer(footerHtmlDescription, UIUtil.getTitledBorderFont()));
        }
        JPanel jPanel = JSLinterConfigFileView.createVerticalPanelFrom(components);
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Configuration file", (boolean)true));
        JPanel jPanel2 = jPanel;
        if (jPanel2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "createResultPanel"));
        }
        return jPanel2;
    }

    @NotNull
    private JPanel createCustomConfigFilePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        int labelComponentGap = Math.max(0, 6);
        int componentTopInset = 0;
        if (UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula()) {
            componentTopInset = 1;
        }
        panel.add((Component)this.myConfigRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, labelComponentGap), 0, 0));
        panel.add((Component)this.myConfigFileField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(componentTopInset, 0, 0, 0), 0, 0));
        panel.add((Component)this.myConfigFileErrorLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "createCustomConfigFilePanel"));
        }
        return jPanel;
    }

    private static JPanel createVerticalPanelFrom(@NotNull List<Component> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "createVerticalPanelFrom"));
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int i = 0;
        for (Component component : components) {
            panel.add(component, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            ++i;
        }
        return panel;
    }

    @NotNull
    private TextFieldWithHistoryWithBrowseButton createCustomConfigField(final @NotNull Project project, String selectFileText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "createCustomConfigField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)selectFileText, (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), (NotNullProducer)new NotNullProducer<List<String>>(){

            @NotNull
            public List<String> produce() {
                List<VirtualFile> files = JSLinterConfigFileView.this.listConfigFilesInContentScope(project);
                List filePaths = ContainerUtil.map(files, (Function)new Function<VirtualFile, String>(){

                    public String fun(VirtualFile file) {
                        return FileUtil.toSystemDependentName((String)file.getPath());
                    }
                });
                Collections.sort(filePaths);
                List list = filePaths;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView$3", "produce"));
                }
                return list;
            }
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "createCustomConfigField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public List<VirtualFile> listConfigFilesInContentScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "listConfigFilesInContentScope"));
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
        Collection configs = FileTypeIndex.getFiles((FileType)this.myConfigFileType, (GlobalSearchScope)scope);
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile config : configs) {
            String path;
            if (config == null || !config.isValid() || config.isDirectory() || (path = config.getPath()).contains("/node_modules/") || path.contains("/bower_components/")) continue;
            result.add(config);
        }
        if (this.myAdditionalConfigFilesGetter != null) {
            List files = (List)this.myAdditionalConfigFilesGetter.produce();
            result.addAll(files);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/ui/JSLinterConfigFileView", "listConfigFilesInContentScope"));
        }
        return arrayList;
    }

    public void setPreferredWidthToComponents() {
        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigFileField);
    }
}

