/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ImportES6ModuleFix
extends ImportCommonJSModuleFix {
    private String myInsertedText;
    private String myCorrectedPath;

    public ImportES6ModuleFix(@NotNull JSReferenceExpression node, @NotNull ModuleFixCreator.FixDescriptor descriptor, boolean singleQuotes) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "<init>"));
        }
        super(node, descriptor, singleQuotes);
    }

    @Override
    protected boolean isPreferImportAnchor() {
        return true;
    }

    @Override
    public String getPath() {
        if (this.myCorrectedPath != null) {
            return this.myCorrectedPath;
        }
        String path = super.getPath();
        int slashIdx = path.lastIndexOf(47);
        int dotIdx = path.lastIndexOf(46);
        this.myCorrectedPath = path;
        if (dotIdx > 0 && dotIdx > slashIdx) {
            this.myCorrectedPath = this.myCorrectedPath.substring(0, dotIdx);
        }
        return this.myCorrectedPath;
    }

    @Override
    protected PsiElement createRequire(Project project) {
        PsiFile file = ImportES6ModuleFix.createDummyFile(project, this.getInsertedText() + ";");
        return file.getFirstChild();
    }

    private String getInsertedText() {
        if (this.myInsertedText == null) {
            String prefix = this.getPrefix();
            this.myInsertedText = this.mySingleQuotes ? "import " + prefix + " from '" + this.getPath() + "'" : "import " + prefix + " from \"" + this.getPath() + "\"";
        }
        return this.myInsertedText;
    }

    @NotNull
    private String getPrefix() {
        String varName = this.myFixDescriptor.getFirstWordInFile();
        if (this.myFixDescriptor.isDefaultExport()) {
            String string = varName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
            }
            return string;
        }
        if (this.myFixDescriptor.getFirstWordInExportsName() != null) {
            if (this.myFixDescriptor.getFirstWordInExportsName().equals(varName)) {
                String string = "{" + varName + "}";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
                }
                return string;
            }
            String string = "{" + this.myFixDescriptor.getFirstWordInExportsName() + " as " + varName + "}";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
            }
            return string;
        }
        if (this.myFixDescriptor.getTail() != null) {
            String string = "{" + this.myFixDescriptor.getTail()[0] + "}";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
            }
            return string;
        }
        String string = "* as " + varName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getPrefix"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        char quote = this.mySingleQuotes ? (char)'\"' : '\'';
        String string = "Insert " + quote + this.getInsertedText() + quote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix", "getText"));
        }
        return string;
    }
}

