/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.LocalReferenceResolver;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseModulesDependenciesElementVisitor
extends JSElementVisitor {
    private static final Key<Set<VirtualFile>> ourPredefinedLibrariesKey = Key.create((String)"NodeJs.Predefined.Libraies");
    private static final Key<Set<String>> ourDefines = Key.create((String)"NodeJs.Defined.Variables");
    protected final LocalInspectionToolSession mySession;
    private final ProblemsHolder myHolder;
    private final boolean myOnTheFly;
    private ResolveResult[] myResolveResults;
    protected JSReferenceExpression myNode;
    protected ModuleReferenceInfo myModuleReferenceInfo;
    private static final Set<String> BROWSER_GLOBALS = new HashSet<String>();

    public JSBaseModulesDependenciesElementVisitor(LocalInspectionToolSession session, ProblemsHolder holder, boolean onTheFly) {
        BROWSER_GLOBALS.add("document");
        BROWSER_GLOBALS.add("navigator");
        BROWSER_GLOBALS.add("screen");
        BROWSER_GLOBALS.add("history");
        BROWSER_GLOBALS.add("location");
        this.mySession = session;
        this.myHolder = holder;
        this.myOnTheFly = onTheFly;
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        this.myNode = node;
        if (!DialectDetector.isJavaScript((PsiElement)node.getContainingFile())) {
            return;
        }
        JSExpression qualifier = node.getQualifier();
        if (qualifier != null) {
            return;
        }
        ProblemHighlightType unresolvedReferenceHighlightType = JSBaseModulesDependenciesElementVisitor.getUnresolvedReferenceHighlightType(node);
        if (!ProblemHighlightType.LIKE_UNKNOWN_SYMBOL.equals((Object)unresolvedReferenceHighlightType)) {
            return;
        }
        if (JSBaseModulesDependenciesElementVisitor.predefinedModulesWords(StringUtil.notNullize((String)node.getText()))) {
            return;
        }
        this.myModuleReferenceInfo = new ModuleReferenceInfo(node);
        if (this.myModuleReferenceInfo.getModuleName() == null) {
            return;
        }
        if (JSBaseModulesDependenciesElementVisitor.predefinedModulesWords(StringUtil.notNullize((String)this.myModuleReferenceInfo.getTopLevelMember()))) {
            return;
        }
        JsModulesSuggester modulesSuggester = this.createSuggester();
        if (modulesSuggester == null) {
            return;
        }
        boolean noCompleteResolve = this.isNotResolved(modulesSuggester);
        if (noCompleteResolve) {
            modulesSuggester.findFixes(this.myResolveResults, ContainerUtil.notNullize((Set)((Set)this.mySession.getUserData(ourPredefinedLibrariesKey))));
            String inspectionText = this.getInspectionText();
            if (modulesSuggester.isEmpty()) {
                if (modulesSuggester.warnWithoutVariants()) {
                    this.myHolder.registerProblemForReference((PsiReference)this.myNode, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, inspectionText, new LocalQuickFix[0]);
                }
                return;
            }
            List<Pair<JSReferenceExpression, List<LocalQuickFix>>> fixes = modulesSuggester.getFixes();
            for (int i = 0; i < fixes.size(); ++i) {
                Pair<JSReferenceExpression, List<LocalQuickFix>> pair = fixes.get(i);
                List<LocalQuickFix> list = (List<LocalQuickFix>)pair.getSecond();
                if ((list = JSBaseModulesDependenciesElementVisitor.sortAndFilter(list, this.myModuleReferenceInfo)).isEmpty()) {
                    return;
                }
                if (i == 0 && !this.checkDefines(this.mySession, list)) {
                    return;
                }
                this.myHolder.registerProblemForReference((PsiReference)pair.getFirst(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, inspectionText, list.toArray(new LocalQuickFix[list.size()]));
            }
        }
    }

    protected abstract String getInspectionText();

    @Nullable
    protected abstract JsModulesSuggester createSuggester();

    private static List<LocalQuickFix> sortAndFilter(@NotNull List<LocalQuickFix> fixes, ModuleReferenceInfo moduleReferenceInfo) {
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "sortAndFilter"));
        }
        Collections.sort(fixes, new Comparator<LocalQuickFix>(){

            @Override
            public int compare(LocalQuickFix o1, LocalQuickFix o2) {
                return ((IntentionAction)o1).getText().compareTo(((IntentionAction)o2).getText());
            }
        });
        ArrayList<LocalQuickFix> sublist = new ArrayList<LocalQuickFix>();
        for (LocalQuickFix fix : fixes) {
            String path;
            if (!(fix instanceof ImportCommonJSModuleFix) || !(path = ((ImportCommonJSModuleFix)fix).getPath()).equals(moduleReferenceInfo.getModuleName()) && !path.startsWith(moduleReferenceInfo.getModuleName() + "/")) continue;
            sublist.add(fix);
        }
        if (!sublist.isEmpty()) {
            return sublist;
        }
        return fixes;
    }

    private static ProblemHighlightType getUnresolvedReferenceHighlightType(JSReferenceExpression node) {
        if (node.getQualifier() == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    private static boolean predefinedModulesWords(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "predefinedModulesWords"));
        }
        return "require".equals(text) || "define".equals(text) || "module".equals(text) || "exports".equals(text) || "window".equals(text) || "global".equals(text) || "arguments".equals(text) || BROWSER_GLOBALS.contains(text.toLowerCase());
    }

    private boolean isNotResolved(JsModulesSuggester modulesSuggester) {
        this.myResolveResults = this.myNode.multiResolve(false);
        if (new LocalReferenceResolver(this.myNode.getContainingFile()).checkResolveResults(this.myNode, this.myResolveResults)) {
            return false;
        }
        this.initPredefinedLibraries();
        if (this.myResolveResults.length == 0) {
            return true;
        }
        for (ResolveResult result : this.myResolveResults) {
            if (result instanceof JSResolveResult && ((JSResolveResult)result).wasES6ImportUsed()) {
                return false;
            }
            if (!modulesSuggester.isResolvedGlobally(result, (Set)this.mySession.getUserData(ourPredefinedLibrariesKey))) continue;
            return false;
        }
        return true;
    }

    private boolean checkDefines(@NotNull LocalInspectionToolSession session, @NotNull List<LocalQuickFix> fixes) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "checkDefines"));
        }
        if (fixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "checkDefines"));
        }
        if (this.myOnTheFly) {
            return true;
        }
        if (fixes.isEmpty()) {
            return false;
        }
        Set data = (Set)session.getUserData(ourDefines);
        String varName = ((ImportJSModuleBaseFix)fixes.get(0)).getVarName();
        if (data != null && data.contains(varName)) {
            return false;
        }
        data = data == null ? new HashSet() : data;
        data.add(varName);
        session.putUserData(ourDefines, (Object)data);
        return true;
    }

    private void initPredefinedLibraries() {
        HashSet<VirtualFile> predefinedLibraries = (HashSet<VirtualFile>)this.mySession.getUserData(ourPredefinedLibrariesKey);
        if (predefinedLibraries != null) {
            return;
        }
        predefinedLibraries = new HashSet<VirtualFile>();
        PsiFile psiFile = this.mySession.getFile();
        JSLibraryManager jsLibraryManager = JSLibraryManager.getInstance(psiFile.getProject());
        Set librariesForFile = jsLibraryManager.getLibraryMappings().getLibraryFilesFor(psiFile.getVirtualFile());
        predefinedLibraries.addAll(librariesForFile);
        predefinedLibraries.addAll(JSCorePredefinedLibrariesProvider.getAllRequiredLibraryFiles());
        predefinedLibraries.removeAll(NodeJsCoreLibraryManager.getInstance(psiFile.getProject()).getCoreModules());
        this.mySession.putUserData(ourPredefinedLibrariesKey, predefinedLibraries);
    }

    public static boolean isForBrowser(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "isForBrowser"));
        }
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/lang/javascript/modules/JSBaseModulesDependenciesElementVisitor", "isForBrowser"));
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        return mappings.isLibraryInScopeFor(vf, "HTML");
    }
}

