/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.javascript.nodejs.ForRequireModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.ecmascript6.completion.ES6ImportSpecifierCompletionProvider;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JSBaseModulesSearcher;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSModulesSearcher
extends JSBaseModulesSearcher {
    private ModuleFixCreator myModuleFixCreator;
    private boolean myNotImportedES6ClassMemberUsage;
    private VirtualFile myModuleRoot;
    private boolean myOnlyCommonJs;

    public NodeJSModulesSearcher(@NotNull LocalInspectionToolSession session, @NotNull ModuleReferenceInfo info, @NotNull JSReferenceExpression node, @NotNull ResolveResult[] results, @NotNull Set<VirtualFile> files) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "<init>"));
        }
        super(session, info, node, results, files);
        this.myOnlyCommonJs = true;
    }

    public NodeJSModulesSearcher ignoreNodeLibraryAssociation() {
        this.myOnlyCommonJs = false;
        return this;
    }

    @Override
    public List<ModuleFixCreator.FixDescriptor> find() {
        this.myModuleRoot = NodeModuleUtil.getMainModuleRoot(this.mySession);
        if (this.myModuleRoot == null) {
            return Collections.emptyList();
        }
        this.myModuleFixCreator = new ModuleFixCreator(this.myPredefinedFiles);
        for (ResolveResult result : this.myResolveResults) {
            if (result.getElement() == null) continue;
            this.myModuleFixCreator.checkResolve(result.getElement());
        }
        if (this.myModuleFixCreator.isNoFixesShouldBeSuggested()) {
            return Collections.emptyList();
        }
        this.suggestHardcodedVariants();
        if (this.myModuleReferenceInfo.getTopLevelInModuleRef() != null) {
            if (!this.findVariantsForMethods(this.myModuleReferenceInfo, this.myModuleRoot)) {
                return this.myModuleFixCreator.getFixDescriptors();
            }
        } else {
            String referenceName = this.myNode.getReferenceName();
            if (referenceName != null) {
                VirtualFile coreModule = NodeJsCoreLibraryManager.getInstance(this.myNode.getProject()).findCoreModuleFileByName(referenceName);
                if (coreModule != null) {
                    this.myModuleFixCreator.addFix(new ModuleFixCreator.FixDescriptor(ModuleFixCreator.ModuleType.nodejs, coreModule.getNameWithoutExtension(), coreModule, referenceName, null));
                    return this.myModuleFixCreator.getFixDescriptors();
                }
                VirtualFile byName = NodeModuleUtil.getProjectChildModuleByName(this.myNode.getProject(), this.myModuleRoot, referenceName);
                if (byName != null && byName.getNameWithoutExtension().equals(referenceName)) {
                    this.myModuleFixCreator.addFix(new ModuleFixCreator.FixDescriptor(ModuleFixCreator.ModuleType.nodejs, referenceName, byName, referenceName, null));
                    return this.myModuleFixCreator.getFixDescriptors();
                }
                this.findMatchingExports(referenceName);
                if (!this.myOnlyCommonJs && this.myModuleFixCreator.isEmpty()) {
                    this.findCandidatesFromImportedFiles(referenceName);
                }
            }
        }
        return this.myModuleFixCreator.getFixDescriptors();
    }

    private void suggestHardcodedVariants() {
        VirtualFile moduleFile;
        VirtualFile byName;
        String referenceName = this.myNode.getReferenceName();
        if ("React".equals(referenceName) && (byName = NodeModuleUtil.getProjectChildModuleByName(this.myNode.getProject(), this.myModuleRoot, "react")) != null && byName.isDirectory() && (moduleFile = byName.findChild("react.js")) != null) {
            this.myModuleFixCreator.addFix(new ModuleFixCreator.FixDescriptor(ModuleFixCreator.ModuleType.nodejs, "react", moduleFile, "React", null));
        }
    }

    private void findCandidatesFromImportedFiles(String referenceName) {
        PsiFile file = this.myNode.getContainingFile();
        if (file instanceof JSFile) {
            Set<ES6ImportDeclaration> imports = NodeJSModulesSearcher.findImportsInFile(file);
            HashSet<JSFile> filesFromImport = new HashSet<JSFile>();
            for (ES6ImportDeclaration anImport : imports) {
                PsiFile psiFile;
                ES6FromClause fromClause = anImport.getFromClause();
                if (fromClause == null) continue;
                Collection elements = fromClause.resolveReferencedElements();
                if ((elements = ContainerUtil.filter((Collection)elements, (Condition)new Condition<PsiElement>(){

                    public boolean value(PsiElement element) {
                        return element != null && element.isValid();
                    }
                })).size() != 1 || !((psiFile = ((PsiElement)elements.iterator().next()).getContainingFile()) instanceof JSFile)) continue;
                filesFromImport.add((JSFile)psiFile);
            }
            for (JSFile jsFile : filesFromImport) {
                SinkResolveProcessor<CompletionResultSink> es6processor = ES6ImportSpecifierCompletionProvider.createCompletionProcessor(null);
                ES6PsiUtil.processExportDeclarationInScope((JSElement)jsFile, es6processor, ResolveState.initial(), null, (PsiElement)jsFile);
                List<PsiElement> es6processorResults = es6processor.getResults();
                if (es6processorResults == null) continue;
                for (PsiElement result : es6processorResults) {
                    if (!result.isValid() || !(result instanceof JSElementBase) || ((JSElementBase)result).getNamespace() != null || !referenceName.equals(((JSNamedElementBase)result).getName())) continue;
                    this.processPossibleMatch(result, true, referenceName);
                }
            }
        }
    }

    private static Set<ES6ImportDeclaration> findImportsInFile(PsiFile file) {
        final HashSet<ES6ImportDeclaration> set = new HashSet<ES6ImportDeclaration>();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(null){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher$2", "execute"));
                }
                if (element instanceof ES6ImportDeclaration) {
                    set.add((ES6ImportDeclaration)element);
                } else if (element instanceof ES6ImportSpecifier && element.getParent() instanceof ES6ImportDeclaration) {
                    set.add((ES6ImportDeclaration)element.getParent());
                }
                return true;
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)file, processor, false);
        return set;
    }

    private void findMatchingExports(String referenceName) {
        for (ResolveResult result : this.myResolveResults) {
            if (!result.isValidResult() && !"javascript.element.need.to.be.imported".equals(((JSResolveResult)result).getResolveProblemKey())) continue;
            PsiElement element = result.getElement();
            this.processPossibleMatch(element, true, referenceName);
        }
        PsiFile file = this.myNode.getContainingFile();
        if (file instanceof JSFile && DialectDetector.isES6((PsiElement)file)) {
            PsiFile[] files;
            for (PsiFile psiFile : files = FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(referenceName + ".js"), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myNode.getProject()))) {
                ModuleFixCreator.FixDescriptor descriptor;
                JSElement export;
                if (!(psiFile instanceof JSFile) || (export = ES6PsiUtil.findDefaultExport((JSElement)((JSFile)psiFile))) == null || (descriptor = this.addFixFromFile(psiFile, null, ModuleFixCreator.ModuleType.es6)) == null) continue;
                descriptor.setDefaultExport(true);
            }
        }
    }

    private void searchWithStubIndex(String referenceName, Project project, boolean withoutModuleWord) {
        ArrayList elementsToProcess = new ArrayList();
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)referenceName, project, GlobalSearchScope.allScope((Project)project), JSElement.class, (Processor)new CommonProcessors.CollectProcessor(elementsToProcess));
        for (JSElement element : elementsToProcess) {
            this.processPossibleMatch((PsiElement)element, withoutModuleWord, referenceName);
        }
    }

    private boolean processPossibleMatch(PsiElement element, boolean withoutModuleWord, String referenceName) {
        String aliasText;
        PsiFile file = element.getContainingFile();
        if (!(element.isValid() && file.isValid() && file instanceof JSFile)) {
            return false;
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        JSQualifiedName elementNamespace = ((JSQualifiedNamedElement)element).getNamespace();
        JSFile jsFile = (JSFile)file;
        String string = aliasText = jsFile.getExportsInnerAlias() == null ? null : jsFile.getExportsInnerAlias().getTypeText();
        if (elementNamespace != null) {
            ModuleFixCreator.FixDescriptor descriptor;
            boolean isAlias = elementNamespace.getName().equals(aliasText);
            if ((NodeJSModulesSearcher.isExports(elementNamespace.getName()) || isAlias) && (descriptor = this.addFixFromFile((PsiFile)jsFile, withoutModuleWord ? ((JSQualifiedNamedElement)element).getName() : null, ModuleFixCreator.ModuleType.nodejs)) != null) {
                if (withoutModuleWord) {
                    descriptor.moduleElementIsMissing();
                }
                return true;
            }
        }
        JSReferenceExpression completionElement = withoutModuleWord ? this.myNode : this.myModuleReferenceInfo.getTopLevelInModuleRef();
        SinkResolveProcessor<CompletionResultSink> processor = ES6ImportSpecifierCompletionProvider.createCompletionProcessor((PsiElement)completionElement);
        JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)file, processor, false);
        List<PsiElement> results = processor.getResults();
        if (results != null) {
            for (PsiElement result : results) {
                JSQualifiedNamedElement namedElement;
                JSQualifiedName namespace;
                if (elementNamespace == null || !(result instanceof JSQualifiedNamedElement) || (namespace = (namedElement = (JSQualifiedNamedElement)result).getNamespace()) == null || !elementNamespace.getName().equals(namedElement.getName()) && !element.equals(result)) continue;
                String nameInExports = null;
                String qualifiedName = namedElement.getQualifiedName();
                if (!(NodeJSModulesSearcher.isExports(qualifiedName) || aliasText != null && qualifiedName != null && qualifiedName.equals(aliasText))) {
                    nameInExports = element.equals(result) ? ((JSQualifiedNamedElement)element).getName() : namedElement.getName();
                }
                this.addFixFromFile((PsiFile)jsFile, nameInExports, ModuleFixCreator.ModuleType.nodejs);
                return true;
            }
        }
        if (!DialectDetector.isES6((PsiElement)file)) {
            return false;
        }
        if (this.isResolveFromDefaultExport(element, withoutModuleWord, jsFile)) {
            return true;
        }
        if (this.processES6ImportDeclarationsForResolvedElement(element, withoutModuleWord, referenceName, file, elementNamespace, jsFile, (PsiElement)completionElement)) {
            return true;
        }
        if ((element instanceof ES6Class || element.getParent() instanceof ES6Class) && this.myNode.getParent() instanceof JSNewExpression) {
            this.myNotImportedES6ClassMemberUsage = true;
        }
        return false;
    }

    private boolean processES6ImportDeclarationsForResolvedElement(PsiElement element, boolean withoutModuleWord, String referenceName, PsiFile file, JSQualifiedName elementNamespace, JSFile jsFile, PsiElement completionElement) {
        SinkResolveProcessor<CompletionResultSink> es6processor = ES6ImportSpecifierCompletionProvider.createCompletionProcessor(completionElement);
        ES6PsiUtil.processExportDeclarationInScope((JSElement)file, es6processor, ResolveState.initial(), null, (PsiElement)file);
        List<PsiElement> es6processorResults = es6processor.getResults();
        if (es6processorResults != null) {
            for (PsiElement result : es6processorResults) {
                ModuleFixCreator.FixDescriptor descriptor;
                boolean foundByNamespace = false;
                if (!(result instanceof JSNamedElement) || !referenceName.equals(((JSNamedElement)result).getName()) && !(foundByNamespace = elementNamespace != null && Comparing.equal((String)((JSNamedElement)result).getName(), (String)elementNamespace.getName()))) continue;
                if (result instanceof ES6Class && !(this.myNode.getParent() instanceof JSNewExpression)) {
                    boolean ok = this.myNode.getParent() instanceof JSNewExpression;
                    ok |= element instanceof JSFunction && ((JSFunction)element).getJSContext() == JSContext.STATIC;
                    if (!(ok |= element instanceof ES6Class)) continue;
                }
                if ((descriptor = this.addFixFromFile((PsiFile)jsFile, foundByNamespace || withoutModuleWord ? ((JSNamedElement)result).getName() : null, ModuleFixCreator.ModuleType.es6)) == null) continue;
                if (foundByNamespace && this.myModuleReferenceInfo.getTopLevelInModuleRef() != null && this.myModuleReferenceInfo.getModuleName().equals(elementNamespace.getName())) {
                    descriptor.setTwoWordsMath(true);
                }
                if (withoutModuleWord) {
                    descriptor.moduleElementIsMissing();
                }
                if (result.getParent() instanceof ES6ExportDefaultAssignment) {
                    descriptor.setDefaultExport(true);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isNotImportedES6ClassMemberUsage() {
        return this.myNotImportedES6ClassMemberUsage;
    }

    private boolean isResolveFromDefaultExport(PsiElement element, boolean withoutModuleWord, JSFile jsFile) {
        ModuleFixCreator.FixDescriptor descriptor;
        PsiElement current;
        for (current = element; !(current instanceof JSStatement) && !(current instanceof JSFile) && current != null; current = current.getParent()) {
        }
        if (current instanceof ES6ExportDefaultAssignment && (descriptor = this.addFixFromFile((PsiFile)jsFile, withoutModuleWord ? ((JSQualifiedNamedElement)element).getName() : null, ModuleFixCreator.ModuleType.es6)) != null) {
            if (withoutModuleWord) {
                descriptor.moduleElementIsMissing();
            }
            descriptor.setDefaultExport(true);
            return true;
        }
        return false;
    }

    private static boolean isExports(String text) {
        return "exports".equals(text) || "module.exports".equals(text);
    }

    private boolean findVariantsForMethods(ModuleReferenceInfo moduleReferenceInfo, VirtualFile moduleRoot) {
        ResolveResult[] results;
        for (ResolveResult resolveResult : results = this.myModuleReferenceInfo.getTopLevelInModuleRef().multiResolve(false)) {
            if (!resolveResult.isValidResult() || resolveResult.getElement() == null) continue;
            this.processPossibleMatch(resolveResult.getElement(), false, this.myModuleReferenceInfo.getTopLevelMember());
        }
        if (moduleReferenceInfo.getTopLevelMember() != null) {
            this.searchWithStubIndex(this.myModuleReferenceInfo.getTopLevelMember(), this.myNode.getProject(), false);
        }
        return true;
    }

    private ModuleFixCreator.FixDescriptor addFixFromFile(PsiFile targetPsiFile, @Nullable String nameInExports, ModuleFixCreator.ModuleType moduleType) {
        ForRequireModuleInfo required;
        VirtualFile targetFile;
        VirtualFile file = this.myNode.getContainingFile().getVirtualFile();
        if (file.equals(targetFile = targetPsiFile.getVirtualFile())) {
            return null;
        }
        ModuleFixCreator.FixDescriptor descriptor = null;
        if (ModuleFixCreator.ModuleType.es6.equals((Object)moduleType)) {
            String path = NodeJSModulesSearcher.getPath(file, targetFile);
            if (path != null) {
                path = FileUtil.getNameWithoutExtension((String)path);
                descriptor = new ModuleFixCreator.FixDescriptor(moduleType, path, targetFile, this.myModuleReferenceInfo.getModuleName(), nameInExports);
            }
        } else if (ModuleFixCreator.ModuleType.nodejs.equals((Object)moduleType) && NodeJsCoreLibraryManager.getInstance(this.myNode.getProject()).isCoreModuleLibraryFile(targetFile)) {
            descriptor = new ModuleFixCreator.FixDescriptor(moduleType, targetFile.getNameWithoutExtension(), targetFile, this.myModuleReferenceInfo.getModuleName(), nameInExports);
        }
        if (descriptor == null && ModuleFixCreator.ModuleType.nodejs.equals((Object)moduleType) && (required = NodeModuleUtil.canBeRequired(this.myNode.getProject(), this.myModuleRoot, targetPsiFile, this.myOnlyCommonJs)) != null) {
            descriptor = this.addFixForModule(file, required, nameInExports, moduleType);
        }
        if (descriptor != null) {
            this.myModuleFixCreator.addFix(descriptor);
        }
        return this.myModuleFixCreator.isNoFixesShouldBeSuggested() ? null : descriptor;
    }

    private ModuleFixCreator.FixDescriptor addFixForModule(VirtualFile file, ForRequireModuleInfo module, @Nullable String nameInExports, ModuleFixCreator.ModuleType moduleType) {
        String exactPath;
        ModuleType type = module.getType();
        ModuleFixCreator.FixDescriptor descriptor = null;
        if (ModuleType.NODE_MODULES_DIR.equals((Object)type)) {
            if (module.getModuleSourceRoot() != null) {
                String moduleName;
                String string = moduleName = module.getModuleSourceRoot().isDirectory() ? module.getModuleSourceRoot().getName() : module.getModuleSourceRoot().getNameWithoutExtension();
                if (module.isMainFile()) {
                    descriptor = new ModuleFixCreator.FixDescriptor(moduleType, moduleName, module.getModuleSourceRoot(), this.myModuleReferenceInfo.getModuleName(), nameInExports);
                } else {
                    String redirectPath = NodeJSModulesSearcher.computeRedirectPath(this.myNode, module);
                    String relPath = FileUtil.getRelativePath((String)module.getModuleSourceRoot().getPath(), (String)module.getModuleFile().getPath(), (char)'/');
                    if (NodeJSModulesSearcher.relPathsSame(relPath, redirectPath, module.getModuleFile().getExtension())) {
                        descriptor = new ModuleFixCreator.FixDescriptor(moduleType, moduleName, module.getModuleFile(), this.myModuleReferenceInfo.getModuleName(), nameInExports);
                    } else if (relPath != null && !relPath.startsWith("../")) {
                        relPath = relPath.startsWith("./") ? relPath.substring(1) : relPath;
                        relPath = moduleName + (relPath.startsWith("/") ? relPath : "/" + relPath);
                        descriptor = new ModuleFixCreator.FixDescriptor(moduleType, relPath, module.getModuleFile(), this.myModuleReferenceInfo.getModuleName(), nameInExports);
                    }
                }
            }
        } else if (ModuleType.EXACT_PATH.equals((Object)type) && (exactPath = NodeJSModulesSearcher.getPath(file, module.getModuleFile())) != null) {
            descriptor = new ModuleFixCreator.FixDescriptor(moduleType, exactPath, module.getModuleFile(), this.myModuleReferenceInfo.getModuleName(), nameInExports);
        }
        return descriptor;
    }

    @Nullable
    private static String computeRedirectPath(JSReferenceExpression node, ForRequireModuleInfo module) {
        String redirectPath = null;
        if (module.getMainFile() != null && (redirectPath = NodeModuleSearchUtil.getRedirectPathForModule(node.getProject(), module.getMainFile())) != null) {
            redirectPath = redirectPath.startsWith("./") ? redirectPath.substring(2) : redirectPath;
            redirectPath = redirectPath.endsWith("/") ? redirectPath.substring(0, redirectPath.length() - 1) : redirectPath;
            VirtualFile virtualFile = VfsUtil.findRelativeFile((VirtualFile)module.getModuleSourceRoot(), (String[])new String[]{redirectPath});
            if (virtualFile != null && virtualFile.isDirectory()) {
                if (virtualFile.findChild("index.js") != null) {
                    redirectPath = redirectPath + (redirectPath.endsWith("/") ? "" : "/") + "index.js";
                } else if (virtualFile.findChild("index.node") != null) {
                    redirectPath = redirectPath + (redirectPath.endsWith("/") ? "" : "/") + "index.node";
                }
            }
        }
        return redirectPath;
    }

    static boolean relPathsSame(@Nullable String path1, @Nullable String path2, @NotNull String ext2) {
        if (ext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext2", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher", "relPathsSame"));
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = path1.startsWith(".") ? path1.substring(1) : path1;
        path2 = path2.startsWith(".") ? path2.substring(1) : path2;
        path1 = path1.startsWith("/") ? path1.substring(1) : path1;
        path2 = path2.startsWith("/") ? path2.substring(1) : path2;
        return path1.equals(path2) || path1.equals(path2 + "." + ext2);
    }

    static String getPath(VirtualFile file, VirtualFile root) {
        String path = FileUtil.getRelativePath((String)file.getParent().getPath(), (String)root.getPath(), (char)'/');
        if (path == null) {
            return null;
        }
        if (new File(path).isAbsolute()) {
            return path;
        }
        if (path.startsWith("/")) {
            return "." + path;
        }
        if (path.startsWith("./") || path.startsWith("../")) {
            return path;
        }
        return "./" + path;
    }
}

