/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class JSGotoDeclarationHandler
extends GotoDeclarationHandlerBase {
    @Nullable
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement sourceElement, Editor editor) {
        if (sourceElement == null) {
            return null;
        }
        ASTNode node = sourceElement.getNode();
        if (node == null || !JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType())) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof ES6ImportedBinding) {
            ES6ImportedBinding importedBinding = (ES6ImportedBinding)parent;
            if (importedBinding.isNamespaceImport()) {
                return null;
            }
            Collection elements = importedBinding.findReferencedElements();
            return elements.size() == 1 ? (PsiElement)elements.iterator().next() : null;
        }
        return null;
    }
}

