/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class JavaScriptParserBase<T extends JavaScriptParser> {
    public static final Key<JSLanguageDialect> JS_DIALECT_KEY = Key.create((String)"JS_DIALECT");
    public static final Key<ForceContext> FORCE_CONTEXT_KEY = Key.create((String)"FORCE_CONTEXT");
    public static int MAX_TREE_DEPTH = 100;
    protected final PsiBuilder builder;
    protected final T myJavaScriptParser;
    protected static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT = new WhitespacesAndCommentsBinder(){

        public int getEdgePosition(List<IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            IElementType type;
            int i = tokens.size() - 1;
            IElementType iElementType = type = i >= 0 ? tokens.get(i) : null;
            while (type == JSTokenTypes.WHITE_SPACE || type == JSTokenTypes.END_OF_LINE_COMMENT) {
                type = --i >= 0 ? tokens.get(i) : null;
            }
            if (type == JSTokenTypes.DOC_COMMENT_TOKEN) {
                return i;
            }
            return tokens.size();
        }
    };

    protected JavaScriptParserBase(T parser) {
        this.builder = ((JavaScriptParser)parser).builder;
        this.myJavaScriptParser = parser;
    }

    protected static boolean hasSemanticLinefeedBefore(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null || tokenType == JSTokenTypes.RBRACE) {
            return true;
        }
        if (tokenType == JSTokenTypes.ELSE_KEYWORD || tokenType == JSTokenTypes.WHILE_KEYWORD) {
            return true;
        }
        int at = -1;
        IElementType elementTypeBefore = builder.rawLookup(at);
        while (elementTypeBefore == JSTokenTypes.WHITE_SPACE || elementTypeBefore == JSTokenTypes.HEREDOC_BOUND || JSTokenTypes.COMMENTS.contains(elementTypeBefore)) {
            int end = builder.getCurrentOffset();
            CharSequence sequence = builder.getOriginalText();
            for (int start = builder.rawTokenTypeStart(at); start < end; ++start) {
                char ch = sequence.charAt(start);
                if (ch != '\n' && ch != '\u2028' && ch != '\u2029' && ch != '\r') continue;
                return true;
            }
            elementTypeBefore = builder.rawLookup(--at);
        }
        return false;
    }

    protected static boolean checkMatches(PsiBuilder builder, IElementType token, @NonNls @PropertyKey(resourceBundle="com.intellij.lang.javascript.JavaScriptBundle") String errorMessageKey) {
        if (builder.getTokenType() == token) {
            builder.advanceLexer();
            return true;
        }
        builder.error(JSBundle.message((String)errorMessageKey, (Object[])new Object[0]));
        return false;
    }

    protected boolean isECMAL4() {
        return this.builder.getUserData(JS_DIALECT_KEY) == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
    }

    protected boolean isGwt() {
        return this.builder.getUserData(JS_DIALECT_KEY) == JavaScriptSupportLoader.GWT_DIALECT;
    }

    protected boolean isECMA6() {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        return dialect != null && dialect.getOptionHolder().isECMA6;
    }

    protected boolean isJavaScript() {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        return dialect == null || dialect.getOptionHolder().isJavaScript();
    }

    protected boolean isJSorTS() {
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        return dialect == null || dialect.getOptionHolder().isJavaScript() || dialect.getOptionHolder().isTypeScript;
    }

    @NotNull
    protected DialectOptionHolder getOptionHolder(@NotNull DialectOptionHolder defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/lang/javascript/parsing/JavaScriptParserBase", "getOptionHolder"));
        }
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
        DialectOptionHolder dialectOptionHolder = dialect != null ? dialect.getOptionHolder() : defaultValue;
        if (dialectOptionHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/parsing/JavaScriptParserBase", "getOptionHolder"));
        }
        return dialectOptionHolder;
    }

    protected boolean isIdentifierToken(IElementType tokenType) {
        if (tokenType == JSTokenTypes.IDENTIFIER) {
            return true;
        }
        return ((JavaScriptParser)this.myJavaScriptParser).isIdentifierToken(tokenType);
    }

    public static enum ForceContext {
        Type,
        Parameter;

    }
}

