/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypeEvaluator
extends JSElementVisitor {
    protected final JSExpression myParent;
    protected final PsiElement myGrandParent;
    protected JSType myResult;

    public ExpectedTypeEvaluator(JSExpression parent) {
        this.myParent = parent;
        this.myGrandParent = this.myParent.getParent();
    }

    protected ExpectedTypeEvaluator newExpectedTypeEvaluator(JSExpression parent) {
        return new ExpectedTypeEvaluator(parent);
    }

    @Nullable
    public JSType findExpectedType() {
        this.myGrandParent.accept((PsiElementVisitor)this);
        return this.myResult;
    }

    public void visitJSVariable(JSVariable node) {
        this.myResult = node.getType();
    }

    public void visitJSArgumentList(JSArgumentList node) {
        JSParameterItem param = JSResolveUtil.findParameterForUsedArgument(this.myParent, node);
        if (param != null) {
            if (param.isRest()) {
                this.findRestParameterExpectedType(param);
            } else {
                this.myResult = param.getType();
            }
        }
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSFunction.class);
        if (fun != null) {
            JSTypeSource typeSource;
            JSType returnType = fun.getReturnType();
            JSTypeSource jSTypeSource = typeSource = returnType != null ? returnType.getSource() : null;
            if (returnType != null && typeSource.isExplicitlyDeclared()) {
                this.myResult = returnType;
            }
        }
    }

    public void visitJSIfStatement(JSIfStatement node) {
        if (node.getCondition() == this.myParent) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSLoopStatement(JSLoopStatement node) {
        if (node.getCondition() == this.myParent) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (!(JSTokenTypes.EXCL != node.getOperationSign() || node.getParent() instanceof JSPrefixExpression && JSTokenTypes.EXCL == ((JSPrefixExpression)node.getParent()).getOperationSign())) {
            this.myResult = this.createNamedType("Boolean", this.myGrandParent);
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand != null) {
            PsiElement resolve;
            JSExpression expression;
            if ((lOperand = (JSExpression)PsiUtilCore.getOriginalElement((PsiElement)lOperand, lOperand.getClass())) instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) != null && JSResolveUtil.isSameReference((JSReferenceExpression)expression, resolve)) {
                return;
            }
            this.myResult = JSResolveUtil.getQualifiedExpressionJSType(lOperand, this.myGrandParent.getContainingFile());
        }
    }

    public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
        JSType type;
        if (this.myGrandParent.getParent() instanceof JSNewExpression && (type = JSResolveUtil.getQualifiedExpressionJSType((JSExpression)this.myGrandParent.getParent(), this.myGrandParent.getContainingFile())) instanceof JSGenericTypeImpl) {
            this.myResult = (JSType)ContainerUtil.getFirstItem(((JSGenericTypeImpl)type).getArguments());
        }
    }

    public void visitJSThrowStatement(JSThrowStatement node) {
        PsiComment docComment;
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myParent, JSFunction.class);
        if (fun != null && (docComment = JSDocumentationUtils.findDocComment((PsiElement)fun)) != null) {
            final Ref throwsTypeFromCommentRef = new Ref();
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "onCommentLine"));
                    }
                    return false;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "onPatternMatch"));
                    }
                    if (line == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "onPatternMatch"));
                    }
                    if (patternMatched == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/intellij/lang/javascript/psi/ExpectedTypeEvaluator$1", "onPatternMatch"));
                    }
                    if (type == JSDocumentationProcessor.MetaDocType.THROWS && matchName != null) {
                        throwsTypeFromCommentRef.set((Object)matchName);
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }
            });
            String throwsTypeFromComment = (String)throwsTypeFromCommentRef.get();
            if (throwsTypeFromComment != null) {
                this.myResult = JSTypeUtils.createType(throwsTypeFromComment, JSTypeSourceFactory.createTypeSource(this.myGrandParent, true));
                return;
            }
        }
        this.myResult = this.createNamedType("Error", this.myGrandParent);
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        this.myResult = node.getCondition() == this.myParent ? this.createNamedType("Boolean", this.myGrandParent) : JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node);
    }

    public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
        if (node.getIndexExpression() == this.myParent) {
            this.evaluateIndexedAccessType(node);
        }
    }

    protected void evaluateIndexedAccessType(JSIndexedPropertyAccessExpression node) {
        this.myResult = this.createNamedType("number", this.myGrandParent);
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        if (JSUtils.unparenthesize(node.getROperand()) == this.myParent) {
            IElementType opType = node.getOperationSign();
            if (JSTokenTypes.OROR == opType || JSTokenTypes.ANDAND == opType) {
                this.myResult = this.createNamedType("Boolean", this.myGrandParent);
            } else {
                JSExpression lOperand = node.getLOperand();
                if (lOperand != null) {
                    this.myResult = JSResolveUtil.getQualifiedExpressionJSType(lOperand, this.myGrandParent.getContainingFile());
                }
            }
        }
    }

    public void visitJSCaseClause(JSCaseClause node) {
        JSExpression switchExpression;
        JSSwitchStatement switchStatement;
        if (node.getCaseExpression() == this.myParent && (switchStatement = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSSwitchStatement.class)) != null && (switchExpression = switchStatement.getSwitchExpression()) != null) {
            this.myResult = JSResolveUtil.getQualifiedExpressionJSType(switchExpression, this.myGrandParent.getContainingFile());
        }
    }

    protected void findRestParameterExpectedType(JSParameterItem param) {
        this.myResult = this.createNamedType("Object", (PsiElement)this.myParent);
    }

    public void visitJSProperty(JSProperty node) {
        PsiElement parent = node.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            JSRecordType.PropertySignature propertySignature;
            JSType parentExpectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSObjectLiteralExpression)parent));
            parentExpectedType = JSTypeUtils.getValuableType(parentExpectedType);
            String name = node.getName();
            if (parentExpectedType instanceof JSRecordType && name != null && (propertySignature = ((JSRecordType)parentExpectedType).findPropertySignature(name)) != null) {
                this.myResult = propertySignature.getType();
            }
        }
        super.visitJSProperty(node);
    }

    protected JSType createNamedType(String name, PsiElement context) {
        return JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(context, true), JSContext.INSTANCE);
    }

    public void visitJSParenthesizedExpression(JSParenthesizedExpression node) {
        ExpectedTypeEvaluator parensEvaluator = this.newExpectedTypeEvaluator((JSExpression)node);
        this.myResult = parensEvaluator.findExpectedType();
    }
}

