/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterItemWithSource;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSContextTypeEvaluator
extends JSElementVisitor {
    protected final JSExpression myParent;
    protected final PsiElement myGrandParent;
    protected JSType myType;
    protected PsiElement myScope;
    protected JSType myResult;

    public JSContextTypeEvaluator(@NotNull JSExpression parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/JSContextTypeEvaluator", "<init>"));
        }
        this.myParent = parent;
        PsiElement grandParent = this.myParent.getParent();
        while (grandParent instanceof JSParenthesizedExpression) {
            grandParent = grandParent.getParent();
        }
        this.myGrandParent = grandParent;
    }

    @Nullable
    public JSType findExpectedType() {
        this.myGrandParent.accept((PsiElementVisitor)this);
        if (this.myResult != null) {
            return this.myResult;
        }
        return this.myType != null ? JSTypeUtils.copyWithNewSource(this.myType, this.createContextSource()) : null;
    }

    @NotNull
    private JSTypeSource createContextSource() {
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource(this.myScope, this.myType.getSource().isExplicitlyDeclared());
        if (jSTypeSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSContextTypeEvaluator", "createContextSource"));
        }
        return jSTypeSource;
    }

    public void visitJSVariable(@NotNull JSVariable node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/JSContextTypeEvaluator", "visitJSVariable"));
        }
        this.myScope = this.myGrandParent;
        this.myType = node.getType();
    }

    public void visitJSArgumentList(@NotNull JSArgumentList node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/JSContextTypeEvaluator", "visitJSArgumentList"));
        }
        JSExpression mainOccurrence = this.myParent;
        int _paramIndex = 0;
        for (JSExpression expr : node.getArguments()) {
            if (expr == mainOccurrence) break;
            ++_paramIndex;
        }
        int paramIndex = _paramIndex;
        PsiElement firstChild = node.getFirstChild();
        if (firstChild == null) {
            return;
        }
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)firstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        JSExpression methodExpr = originalElement.getMethodExpression();
        boolean isExplicitly = this.hasExplicitlyQualifierType(methodExpr);
        if (methodExpr instanceof JSReferenceExpression) {
            ResolveResult[] results = ((JSReferenceExpression)methodExpr).multiResolve(false);
            ArrayList possibleResults = ContainerUtil.newArrayList();
            for (ResolveResult r : results) {
                JSType type;
                PsiElement element = r.getElement();
                if (element == null || !element.isValid()) continue;
                if (element instanceof JSParameter) {
                    JSType index;
                    JSType type2;
                    JSType definedParameterType = ((JSParameter)element).getType();
                    JSType jSType = type2 = definedParameterType != null ? definedParameterType : JSContextTypeEvaluator.getParameterType((JSParameter)element);
                    if (!(type2 instanceof JSFunctionTypeImpl) || (index = JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionTypeImpl)type2, paramIndex)) == null) continue;
                    possibleResults.add(index);
                    continue;
                }
                JSFunctionItem matchedFunction = JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)originalElement);
                if (matchedFunction == null) continue;
                JSParameterItem[] params = matchedFunction.getParameters();
                JSParameterItem param = null;
                if (paramIndex < params.length) {
                    param = params[paramIndex];
                } else if (params.length > 0 && params[params.length - 1].isRest()) {
                    param = params[params.length - 1];
                }
                if (param == null || (type = param.getType()) == null) continue;
                possibleResults.add(type);
            }
            if (!possibleResults.isEmpty()) {
                this.myScope = this.myParent;
                this.myType = possibleResults.size() == 1 ? (JSType)ContainerUtil.getFirstItem((List)possibleResults) : JSCompositeTypeImpl.optimizeTypeIfComposite(new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource(this.myScope, false), possibleResults));
                if (!isExplicitly) {
                    this.myType = JSTypeUtils.copyWithExplicitlyDeclared(this.myType, false);
                }
            }
        }
    }

    public boolean hasExplicitlyQualifierType(JSExpression methodExpr) {
        JSType type;
        JSTypeEvaluationResult expressionType;
        JSExpression qualifier;
        if (methodExpr instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)methodExpr) && (qualifier = ((JSReferenceExpression)methodExpr).getQualifier()) != null && (expressionType = JSTypeEvaluator.getExpressionType(qualifier)) != null && (type = expressionType.getType()) != null) {
            return TypeScriptUtil.isStrictType(type);
        }
        return true;
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        JSType type;
        if (node.getOperationSign() == JSTokenTypes.OROR && (type = new JSContextTypeEvaluator((JSExpression)node).findExpectedType()) != null) {
            this.myResult = type;
        }
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this.myGrandParent, JSFunction.class);
        if (fun != null) {
            JSType type;
            JSType returnType = fun.getReturnType();
            if (returnType != null && !(returnType instanceof JSTypeofTypeImpl)) {
                JSTypeSource typeSource = returnType.getSource();
                if (typeSource.isExplicitlyDeclared()) {
                    this.myScope = fun;
                    this.myType = returnType;
                }
            } else if (fun instanceof JSFunctionExpression && (type = new JSContextTypeEvaluator((JSExpression)((JSFunctionExpression)fun)).findExpectedType()) instanceof JSFunctionTypeImpl) {
                this.myScope = fun;
                this.myType = ((JSFunctionTypeImpl)type).getReturnType();
            }
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand != null) {
            PsiElement resolve;
            JSExpression expression;
            if (lOperand instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) != null && JSResolveUtil.isSameReference((JSReferenceExpression)expression, resolve)) {
                return;
            }
            this.myType = JSTypeEvaluator.forceEvaluateType((PsiElement)lOperand, lOperand, this.myGrandParent.getContainingFile());
            this.myScope = lOperand;
        }
    }

    public void visitJSProperty(JSProperty node) {
        PsiElement parent = node.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            JSRecordType.PropertySignature propertySignature;
            JSType parentExpectedType = new JSContextTypeEvaluator((JSExpression)((JSObjectLiteralExpression)parent)).findExpectedType();
            parentExpectedType = parentExpectedType == null ? null : parentExpectedType.asRecordType();
            String name = node.getName();
            if (parentExpectedType != null && name != null && (propertySignature = ((JSRecordType)parentExpectedType).findPropertySignature(name)) != null) {
                this.myResult = propertySignature.getType();
            }
        }
        super.visitJSProperty(node);
    }

    @Nullable
    public static JSType getTypeByFunctionParamIndex(JSFunctionTypeImpl funcType, int paramIndex) {
        JSParameterTypeDecorator lastParam;
        List<JSParameterTypeDecorator> funcTypeParameters = funcType.getParameters();
        JSType parameterType = null;
        if (paramIndex < funcTypeParameters.size()) {
            parameterType = funcTypeParameters.get(paramIndex).getType();
        }
        JSParameterTypeDecorator jSParameterTypeDecorator = lastParam = funcTypeParameters.size() > 0 ? funcTypeParameters.get(funcTypeParameters.size() - 1) : null;
        if (lastParam != null && lastParam.isRest()) {
            parameterType = lastParam.getType();
        }
        return parameterType;
    }

    @Nullable
    public static JSType getParameterType(@NotNull JSParameter parameter) {
        JSNamespaceEvaluationResult initialization;
        JSParameter superParameter;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/psi/JSContextTypeEvaluator", "getParameterType"));
        }
        JSType parameterType = null;
        JSFunction fun = parameter.getDeclaringFunction();
        if (fun != null && (superParameter = JSInheritanceUtil.findMatchedSuperParameter(parameter, fun)) != null) {
            parameterType = superParameter.getType();
        }
        if (parameterType == null && (fun instanceof JSFunctionExpression || fun instanceof ES6FunctionProperty)) {
            Collection<JSType> types;
            JSType funcType;
            PsiElement parentOfFunction = fun.getParent();
            if (fun instanceof ES6FunctionProperty) {
                funcType = null;
                if (parentOfFunction instanceof JSObjectLiteralExpression) {
                    JSRecordType.PropertySignature propertySignature;
                    JSType parentType = new JSContextTypeEvaluator((JSExpression)((JSObjectLiteralExpression)parentOfFunction)).findExpectedType();
                    String name = fun.getName();
                    if (parentType instanceof JSRecordType && name != null && (propertySignature = ((JSRecordType)parentType).findPropertySignature(name)) != null) {
                        funcType = propertySignature.getType();
                    }
                }
            } else {
                funcType = new JSContextTypeEvaluator((JSExpression)((JSFunctionExpression)fun)).findExpectedType();
            }
            if (!(types = JSTypeUtils.getFunctionType(funcType, false)).isEmpty()) {
                int paramIndex;
                JSParameterItemWithSource[] parameters = fun.getParameters();
                for (paramIndex = 0; paramIndex < parameters.length && parameters[paramIndex] != parameter; ++paramIndex) {
                }
                for (JSType type : types) {
                    JSExpression methodExpr;
                    if (!(type instanceof JSFunctionTypeImpl) || (parameterType = JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionTypeImpl)type, paramIndex)) == null) continue;
                    PsiElement callExpr = parentOfFunction.getParent();
                    if (!(callExpr instanceof JSCallExpression) || !((methodExpr = ((JSCallExpression)callExpr).getMethodExpression()) instanceof JSReferenceExpression)) break;
                    PsiElement resolve = ((JSReferenceExpression)methodExpr).resolve();
                    parameterType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(parameterType, methodExpr, resolve);
                    break;
                }
            }
            if (funcType != null && parameterType != null && funcType.getSource().isTypeScript() && !funcType.getSource().isExplicitlyDeclared()) {
                parameterType = JSTypeUtils.copyWithExplicitlyDeclared(parameterType, false);
            }
        }
        if (parameterType == null && fun instanceof JSFunctionExpression && fun.isAnonymousFunctionCall() && (initialization = JSSymbolUtil.getParameterInitialization(parameter)) != null) {
            parameterType = initialization.getSource() instanceof JSExpression && !initialization.isExplicitlyDeclared() ? JSResolveUtil.getExpressionJSType((JSExpression)initialization.getSource()) : initialization.toType((PsiElement)parameter);
        }
        return parameterType;
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        if (this.myParent == JSUtils.unparenthesize(node.getThen()) || this.myParent == JSUtils.unparenthesize(node.getElse())) {
            this.myResult = new JSContextTypeEvaluator((JSExpression)node).findExpectedType();
        }
    }
}

