/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSKeywordsCompletionProvider;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementFactory {
    private JSElementFactory() {
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/JSElementFactory", "createExpressionCodeFragment"));
        }
        JSExpressionCodeFragment jSExpressionCodeFragment = JSElementFactory.createExpressionCodeFragment(project, text, context, true, null, null, TopLevelCompletion.YES, null);
        if (jSExpressionCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSElementFactory", "createExpressionCodeFragment"));
        }
        return jSExpressionCodeFragment;
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context, @Nullable JSLanguageDialect dialect, @Nullable GlobalSearchScope resolveScope, @NotNull TopLevelCompletion topLevelCompletion, @Nullable JavaScriptParserBase.ForceContext forceContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/JSElementFactory", "createExpressionCodeFragment"));
        }
        if (topLevelCompletion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelCompletion", "com/intellij/lang/javascript/psi/JSElementFactory", "createExpressionCodeFragment"));
        }
        JSExpressionCodeFragment jSExpressionCodeFragment = JSElementFactory.createExpressionCodeFragment(project, text, context, true, dialect, resolveScope, topLevelCompletion, forceContext);
        if (jSExpressionCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSElementFactory", "createExpressionCodeFragment"));
        }
        return jSExpressionCodeFragment;
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context, boolean physical, @Nullable JSLanguageDialect dialect, @Nullable GlobalSearchScope resolveScope, final @NotNull TopLevelCompletion topLevelCompletion, @Nullable JavaScriptParserBase.ForceContext forceContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/JSElementFactory", "createExpressionCodeFragment"));
        }
        if (topLevelCompletion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelCompletion", "com/intellij/lang/javascript/psi/JSElementFactory", "createExpressionCodeFragment"));
        }
        String name = "fragment." + (dialect != null ? dialect.getFileExtension() : JavaScriptSupportLoader.JAVASCRIPT.getDefaultExtension());
        JSExpressionCodeFragmentImpl codeFragment = new JSExpressionCodeFragmentImpl(project, name, text, physical, forceContext){

            @Override
            public List<?> getTopLevelVariants(PsiElement context) {
                switch (topLevelCompletion) {
                    case YES: {
                        return super.getTopLevelVariants(context);
                    }
                    case NO: {
                        return Collections.emptyList();
                    }
                    case LITERAL_VALUES: {
                        return Arrays.asList(JSKeywordsCompletionProvider.TYPE_LITERAL_VALUES);
                    }
                }
                assert (false) : "unknown completion type: " + (Object)((Object)topLevelCompletion);
                return null;
            }
        };
        codeFragment.forceResolveScope(resolveScope);
        codeFragment.setContext(context);
        JSExpressionCodeFragmentImpl jSExpressionCodeFragmentImpl = codeFragment;
        if (jSExpressionCodeFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSElementFactory", "createExpressionCodeFragment"));
        }
        return jSExpressionCodeFragmentImpl;
    }

    public static enum TopLevelCompletion {
        YES,
        NO,
        LITERAL_VALUES;

    }
}

