/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesConfigurableProvider;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSInheritedLanguagesHelper {
    private static final JSInheritedLanguagesConfigurableProvider DEFAULT = new JSInheritedLanguagesConfigurableProvider(){};

    @NotNull
    public static JSInheritedLanguagesConfigurableProvider getConfigurableProvider(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getConfigurableProvider"));
        }
        while (node != null && node.getPsi() == null) {
            node = node.getTreeParent();
        }
        if (node != null && node.getPsi() != null) {
            JSInheritedLanguagesConfigurableProvider jSInheritedLanguagesConfigurableProvider = JSInheritedLanguagesHelper.getConfigurableProvider(node.getPsi());
            if (jSInheritedLanguagesConfigurableProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getConfigurableProvider"));
            }
            return jSInheritedLanguagesConfigurableProvider;
        }
        JSInheritedLanguagesConfigurableProvider jSInheritedLanguagesConfigurableProvider = DEFAULT;
        if (jSInheritedLanguagesConfigurableProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getConfigurableProvider"));
        }
        return jSInheritedLanguagesConfigurableProvider;
    }

    @NotNull
    public static JSInheritedLanguagesConfigurableProvider getConfigurableProvider(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getConfigurableProvider"));
        }
        JSInheritedLanguagesConfigurableProvider result = (JSInheritedLanguagesConfigurableProvider)JSInheritedLanguagesConfigurableProvider.INSTANCE.forLanguage(DialectDetector.languageOfElement(element));
        JSInheritedLanguagesConfigurableProvider jSInheritedLanguagesConfigurableProvider = result != null ? result : DEFAULT;
        if (jSInheritedLanguagesConfigurableProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getConfigurableProvider"));
        }
        return jSInheritedLanguagesConfigurableProvider;
    }

    public static boolean isBadExpressionStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "isBadExpressionStatement"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.isBadExpressionStatement(element);
    }

    public static boolean isNeedToBeTerminated(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "isNeedToBeTerminated"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.isNeedToBeTerminated(element);
    }

    public static boolean isLHSExpression(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "isLHSExpression"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.isLHSExpression(element);
    }

    public static boolean isCaseStatementInterrupted(JSStatement statement) {
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider((PsiElement)statement);
        return redefiner.isCaseStatementInterrupted(statement);
    }

    public static boolean forConditionShouldUseVariables(@NotNull PsiElement forStatement) {
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "forConditionShouldUseVariables"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(forStatement);
        return redefiner.forConditionShouldUseVariables();
    }

    public static boolean constructorCallWithoutNewActual(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "constructorCallWithoutNewActual"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.constructorCallWithoutNewActual();
    }

    public static boolean unnecessaryBlockStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "unnecessaryBlockStatement"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.unnecessaryBlockStatement(element);
    }

    public static Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getLanguage"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.getLanguage();
    }

    public static boolean skipNonBlockBranch(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "skipNonBlockBranch"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.hasNonBlockBranch(element);
    }

    public static boolean isRemoveUnnecessaryParenthesesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "isRemoveUnnecessaryParenthesesEnabled"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.isRemoveUnnecessaryParenthesesEnabled(element);
    }

    public static boolean isSimplifyBooleanFixEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "isSimplifyBooleanFixEnabled"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.isSimplifyBooleanFixEnabled(element);
    }

    public static boolean shouldRenameFileWithClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "shouldRenameFileWithClass"));
        }
        JSInheritedLanguagesConfigurableProvider redefiner = JSInheritedLanguagesHelper.getConfigurableProvider(element);
        return redefiner.shouldRenameFileWithClass(element);
    }

    public static PsiElement createExpressionFromText(@NotNull String text, @NotNull PsiElement element, boolean reportErrorIfFailed) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "createExpressionFromText"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "createExpressionFromText"));
        }
        return JSInheritedLanguagesHelper.getConfigurableProvider(element).createExpressionFromText(text, element, reportErrorIfFailed);
    }

    public static PsiElement createStatementFromText(@NotNull String text, @NotNull PsiElement element) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "createStatementFromText"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "createStatementFromText"));
        }
        return JSInheritedLanguagesHelper.getConfigurableProvider(element).createStatementFromText(text, element);
    }

    public static boolean isMultilineLiteral(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "isMultilineLiteral"));
        }
        return JSInheritedLanguagesHelper.getConfigurableProvider(element).isMultilineLiteral(element);
    }

    public static String getMultilineLiteralContent(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getMultilineLiteralContent"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getMultilineLiteralContent"));
        }
        return JSInheritedLanguagesHelper.getConfigurableProvider(context).getMultilineLiteralContent(text);
    }

    public static TextRange getRangeInElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/JSInheritedLanguagesHelper", "getRangeInElement"));
        }
        return JSInheritedLanguagesHelper.getConfigurableProvider(element).getRangeInElement(element);
    }
}

