/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFunctionBaseImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.stubs.TypeScriptFunctionStub;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFunctionImpl
extends TypeScriptFunctionBaseImpl<TypeScriptFunctionStub, TypeScriptFunction>
implements TypeScriptFunction,
JSComputedPropertyNameOwner,
JSSuppressionHolder {
    public TypeScriptFunctionImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptFunctionImpl(TypeScriptFunctionStub stub, IStubElementType signature) {
        super(stub, signature);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFunctionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFunctionDeclaration((JSFunction)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean isOverloadDeclaration() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getStub();
        if (stub != null) {
            return stub.isOverloadDeclaration();
        }
        return (Boolean)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                return CachedValueProvider.Result.create((Object)TypeScriptFunctionImpl.isOverloadDeclaration(TypeScriptFunctionImpl.this), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
        });
    }

    public static boolean isOverloadDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFunctionImpl", "isOverloadDeclaration"));
        }
        if (function.getBody().length != 0) {
            return false;
        }
        ASTNode functionNode = function.getNode();
        ASTNode nextSourceElement = TreeUtil.findSibling((ASTNode)functionNode.getTreeNext(), (TokenSet)JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS);
        if (nextSourceElement != null && nextSourceElement.getElementType() == JSStubElementTypes.TYPESCRIPT_FUNCTION) {
            ASTNode nameIdentifier = JSPsiImplUtils.findNameIdentifierOfFunction(functionNode);
            ASTNode nextNameIdentifier = JSPsiImplUtils.findNameIdentifierOfFunction(nextSourceElement);
            return nameIdentifier != null && nextNameIdentifier != null && StringUtil.equals((CharSequence)TypeScriptPsiUtil.getNameFromIdentifier(nameIdentifier), (CharSequence)TypeScriptPsiUtil.getNameFromIdentifier(nextNameIdentifier));
        }
        return false;
    }

    @Override
    @NotNull
    public List<TypeScriptFunction> getOverloadDeclarations() {
        PsiElement prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling((PsiElement)this);
        if (prevSibling != null) {
            SmartList result = new SmartList();
            while (prevSibling != null) {
                if (!(prevSibling instanceof JSSourceElement)) {
                    prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(prevSibling);
                    continue;
                }
                if (!(prevSibling instanceof TypeScriptFunction) || !((TypeScriptFunction)prevSibling).isOverloadDeclaration()) break;
                result.add(0, (TypeScriptFunction)prevSibling);
                prevSibling = JSStubBasedPsiTreeUtil.getPrevSibling(prevSibling);
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFunctionImpl", "getOverloadDeclarations"));
            }
            return smartList;
        }
        List<TypeScriptFunction> list = super.getOverloadDeclarations();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFunctionImpl", "getOverloadDeclarations"));
        }
        return list;
    }

    @Override
    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName((JSQualifiedNamedElement)this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSFunctionStubBase jsFunctionStub = (JSFunctionStubBase)this.getStub();
        if (jsFunctionStub != null) {
            return jsFunctionStub.getNamespace();
        }
        return JSPsiImplUtils.getNamespace((JSNamedElement)this);
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        return TypeScriptPsiUtil.isTopLevelContainer(parent);
    }

    @Override
    public boolean isConstructor() {
        JSFunctionStubBase stub = (JSFunctionStubBase)this.getStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)this);
        if (parent instanceof JSClass) {
            return Comparing.equal((String)"constructor", (String)this.getName(), (boolean)true);
        }
        return super.isConstructor();
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JSFunctionImpl.getFunctionIcon((JSFunctionItem)this, flags);
    }

    @Override
    public String getName() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return TypeScriptPsiUtil.getNameFromIdentifier(this.findNameIdentifier());
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list = this.getAttributeList();
        JSAttributeList.AccessType accessType = list != null ? list.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptFunctionImpl", "getAccessType"));
        }
        return accessType;
    }

    @Override
    public boolean isGenerator() {
        TypeScriptFunctionStub stub = (TypeScriptFunctionStub)this.getStub();
        if (stub != null) {
            return stub.isGenerator();
        }
        return this.getNode().findChildByType(JSTokenTypes.MULT) != null;
    }

    @Nullable
    public ES6ComputedName getComputedPropertyName() {
        return (ES6ComputedName)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.COMPUTED_NAME);
    }

    @Override
    public ASTNode findNameIdentifier() {
        if (this.getNode().findChildByType(JSTokenTypes.LBRACKET) != null) {
            return null;
        }
        return super.findNameIdentifier();
    }
}

