/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptIndexSignatureStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptIndexSignatureImpl
extends JSStubElementImpl<TypeScriptIndexSignatureStub>
implements TypeScriptIndexSignature,
StubBasedPsiElement<TypeScriptIndexSignatureStub> {
    public TypeScriptIndexSignatureImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptIndexSignatureImpl(TypeScriptIndexSignatureStub stub) {
        super(stub, (IStubElementType)TypeScriptElementTypes.INDEX_SIGNATURE);
    }

    public TypeScriptType getParameterType() {
        TypeScriptIndexSignatureStub stub = (TypeScriptIndexSignatureStub)this.getStub();
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            for (StubElement stubElement : stubs) {
                PsiElement element = stubElement.getPsi();
                if (!(element instanceof TypeScriptType)) continue;
                return (TypeScriptType)element;
            }
            return null;
        }
        ASTNode rbracket = this.getNode().findChildByType(JSTokenTypes.RBRACKET);
        ASTNode parameterType = TreeUtil.findSiblingBackward((ASTNode)rbracket, (TokenSet)JSElementTypes.TYPESCRIPT_OR_ES6_TYPES);
        return parameterType != null ? (TypeScriptType)parameterType.getPsi() : null;
    }

    @Nullable
    public PsiElement getParameterNameElement() {
        ASTNode bracket = this.getNode().findChildByType(JSTokenTypes.LBRACKET);
        ASTNode identifier = TreeUtil.findSibling((ASTNode)bracket, (IElementType)JSTokenTypes.IDENTIFIER);
        return identifier != null ? identifier.getPsi() : null;
    }

    public TypeScriptType getType() {
        TypeScriptIndexSignatureStub stub = (TypeScriptIndexSignatureStub)this.getStub();
        if (stub != null) {
            List stubs = stub.getChildrenStubs();
            boolean seenParameterType = false;
            for (StubElement stubElement : stubs) {
                PsiElement element = stubElement.getPsi();
                if (!(element instanceof TypeScriptType)) continue;
                if (seenParameterType) {
                    return (TypeScriptType)element;
                }
                seenParameterType = true;
            }
            return null;
        }
        ASTNode rbracket = this.getNode().findChildByType(JSTokenTypes.RBRACKET);
        ASTNode type = TreeUtil.findSibling((ASTNode)rbracket, (TokenSet)JSElementTypes.TYPESCRIPT_OR_ES6_TYPES);
        return type != null ? (TypeScriptType)type.getPsi() : null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptIndexSignatureImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptIndexSignature((TypeScriptIndexSignature)this);
        } else {
            super.accept(visitor);
        }
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }
}

