/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptInterfaceStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInterfaceImpl
extends TypeScriptClassBase<TypeScriptInterfaceStub>
implements TypeScriptInterface {
    public TypeScriptInterfaceImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptInterfaceImpl(TypeScriptInterfaceStub stub) {
        super(stub, JSStubElementTypes.TYPESCRIPT_INTERFACE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptInterface((TypeScriptInterface)this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getName() {
        TypeScriptInterfaceStub stub = (TypeScriptInterfaceStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode node = this.findNameIdentifier();
        if (node != null) {
            return ((JSReferenceExpression)node.getPsi()).getReferencedName();
        }
        return null;
    }

    @Override
    public int getTextOffset() {
        ASTNode node = this.findNameIdentifier();
        return node == null ? super.getTextOffset() : node.getStartOffset();
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "setName"));
        }
        String oldName = this.getName();
        if (name.equals(oldName)) {
            return this;
        }
        ASTNode child = this.findNameIdentifier();
        if (child != null) {
            JSExpression qualifier;
            String qName = name;
            if (child.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && (qualifier = ((JSReferenceExpression)child.getPsi()).getQualifier()) != null) {
                qName = qualifier.getText() + "." + name;
            }
            this.getNode().replaceChild(child, JSChangeUtil.createExpressionFromText(this.getProject(), qName));
        }
        return this;
    }

    public TypeScriptObjectType getBody() {
        return (TypeScriptObjectType)this.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.OBJECT_TYPE);
    }

    public boolean isInterface() {
        return true;
    }

    @Override
    @NotNull
    public JSClass[] getSupers() {
        JSClass[] jSClassArray = this.getSuperClasses();
        if (jSClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getSupers"));
        }
        return jSClassArray;
    }

    @Override
    public JSFunction[] getFunctions() {
        return JSFunction.EMPTY_ARRAY;
    }

    @Override
    public JSVariable[] getFields() {
        return JSVariable.EMPTY_ARRAY;
    }

    @Override
    public JSFunction findFunctionByName(String name) {
        return this.findFunctionByNameAndKind(name, JSFunction.FunctionKind.SIMPLE);
    }

    @Override
    @Nullable
    public JSFunction findFunctionByNameAndKind(String name, JSFunction.FunctionKind kind) {
        if (kind != JSFunction.FunctionKind.SIMPLE) {
            return null;
        }
        TypeScriptObjectType body = this.getBody();
        if (body == null) {
            return null;
        }
        for (TypeScriptTypeMember member : body.getTypeMembers()) {
            if (!StringUtil.equals((CharSequence)member.getName(), (CharSequence)name) || !(member instanceof JSFunction)) continue;
            return (JSFunction)member;
        }
        return null;
    }

    @Override
    public JSVariable findFieldByName(String name) {
        return null;
    }

    @Override
    @NotNull
    public JSClass[] getImplementedInterfaces() {
        if (JSClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getImplementedInterfaces"));
        }
        return JSClass.EMPTY_ARRAY;
    }

    public boolean isDeprecated() {
        return false;
    }

    @Override
    @Nullable
    public JSFunction getConstructor() {
        return null;
    }

    @Override
    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        return PlatformIcons.INTERFACE_ICON;
    }

    @Override
    @NotNull
    public Iterable<? extends JSElement> getMembers() {
        TypeScriptObjectType body = this.getBody();
        List list = body != null ? ContainerUtil.list((Object[])body.getTypeMembers()) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "getMembers"));
        }
        return list;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.INTERFACE;
        if (classOrInterface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl", "isClassOrInterface"));
        }
        return classOrInterface;
    }
}

