/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.LanguageExtension;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import icons.JavaScriptPsiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSIconProvider {
    public static final Icon HTML_TAG_ICON = PlatformIcons.XML_TAG_ICON;
    public static final LanguageExtension<JSIconProvider> INSTANCE = new LanguageExtension("JavaScript.iconProvider");
    public static final JSIconProvider DEFAULT_INSTANCE = new JSIconProvider();
    public static final JSIconProvider AS_INSTANCE = new ASIconProvider();

    @NotNull
    public static JSIconProvider getForLanguage(PsiElement element) {
        JSIconProvider customIconProvider;
        PsiFile container;
        PsiFile psiFile = container = element != null ? element.getContainingFile() : null;
        if (container != null && (customIconProvider = (JSIconProvider)INSTANCE.forLanguage(container.getLanguage())) != null) {
            JSIconProvider jSIconProvider = customIconProvider;
            if (jSIconProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSIconProvider", "getForLanguage"));
            }
            return jSIconProvider;
        }
        JSIconProvider jSIconProvider = DEFAULT_INSTANCE;
        if (jSIconProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSIconProvider", "getForLanguage"));
        }
        return jSIconProvider;
    }

    @NotNull
    public Icon getClassIcon() {
        Icon icon = JavaScriptPsiIcons.Classes.JavaScriptClass;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSIconProvider", "getClassIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getInterfaceIcon() {
        Icon icon = PlatformIcons.INTERFACE_ICON;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSIconProvider", "getInterfaceIcon"));
        }
        return icon;
    }

    public static class TypeScriptIconProvider
    extends JSIconProvider {
        @Override
        @NotNull
        public Icon getClassIcon() {
            Icon icon = JavaScriptPsiIcons.Classes.TypeScriptClass;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSIconProvider$TypeScriptIconProvider", "getClassIcon"));
            }
            return icon;
        }
    }

    public static class ASIconProvider
    extends JSIconProvider {
        @Override
        @NotNull
        public Icon getClassIcon() {
            Icon icon = JavaScriptPsiIcons.Classes.ActionScriptClass;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSIconProvider$ASIconProvider", "getClassIcon"));
            }
            return icon;
        }

        @Override
        @NotNull
        public Icon getInterfaceIcon() {
            Icon icon = JavaScriptPsiIcons.Classes.ActionScriptInterface;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSIconProvider$ASIconProvider", "getInterfaceIcon"));
            }
            return icon;
        }
    }
}

