/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringElementStubImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSDestructuringElementImpl
extends JSStubElementImpl<JSDestructuringElementStubImpl>
implements JSDestructuringElement,
StubBasedPsiElement<JSDestructuringElementStubImpl> {
    private static final TokenSet DESTRUCTURING_ASSIGNMENT_TARGET_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.DESTRUCTURING_CONTAINERS, JSExtendedLanguagesTokenSetProvider.VARIABLES, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION})});

    public JSDestructuringElementImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringElementImpl(JSDestructuringElementStubImpl stub) {
        super(stub, (IStubElementType)JSStubElementTypes.DESTRUCTURING_ELEMENT);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "processDeclarations"));
        }
        JSDestructuringContainer destructuringContainer = (JSDestructuringContainer)PsiTreeUtil.getChildOfType((PsiElement)this, JSDestructuringContainer.class);
        if (destructuringContainer != null) {
            return destructuringContainer.processDeclarations(processor, state, lastParent, place);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringAssignment((JSDestructuringElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSElement getTarget() {
        ASTNode target = JSDestructuringElementImpl.getDestructuringAssignmentTarget(this.getNode());
        return target != null ? (JSElement)target.getPsi() : null;
    }

    public static ASTNode getDestructuringAssignmentTarget(@NotNull ASTNode destructuringAssignment) {
        if (destructuringAssignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringAssignment", "com/intellij/lang/javascript/psi/impl/JSDestructuringElementImpl", "getDestructuringAssignmentTarget"));
        }
        return destructuringAssignment.findChildByType(DESTRUCTURING_ASSIGNMENT_TARGET_TYPES);
    }

    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }
}

