/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSStubbedStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVarStatementImpl
extends JSStubbedStatementImpl<JSVarStatementStub>
implements JSVarStatement,
JSAttributeListOwner {
    public JSVarStatementImpl(ASTNode node) {
        super(node);
    }

    public JSVarStatementImpl(JSVarStatementStub node) {
        super(node, (IStubElementType)JSStubElementTypes.VAR_STATEMENT);
    }

    @NotNull
    public JSVariable[] getVariables() {
        Object[] variables = (JSVariable[])this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.VARIABLES, JSVariable.ARRAY_FACTORY);
        JSDestructuringContainer[] destructuringContainers = (JSDestructuringContainer[])this.getStubOrPsiChildren(JSElementTypes.DESTRUCTURING_CONTAINERS, JSDestructuringContainer.ARRAY_FACTORY);
        if (destructuringContainers.length == 0) {
            if (variables == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "getVariables"));
            }
            return variables;
        }
        ArrayList result = ContainerUtil.newArrayList((Object[])variables);
        for (JSDestructuringContainer destructuringContainer : destructuringContainers) {
            Collection<PsiElement> descendants = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)destructuringContainer, JSExtendedLanguagesTokenSetProvider.VARIABLES);
            for (PsiElement descendant : descendants) {
                result.add((JSVariable)descendant);
            }
        }
        JSVariable[] jSVariableArray = result.toArray(new JSVariable[result.size()]);
        if (jSVariableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "getVariables"));
        }
        return jSVariableArray;
    }

    public void declareVariable(String name, JSExpression initializer) {
        throw new UnsupportedOperationException("TODO: implement");
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSVarStatement((JSVarStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSVarStatementImpl", "processDeclarations"));
        }
        if (JSResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)this)) {
            return true;
        }
        ASTNode firstChild = this.getNode().getFirstChildNode();
        if (lastParent != null || !(processor instanceof ResolveProcessor) || ((ResolveProcessor)processor).getName() == null || firstChild != null && (firstChild.getElementType() == JSTokenTypes.LET_KEYWORD || firstChild.getElementType() == JSTokenTypes.CONST_KEYWORD)) {
            JSVariable[] vars;
            for (JSVariable var : vars = this.getVariables()) {
                if (lastParent == var) break;
                if (var.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
        } else if (!JSResolveUtil.processDeclarationsInScope(this, processor, state, null, place)) {
            return false;
        }
        return true;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        for (JSVariable v : this.getVariables()) {
            ((JSVariableBaseImpl)v).clearCaches();
        }
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }
}

