/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedData;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocCommentCachedDataBuilder
implements JSDocumentationProcessor {
    @NotNull
    private final JSDocCommentCachedData myCachedData;
    @NotNull
    private final ASTNode myNode;
    private String myNameTag;
    private String myMemberOfTag;

    public JSDocCommentCachedDataBuilder(@NotNull JSDocCommentCachedData cachedData, @NotNull ASTNode node) {
        if (cachedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedData", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder", "<init>"));
        }
        this.myCachedData = cachedData;
        this.myNode = node;
    }

    @Override
    public boolean needsPlainCommentData() {
        return false;
    }

    @Override
    public boolean onCommentLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder", "onCommentLine"));
        }
        return false;
    }

    @Override
    public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder", "onPatternMatch"));
        }
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder", "onPatternMatch"));
        }
        if (patternMatched == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternMatched", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder", "onPatternMatch"));
        }
        if (type == JSDocumentationProcessor.MetaDocType.TYPEDEF && StringUtil.isNotEmpty((String)matchValue)) {
            this.myCachedData.addTypedef(matchName, matchValue);
            this.myCachedData.setIsInterface();
        } else if (type == JSDocumentationProcessor.MetaDocType.TYPE) {
            this.myCachedData.setType(matchName);
        } else if (type == JSDocumentationProcessor.MetaDocType.ALIAS) {
            this.myNameTag = matchName;
            this.myCachedData.setAlias(matchName);
        } else if (type == JSDocumentationProcessor.MetaDocType.NAME || type == JSDocumentationProcessor.MetaDocType.EXTERNAL) {
            this.myNameTag = matchName;
        } else if (type == JSDocumentationProcessor.MetaDocType.CALLBACK) {
            this.myNameTag = matchName;
            this.myCachedData.setIsInterface();
            this.myCachedData.setSeemsToBeFunction();
            this.myCachedData.addTypedef(matchName, "Function");
        } else if (type == JSDocumentationProcessor.MetaDocType.MEMBER_OF) {
            this.myMemberOfTag = matchName;
        } else if (type == JSDocumentationProcessor.MetaDocType.CLASS) {
            if (matchName != null) {
                this.myCachedData.setClassName(JSQualifiedNameImpl.fromQualifiedName(matchName));
            }
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.NAMESPACE) {
            this.myCachedData.setHasNamespaceTag();
            if (matchName != null) {
                JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName(matchName);
                this.myCachedData.setExplicitName(qName.getName());
                this.myCachedData.setNamespace(qName.getParent());
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.PROPERTY && matchName != null) {
            JSQualifiedNameImpl prop = JSQualifiedNameImpl.fromQualifiedName(matchName);
            this.myCachedData.addProperty(prop, matchValue);
        } else if (type == JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS && matchName != null) {
            JSQualifiedNameImpl prop = JSQualifiedNameImpl.fromQualifiedName(matchName);
            this.myCachedData.setOptional(prop);
        } else if (type == JSDocumentationProcessor.MetaDocType.TEMPLATE && matchName != null) {
            List generics = StringUtil.split((String)matchName, (String)",");
            for (String generic : generics) {
                this.myCachedData.addGenericParameter(generic.trim());
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.PRIVATE) {
            this.myCachedData.setAccessType(JSAttributeList.AccessType.PRIVATE);
            if (matchName != null) {
                this.myCachedData.setType(matchName);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.PROTECTED) {
            this.myCachedData.setAccessType(JSAttributeList.AccessType.PROTECTED);
            if (matchName != null) {
                this.myCachedData.setType(matchName);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.PUBLIC) {
            this.myCachedData.setAccessType(JSAttributeList.AccessType.PUBLIC);
            if (matchName != null) {
                this.myCachedData.setType(matchName);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.STATIC) {
            this.myCachedData.setContext(JSContext.STATIC);
        } else if (type == JSDocumentationProcessor.MetaDocType.EXTENDS || type == JSDocumentationProcessor.MetaDocType.IMPLEMENTS) {
            if (matchName != null) {
                this.myCachedData.addBaseType(matchName);
            }
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.MIXES) {
            if (matchName != null) {
                this.myCachedData.addBaseType(matchName);
                this.myCachedData.addBaseType(JSNamedType.appendStaticSuffix(matchName));
            }
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.ENUM) {
            this.myCachedData.setEnumType(matchName == null || matchName.isEmpty() ? "number" : matchName);
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.CONFIG) {
            this.myCachedData.setExplicitName(matchName);
            PsiElement comment = this.myNode.getPsi();
            String className = JSDocumentationUtils.findDocForAnchor(comment.getParent(), JSDocumentationProcessor.MetaDocType.CLASS, JSDocumentationProcessor.MetaDocType.LENDS);
            if (className != null) {
                JSQualifiedName name = JSNamespaceImpl.fromNamepath(className, true).getQualifiedName();
                if (name != null) {
                    className = name.getQualifiedName();
                }
                this.myCachedData.setNamespace(JSQualifiedNameImpl.fromQualifiedName(className + "." + "options"));
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.LENDS) {
            if (matchName != null) {
                this.applyNamepath(matchName);
            }
            this.myCachedData.setIsClassExplicitly();
            this.myCachedData.setHasLendsTag();
        } else if (type == JSDocumentationProcessor.MetaDocType.INTERFACE) {
            this.myCachedData.setIsInterface();
            if (matchName != null) {
                this.applyNamepath(matchName);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.MIXIN) {
            if (matchName != null) {
                this.applyNamepath(matchName);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.CONSTRUCTOR) {
            this.myCachedData.setIsClassExplicitly();
        } else if (type == JSDocumentationProcessor.MetaDocType.DEPRECATED) {
            this.myCachedData.setHasDeprecatedTag();
        } else if (type == JSDocumentationProcessor.MetaDocType.CONSTRUCTS) {
            this.myCachedData.setHasConstructsTag();
        } else if (type == JSDocumentationProcessor.MetaDocType.RETURN) {
            this.myCachedData.setReturnType(matchName);
        } else if (type == JSDocumentationProcessor.MetaDocType.BROWSER) {
            if ("ie".equalsIgnoreCase(remainingLineContent)) {
                this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.IE);
            } else if ("gecko".equalsIgnoreCase(remainingLineContent)) {
                this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.GECKO);
            } else if ("opera".equalsIgnoreCase(remainingLineContent)) {
                this.myCachedData.setBrowserFamily(JSDocComment.BrowserFamily.OPERA);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.GLOBAL) {
            this.myCachedData.setNamespace(null);
        } else if (type == JSDocumentationProcessor.MetaDocType.MEMBER) {
            if (matchName != null) {
                this.myNameTag = matchName;
            }
            this.myCachedData.setType(matchValue);
        } else if (type == JSDocumentationProcessor.MetaDocType.PARAMETER || type == JSDocumentationProcessor.MetaDocType.FIELD) {
            if (matchName != null) {
                JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(matchName);
                this.myCachedData.addParameter(name, matchValue);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.DEFAULT) {
            if (matchName != null) {
                this.myCachedData.addDefaultValue(JSQualifiedNameImpl.fromQualifiedName(matchName), remainingLineContent);
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.THIS) {
            this.myCachedData.setThisType(matchName);
        } else if (type == JSDocumentationProcessor.MetaDocType.ABSTRACT) {
            this.myCachedData.setHasAbstractTag();
        } else if (type == JSDocumentationProcessor.MetaDocType.EVENT) {
            if (matchName != null) {
                this.myNameTag = JSDocumentationUtils.appendPrefixToName(matchName, "event:");
            }
        } else if (type == JSDocumentationProcessor.MetaDocType.MODULE || type == JSDocumentationProcessor.MetaDocType.EXPORTS) {
            boolean looksLikeAngularRequiredModuleTag;
            boolean bl = looksLikeAngularRequiredModuleTag = type == JSDocumentationProcessor.MetaDocType.MODULE && this.myNameTag != null;
            if (matchName != null && !looksLikeAngularRequiredModuleTag) {
                this.myNameTag = JSDocumentationUtils.appendPrefixToName(matchName, "module:");
            }
        }
        if (type == JSDocumentationProcessor.MetaDocType.PARAMETER || type == JSDocumentationProcessor.MetaDocType.FUNCTION || type == JSDocumentationProcessor.MetaDocType.RETURN) {
            this.myCachedData.setSeemsToBeFunction();
        }
        return true;
    }

    private void applyNamepath(@NotNull String matchName) {
        if (matchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchName", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentCachedDataBuilder", "applyNamepath"));
        }
        JSNamespace namespace = JSNamespaceImpl.fromNamepath(matchName, true);
        JSQualifiedName qName = namespace.getQualifiedName();
        assert (qName != null);
        this.myCachedData.setExplicitName(qName.getName());
        this.myCachedData.setNamespace(qName.getParent());
        this.myCachedData.setContext(namespace.getJSContext());
    }

    @Override
    public void postProcess() {
        if (this.myNameTag != null || this.myMemberOfTag != null) {
            JSContext context = JSContext.STATIC;
            JSQualifiedNameImpl namespace = null;
            if (this.myNameTag != null) {
                JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromNamepath(this.myNameTag);
                String name = qName.getName();
                this.myCachedData.setExplicitName(name);
                namespace = qName.getParent();
                if (this.myNameTag.length() > name.length()) {
                    char lastSeparator = this.myNameTag.charAt(this.myNameTag.length() - name.length() - 1);
                    if (lastSeparator == '#') {
                        context = JSContext.INSTANCE;
                    } else if (lastSeparator == '~') {
                        context = JSContext.UNKNOWN;
                    }
                }
            }
            if (this.myMemberOfTag != null) {
                String memberOf = this.myMemberOfTag;
                if (memberOf.endsWith("#")) {
                    context = JSContext.INSTANCE;
                    memberOf = memberOf.substring(0, memberOf.length() - 1);
                }
                namespace = JSQualifiedNameImpl.fromNamepath(memberOf);
            }
            this.myCachedData.setNamespace(namespace);
            if (this.myCachedData.getContext() == JSContext.UNKNOWN) {
                this.myCachedData.setContext(context);
            }
        }
    }
}

