/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocTagImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSDocParamReference
implements PsiReference,
EmptyResolveMessageProvider {
    @NotNull
    private JSDocTag myJSDocTag;
    @NotNull
    private TextRange myRangeInElement;

    public JSDocParamReference(@NotNull JSDocTagImpl elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "<init>"));
        }
        this.myJSDocTag = elt;
        this.myRangeInElement = this.calcRangeInElement();
    }

    @NotNull
    private TextRange calcRangeInElement() {
        TextRange range = JSDocumentationUtils.getParameterNameRange(this.myJSDocTag);
        if (range != null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "calcRangeInElement"));
            }
            return textRange;
        }
        PsiElement commentData = this.myJSDocTag.getDocCommentData();
        if (commentData != null) {
            int startOffsetInParent = commentData.getStartOffsetInParent();
            TextRange textRange = new TextRange(startOffsetInParent, startOffsetInParent + commentData.getTextLength());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "calcRangeInElement"));
            }
            return textRange;
        }
        TextRange textRange = new TextRange(0, this.myJSDocTag.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "calcRangeInElement"));
        }
        return textRange;
    }

    public PsiElement getElement() {
        return this.myJSDocTag;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getRangeInElement"));
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        int offsetInText = this.myRangeInElement.getStartOffset();
        String string = this.myJSDocTag.getText().substring(offsetInText, offsetInText + this.myRangeInElement.getLength());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myJSDocTag);
        this.myJSDocTag = (JSDocTag)manipulator.handleContentChange((PsiElement)this.myJSDocTag, this.myRangeInElement, newElementName);
        this.myRangeInElement = this.calcRangeInElement();
        return this.myJSDocTag;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element.isEquivalentTo(this.resolve());
    }

    public static JSParameterList findParameterList(PsiElement elt) {
        if (elt == null) {
            return null;
        }
        PsiComment psiComment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)elt, PsiComment.class);
        assert (psiComment != null);
        PsiElement next = JSDocumentationUtils.findAttachedElementFromComment(psiComment);
        if (next instanceof JSDefinitionExpression) {
            PsiElement expression = next.getParent();
            if (expression instanceof JSAssignmentExpression) {
                JSExpression roperand = ((JSAssignmentExpression)expression).getROperand();
                if (roperand instanceof JSNewExpression) {
                    roperand = ((JSNewExpression)roperand).getMethodExpression();
                }
                if (roperand instanceof JSFunctionExpression) {
                    next = roperand;
                }
            }
        } else {
            if (next instanceof ES6FunctionProperty) {
                return ((ES6FunctionProperty)next).getParameterList();
            }
            if (next instanceof JSProperty) {
                next = ((JSProperty)next).getValue();
            } else if (next instanceof JSVarStatement) {
                JSExpression initializer;
                JSVariable[] variables = ((JSVarStatement)next).getVariables();
                if (variables.length > 0 && (initializer = variables[0].getInitializer()) instanceof JSFunctionExpression) {
                    next = initializer;
                }
            } else if (next != null) {
                PsiElement nextParent;
                JSExpression expression;
                if (next instanceof JSVariable && (expression = ((JSVariable)next).getInitializer()) instanceof JSFunctionExpression) {
                    next = expression;
                }
                if ((nextParent = next.getParent()) instanceof JSFunction) {
                    next = nextParent;
                }
            }
        }
        if (next instanceof JSFunction) {
            return ((JSFunction)next).getParameterList();
        }
        return null;
    }

    public PsiElement resolve() {
        JSParameterList parameterList = JSDocParamReference.findParameterList(this.getElement());
        if (parameterList != null) {
            String name = this.getCanonicalText();
            if ("arguments".equals(name)) {
                return this.getElement();
            }
            for (JSParameter param : parameterList.getParameters()) {
                if (!name.equals(param.getName())) continue;
                return param;
            }
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return JSDocParamReference.findParameterList(this.getElement()) == null;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JSBundle.message((String)"javascript.validation.message.incorrect.parameter.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

