/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;

public class JSDocReferenceSet
extends JSReferenceSet {
    public static final String NAMEPATH_SEPARATORS = ".#~";
    private static final String GLOBAL_PREFIX = "global#";
    private final boolean myAddEventPrefix;
    private final boolean myAddModulePrefix;

    public JSDocReferenceSet(PsiElement element, String text, int offset, boolean soft) {
        this(element, text, offset, soft, false, false);
    }

    public JSDocReferenceSet(PsiElement element, String text, int offset, boolean soft, boolean addEventPrefix, boolean addModulePrefix) {
        super(element, soft);
        this.myAddEventPrefix = addEventPrefix;
        this.myAddModulePrefix = addModulePrefix;
        this.myReferenceText = text;
        this.myOffset = offset;
        this.myReferences = this.reparse(text, offset);
    }

    @Override
    protected PsiReference[] reparse(String value, int offset) {
        String substring;
        String s;
        if (value.startsWith(GLOBAL_PREFIX)) {
            value = value.substring(GLOBAL_PREFIX.length());
            offset += GLOBAL_PREFIX.length();
            this.myOnlyDefaultPackage = true;
        }
        ArrayList<JSDocReference> refs = new ArrayList<JSDocReference>(1);
        int lastPos = 0;
        int dotPos = StringUtil.indexOfAny((String)value, (String)NAMEPATH_SEPARATORS, (int)lastPos, (int)value.length());
        while (dotPos != -1) {
            String s2 = value.substring(lastPos, dotPos).trim();
            if (s2.length() > 0) {
                TextRange range = TextRange.from((int)(offset + lastPos), (int)s2.length());
                refs.add(new JSDocReference((JSReferenceSet)this, s2, range, false));
            }
            lastPos = dotPos + 1;
            dotPos = StringUtil.indexOfAny((String)value, (String)NAMEPATH_SEPARATORS, (int)lastPos, (int)value.length());
        }
        int end = value.length();
        int lpar = value.indexOf(40, lastPos);
        if (lpar != -1) {
            end = lpar;
        }
        if ((s = (substring = value.substring(lastPos, end)).trim()).length() > 0) {
            int index;
            for (index = 0; index < substring.length() && Character.isWhitespace(substring.charAt(index)); ++index) {
            }
            boolean isMethodRef = lastPos > 0 && value.charAt(lastPos - 1) == '#';
            TextRange range = TextRange.from((int)(offset + lastPos + index), (int)s.length());
            if (this.myAddEventPrefix && !s.startsWith("event:")) {
                s = "event:" + s;
            }
            if (this.myAddModulePrefix && !s.startsWith("module:")) {
                s = "module:" + s;
            }
            refs.add(new JSDocReference((JSReferenceSet)this, s, range, isMethodRef));
        }
        return refs.size() > 0 ? refs.toArray(new PsiReference[refs.size()]) : PsiReference.EMPTY_ARRAY;
    }
}

