/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluateContext
implements JSEvaluationResultContext {
    public final PsiFile targetFile;
    private final Set<String> visitedTypes = new THashSet();
    private Set<PsiElement> processingItems;
    private PsiElement source;
    private JSReferenceExpression myProcessedExpression;
    private Deque<JSElement> myJSElementsToApply;
    private boolean myTypeIsGuessed;
    protected boolean myPrototypeWasReferenced;

    public JSEvaluateContext(PsiFile _targetFile) {
        this.targetFile = _targetFile;
        this.myJSElementsToApply = new ArrayDeque<JSElement>(5);
    }

    @NotNull
    public static JSEvaluateContext fromEvaluationResultContext(@NotNull JSEvaluationResultContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
        }
        if (context instanceof JSEvaluateContext) {
            JSEvaluateContext jSEvaluateContext = (JSEvaluateContext)context;
            if (jSEvaluateContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
            }
            return jSEvaluateContext;
        }
        JSEvaluateContext result = new JSEvaluateContext(null);
        for (JSElement element : context.getJSElementsToApply()) {
            result.pushJSElementToApply(element);
        }
        result.setTypeIsGuessed(context.isTypeGuessed());
        result.setPrototypeWasReferenced(context.wasPrototypeReferenced());
        JSEvaluateContext jSEvaluateContext = result;
        if (jSEvaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "fromEvaluationResultContext"));
        }
        return jSEvaluateContext;
    }

    public boolean isAlreadyProcessingItem(PsiElement element) {
        if (this.processingItems != null) {
            return this.processingItems.contains(element);
        }
        return false;
    }

    @Nullable
    public JSReferenceExpression getProcessedExpression() {
        return this.myProcessedExpression;
    }

    public void setProcessedExpression(@Nullable JSReferenceExpression processedExpression) {
        this.myProcessedExpression = processedExpression;
    }

    public void addProcessingItem(PsiElement element) {
        if (this.processingItems == null) {
            this.processingItems = new THashSet();
        }
        this.processingItems.add(element);
    }

    public void removeProcessingItem(PsiElement element) {
        this.processingItems.remove(element);
    }

    public PsiElement getSource() {
        return this.source;
    }

    public void setSource(PsiElement source) {
        this.source = source;
    }

    public boolean alreadyProcessed(String type) {
        return this.visitedTypes.contains(type);
    }

    public boolean ensureProcessed(String type) {
        return !this.visitedTypes.add(type);
    }

    @NotNull
    public JSElement popJSElementToApply() {
        JSElement jSElement = this.myJSElementsToApply.pop();
        if (jSElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "popJSElementToApply"));
        }
        return jSElement;
    }

    @Override
    @Nullable
    public JSElement peekJSElementToApply() {
        return this.myJSElementsToApply.peek();
    }

    public void pushJSElementToApply(@NotNull JSElement elementToApply) {
        if (elementToApply == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToApply", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "pushJSElementToApply"));
        }
        this.myJSElementsToApply.push(elementToApply);
    }

    @Override
    public boolean isJSElementsToApplyEmpty() {
        return this.myJSElementsToApply.isEmpty();
    }

    @Override
    public boolean isTypeGuessed() {
        return this.myTypeIsGuessed;
    }

    public void setTypeIsGuessed(boolean typeIsGuessed) {
        this.myTypeIsGuessed = typeIsGuessed;
    }

    @Override
    public boolean wasPrototypeReferenced() {
        return this.myPrototypeWasReferenced;
    }

    public void setPrototypeWasReferenced(boolean prototypeWasReferenced) {
        this.myPrototypeWasReferenced = prototypeWasReferenced;
    }

    @NotNull
    public Deque<JSElement> getJSElementsToApply() {
        Deque<JSElement> deque = this.myJSElementsToApply;
        if (deque == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext", "getJSElementsToApply"));
        }
        return deque;
    }

    @Override
    public boolean isEquivalentTo(JSEvaluationResultContext other) {
        return JSEvaluationResultContext.JSEvaluationResultContextImpl.areEvaluationContextsEquivalent(this, other);
    }
}

