/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.json.JsonFileType;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSIndexedRootProvider;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNameIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentUtil;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.AbstractQuery;
import com.intellij.util.CollectionQuery;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.text.StringTokenizer;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSResolveUtil {
    private static final Key<CachedValue<TIntObjectHashMap<Object>>> MY_CACHED_STATEMENTS = Key.create((String)"JS.RelevantStatements");
    private static final UserDataCache<CachedValue<TIntObjectHashMap<Object>>, JSElement, Object> ourCachedDefsCache = new RelevantDefsUserDataCache();
    @NonNls
    public static final String PROTOTYPE_FIELD_NAME = "prototype";
    public static final String USE_STRICT = "use strict";
    public static final String QUOTED_USE_STRICT = "\"use strict\"";
    public static final String SINGLE_QUOTED_USE_STRICT = "'use strict'";
    private static final Key<GlobalSearchScope> PROJECT_SCOPE_WITH_PREDEFINED_KEY = Key.create((String)"object.default.scope");
    @NonNls
    public static final String OPTIONS_NAME = "options";
    public static final String VECTOR$OBJECT_TYPE_NAME = "Vector$object";
    public static final String EXCLUDE_CLASS_METADATA = "ExcludeClass";
    public static final String FLASH_UTILS_PROXY = "flash.utils.Proxy";
    public static final String BINDABLE_ATTR_NAME = "Bindable";
    private static final JSIndexedRootProvider JS_INDEXED_ROOT_PROVIDER = (JSIndexedRootProvider)((Object)IndexableSetContributor.EP_NAME.findExtension(JSIndexedRootProvider.class));
    private static final Key<NonJsonScope> NON_JSON_SCOPE_KEY = Key.create((String)"non.json.scope.key");
    private static final Key<ParameterizedCachedValue<Map<String, String>, JSElement>> ourCachedOpenedNsesKey = Key.create((String)"opened.nses");
    private static final UserDataCache<ParameterizedCachedValue<Map<String, String>, JSElement>, JSElement, Object> ourCachedOpenedNsesCache = new UserDataCache<ParameterizedCachedValue<Map<String, String>, JSElement>, JSElement, Object>(){

        protected ParameterizedCachedValue<Map<String, String>, JSElement> compute(JSElement jsElement, Object p) {
            return CachedValuesManager.getManager((Project)jsElement.getProject()).createParameterizedCachedValue((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<Map<String, String>, JSElement>(){

                public CachedValueProvider.Result<Map<String, String>> compute(JSElement context) {
                    class MyProcessor
                    extends StructureResolveProcessor {
                        Map<String, String> openedNses;

                        public MyProcessor() {
                            super((String)null);
                            this.putUserData(LOOKING_FOR_USE_NAMESPACES, true);
                        }

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            String nsValue;
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$9$1$1MyProcessor", "execute"));
                            }
                            if (state == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$9$1$1MyProcessor", "execute"));
                            }
                            if (element instanceof JSPackageStatement) {
                                return false;
                            }
                            if (!(element instanceof JSUseNamespaceDirective)) {
                                return true;
                            }
                            if (this.openedNses == null) {
                                this.openedNses = new THashMap(1);
                            }
                            if ((nsValue = JSPsiImplUtils.calcNamespaceReference(element)) != null) {
                                this.openedNses.put(nsValue, ((JSUseNamespaceDirective)element).getNamespaceToBeUsed());
                            }
                            return true;
                        }
                    }
                    MyProcessor processor = new MyProcessor();
                    JSResolveUtil.walkOverStructure((PsiElement)context, processor);
                    return new CachedValueProvider.Result(processor.openedNses, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
        }
    };
    private static final Class[] PACKAGE_ELEMENTS = new Class[]{TypeScriptModule.class, JSVariable.class, JSNamespaceDeclaration.class, JSPackageStatement.class, JSPackage.class, JSFunction.class, JSClass.class};
    private static final Key<CachedValue<PsiElement[]>> ourFileElementsValueKey = Key.create((String)"file.elements");
    private static final Key<CachedValue<Map<PsiPolyVariantReference, ResolveResult[]>>> MY_RESOLVED_CACHED_KEY = Key.create((String)"JS.AllResolvedKey");
    private static final UserDataCache<CachedValue<Map<PsiPolyVariantReference, ResolveResult[]>>, PsiFile, Object> ourCachedResolveCache = new UserDataCache<CachedValue<Map<PsiPolyVariantReference, ResolveResult[]>>, PsiFile, Object>(){

        protected CachedValue<Map<PsiPolyVariantReference, ResolveResult[]>> compute(PsiFile file, Object o) {
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<PsiPolyVariantReference, ResolveResult[]>>(){

                public CachedValueProvider.Result<Map<PsiPolyVariantReference, ResolveResult[]>> compute() {
                    return new CachedValueProvider.Result(Collections.synchronizedMap(new THashMap()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
        }
    };
    public static final UserDataCache<CachedValue<GlobalSearchScope>, Module, Void> ourScopeCache = new UserDataCache<CachedValue<GlobalSearchScope>, Module, Void>("scope.excluding.js.libraries"){

        protected CachedValue<GlobalSearchScope> compute(final Module module, Void p) {
            return CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<GlobalSearchScope>(){

                @Nullable
                public CachedValueProvider.Result<GlobalSearchScope> compute() {
                    Project project = module.getProject();
                    GlobalSearchScope allLibFiles = JSElementResolveScopeProvider.getFilesAndDirectoriesScope(project, JS_INDEXED_ROOT_PROVIDER.getLibraryFiles(project));
                    GlobalSearchScope moduleContentScope = module.getModuleContentWithDependenciesScope();
                    GlobalSearchScope moduleWithDependenciesAndLibrariesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
                    GlobalSearchScope result = moduleContentScope.uniteWith(moduleWithDependenciesAndLibrariesScope).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)allLibFiles));
                    return new CachedValueProvider.Result((Object)result, new Object[]{ProjectRootManager.getInstance((Project)project)});
                }
            }, false);
        }
    };
    public static Key<PsiElement> contextKey = Key.create((String)"context.key");

    public static void processInjectedFileForTag(@NotNull XmlTag tag, @NotNull JSInjectedFilesVisitor visitor) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "processInjectedFileForTag"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "processInjectedFileForTag"));
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)tag.getProject());
        if (manager != null) {
            for (XmlTagChild child : tag.getValue().getChildren()) {
                if (!(child instanceof XmlText)) continue;
                manager.enumerate((PsiElement)child, (PsiLanguageInjectionHost.InjectedPsiVisitor)visitor);
            }
        }
    }

    public static String findPackageForMxml(PsiElement expression) {
        String s = null;
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4 && containingFile.getContext() != null) {
            PsiFile contextContainigFile = containingFile.getContext().getContainingFile();
            VirtualFile file = contextContainigFile.getOriginalFile().getVirtualFile();
            s = JSResolveUtil.getExpectedPackageNameFromFile(file, containingFile.getProject());
        }
        return s;
    }

    public static String getExpectedPackageNameFromFile(VirtualFile file, Project project) {
        VirtualFile rootForFile;
        if (file == null) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if ((rootForFile = projectFileIndex.getSourceRootForFile(file)) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)(file.isDirectory() ? file : file.getParent()), (VirtualFile)rootForFile, (char)'.');
        }
        return null;
    }

    public static void processInterfaceMethods(JSClass clazz, CollectMethodsToImplementProcessor implementedMethodProcessor) {
        clazz.processDeclarations((PsiScopeProcessor)implementedMethodProcessor, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
    }

    @Deprecated
    public static String getExpressionType(JSExpression expression, PsiFile containingFile) {
        if (expression == null) {
            return null;
        }
        if (DialectDetector.isTypeScript((PsiElement)expression)) {
            JSType type = JSResolveUtil.getQualifiedExpressionJSType(expression, containingFile);
            return type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        }
        String type = JSResolveUtil.getQualifiedExpressionType(expression, containingFile);
        return JSResolveUtil.getShortenedType(type, (PsiElement)expression);
    }

    public static String getShortenedType(@Nullable String type, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getShortenedType"));
        }
        if (type == null) {
            type = "*";
        } else {
            String shortName = JSResolveUtil.getShortTypeName(type, true);
            String expr = JSImportHandlingUtil.resolveTypeName(shortName, context);
            if (expr != null && !expr.equals(shortName) && !JSResolveUtil.shortReferenceIsAmbiguousOrUnequal(shortName, context, type, true)) {
                type = shortName;
            }
        }
        return type;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static String getQualifiedExpressionType(@Nullable JSExpression expression, PsiFile containingFile) {
        JSType type = JSResolveUtil.getQualifiedExpressionJSType(expression, containingFile);
        return type == null ? null : JSTypeUtils.getPresentableType(type, true);
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static JSType getQualifiedExpressionJSType(@Nullable JSExpression expression, PsiFile containingFile) {
        if (expression != null) {
            JSType jsType = JSTypeEvaluator.forceEvaluateType((PsiElement)expression, expression, containingFile);
            if (JSTypeUtils.isActionScriptVectorType(jsType)) {
                PsiElement resolve;
                if (expression instanceof JSCallExpression) {
                    expression = ((JSCallExpression)expression).getMethodExpression();
                }
                if (expression instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)expression).resolve()) instanceof JSFunction && !((JSFunction)resolve).isConstructor()) {
                    jsType = JSFunctionImpl.getReturnTypeInContext((JSFunction)resolve, (PsiElement)expression);
                }
            }
            return jsType;
        }
        return null;
    }

    @Nullable
    public static JSType getExpressionJSType(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        JSTypeEvaluationResult result = JSTypeEvaluator.getExpressionType(expression);
        return result != null ? result.getType() : null;
    }

    @NotNull
    public static String getShortTypeName(String type, boolean withSignature) {
        int i2;
        String str = type;
        int i = str.indexOf(60);
        String signature = null;
        if (i != -1) {
            int index = str.lastIndexOf(46, i);
            if (index == -1) {
                String string = type;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getShortTypeName"));
                }
                return string;
            }
            signature = str.substring(index);
            str = str.substring(0, index);
        }
        if ((i2 = str.lastIndexOf(46)) != -1) {
            str = str.substring(i2 + 1);
        }
        String string = str + (withSignature && signature != null ? signature : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getShortTypeName"));
        }
        return string;
    }

    public static PsiElement getClassReferenceForXmlFromContext(PsiElement parent) {
        PsiElement context;
        PsiElement psiElement = context = parent != null ? parent.getContext() : null;
        if (context instanceof XmlElement && context.getContainingFile() instanceof XmlFile) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)context);
        }
        return parent;
    }

    @Nullable
    public static XmlBackedJSClass getXmlBackedClass(JSFile injectedJsFile) {
        PsiElement context = injectedJsFile.getContext();
        if (context instanceof XmlAttributeValue || context instanceof XmlText) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)context);
        }
        return null;
    }

    public static <T extends JSPsiElementBase> SearchScope findUseScope(T element) {
        PsiElement scope;
        PsiElement scopeElement = scope = PsiTreeUtil.getParentOfType(element, (Class[])new Class[]{JSCatchBlock.class, JSClass.class, JSObjectLiteralExpression.class, JSExecutionScope.class});
        PsiFile file = element.getContainingFile().getOriginalFile();
        if (!(element instanceof JSAttributeListOwner)) {
            return JSResolveUtil.getDefaultScope((JSStubElementImpl)element, file);
        }
        if (scope instanceof JSFile) {
            PsiElement xmlFromContext = JSResolveUtil.getClassReferenceForXmlFromContext(scope);
            if (xmlFromContext != scope) {
                scope = xmlFromContext;
                scopeElement = scope.getContainingFile();
            } else if (!DialectDetector.isES6(element) || !((JSFile)scope).hasES6Syntax() || !((JSFile)scope).isCommonJSModule() || ES6ImportHandler.isExported(element)) {
                scope = null;
            }
        }
        if (scope != null) {
            JSAttributeList attributeList;
            if (scope instanceof JSClass && ((attributeList = ((JSAttributeListOwner)element).getAttributeList()) == null || attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE)) {
                return JSResolveUtil.getDefaultScope((JSStubElementImpl)element, file);
            }
            if (scope instanceof JSEmbeddedContent) {
                return new LocalSearchScope((PsiElement)scopeElement.getContainingFile());
            }
            return new LocalSearchScope(scopeElement);
        }
        if (JSResolveUtil.isFileLocalSymbol(element)) {
            return GlobalSearchScope.fileScope((PsiFile)file);
        }
        return JSResolveUtil.getDefaultScope((JSStubElementImpl)element, file);
    }

    @NotNull
    private static SearchScope getDefaultScope(JSStubElementImpl element, PsiFile file) {
        SearchScope result = element.getDefaultUseScope();
        if (!DialectDetector.isJavaScript((PsiElement)file)) {
            result = result.intersectWith(JSResolveUtil.getNonJSonScope(file.getProject()));
        }
        SearchScope searchScope = result;
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getDefaultScope"));
        }
        return searchScope;
    }

    private static SearchScope getNonJSonScope(Project project) {
        NonJsonScope cached = (NonJsonScope)((Object)project.getUserData(NON_JSON_SCOPE_KEY));
        return cached != null ? cached : (SearchScope)((UserDataHolderEx)project).putUserDataIfAbsent(NON_JSON_SCOPE_KEY, (Object)new NonJsonScope(project));
    }

    public static boolean isFileLocalSymbol(PsiElement element) {
        JSAttributeList attrList;
        if (element instanceof XmlBackedJSClass) {
            return false;
        }
        JSPackageStatement packageStatement = (JSPackageStatement)PsiTreeUtil.getParentOfType((PsiElement)element, JSPackageStatement.class, (boolean)false);
        if (packageStatement != null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof JSFile)) {
            return false;
        }
        if (file.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return false;
        }
        if (file.getContext() != null) {
            return false;
        }
        String qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
        JSAttributeList jSAttributeList = attrList = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
        if (attrList != null) {
            if (attrList.getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC) {
                return !attrList.hasModifier(JSAttributeList.ModifierType.NATIVE) && (qName == null || qName.indexOf(46) == -1);
            }
            if (attrList.getNamespace() != null || qName != null && qName.indexOf(46) != -1) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiElement findType(String type, @Nullable PsiElement context, boolean ecma) {
        if (type == null || context == null) {
            return null;
        }
        PsiElement typeClass = null;
        if (ecma) {
            if (context.getParent() instanceof JSNewExpression) {
                context = context.getParent();
            }
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(type, context, new ResolveResultSink(context, type));
            processor.setLocalResolve(true);
            processor.setTypeContext(true);
            processor.setToProcessHierarchy(false);
            processor.setToProcessMembers(false);
            JSResolveUtil.treeWalkUp(processor, (PsiElement)context.getContainingFile(), null, context);
            typeClass = processor.getResult();
        }
        if (typeClass == null) {
            typeClass = JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(type, context);
        }
        return typeClass;
    }

    public static boolean isAssignableType(@NonNls String expectedType, @NonNls String type, @Nullable PsiElement context) {
        if (context == null) {
            return JSResolveUtil.isAssignableTypeStatus(expectedType, type, null) != AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        JSType lOpType = JSTypeUtils.createType(expectedType, source);
        JSType rOpType = JSTypeUtils.createType(type, source);
        return JSResolveUtil.isAssignableJSType(lOpType, rOpType);
    }

    public static boolean isAssignableJSType(@Nullable JSType lOpType, JSType rOpType) {
        return lOpType == null || lOpType.isDirectlyAssignableType(rOpType, null);
    }

    public static boolean isEcmaScript5(PsiElement decl) {
        JSElement scope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)decl, JSExecutionScope.class);
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(USE_STRICT, new ResolveResultSink(null, USE_STRICT));
        while (scope != null) {
            JSResolveUtil.processDeclarationsInScope(scope, processor, ResolveState.initial(), null, decl);
            if (processor.getResult() != null) {
                return true;
            }
            scope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)scope, JSExecutionScope.class);
        }
        return false;
    }

    public static Collection<VirtualFile> sortFiles(Collection<VirtualFile> virtualFiles) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(virtualFiles);
        Collections.sort(files, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return (int)(o1.getLength() - o2.getLength());
            }
        });
        return files;
    }

    public static boolean calculateStaticFromContext(PsiElement psiElement) {
        JSAttributeList attributeList;
        PsiElement grandParent;
        JSAttributeListOwner attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSAttributeListOwner.class});
        while (attributeListOwner instanceof JSFunction && JSPsiImplUtils.isArrowFunction((JSFunction)attributeListOwner) != null) {
            attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getParentOfType((PsiElement)attributeListOwner, JSAttributeListOwner.class);
        }
        if ((attributeListOwner instanceof JSVariable || attributeListOwner instanceof JSVarStatement) && !((grandParent = JSResolveUtil.findParent((PsiElement)attributeListOwner)) instanceof JSFile) && !(grandParent instanceof JSClass)) {
            attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)grandParent, (Class[])new Class[]{JSAttributeListOwner.class});
        }
        return attributeListOwner != null && (attributeList = attributeListOwner.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    public static boolean shortReferenceIsAmbiguousOrUnequal(@NotNull String shortName, PsiElement context, String expectedFqn, Boolean forceInTypeContext) {
        if (shortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "shortReferenceIsAmbiguousOrUnequal"));
        }
        ResolveResult[] results = JSReferenceExpressionImpl.resolveUnqualified(shortName, context, forceInTypeContext);
        if (results.length > 1) {
            return true;
        }
        if (results.length == 0) {
            return false;
        }
        PsiElement element = results[0].getElement();
        if (context.getParent() instanceof JSNewExpression && element instanceof JSFunction && element.getParent() instanceof JSClass) {
            element = element.getParent();
        }
        return element instanceof JSQualifiedNamedElement && !expectedFqn.equals(((JSQualifiedNamedElement)element).getQualifiedName());
    }

    public static Query<JSPsiElementBase> doFindOverridenFunctionStatic(final JSPsiElementBase elt) {
        PsiElement parent = JSResolveUtil.findParent((PsiElement)elt);
        if (parent instanceof JSClass && elt instanceof JSFunction) {
            return new AbstractQuery<JSPsiElementBase>(){

                protected boolean processResults(final @NotNull Processor<JSPsiElementBase> consumer) {
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$2", "processResults"));
                    }
                    return JSFunctionsSearch.searchOverridingFunctions((JSFunction)elt, true).forEach((Processor)new Processor<JSFunction>(){

                        public boolean process(JSFunction jsFunction) {
                            return consumer.process((Object)jsFunction);
                        }
                    });
                }
            };
        }
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(elt);
        if (qName != null) {
            ArrayList result = new ArrayList();
            THashMap results = new THashMap();
            MyNamespaceProcessor namespaceProcessor = new MyNamespaceProcessor((Set)new THashSet(Collections.singletonList(elt)), true, (Map)results, result){
                final /* synthetic */ Map val$results;
                final /* synthetic */ ArrayList val$result;
                {
                    this.val$results = map;
                    this.val$result = arrayList;
                    super(functions, findAll);
                }

                @Override
                protected boolean doProcess(PsiElement elt) {
                    if (elt instanceof JSProperty) {
                        elt = ((JSProperty)elt).getValue();
                    }
                    if (!(elt instanceof JSPsiElementBase)) {
                        return true;
                    }
                    String qName = JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)elt);
                    if (qName != null) {
                        ArrayList<JSPsiElementBase> list = (ArrayList<JSPsiElementBase>)this.val$results.get(qName);
                        if (list == null) {
                            list = new ArrayList<JSPsiElementBase>(2);
                            this.val$results.put(qName, list);
                        }
                        list.add((JSPsiElementBase)elt);
                    } else {
                        this.val$result.add((JSPsiElementBase)elt);
                    }
                    return true;
                }
            };
            namespaceProcessor.processDescendantsOf(qName, (PsiElement)elt);
            for (List funs : results.values()) {
                result.addAll(funs);
            }
            return new CollectionQuery(result);
        }
        return new CollectionQuery(Collections.emptyList());
    }

    public static boolean isFromPredefinedFile(@Nullable PsiFile containingFile) {
        if (containingFile == null) {
            return false;
        }
        return JSResolveUtil.isFromPredefinedFile(containingFile.getProject(), containingFile.getOriginalFile().getVirtualFile());
    }

    public static boolean isFromPredefinedFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "isFromPredefinedFile"));
        }
        return JSLibraryManager.getInstance(project).isPredefinedLibraryFile(file);
    }

    public static AssignableTypeStatus isAssignableTypeStatus(@NonNls String _expectedType, @NonNls String _type, @Nullable PsiElement context) {
        boolean nonecma;
        final String expectedType = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(JSDocumentationUtils.stripTypeDecorations(_expectedType));
        String type = JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(JSDocumentationUtils.stripTypeDecorations(_type));
        if (expectedType != null && JSResolveUtil.hasMultipleOccurenceDelimiters(expectedType) || type != null && JSResolveUtil.hasMultipleOccurenceDelimiters(type)) {
            StringTokenizer expectedTypeIterator = new StringTokenizer(expectedType != null ? expectedType : "", "|/");
            while (expectedTypeIterator.hasMoreElements()) {
                String primitiveExpectedType = expectedTypeIterator.nextToken().trim();
                StringTokenizer typeIterator = new StringTokenizer(type != null ? type : "", "|/");
                while (typeIterator.hasMoreElements()) {
                    String primitiveType = typeIterator.nextToken().trim();
                    AssignableTypeStatus state = JSResolveUtil.isAssignableTypeStatus(primitiveExpectedType, primitiveType, context);
                    if (state == AssignableTypeStatus.COMPILE_TIME_FAIL) continue;
                    return state;
                }
            }
            return AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (expectedType == null || expectedType.equals("*") || expectedType.equals("Object")) {
            return AssignableTypeStatus.OK;
        }
        if (expectedType.equals(type)) {
            return AssignableTypeStatus.OK;
        }
        boolean bl = nonecma = context != null && context.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (nonecma && "Function".equals(type) && expectedType.startsWith("function")) {
            return AssignableTypeStatus.OK;
        }
        GenericSignature signature = JSResolveUtil.extractGenericSignature(type);
        GenericSignature expectedSignature = JSResolveUtil.extractGenericSignature(expectedType);
        if (expectedSignature != null && signature != null) {
            return JSResolveUtil.isAssignableTypeStatus(expectedSignature.elementType, signature.elementType, context) == AssignableTypeStatus.OK && expectedSignature.genericType.equals(signature.genericType) ? AssignableTypeStatus.OK : AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (expectedSignature != null) {
            if (nonecma && expectedSignature.elementType.equals(type)) {
                return AssignableTypeStatus.OK;
            }
            return "*".equals(type) ? AssignableTypeStatus.OK : AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if (signature != null) {
            return JSResolveUtil.isAssignableTypeStatus(expectedType, signature.elementType, context);
        }
        if ("Number".equals(expectedType) && ("int".equals(type) || "uint".equals(type))) {
            return AssignableTypeStatus.OK;
        }
        if ("int".equals(expectedType) && ("Number".equals(type) || "uint".equals(type))) {
            return AssignableTypeStatus.OK;
        }
        if ("uint".equals(expectedType) && ("int".equals(type) || "Number".equals(type))) {
            return AssignableTypeStatus.OK;
        }
        if ("Array".equals(type) && ("Arguments".equals(expectedType) || expectedType.startsWith("Array") || JSTypeEvaluateManager.isArrayType(expectedType))) {
            return AssignableTypeStatus.OK;
        }
        if ("Array".equals(expectedType) && JSTypeEvaluateManager.isArrayType(type)) {
            return AssignableTypeStatus.OK;
        }
        if ("String".equalsIgnoreCase(expectedType) && (nonecma ? "Number".equalsIgnoreCase(type) || "int".equals(type) || "Boolean".equalsIgnoreCase(type) : "XML".equals(type) || "XMLList".equals(type))) {
            return AssignableTypeStatus.OK;
        }
        if ("void".equals(type)) {
            return AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        if ("Boolean".equalsIgnoreCase(expectedType)) {
            return AssignableTypeStatus.LANG_IMPLICIT_COERCION;
        }
        if (("XML".equals(expectedType) || "XMLList".equals(expectedType)) && "Object".equals(type)) {
            return AssignableTypeStatus.OK;
        }
        if ("*".equals(type)) {
            return AssignableTypeStatus.OK;
        }
        PsiElement typeClass = JSResolveUtil.findType(type, context, !nonecma);
        if (!(typeClass instanceof JSClass)) {
            if (nonecma) {
                boolean result = JSTypeEvaluateManager.iterateTypeHierarchy(context, type, new JSTypeEvaluateManager.NamespaceProcessor(){
                    final Set<String> visited = new THashSet();

                    @Override
                    public boolean process(String serializedType, VirtualFile file) {
                        String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                        if (!this.visited.contains(qName)) {
                            this.visited.add(qName);
                            return !expectedType.equals(qName);
                        }
                        return true;
                    }
                });
                if (!result) {
                    return AssignableTypeStatus.OK;
                }
                return JSResolveUtil.checkTypedef(context, expectedType, type);
            }
            return AssignableTypeStatus.COMPILE_TIME_FAIL;
        }
        boolean result = JSResolveUtil.processHierarchy((JSClass)typeClass, new Processor<JSClass>(){

            public boolean process(JSClass jsClass) {
                return !jsClass.getQualifiedName().equals(expectedType);
            }
        }, true);
        if (!result) {
            return AssignableTypeStatus.OK;
        }
        return JSResolveUtil.checkTypedef(context, expectedType, type);
    }

    private static AssignableTypeStatus checkTypedef(PsiElement context, String expectedType, String type) {
        JSType typedefType = JSTypeEvaluateManager.expandTypedefs(context, expectedType);
        return typedefType == null ? AssignableTypeStatus.COMPILE_TIME_FAIL : JSResolveUtil.isAssignableTypeStatus(typedefType.getTypeText(), type, context);
    }

    public static boolean hasMultipleOccurenceDelimiters(String expectedType) {
        String commentDelimiters = "|/";
        for (int i = 0; i < "|/".length(); ++i) {
            if (expectedType.indexOf("|/".charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        GlobalSearchScope scope;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getResolveScope"));
        }
        Language language = DialectDetector.languageOfElement(element);
        JSElementResolveScopeProvider provider = (JSElementResolveScopeProvider)((Object)JSElementResolveScopeProvider.EP_NAME.forLanguage(language));
        if (provider != null) {
            scope = provider.getElementResolveScope(element);
        } else {
            VirtualFile file;
            PsiFile containingFile = element.getContainingFile();
            PsiFile psiFile = containingFile != null ? containingFile.getOriginalFile() : null;
            VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
            scope = file != null ? JSResolveUtil.getJavaScriptSymbolsResolveScope(psiFile.getProject(), file) : (psiFile != null ? psiFile.getResolveScope() : element.getResolveScope());
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public static PsiElement getContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getContext"));
        }
        PsiElement result = (PsiElement)element.getUserData(contextKey);
        if (result != null && !result.isValid()) {
            result = null;
        }
        return result;
    }

    public static boolean isObjectClass(@NotNull JSClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "isObjectClass"));
        }
        return "Object".equals(aClass.getQualifiedName());
    }

    public static boolean processHierarchy(String qName, PsiFile containingFile, Processor<JSClass> processor, boolean visitInterfaces) {
        PsiElement clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)containingFile).getClassResolver().findClassByQName(qName, (PsiElement)containingFile);
        if (clazz instanceof JSClass) {
            return JSResolveUtil.processHierarchy((JSClass)clazz, processor, visitInterfaces);
        }
        return true;
    }

    public static boolean processHierarchy(JSClass clazz, Processor<JSClass> processor, boolean visitInterfaces) {
        return clazz.processDeclarations((PsiScopeProcessor)new VisitAllTypesProcessor(processor, visitInterfaces), ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
    }

    public static void stableResolveOrder(ResolveResult[] results) {
        Arrays.sort(results, new Comparator<ResolveResult>(){

            @Override
            public int compare(ResolveResult o1, ResolveResult o2) {
                PsiElement elt = o1.getElement();
                PsiElement elt2 = o2.getElement();
                if (elt != null && elt2 != null && elt.getContainingFile() == elt2.getContainingFile()) {
                    return elt.getTextOffset() - elt2.getTextOffset();
                }
                return 0;
            }
        });
    }

    public static ResolveResult[] filterResolveResultsByLibraryScope(PsiElement original, ResolveResult[] results) {
        PsiFile originalFile = original.getContainingFile();
        if (!JavaScriptSupportLoader.isPlainJavaScriptFile(originalFile)) {
            return results;
        }
        Project project = original.getProject();
        JSLibraryManager libraryManager = (JSLibraryManager)((Object)ServiceManager.getService((Project)project, JSLibraryManager.class));
        ScriptingLibraryMappings mappings = (ScriptingLibraryMappings)ServiceManager.getService((Project)project, JSLibraryMappings.class);
        ArrayList<ResolveResult> filtered = new ArrayList<ResolveResult>();
        for (ResolveResult r : results) {
            VirtualFile f;
            PsiElement e = r.getElement();
            PsiFile psiFile = e != null ? e.getContainingFile() : null;
            VirtualFile virtualFile = f = psiFile != null ? psiFile.getVirtualFile() : null;
            if (libraryManager.isLibraryFile(f) && !mappings.isApplicable(f, originalFile.getVirtualFile())) continue;
            filtered.add(r);
        }
        if (filtered.isEmpty()) {
            return results;
        }
        return filtered.toArray(new ResolveResult[filtered.size()]);
    }

    public static JSNamedElement findFileLocalElement(@NotNull String str, PsiElement context) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findFileLocalElement"));
        }
        SinkResolveProcessor processor = new SinkResolveProcessor(str, new ResolveResultSink(null, str)){
            {
                this.setTypeContext(true);
                this.setToProcessMembers(false);
            }
        };
        boolean b = context.getContainingFile().processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, context);
        return (JSNamedElement)processor.getResult();
    }

    @Nullable
    public static String getQualifiedTypeName(@Nullable String _typeName) {
        if (_typeName != null) {
            String typeName;
            GenericSignature signature = JSResolveUtil.extractGenericSignature(_typeName);
            String string = typeName = signature != null ? signature.elementType : _typeName;
            if (VECTOR$OBJECT_TYPE_NAME.equals(typeName)) {
                typeName = "Vector";
            }
            return GenericSignature.build(typeName, signature);
        }
        return null;
    }

    public static boolean weShouldSkipResolveBecauseOfImplicitClass(PsiElement elt) {
        if (elt == null) {
            return false;
        }
        PsiElement responsibleElement = elt instanceof JSFile ? elt : elt.getParent();
        return responsibleElement instanceof JSFile && DialectDetector.isActionScript(responsibleElement) && responsibleElement.getContext() != null;
    }

    public static boolean isAccessibleFromPackage(PsiElement element, @NotNull String forcedPackageName) {
        JSAttributeList attributeList;
        if (forcedPackageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forcedPackageName", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "isAccessibleFromPackage"));
        }
        if (element instanceof TypeScriptCallSignature) {
            element = element.getParent().getParent();
        }
        if (element instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null) {
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType == JSAttributeList.AccessType.PRIVATE && element instanceof JSClass) {
                return false;
            }
            if (!(accessType != JSAttributeList.AccessType.PACKAGE_LOCAL || attributeList.getNamespace() != null || element instanceof JSFunction && ((JSFunction)element).isConstructor() || JSResolveUtil.isQualifiedAS2Symbol(element))) {
                PsiElement parent = JSResolveUtil.findParent(element);
                if (parent instanceof JSClass ? ((JSClass)parent).isInterface() : !(parent instanceof JSFile) && !(parent instanceof JSPackageStatement) && !(parent instanceof TypeScriptModule)) {
                    return true;
                }
                String packageName2 = JSResolveUtil.getPackageName(element);
                if (!forcedPackageName.equals(packageName2)) {
                    return false;
                }
                if (forcedPackageName.isEmpty() && element instanceof JSClass && JSResolveUtil.isFileLocalSymbol(element)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isSelfReference(PsiElement element) {
        return JSResolveUtil.isSelfReference(element.getParent(), element);
    }

    @Nullable
    public static GenericSignature extractGenericSignature(String type) {
        if (type == null) {
            return null;
        }
        int ltPos = type.indexOf(60);
        if (ltPos > 0 && type.charAt(ltPos - 1) == '.') {
            int gtPos = type.lastIndexOf(62);
            String genericType = type.substring(ltPos + 1, gtPos != -1 ? gtPos : type.length()).trim();
            type = type.substring(0, ltPos - 1).trim();
            return new GenericSignature(type, genericType);
        }
        return null;
    }

    public static PsiElement getTopReferenceParent(PsiElement parent) {
        PsiElement currentParent = parent;
        while (currentParent instanceof JSReferenceExpression) {
            currentParent = currentParent.getParent();
        }
        return currentParent;
    }

    public static PsiElement getTopReferenceExpression(@NotNull PsiElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getTopReferenceExpression"));
        }
        PsiElement element = parent;
        PsiElement currentParent = parent.getParent();
        while (currentParent instanceof JSReferenceExpression) {
            element = currentParent;
            currentParent = currentParent.getParent();
        }
        return element;
    }

    public static boolean isSelfReference(PsiElement currentParent, PsiElement elt) {
        if (currentParent instanceof TypeScriptModule) {
            PsiElement identifier = ((TypeScriptModule)currentParent).getNameIdentifier();
            return identifier != null && identifier.getParent() == elt;
        }
        return currentParent instanceof JSPackageStatement || currentParent instanceof JSNamespaceDeclaration && ((JSNamespaceDeclaration)currentParent).findNameIdentifier() == elt.getNode() || currentParent instanceof JSVariable && ((JSVariable)currentParent).findNameIdentifier() == elt.getNode() || currentParent instanceof JSFunction && JSPsiImplUtils.isFunctionNameReference((JSFunction)currentParent, elt) || currentParent instanceof JSClass;
    }

    public static boolean isSameReference(@NotNull JSReferenceExpression ref, @NotNull PsiElement resolve) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "isSameReference"));
        }
        if (resolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolve", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "isSameReference"));
        }
        if (ref.getContainingFile() != resolve.getContainingFile()) {
            return false;
        }
        JSExpression resolveRef = resolve instanceof JSDefinitionExpression ? ((JSDefinitionExpression)resolve).getExpression() : (resolve instanceof JSNamedElement ? ((JSNamedElement)resolve).getNameIdentifier() : resolve);
        return ref == resolveRef;
    }

    public static PsiElement findParent(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findParent"));
        }
        PsiElement parent = element.getParent();
        if (element instanceof JSVariable && (parent = JSDestructuringUtil.getParentSkippingDestructuring((JSVariable)element)) != null) {
            parent = parent.getParent();
        }
        if (parent instanceof TypeScriptObjectType && parent.getParent() instanceof TypeScriptInterface) {
            parent = parent.getParent();
        }
        if (parent instanceof JSBlockStatement) {
            XmlBackedJSClass xmlBackedClass;
            PsiElement grandParent = parent.getParent();
            if (((JSBlockStatement)parent).isConditionalCompileBlock()) {
                parent = grandParent;
            } else if (grandParent instanceof JSClass) {
                parent = grandParent;
            } else if (grandParent instanceof JSFile && (xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)grandParent)) != null) {
                return xmlBackedClass;
            }
        }
        return parent instanceof JSFile ? JSResolveUtil.findParentClass((JSFile)parent) : parent;
    }

    public static PsiElement findParentClass(JSFile file) {
        PsiFile containingFile;
        XmlBackedJSClass xmlBackedClass = JSResolveUtil.getXmlBackedClass(file);
        if (xmlBackedClass != null) {
            return xmlBackedClass;
        }
        PsiElement forcedContext = JSResolveUtil.getContext((PsiElement)file);
        if (forcedContext instanceof JSClass) {
            return forcedContext;
        }
        if (forcedContext instanceof JSFile) {
            return JSResolveUtil.findParentClass((JSFile)forcedContext);
        }
        if (forcedContext instanceof PsiFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)forcedContext)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)forcedContext);
        }
        if (forcedContext instanceof XmlElement && JavaScriptSupportLoader.isFlexMxmFile(containingFile = forcedContext.getContainingFile())) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)containingFile);
        }
        if (forcedContext != null) {
            JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)forcedContext, JSClass.class);
            if (jsClass != null) {
                return jsClass;
            }
            PsiFile containingFile2 = forcedContext.getContainingFile();
            if (containingFile2 instanceof JSFile && containingFile2 != file) {
                return JSResolveUtil.findParentClass((JSFile)containingFile2);
            }
        }
        return file;
    }

    @Nullable
    public static JSClass getClassOfContext(@Nullable PsiElement node) {
        return JSResolveUtil.getClassOfContext(node, false);
    }

    @Nullable
    public static JSClass getClassOfContext(@Nullable PsiElement node, boolean strict) {
        JSFunction fun;
        if (node == null) {
            return null;
        }
        if (strict && (fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) != null && JSPsiImplUtils.isArrowFunction(fun) == null) {
            PsiElement parent = JSResolveUtil.findParent((PsiElement)fun);
            return parent instanceof JSClass ? (JSClass)parent : null;
        }
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)node, JSClass.class);
        if (jsClass != null) {
            return jsClass;
        }
        PsiElement context = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)node.getContainingFile());
        if (context instanceof JSClass) {
            return (JSClass)context;
        }
        return null;
    }

    @Nullable
    public static JSClass findClassOfQualifier(JSExpression qualifier, PsiFile containingFile) {
        PsiElement qName;
        String s = JSResolveUtil.getQualifiedExpressionType(qualifier, containingFile);
        PsiElement psiElement = qName = s != null ? JSResolveUtil.unwrapProxy(JSClassResolver.findClassFromNamespace(s, (PsiElement)containingFile)) : null;
        if (qName instanceof JSClass) {
            return (JSClass)qName;
        }
        return null;
    }

    @Nullable
    public static Pair<? extends PsiElement, String> getElementThatShouldBeQualified(PsiElement element, String fqn) {
        PsiElement parent;
        JSReferenceExpression reference = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSReferenceExpression.class});
        if (reference != null && ((parent = reference.getParent()) instanceof JSImportStatement || parent instanceof JSReferenceListMember && reference.getContainingFile().getContext() != null)) {
            return Pair.create((Object)reference, (Object)fqn);
        }
        if (element.getContainingFile() instanceof JSExpressionCodeFragment) {
            return Pair.create((Object)reference, (Object)fqn);
        }
        return null;
    }

    public static boolean isArtificialClassUsedForReferenceList(JSClass clazz) {
        return clazz.getContainingFile().getContext() != null;
    }

    public static Collection<JSQualifiedNamedElement> findElementsByName(String name, Project project, GlobalSearchScope scope) {
        return JSResolveUtil.findElementsByName(name, project, scope, true);
    }

    public static Collection<JSQualifiedNamedElement> findElementsByName(String name, Project project, GlobalSearchScope scope, boolean resultAsNavigatonElements) {
        HashSet<JSQualifiedNamedElement> result = new HashSet<JSQualifiedNamedElement>();
        Collection jsQualifiedNamedElements = StubIndex.getElements(JSNameIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (JSQualifiedNamedElement e : jsQualifiedNamedElements) {
            VirtualFile fileOrDir = e.getContainingFile().getVirtualFile();
            if (!projectFileIndex.isInLibrarySource(fileOrDir) ? !projectFileIndex.isInSource(fileOrDir) && !projectFileIndex.isInLibraryClasses(fileOrDir) && e.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4 : ApplicationManager.getApplication().isUnitTestMode() && !projectFileIndex.isInLibraryClasses(fileOrDir)) continue;
            if (resultAsNavigatonElements) {
                PsiElement navElement = e.getNavigationElement();
                if (navElement instanceof JSQualifiedNamedElement) {
                    result.add((JSQualifiedNamedElement)navElement);
                    continue;
                }
                result.add(e);
                continue;
            }
            result.add(e);
        }
        ArrayList files = new ArrayList();
        files.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)(name + ".mxml"), (GlobalSearchScope)scope));
        for (VirtualFile file : files) {
            PsiFile psiFile;
            if (!file.isValid() || !projectFileIndex.isInSource(file) || (psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) continue;
            result.add((JSQualifiedNamedElement)XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)psiFile));
        }
        return result;
    }

    public static boolean isActionScript(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "isActionScript"));
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(psiFile);
        return dialect == DialectOptionHolder.ECMA_4;
    }

    @Nullable
    public static JSType getTypeFromSetAccessor(JSFunctionItem fun) {
        JSParameterItem parameter = JSResolveUtil.getParameterFromSetAccessor(fun);
        return parameter != null ? parameter.getType() : null;
    }

    @Nullable
    public static JSParameterItem getParameterFromSetAccessor(JSFunctionItem fun) {
        if (!fun.isSetProperty()) {
            return null;
        }
        JSParameterItem[] jsParameters = fun.getParameters();
        if (jsParameters.length != 1) {
            return null;
        }
        return jsParameters[0];
    }

    public static boolean processTopPackages(final ResolveProcessor processor, final ResolveState state, final Project project, final GlobalSearchScope scope) {
        if (processor.skipTopLevelItems()) {
            return true;
        }
        return JSPackageIndex.processElementsInScope("", processor.getName(), new JSPackageIndex.PackageElementsProcessor(){

            @Override
            public boolean process(VirtualFile file, String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                if (kind != JSPackageIndexInfo.Kind.PACKAGE) {
                    return true;
                }
                return processor.execute((PsiElement)new JSPackageWrapper(name, project, scope), state);
            }
        }, scope, project);
    }

    public static boolean shouldProcessTopLevelGlobalContext(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        PsiElement placeParent;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "shouldProcessTopLevelGlobalContext"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "shouldProcessTopLevelGlobalContext"));
        }
        return JSResolveUtil.shouldProcessImports(place, processor) && (!((placeParent = place.getParent()) instanceof JSCallExpression) || place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null && ((ResolveProcessor)processor).needsAllVariants() || placeParent instanceof JSNewExpression);
    }

    public static boolean shouldProcessImports(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "shouldProcessImports"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "shouldProcessImports"));
        }
        if (!(processor instanceof ResolveProcessor) || ((ResolveProcessor)processor).isLocalResolve()) {
            return false;
        }
        return !(place instanceof JSReferenceExpression) || ((JSReferenceExpression)place).getQualifier() == null || ((ResolveProcessor)processor).needsAllVariants();
    }

    public static boolean processTopLevelClasses(ResolveProcessor processor, ResolveState state, Project project, GlobalSearchScope scope, GlobalSymbolsAcceptanceState acceptOnlyClasses, boolean acceptQualifiedElements) {
        boolean result = true;
        String resolvedName = processor.getName();
        if (resolvedName == null) {
            if (processor.skipTopLevelItems()) {
                return true;
            }
            for (String s : StubIndex.getInstance().getAllKeys(JSNameIndex.KEY, project)) {
                if (!processor.needTopLevelClassName(s) || "Arguments".equals(s)) continue;
                for (JSQualifiedNamedElement e : StubIndex.getElements(JSNameIndex.KEY, (Object)s, (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class)) {
                    if (e instanceof JSAttributeListOwner && JSResolveUtil.hasExcludeClassMetadata((JSAttributeListOwner)e) || !JSResolveUtil.acceptableSymbol(e, acceptOnlyClasses, acceptQualifiedElements, processor.place)) continue;
                    result &= processor.execute((PsiElement)e, state);
                }
            }
        } else {
            JSQualifiedNamedElement e;
            Iterator iterator = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)resolvedName.hashCode(), (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class).iterator();
            while (iterator.hasNext() && (!StringUtil.equals((CharSequence)(e = (JSQualifiedNamedElement)iterator.next()).getName(), (CharSequence)resolvedName) || !JSResolveUtil.acceptableSymbol(e, acceptOnlyClasses, acceptQualifiedElements, processor.place) || (result = processor.execute((PsiElement)e, state)))) {
            }
        }
        return result;
    }

    public static boolean hasExcludeClassMetadata(@NotNull JSAttributeListOwner attributeListOwner) {
        if (attributeListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeListOwner", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "hasExcludeClassMetadata"));
        }
        JSAttributeList attributeList = attributeListOwner.getAttributeList();
        return attributeList != null && attributeList.findAttributeByName(EXCLUDE_CLASS_METADATA) != null;
    }

    public static boolean acceptableSymbol(JSQualifiedNamedElement e, GlobalSymbolsAcceptanceState acceptOnlyClasses, boolean acceptQualifiedElements, PsiElement place) {
        boolean isNotTopLevel;
        if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES ? !(e instanceof JSClass) : (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_NO_CLASSES ? e instanceof JSClass : acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS && !(e instanceof JSNamespaceDeclaration) && !(e instanceof JSVariable))) {
            return false;
        }
        String qName = e.getQualifiedName();
        boolean bl = isNotTopLevel = qName != null && qName.indexOf(46) != -1;
        if (!isNotTopLevel && !JSResolveUtil.isAccessibleSymbol(e, place)) {
            return false;
        }
        if (!acceptQualifiedElements && isNotTopLevel) {
            return false;
        }
        return !(e instanceof JSVariable) && !(e instanceof JSFunction) || DialectDetector.isActionScript((PsiElement)e);
    }

    public static boolean walkOverStructure(@NotNull PsiElement context, Processor<PsiNamedElement> processor) {
        PsiElement forcedContext;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "walkOverStructure"));
        }
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
        if (parent instanceof JSClass && (forcedContext = JSResolveUtil.getContext((PsiElement)parent)) instanceof XmlBackedJSClass && !processor.process((Object)((PsiNamedElement)forcedContext))) {
            return false;
        }
        while (parent != null) {
            if (parent instanceof JSFunctionExpression) {
                parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
                continue;
            }
            if (!processor.process((Object)parent)) {
                return false;
            }
            if (parent instanceof PsiFile) {
                PsiElement data = JSResolveUtil.getContext((PsiElement)parent);
                if (!(data instanceof JSElement)) break;
                parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)data, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
                continue;
            }
            parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
        }
        return true;
    }

    public static Map<String, String> calculateOpenNses(PsiElement place) {
        final Ref result = new Ref();
        JSResolveUtil.walkOverStructure(place, new Processor<PsiNamedElement>(){

            public boolean process(PsiNamedElement psiNamedElement) {
                if (psiNamedElement instanceof JSElement) {
                    result.set(((ParameterizedCachedValue)ourCachedOpenedNsesCache.get(ourCachedOpenedNsesKey, (UserDataHolder)((JSElement)psiNamedElement), null)).getValue((Object)((JSElement)psiNamedElement)));
                }
                return false;
            }
        });
        return result.get() != null ? (Map)result.get() : Collections.emptyMap();
    }

    public static boolean processGlobalThings(ResolveProcessor processor, ResolveState state, PsiElement place, PsiElement context) {
        boolean result = true;
        Project project = context.getProject();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        PsiElement placeParent = place.getParent();
        if (JSResolveUtil.shouldProcessTopLevelGlobalContext(place, processor) && (!(place instanceof JSReferenceExpression) || placeParent instanceof JSReferenceExpression || processor.needPackages() || processor.getName() == null)) {
            result = JSResolveUtil.processTopPackages(processor, state, project, scope);
        }
        if (result && !processor.needPackages()) {
            boolean refExpr = place instanceof JSReferenceExpression;
            GlobalSymbolsAcceptanceState acceptOnlyClasses = null;
            if (refExpr && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)place)) {
                acceptOnlyClasses = GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES;
            }
            if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES && processor.getName() == null && JSResolveUtil.isInsideArtificialAttrList((JSReferenceExpression)place)) {
                acceptOnlyClasses = null;
            }
            if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES && placeParent instanceof JSImportStatement && processor.getName() == null) {
                acceptOnlyClasses = null;
            }
            if (placeParent instanceof JSUseNamespaceDirective) {
                acceptOnlyClasses = GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS;
            } else if (placeParent instanceof JSAttributeList && JSResolveUtil.isPlaceWhereNsCanBe(placeParent) || placeParent instanceof JSExpressionStatement && JSResolveUtil.isPlaceWhereNsCanBe(placeParent)) {
                PsiElement parent = JSResolveUtil.findParent(placeParent);
                acceptOnlyClasses = parent instanceof JSExpressionCodeFragment ? GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES : (parent instanceof JSClass ? GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS : GlobalSymbolsAcceptanceState.ACCEPT_NO_CLASSES);
            }
            result = JSResolveUtil.processTopLevelClasses(processor, state, project, scope, acceptOnlyClasses, true);
        }
        return result;
    }

    public static boolean isInsideArtificialAttrList(JSReferenceExpression place) {
        if (place.getParent() instanceof JSAttributeList) {
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)place);
            if (next instanceof PsiErrorElement) {
                next = PsiTreeUtil.nextLeaf((PsiElement)next);
            }
            return next instanceof PsiWhiteSpace && next.textContains('\n');
        }
        return false;
    }

    public static void processParametersForUsedArgument(@NotNull JSExpression mainOccurrence, @NotNull JSArgumentList parent, @NotNull Processor<JSParameterItem> processor) {
        JSParameterItem parameter;
        PsiElement declaration;
        XmlAttribute attr;
        XmlAttributeDescriptor descriptor;
        PsiElement context;
        if (mainOccurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainOccurrence", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "processParametersForUsedArgument"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "processParametersForUsedArgument"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "processParametersForUsedArgument"));
        }
        int _paramIndex = 0;
        for (JSExpression expr : parent.getArguments()) {
            if (expr == mainOccurrence) break;
            ++_paramIndex;
        }
        int paramIndex = _paramIndex;
        PsiElement firstChild = parent.getFirstChild();
        PsiElement originalFirstChild = PsiUtilCore.getOriginalElement((PsiElement)firstChild, firstChild.getClass());
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalFirstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        JSExpression methodExpr = originalElement.getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult r : results = ((JSReferenceExpression)methodExpr).multiResolve(false)) {
                JSParameterItem[] params;
                JSFunctionItem matchedFunction;
                PsiElement element = r.getElement();
                if (element == null || !element.isValid() || (matchedFunction = JSPsiImplUtils.calculatePossibleFunction(element)) == null || !(paramIndex < (params = matchedFunction.getParameters()).length ? !processor.process((Object)params[paramIndex]) : params.length > 0 && params[params.length - 1].isRest() && !processor.process((Object)params[params.length - 1]))) continue;
                return;
            }
        } else if (methodExpr instanceof JSParenthesizedExpression && (context = methodExpr.getContainingFile().getContext()) instanceof XmlAttributeValue && (descriptor = (attr = (XmlAttribute)context.getParent()).getDescriptor()) instanceof AnnotationBackedDescriptor && (declaration = descriptor.getDeclaration()) instanceof JSFunction && (parameter = JSResolveUtil.getParameterFromSetAccessor((JSFunctionItem)((JSFunction)declaration))) != null) {
            processor.process((Object)parameter);
        }
    }

    @Nullable
    public static JSParameterItem findParameterForUsedArgument(@NotNull JSExpression mainOccurrence, @NotNull JSArgumentList parent) {
        if (mainOccurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainOccurrence", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findParameterForUsedArgument"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findParameterForUsedArgument"));
        }
        final Ref result = new Ref();
        JSResolveUtil.processParametersForUsedArgument(mainOccurrence, parent, new Processor<JSParameterItem>(){

            public boolean process(JSParameterItem jsParameter) {
                result.set((Object)jsParameter);
                return false;
            }
        });
        return (JSParameterItem)result.get();
    }

    public static boolean isAccessibleSymbol(JSQualifiedNamedElement subject, PsiElement context) {
        if (JSResolveUtil.isFileLocalSymbol((PsiElement)subject)) {
            return context != null && JSResolveUtil.isFileLocalSymbolAccessible((PsiElement)subject, context);
        }
        return true;
    }

    private static boolean isFileLocalSymbolAccessible(PsiElement subject, PsiElement context) {
        PsiElement fragmentContext;
        PsiFile contextFile = context.getContainingFile().getOriginalFile();
        if (contextFile instanceof PsiCodeFragment && (fragmentContext = JSResolveUtil.getContext((PsiElement)contextFile)) != null) {
            contextFile = fragmentContext.getContainingFile();
        }
        return subject.getContainingFile() == contextFile;
    }

    public static boolean isAccessibleFromCurrentPackage(PsiElement element, PsiElement place) {
        return JSResolveUtil.isAccessibleFromCurrentPackage(element, place != null ? JSResolveUtil.getPackageNameFromPlace(place) : null, place);
    }

    public static boolean isAccessibleFromCurrentPackage(PsiElement element, String packageName2, PsiElement place) {
        if (place != null) {
            JSAttributeList attrList;
            if (packageName2 == null) {
                return false;
            }
            PsiFile containingFile = place.getContainingFile();
            if ((DialectDetector.isTypeScript((PsiElement)containingFile) || DialectDetector.dialectOfFile(containingFile) == DialectOptionHolder.FLOW) && place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() == null) {
                return true;
            }
            if (place.getParent() instanceof JSReferenceListMember && containingFile instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)containingFile) && element instanceof JSAttributeListOwner && (attrList = ((JSAttributeListOwner)element).getAttributeList()) != null && attrList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
                return false;
            }
            if (!JSResolveUtil.isAccessibleFromPackage(element, packageName2)) {
                return (JSResolveUtil.getPackageName(element).isEmpty() || packageName2.isEmpty()) && (JSResolveUtil.isFileLocalSymbol(element) && JSResolveUtil.isFileLocalSymbolAccessible(element, place) || ResolveProcessor.toSkipPackageLocalCheck(place));
            }
        }
        return true;
    }

    private static boolean isQualifiedAS2Symbol(PsiElement element) {
        String qName;
        return element instanceof JSQualifiedNamedElement && (qName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null && !StringUtil.getPackageName((String)qName).isEmpty() && JSResolveUtil.findParent(element) instanceof JSFile;
    }

    public static String getPackageNameFromPlace(@NotNull PsiElement place) {
        String packageName2;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getPackageNameFromPlace"));
        }
        JSQualifiedNamedElement namedElement = (JSQualifiedNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])PACKAGE_ELEMENTS);
        while (namedElement instanceof JSFunction || namedElement instanceof JSVariable || namedElement instanceof JSDefinitionExpression) {
            PsiElement namedElementParent = JSResolveUtil.findParent((PsiElement)namedElement);
            if (namedElementParent instanceof JSQualifiedNamedElement) {
                namedElement = (JSQualifiedNamedElement)namedElementParent;
                continue;
            }
            namedElement = (JSQualifiedNamedElement)PsiTreeUtil.getParentOfType((PsiElement)namedElementParent, JSQualifiedNamedElement.class);
        }
        if (namedElement == null) {
            PsiFile containingFile = place.getContainingFile().getOriginalFile();
            PsiElement context = containingFile.getContext();
            if (context != null) {
                containingFile = context.getContainingFile().getOriginalFile();
            }
            if (JavaScriptSupportLoader.isMxmlOrFxgFile(containingFile)) {
                return JSResolveUtil.getExpectedPackageNameFromFile(containingFile.getVirtualFile(), containingFile.getProject());
            }
        }
        String string = namedElement instanceof JSPackageStatement || namedElement instanceof TypeScriptModule ? namedElement.getQualifiedName() : (packageName2 = namedElement != null ? JSResolveUtil.getPackageName((PsiElement)namedElement) : "");
        if (packageName2 == null) {
            packageName2 = "";
        }
        return packageName2;
    }

    @NotNull
    public static String getPackageName(PsiElement element) {
        PsiElement parent = JSResolveUtil.findParent(element);
        if (parent instanceof JSClass) {
            String string = JSResolveUtil.getPackageName(parent);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getPackageName"));
            }
            return string;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (!(dialect == DialectOptionHolder.ECMA_4 || dialect != null && dialect.isTypeScript)) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getPackageName"));
            }
            return "";
        }
        JSQualifiedName namespace = ((JSQualifiedNamedElement)element).getNamespace();
        String string = namespace != null ? namespace.getQualifiedName() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getPackageName"));
        }
        return string;
    }

    private JSResolveUtil() {
    }

    public static void treeWalkUp(PsiScopeProcessor processor, PsiElement elt, PsiElement lastParent, PsiElement place) {
        JSResolveUtil.treeWalkUp(processor, elt, lastParent, place, null);
    }

    public static void treeWalkUp(PsiScopeProcessor processor, PsiElement elt, PsiElement lastParent, PsiElement place, PsiElement terminatingParent) {
        while (elt != null) {
            PsiElement parentElement = elt.getContext();
            boolean parentIsClass = parentElement instanceof JSClass;
            int initialIndex = -1;
            PsiElement[] children = JSResolveUtil.getChildren(parentElement);
            if (children != null && children.length > 0) {
                initialIndex = 0;
                for (PsiElement el : children) {
                    if (el == elt) break;
                    ++initialIndex;
                }
            }
            int index = initialIndex;
            boolean finish = false;
            Object cur = elt;
            do {
                if (!cur.processDeclarations(processor, ResolveState.initial(), (PsiElement)(cur == elt ? lastParent : null), place) && processor instanceof ResolveProcessor) {
                    return;
                }
                if (terminatingParent != cur) continue;
                finish = true;
                break;
            } while (!(cur instanceof PsiFile) && !parentIsClass && (!(cur instanceof JSStatement) || !(parentElement instanceof JSIfStatement)) && (cur = index == -1 ? cur.getPrevSibling() : (index == initialIndex + 1 ? null : (index == 0 ? ((index = children.length - 1) > initialIndex ? children[index] : null) : children[--index]))) != null);
            if (!(finish || parentIsClass || parentElement instanceof JSProperty || JSResolveUtil.weShouldSkipResolveBecauseOfImplicitClass(parentElement) || JSResolveUtil.processFunctionDeclarations(processor, parentElement))) {
                return;
            }
            if (elt instanceof PsiFile) {
                XmlBackedJSClassProvider[] rootTag;
                if (elt instanceof XmlFile) {
                    XmlFile xmlFile = (XmlFile)elt;
                    XmlDocument document = xmlFile.getDocument();
                    XmlBackedJSClassProvider[] xmlBackedJSClassProviderArray = rootTag = document != null ? document.getRootTag() : null;
                    if (JavaScriptSupportLoader.isFlexMxmFile((PsiFile)xmlFile)) {
                        JSResolveUtil.processAllGlobalsInXmlFile(processor, xmlFile, place);
                    } else if (rootTag != null && xmlFile.getFileType() == XmlFileType.INSTANCE) {
                        JSResolveUtil.processAllGlobalsInXmlFile(processor, xmlFile, place);
                    }
                    if (parentElement != null) {
                        parentElement = parentElement.getContainingFile();
                    }
                } else if (elt instanceof JSFile) {
                    if (parentElement != null) {
                        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parentElement, XmlTag.class);
                        if (tag != null) {
                            PsiFile containingFile = parentElement.getContainingFile();
                            while (tag != null) {
                                rootTag = (XmlBackedJSClassProvider[])Extensions.getExtensions((ExtensionPointName)XmlBackedJSClassProvider.EP_NAME);
                                int n = rootTag.length;
                                for (int i = 0; i < n; ++i) {
                                    XmlBackedJSClassProvider provider = rootTag[i];
                                    if (!provider.canCreateClassFromTag(tag)) continue;
                                    XmlBackedJSClass clazz = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(tag);
                                    if (!clazz.processOuterDeclarations(processor)) {
                                        return;
                                    }
                                    clazz.processDeclarations(processor, ResolveState.initial(), (PsiElement)clazz, place);
                                    return;
                                }
                                tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class);
                            }
                            parentElement = containingFile;
                        } else {
                            FileViewProvider provider;
                            PsiElement topResonableParent = PsiTreeUtil.getParentOfType((PsiElement)parentElement, (Class[])new Class[]{PsiFile.class, JSExecutionScope.class});
                            if (topResonableParent instanceof PsiFile && (provider = ((PsiFile)topResonableParent).getViewProvider()) instanceof MultiplePsiFilesPerDocumentFileViewProvider && topResonableParent == provider.getPsi(provider.getBaseLanguage())) {
                                return;
                            }
                        }
                    } else {
                        parentElement = JSResolveUtil.getContext(elt);
                    }
                } else if (parentElement != null) {
                    parentElement = parentElement.getContainingFile();
                }
                if (!(elt instanceof JSExpressionCodeFragment) && parentElement == null) {
                    return;
                }
            }
            if (finish) {
                return;
            }
            lastParent = elt;
            elt = parentElement;
        }
        return;
    }

    public static boolean processImplicitVars(PsiScopeProcessor processor, PsiFile containingFile, ImplicitVariableProvider cachedPredefinedVars, Key<CachedValue<List<JSVariable>>> cachedPredefinedVarsKey) {
        for (JSVariable var : (List)((CachedValue)cachedPredefinedVars.get(cachedPredefinedVarsKey, (UserDataHolder)((XmlFile)containingFile), null)).getValue()) {
            if (processor.execute((PsiElement)var, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    public static boolean processAllGlobalsInXmlFile(PsiScopeProcessor processor, XmlFile xmlFile, PsiElement place) {
        XmlBackedJSClass clazz = XmlBackedJSClassFactory.getXmlBackedClass(xmlFile);
        return clazz == null || clazz.processDeclarations(processor, ResolveState.initial(), (PsiElement)clazz, place);
    }

    public static void tryProcessXmlFileImplicitElements(@NotNull PsiElement context, @NotNull WalkUpResolveProcessor processor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "tryProcessXmlFileImplicitElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "tryProcessXmlFileImplicitElements"));
        }
        PsiFile file = context.getContainingFile();
        XmlFile xmlFile = null;
        if (file instanceof XmlFile) {
            xmlFile = (XmlFile)file;
        } else {
            PsiFile outerFile;
            PsiElement fileContext = file.getContext();
            if (fileContext != null && (outerFile = fileContext.getContainingFile()) instanceof XmlFile) {
                xmlFile = (XmlFile)outerFile;
            }
        }
        if (xmlFile == null) {
            return;
        }
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        if (virtualFile != null && JSImplicitElementsIndex.Holder.containFileType(virtualFile.getFileType())) {
            return;
        }
        Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> elements = JSIndexContent.get((PsiFile)xmlFile).getImplicitElements();
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies = elements.get(processor.getRequiredName());
        if (proxies != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                processor.doQualifiedCheck((JSPsiElementBase)new JSOffsetBasedImplicitElement(proxy.getBuilder(), proxy.getOffset(), (PsiFile)xmlFile));
            }
        }
    }

    public static void tryProcessAllElementsInInjectedContext(@NotNull PsiFile file, final @NotNull Processor<JSPsiElementBase> processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "tryProcessAllElementsInInjectedContext"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "tryProcessAllElementsInInjectedContext"));
        }
        if (!(file instanceof JSFile) || InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file) == null) {
            return;
        }
        new JSRecursiveWalkingElementVisitor(){

            public void visitJSElement(JSElement node) {
                Collection elements;
                JSElementIndexingData data;
                if (node instanceof JSFunctionExpression) {
                    return;
                }
                if (node instanceof JSPsiElementBase) {
                    processor.process((Object)((JSPsiElementBase)node));
                }
                if (node instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)node).getIndexingData()) != null && (elements = data.getImplicitElements()) != null) {
                    for (JSImplicitElement implicitElement : elements) {
                        processor.process((Object)implicitElement);
                    }
                }
                super.visitJSElement(node);
            }
        }.visitJSElement((JSElement)((JSFile)file));
    }

    private static PsiElement[] getChildren(final PsiElement element) {
        if (!(element instanceof JSFile || element instanceof JSBlockStatement && element.getParent() instanceof JSNamedElement)) {
            return null;
        }
        CachedValue value = (CachedValue)element.getUserData(ourFileElementsValueKey);
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != containingFile.getOriginalFile() && containingFile.getContext() != null) {
            value = null;
        }
        if (value == null) {
            value = CachedValuesManager.getManager((Project)element.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiElement[]>(){

                public CachedValueProvider.Result<PsiElement[]> compute() {
                    return new CachedValueProvider.Result((Object)element.getChildren(), new Object[]{element});
                }
            }, false);
            element.putUserData(ourFileElementsValueKey, (Object)value);
        }
        return (PsiElement[])value.getValue();
    }

    private static boolean processFunctionDeclarations(@NotNull PsiScopeProcessor processor, @Nullable PsiElement context) {
        PsiElement cur;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "processFunctionDeclarations"));
        }
        if (!(context instanceof JSElement)) {
            return true;
        }
        PsiElement[] children = JSResolveUtil.getChildren(context);
        if (children == null) {
            return true;
        }
        int index = children.length - 1;
        PsiElement psiElement = cur = index >= 0 ? children[index] : null;
        while (cur != null) {
            if ((cur instanceof JSFunction || cur instanceof JSClass) && !processor.execute(cur, ResolveState.initial())) {
                return false;
            }
            if (index != 0) {
                cur = children[--index];
                continue;
            }
            cur = null;
        }
        return true;
    }

    public static boolean isReferenceTo(PsiPolyVariantReference reference, String referencedName, PsiElement _element) {
        String elementName;
        boolean processingSourceRefFromLibrary = false;
        if (_element instanceof JSImplicitElement) {
            elementName = ((JSImplicitElement)_element).getName();
        } else if (_element instanceof JSNamedElement) {
            ProjectFileIndex index;
            elementName = ((PsiNamedElement)_element).getName();
            PsiFile containingFile = _element.getContainingFile();
            if (containingFile != null && containingFile.getVirtualFile() != null && (index = ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex()).isInLibrarySource(containingFile.getVirtualFile())) {
                processingSourceRefFromLibrary = true;
            }
        } else if (_element instanceof XmlAttributeValue) {
            elementName = ((XmlAttributeValue)_element).getValue();
        } else if (_element instanceof PsiFile) {
            VirtualFile file = ((PsiFile)_element).getVirtualFile();
            elementName = file != null ? file.getNameWithoutExtension() : null;
        } else if (_element instanceof PsiDirectoryContainer) {
            elementName = ((PsiNamedElement)_element).getName();
        } else if (_element instanceof JSNamedElementBase) {
            elementName = ((JSNamedElementBase)_element).getName();
        } else if (_element instanceof PsiNamedElement && "JAVA".equals(_element.getLanguage().getID()) && DialectDetector.getLanguageDialect(reference.getElement()) == JavaScriptSupportLoader.NASHORN_JS) {
            elementName = ((PsiNamedElement)_element).getName();
        } else {
            return false;
        }
        if (Comparing.equal((String)referencedName, (String)elementName, (boolean)true)) {
            ProjectFileIndex resolveResults = reference.multiResolve(true);
            if (_element instanceof JSImplicitElement) {
                for (ProjectFileIndex resolveResult : resolveResults) {
                    PsiElement resolved = resolveResult.getElement();
                    if (!_element.isEquivalentTo(resolved)) continue;
                    return true;
                }
                return false;
            }
            boolean skipDynamicResults = false;
            boolean skipAnyResults = false;
            boolean skipDynamicResultsCalculated = false;
            for (ProjectFileIndex r : resolveResults) {
                PsiElement resolvedElement;
                if ((!skipDynamicResultsCalculated || skipDynamicResults || skipAnyResults) && reference instanceof JSReferenceExpression) {
                    if (!skipDynamicResultsCalculated) {
                        PsiFile containingFile = reference.getElement().getContainingFile();
                        if (containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
                            JSAttributeList attributeList;
                            JSExpression qualifier = ((JSReferenceExpressionImpl)reference).getResolveQualifier();
                            JSClass jsClass = null;
                            if (qualifier != null) {
                                String expressionType = JSResolveUtil.getQualifiedExpressionType(qualifier, containingFile);
                                if ("*".equals(expressionType)) {
                                    skipAnyResults = true;
                                } else if (expressionType != null) {
                                    PsiElement qName;
                                    PsiElement psiElement = qName = expressionType != null ? JSResolveUtil.unwrapProxy(JSClassResolver.findClassFromNamespace(expressionType, (PsiElement)containingFile)) : null;
                                    if (qName instanceof JSClass) {
                                        jsClass = (JSClass)qName;
                                    }
                                }
                            } else {
                                jsClass = JSResolveUtil.getClassOfContext(reference.getElement());
                            }
                            if (jsClass != null && (attributeList = jsClass.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
                                skipDynamicResults = true;
                            }
                        }
                        skipDynamicResultsCalculated = true;
                    }
                    if (!r.isValidResult() && skipDynamicResults || skipAnyResults) continue;
                }
                if ((resolvedElement = r.getElement()) instanceof JSOffsetBasedImplicitElement) {
                    resolvedElement = ((JSOffsetBasedImplicitElement)resolvedElement).getElementAtOffset();
                }
                if (resolvedElement == null) continue;
                if (processingSourceRefFromLibrary) {
                    resolvedElement = resolvedElement.getNavigationElement();
                }
                if (resolvedElement.isEquivalentTo(_element) || _element.isEquivalentTo(resolvedElement) || (_element instanceof JSProperty || _element instanceof XmlAttributeValue) && resolvedElement.getParent() == _element) {
                    return true;
                }
                if (resolvedElement instanceof JSFunctionExpression) {
                    ASTNode treeParent;
                    ASTNode nameIdentifier = ((JSFunctionExpression)resolvedElement).findNameIdentifier();
                    if (nameIdentifier != null && ((treeParent = nameIdentifier.getTreeParent()).getPsi() == _element || treeParent.getTreeParent().getPsi() == _element)) {
                        return true;
                    }
                } else if (resolvedElement instanceof JSFunction) {
                    if (_element instanceof JSClass && ((JSFunction)resolvedElement).isConstructor() && _element.isEquivalentTo(JSResolveUtil.findParent(resolvedElement)) && reference instanceof PsiElement && !JSResolveUtil.isSelfReference((PsiElement)reference)) {
                        return true;
                    }
                    if (_element instanceof JSFunction) {
                        PsiElement resolvedElementParent = JSResolveUtil.findParent(resolvedElement);
                        PsiElement elementParent = JSResolveUtil.findParent(_element);
                        if (elementParent instanceof JSClass && resolvedElementParent instanceof JSClass && !JSResolveUtil.isSelfReference(reference.getElement())) {
                            final JSClass anotherClass = (JSClass)elementParent;
                            final Ref topOverriddenMethod = new Ref((Object)((JSFunction)resolvedElement));
                            final Ref success = new Ref();
                            JSInheritanceUtil.iterateOverriddenMethodsUp((JSFunction)topOverriddenMethod.get(), new Processor<JSFunction>(){

                                public boolean process(JSFunction function) {
                                    if (function.getParent().isEquivalentTo((PsiElement)anotherClass)) {
                                        success.set((Object)true);
                                        return false;
                                    }
                                    topOverriddenMethod.set((Object)function);
                                    JSAttributeList attributeList = function.getAttributeList();
                                    return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE);
                                }
                            });
                            if (!success.isNull()) {
                                return true;
                            }
                            Collection<JSFunction> implemented = JSInheritanceUtil.findImplementedMethods((JSFunction)topOverriddenMethod.get());
                            for (JSFunction jsFunction : implemented) {
                                if (!anotherClass.isEquivalentTo(jsFunction.getParent())) continue;
                                return true;
                            }
                        }
                    }
                }
                if (!(resolvedElement instanceof JSClass) && !(resolvedElement instanceof JSNamespaceDeclaration) && !(resolvedElement instanceof JSFunction) && !(resolvedElement instanceof JSVariable) || (!(_element instanceof XmlFile) || resolvedElement.getParent().getContainingFile() != _element) && (!(_element instanceof JSFile) || reference.getElement().getParent() == resolvedElement || !JSResolveUtil.isPublicEntityReferenceToJSFile(resolvedElement, _element))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean fieldIsImplicitAccessorMethod(JSFunction fun, JSVariable var) {
        JSAttributeList clazzAttributeList;
        if (!fun.isGetProperty() && !fun.isSetProperty()) {
            return false;
        }
        PsiElement funParent = JSResolveUtil.findParent((PsiElement)fun);
        if (!(funParent instanceof JSClass) || !((JSClass)funParent).isInterface()) {
            return false;
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)var);
        if (!(parent instanceof JSClass)) {
            return false;
        }
        JSAttributeList attributeList = var.getAttributeList();
        if (attributeList == null || attributeList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
            return false;
        }
        JSClass clazz = (JSClass)parent;
        if (attributeList.findAttributeByName(BINDABLE_ATTR_NAME) == null && ((clazzAttributeList = clazz.getAttributeList()) == null || clazzAttributeList.findAttributeByName(BINDABLE_ATTR_NAME) == null)) {
            return false;
        }
        for (JSClass c : clazz.getImplementedInterfaces()) {
            if (c != funParent) continue;
            return true;
        }
        return false;
    }

    private static boolean isPublicEntityReferenceToJSFile(PsiElement resolvedElement, PsiElement element) {
        PsiElement parent = resolvedElement.getParent();
        if (parent instanceof JSVarStatement) {
            parent = parent.getParent();
        }
        return parent instanceof JSPackageStatement && parent.getParent() == element;
    }

    @Nullable
    public static JSExpression getRealRefExprQualifier(JSReferenceExpression expr) {
        if (!(expr instanceof JSReferenceExpressionImpl)) {
            return null;
        }
        JSExpression qualifier = ((JSReferenceExpressionImpl)expr).getResolveQualifier();
        if (qualifier != null) {
            return qualifier;
        }
        if (JSResolveUtil.isExprInTypeContext(expr) && !DialectDetector.isTypeScript((PsiElement)expr)) {
            JSImportedElementResolveResult resolved = JSImportHandlingUtil.resolveTypeNameUsingImports(expr);
            if (resolved == null) {
                return expr.getQualifier();
            }
            return JSResolveUtil.getRealRefExprQualifierFromResult(expr, resolved);
        }
        return qualifier;
    }

    @Nullable
    public static JSExpression getRealRefExprQualifierFromResult(JSReferenceExpression expr, JSImportedElementResolveResult resolved) {
        GenericSignature signature = JSResolveUtil.extractGenericSignature(resolved.qualifiedName);
        String typeWithoutSignature = signature != null ? signature.elementType : resolved.qualifiedName;
        return ((JSReferenceExpression)JSChangeUtil.createExpressionFromText(expr.getProject(), typeWithoutSignature).getPsi()).getQualifier();
    }

    public static String findPackageStatementQualifier(PsiElement context) {
        String s;
        if (context instanceof JSClass && (s = ((JSClass)context).getQualifiedName()) != null) {
            int i = s.lastIndexOf(46);
            if (i != -1) {
                return s.substring(0, i);
            }
            return null;
        }
        JSQualifiedNamedElement packageOrModuleStatement = (JSQualifiedNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, TypeScriptModule.class});
        if (packageOrModuleStatement != null) {
            return packageOrModuleStatement.getQualifiedName();
        }
        return null;
    }

    public static boolean isExprInStrictTypeContext(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "isExprInStrictTypeContext"));
        }
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions(JSResolveHelper.EP_NAME)) {
            if (helper.isStrictTypeContext((PsiElement)expr)) continue;
            return false;
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof JSReferenceListMember) {
            parent = parent.getParent();
        }
        if (parent instanceof JSGenericSignature || parent instanceof JSImportStatement || parent instanceof JSReferenceList && !(parent instanceof ES6ReferenceList) || parent instanceof TypeScriptType && !(parent instanceof TypeScriptTypeofType) || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
            return true;
        }
        if (parent instanceof JSFunction && ((JSFunction)parent).getReturnTypeElement() == expr) {
            return true;
        }
        return parent instanceof JSVariable && ((JSVariable)parent).getTypeElement() == expr;
    }

    public static boolean isExprInTypeContext(JSReferenceExpression expr) {
        PsiElement parent = expr.getParent();
        return JSResolveUtil.isExprInStrictTypeContext(expr) || parent instanceof JSNewExpression || parent instanceof JSBinaryExpression && ((JSBinaryExpression)parent).getROperand() == expr && (((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.IS_KEYWORD || ((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.AS_KEYWORD);
    }

    public static boolean isExprInJSTypeContext(JSReferenceExpression expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof JSBinaryExpression) {
            JSExpression otherOperand;
            JSBinaryExpression binaryExpr = (JSBinaryExpression)parent;
            JSExpression lOperand = binaryExpr.getLOperand();
            JSExpression jSExpression = otherOperand = lOperand == expr ? binaryExpr.getROperand() : lOperand;
            if (otherOperand instanceof JSPrefixExpression && ((JSPrefixExpression)otherOperand).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static VirtualFile findPredefinedOrLibraryFile(Project project, String fileName) {
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        VirtualFile vf = libraryManager.findPredefinedLibraryFileByName(fileName);
        if (vf != null) {
            return vf;
        }
        return libraryManager.getMatchingFile(fileName);
    }

    @NotNull
    public static GlobalSearchScope getJavaScriptSymbolsResolveScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getJavaScriptSymbolsResolveScope"));
        }
        GlobalSearchScope allScope = (GlobalSearchScope)project.getUserData(PROJECT_SCOPE_WITH_PREDEFINED_KEY);
        if (allScope == null) {
            allScope = GlobalSearchScope.allScope((Project)project);
            allScope = new AdditionalIndexedRootsScope(allScope, (IndexableFileSet)new AdditionalIndexableFileSet(project, new IndexableSetContributor[]{JS_INDEXED_ROOT_PROVIDER}));
            project.putUserData(PROJECT_SCOPE_WITH_PREDEFINED_KEY, (Object)allScope);
        }
        GlobalSearchScope globalSearchScope = allScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getJavaScriptSymbolsResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getJavaScriptSymbolsResolveScope(Project project, VirtualFile virtualFile) {
        Module module;
        Module module2 = module = virtualFile != null ? ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(virtualFile) : null;
        if (module == null) {
            GlobalSearchScope globalSearchScope = JSResolveUtil.getJavaScriptSymbolsResolveScope(project);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getJavaScriptSymbolsResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope scopeExcludingJsLibs = (GlobalSearchScope)((CachedValue)ourScopeCache.get((UserDataHolder)module, null)).getValue();
        GlobalSearchScope libraryFilesScope = JSResolveUtil.getLibraryFilesScope(project, virtualFile);
        if (libraryFilesScope != null) {
            scopeExcludingJsLibs = scopeExcludingJsLibs.uniteWith(libraryFilesScope);
        }
        GlobalSearchScope globalSearchScope = scopeExcludingJsLibs;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getJavaScriptSymbolsResolveScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public static GlobalSearchScope getLibraryFilesScope(@NotNull Project project, VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getLibraryFilesScope"));
        }
        ScriptingLibraryMappings mappings = (ScriptingLibraryMappings)ServiceManager.getService((Project)project, JSLibraryMappings.class);
        if (mappings != null) {
            return JSElementResolveScopeProvider.getFilesAndDirectoriesScope(project, mappings.getLibraryFilesFor(virtualFile));
        }
        return null;
    }

    @NotNull
    public static JSSymbolNamespace buildNamespaceForQualifier(JSExpression qualifier) {
        List<String> nameIds = null;
        if (qualifier == null) {
            nameIds = JSSymbolUtil.buildNameIndexArray(null);
        } else {
            JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(qualifier);
            if (ns != null && ns.getQualifiedName() != null) {
                JSNamespaceEvaluationResult jSNamespaceEvaluationResult = ns;
                if (jSNamespaceEvaluationResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "buildNamespaceForQualifier"));
                }
                return jSNamespaceEvaluationResult;
            }
            nameIds = Collections.singletonList("");
        }
        JSSymbolNamespaceImpl jSSymbolNamespaceImpl = new JSSymbolNamespaceImpl(JSQualifiedNameImpl.fromComponents(nameIds), JSContext.UNKNOWN, true, true);
        if (jSSymbolNamespaceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "buildNamespaceForQualifier"));
        }
        return jSSymbolNamespaceImpl;
    }

    public static boolean iterateType(JSPsiElementBase node, final PsiElement jsClass, String typeName, final OverrideHandler handler) {
        final String name = node.getName();
        if (name == null) {
            return true;
        }
        if (jsClass instanceof JSClass) {
            return JSResolveUtil.processOverrides((JSClass)jsClass, handler, name, JSResolveUtil.getNamespaceValue(((JSAttributeListOwner)node).getAttributeList()), (PsiElement)node);
        }
        if (node.getJSContext() == JSContext.STATIC) {
            return true;
        }
        final GlobalSearchScope resolveScope = JSResolveUtil.getResolveScope(jsClass);
        final JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement(jsClass).getClassResolver();
        return JSTypeEvaluateManager.iterateTypeHierarchy(jsClass, typeName, new JSTypeEvaluateManager.NamespaceProcessor(){
            final Set<String> visited = new THashSet();

            @Override
            public boolean process(String type, VirtualFile file) {
                String qName = JSTypeUtils.getTypeMatchingNamespace(type);
                if (this.visited.contains(qName)) {
                    return true;
                }
                this.visited.add(qName);
                CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
                GlobalSearchScope scope = jsClass instanceof JSFile ? resolveScope : GlobalSearchScope.fileScope((PsiFile)jsClass.getContainingFile());
                String className = qName + "." + name;
                resolver.processElementsByQNameIncludingImplicit(className, scope, (Processor<JSPsiElementBase>)collectProcessor);
                ArrayList results = ContainerUtil.newArrayListWithCapacity((int)collectProcessor.getResults().size());
                for (JSPsiElementBase result : collectProcessor.getResults()) {
                    if (result.getAccessType() == JSAttributeList.AccessType.PRIVATE || result.getJSContext() == JSContext.STATIC) continue;
                    results.add(result);
                }
                return results.isEmpty() || handler.process(results, jsClass, qName);
            }
        });
    }

    public static String getNamespaceValue(JSAttributeList attributeList) {
        if (attributeList == null) {
            return null;
        }
        String namespace_id = attributeList.getNamespace();
        if (namespace_id == null) {
            return null;
        }
        return attributeList.resolveNamespaceValue();
    }

    public static boolean processOverrides(JSClass clazz, OverrideHandler handler, @NotNull String name, final String namespace, final PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "processOverrides"));
        }
        SinkResolveProcessor<ResolveResultSink> resolveProcessor = new SinkResolveProcessor<ResolveResultSink>(name, context, new ResolveResultSink(context, name)){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$18", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$18", "execute"));
                }
                if (!(element instanceof JSFunction)) {
                    return true;
                }
                if (!JSResolveUtil.isRealOverride((JSFunction)element, namespace, context)) {
                    return true;
                }
                return super.execute(element, state);
            }
        };
        resolveProcessor.setToProcessHierarchy(true);
        resolveProcessor.setLocalResolve(true);
        resolveProcessor.setSkipImplicitDeclarations(true);
        for (JSClass superClazz : clazz.getSuperClasses()) {
            List<PsiElement> unfilteredResults;
            List results;
            PsiElement parent;
            PsiElement element;
            if (superClazz == clazz) break;
            boolean b = superClazz.processDeclarations((PsiScopeProcessor)resolveProcessor, ResolveState.initial(), (PsiElement)superClazz, context);
            if (b || (element = resolveProcessor.getResult()) == null || !((parent = JSResolveUtil.findParent(element)) instanceof JSClass) || handler.process(results = ContainerUtil.collect(((unfilteredResults = resolveProcessor.getResults()) != null ? unfilteredResults : Collections.emptyList()).iterator(), (FilteringIterator.InstanceOf)new FilteringIterator.InstanceOf(JSPsiElementBase.class)), (PsiElement)superClazz, ((JSClass)parent).getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRealOverride(JSFunction fun, String namespace, PsiElement context) {
        JSAttributeList attributeList = fun.getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            if (type == JSAttributeList.AccessType.PRIVATE) {
                return false;
            }
            if (type == JSAttributeList.AccessType.PACKAGE_LOCAL && attributeList.getNamespace() == null && !(fun.getParent() instanceof JSFile)) {
                return JSResolveUtil.isAccessibleFromCurrentPackage((PsiElement)fun, context);
            }
        }
        String elementNs = JSResolveUtil.getNamespaceValue(attributeList);
        return (namespace != null || elementNs == null) && (namespace == null || namespace.equals(elementNs));
    }

    @Nullable
    public static String getQNameToStartHierarchySearch(JSPsiElementBase node) {
        JSQualifiedName namespace;
        if (node instanceof JSFunction && (namespace = node.getNamespace()) != null && !JSSymbolUtil.isConstructorSymbol(node)) {
            if (namespace.getName().equals(PROTOTYPE_FIELD_NAME)) {
                namespace = namespace.getParent();
            }
            return namespace != null ? namespace.getQualifiedName() : null;
        }
        PsiElement parentNode = JSResolveUtil.findParent((PsiElement)node);
        if (parentNode instanceof JSClass) {
            JSAttributeList attributeList;
            if (DialectDetector.isTypeScript(parentNode)) {
                return ((JSClass)parentNode).getQualifiedName();
            }
            JSAttributeList jSAttributeList = attributeList = node instanceof JSAttributeListOwner ? ((JSAttributeListOwner)node).getAttributeList() : null;
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
                return null;
            }
            return ((JSClass)parentNode).getQualifiedName();
        }
        if (node instanceof JSFunctionExpression && parentNode.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            JSType type = JSContextResolver.resolveContext(node.getFirstChild()).getType();
            if (type != null) {
                return JSTypeUtils.getQualifiedNameMatchingType(type, false);
            }
        } else {
            JSType type;
            if (parentNode instanceof JSFile && parentNode.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
                return node.getName();
            }
            if (node instanceof JSDefinitionExpression) {
                JSExpression expression = ((JSDefinitionExpression)node).getExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSExpression expr = JSSymbolUtil.isConstructorSymbol(node) ? expression : ((JSReferenceExpression)expression).getQualifier();
                    JSNamespaceEvaluationResult ns = JSSymbolUtil.evaluateNamespaceLocally(expr);
                    return ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : null;
                }
            } else if (node instanceof JSVariable && (type = JSContextResolver.resolveContext((PsiElement)node).getType()) != null) {
                return JSTypeUtils.getQualifiedNameMatchingType(type, false);
            }
        }
        return null;
    }

    public static boolean isInPlaceWhereTypeCanBeDuringCompletion(PsiElement expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof JSArgumentList || parent instanceof JSVariable && ((JSVariable)parent).getInitializer() == expr) {
            if (expr instanceof JSReferenceExpression) {
                JSExpression qualifier = ((JSReferenceExpression)expr).getQualifier();
                return qualifier == null || qualifier instanceof JSReferenceExpression;
            }
            return true;
        }
        if (parent instanceof JSExpressionStatement) {
            if (expr instanceof JSReferenceExpression) {
                return ((JSReferenceExpression)expr).getQualifier() == null;
            }
            return true;
        }
        return false;
    }

    public static boolean isPlaceWhereNsCanBe(PsiElement parent) {
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSClass || grandParent instanceof JSPackageStatement || grandParent instanceof JSFile && grandParent.getContext() == null;
    }

    @Nullable
    public static String getTypeFromTagNameInMxml(@Nullable PsiElement psiElement) {
        JSClass clazz = JSResolveUtil.getClassFromTagNameInMxml(psiElement);
        return clazz != null ? clazz.getQualifiedName() : null;
    }

    public static JSClass getClassFromTagNameInMxml(PsiElement psiElement) {
        XmlTag tag;
        XmlTag xmlTag = tag = psiElement != null ? (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{XmlTag.class}) : null;
        if (tag != null && (!tag.getNamespacePrefix().isEmpty() || JavaScriptSupportLoader.isFlexMxmFile(tag.getContainingFile()))) {
            XmlElementDescriptor descriptor;
            if ("Script".equals(tag.getLocalName())) {
                tag = ((XmlFile)tag.getContainingFile()).getDocument().getRootTag();
            }
            if ((descriptor = tag.getDescriptor()) != null) {
                PsiElement decl = descriptor.getDeclaration();
                if (decl instanceof JSClass) {
                    return (JSClass)decl;
                }
                if (decl instanceof XmlFile) {
                    return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)decl);
                }
            }
        }
        return null;
    }

    public static boolean processMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor) {
        return JSResolveUtil.processMetaAttributesForClass(jsClass, processor, true);
    }

    public static boolean processMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor, boolean withIncludedFiles) {
        return JSResolveUtil.doProcessMetaAttributesForClass(JSResolveUtil.unwrapProxy(jsClass), processor, null, true, withIncludedFiles);
    }

    private static boolean doProcessMetaAttributesForClass(PsiElement jsClass, MetaDataProcessor processor, PsiElement lastParent, boolean forward, boolean withIncludedFiles) {
        int i;
        PsiElement[] elements;
        if (jsClass instanceof JSClass) {
            PsiElement current;
            int ind;
            if ("Object".equals(((JSClass)jsClass).getQualifiedName())) {
                return true;
            }
            elements = JSResolveUtil.getStubbedChildren(jsClass.getParent());
            for (ind = elements.length - 1; ind >= 0 && elements[ind] != jsClass; --ind) {
            }
            --ind;
            while (ind >= 0 && (current = elements[ind]) instanceof JSIncludeDirective) {
                if (withIncludedFiles && !JSResolveUtil.processIncludeDirective(processor, jsClass, (JSIncludeDirective)current, false)) {
                    return false;
                }
                --ind;
            }
            JSAttributeList attributeList = ((JSClass)jsClass).getAttributeList();
            if (attributeList != null && !JSResolveUtil.processAttributeList(processor, jsClass, attributeList, true, withIncludedFiles)) {
                return false;
            }
        }
        elements = JSResolveUtil.getStubbedChildren(jsClass);
        Ref continuePassElement = new Ref();
        int n = i = forward ? 0 : elements.length - 1;
        while (i < elements.length && i >= 0) {
            PsiElement el = elements[i];
            if (el instanceof JSIncludeDirective) {
                if (withIncludedFiles && !JSResolveUtil.processIncludeDirective(processor, lastParent, (JSIncludeDirective)el, forward)) {
                    return false;
                }
            } else if (el instanceof JSAttributeList) {
                if (!JSResolveUtil.processAttributeList(processor, lastParent, (JSAttributeList)el, forward, withIncludedFiles)) {
                    return false;
                }
            } else {
                JSAttributeList attributeList;
                continuePassElement.set(null);
                if (!processor.handleOtherElement(el, jsClass, (Ref<PsiElement>)continuePassElement)) {
                    return false;
                }
                PsiElement nextEl = (PsiElement)continuePassElement.get();
                if (nextEl instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)nextEl).getAttributeList()) != null && !JSResolveUtil.processAttributeList(processor, nextEl, attributeList, forward, withIncludedFiles)) {
                    return false;
                }
            }
            i += forward ? 1 : -1;
        }
        return true;
    }

    public static boolean processAttributeList(MetaDataProcessor processor, PsiElement el, JSAttributeList attributeList, boolean forward, boolean withIncludedFiles) {
        int i;
        PsiElement[] elements = JSResolveUtil.getStubbedChildren((PsiElement)attributeList);
        int n = i = forward ? 0 : elements.length - 1;
        while (i < elements.length && i >= 0) {
            PsiElement cur = elements[i];
            if (cur instanceof JSIncludeDirective) {
                if (withIncludedFiles && !JSResolveUtil.processIncludeDirective(processor, el, (JSIncludeDirective)cur, forward)) {
                    return false;
                }
            } else if (cur instanceof JSAttribute) {
                if (!processor.process((JSAttribute)cur)) {
                    return false;
                }
            } else if (cur instanceof JSNamedElement) break;
            i += forward ? 1 : -1;
        }
        return processor.handleOtherElement((PsiElement)attributeList, el, null);
    }

    private static boolean processIncludeDirective(MetaDataProcessor processor, PsiElement lastParent, JSIncludeDirective el, boolean forward) {
        PsiFile file = el.resolveFile();
        return !(file instanceof JSFile) || JSResolveUtil.doProcessMetaAttributesForClass((PsiElement)file, processor, lastParent, forward, true);
    }

    @Deprecated
    public static PsiElement unwrapProxy(PsiElement jsClass) {
        return jsClass;
    }

    public static <T extends PsiPolyVariantReference> ResolveResult[] resolve(PsiFile file, T instance, Resolver<T> resolver) {
        if (file == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        Map resultsMap = (Map)((CachedValue)ourCachedResolveCache.get(MY_RESOLVED_CACHED_KEY, (UserDataHolder)file, null)).getValue();
        ResolveResult[] results = (ResolveResult[])resultsMap.get(instance);
        if (results != null) {
            return results;
        }
        results = resolver.doResolve();
        resultsMap.put(instance, results);
        return results;
    }

    public static void clearResolveCaches(PsiFile file) {
        file.putUserData(MY_RESOLVED_CACHED_KEY, null);
    }

    public static boolean processDeclarationsInScope(JSElement _scope, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        JSElement scope = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)_scope);
        if (scope == null) {
            return true;
        }
        String requiredName = null;
        boolean toProcessImplicits = true;
        if (processor instanceof JSResolveProcessorBase) {
            requiredName = ((JSResolveProcessorBase)processor).getName();
        }
        if (processor instanceof ResolveProcessor) {
            ResolveProcessor resolveProcessor = (ResolveProcessor)processor;
            toProcessImplicits = !resolveProcessor.isProcessingFromIndices();
        }
        boolean result = true;
        TIntObjectHashMap defsMap = (TIntObjectHashMap)((CachedValue)ourCachedDefsCache.get(MY_CACHED_STATEMENTS, (UserDataHolder)scope, null)).getValue();
        if (requiredName == null) {
            TIntObjectIterator iterator = defsMap.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                result = JSResolveUtil.dispatchResolve(processor, state, place, result, iterator.value());
            }
        } else {
            Object defs = defsMap.get(requiredName.hashCode());
            if (defs != null) {
                result = JSResolveUtil.dispatchResolve(processor, state, place, result, defs);
            }
        }
        if (result && toProcessImplicits && scope instanceof JSClassBase) {
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_STARTED, (Object)scope);
            for (JSClass clazz : ((JSClassBase)scope).getImplicitlyDeclaredInterfaces()) {
                result = clazz.processDeclarations(processor, state, lastParent, place);
            }
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_FINISHED, (Object)scope);
        }
        return result;
    }

    private static boolean dispatchResolve(PsiScopeProcessor processor, ResolveState state, PsiElement place, boolean result, Object o) {
        if (o instanceof JSElement[]) {
            for (JSElement s : (JSElement[])o) {
                result &= s.processDeclarations(processor, state, null, place);
            }
        } else {
            JSElement s = (JSElement)o;
            result &= s.processDeclarations(processor, state, null, place);
        }
        return result;
    }

    @NotNull
    public static Collection<JSElement> findNamedElementsInScope(@NotNull String name, @NotNull JSElement _scope) {
        TIntObjectHashMap defsMap;
        Object defs;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findNamedElementsInScope"));
        }
        if (_scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_scope", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findNamedElementsInScope"));
        }
        JSElement scope = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)_scope);
        if (scope == null) {
            scope = _scope;
        }
        if ((defs = (defsMap = (TIntObjectHashMap)((CachedValue)ourCachedDefsCache.get(MY_CACHED_STATEMENTS, (UserDataHolder)scope, null)).getValue()).get(name.hashCode())) instanceof JSElement) {
            Set<JSElement> set = Collections.singleton((JSElement)defs);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findNamedElementsInScope"));
            }
            return set;
        }
        if (defs instanceof JSElement[]) {
            List<JSElement> list = Arrays.asList((JSElement[])defs);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findNamedElementsInScope"));
            }
            return list;
        }
        List<JSElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findNamedElementsInScope"));
        }
        return list;
    }

    @Nullable
    public static PsiElement getLocalVariableRef(@Nullable JSFunction function, JSReferenceExpression expr) {
        return expr.getQualifier() == null ? JSResolveUtil.getLocalVariableRef(function, expr.getReferenceName()) : null;
    }

    @Nullable
    public static PsiElement getLocalVariableRef(@Nullable JSFunction function, @Nullable String referencedName) {
        if (referencedName != null) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(referencedName, true, new ResolveResultSink(null, referencedName));
            while (function != null) {
                boolean val = function.processDeclarations(processor, ResolveState.initial(), (PsiElement)function.getParameterList(), (PsiElement)function);
                if (!val) {
                    return processor.getResult();
                }
                if ((function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class)) != null) continue;
                break;
            }
        }
        return null;
    }

    public static JSSourceElement[] getSourceElements(PsiElement owner) {
        if (owner instanceof JSStubElementImpl) {
            return (JSSourceElement[])((JSStubElementImpl)owner).getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, (PsiElement[])JSSourceElement.EMPTY_ARRAY);
        }
        if (owner instanceof JSFile) {
            return ((JSFile)owner).getStatements();
        }
        return JSSourceElement.EMPTY_ARRAY;
    }

    public static PsiElement[] getStubbedChildren(PsiElement owner) {
        return JSResolveUtil.getStubbedChildren(owner, JSExtendedLanguagesTokenSetProvider.OUR_STUBBED_FILTER);
    }

    public static PsiElement[] getStubbedChildren(PsiElement owner, TokenSet filter) {
        if (owner instanceof JSStubElementImpl) {
            JSStubElementImpl element = (JSStubElementImpl)owner;
            StubElement stub = element.getStub();
            if (stub != null) {
                return stub.getChildrenByType(filter, PsiElement.EMPTY_ARRAY);
            }
            return JSResolveUtil.getChildrenFromTokenSet(element.getNode(), filter);
        }
        if (owner instanceof JSFile) {
            JSFile file = (JSFile)owner;
            StubElement stub = ((JSFileImpl)file).getStub();
            if (stub != null) {
                return stub.getChildrenByType(filter, PsiElement.EMPTY_ARRAY);
            }
            return JSResolveUtil.getChildrenFromTokenSet((ASTNode)file.getNode(), filter);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement[] getChildrenFromTokenSet(ASTNode astNode, TokenSet filter) {
        ASTNode[] astNodes = astNode.getChildren(filter);
        PsiElement[] result = new PsiElement[astNodes.length];
        for (int i = 0; i < astNodes.length; ++i) {
            result[i] = astNodes[i].getPsi();
        }
        return result;
    }

    @Nullable
    public static PsiElement findReferencedModuleIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findReferencedModuleIfRequireCall"));
        }
        return (PsiElement)ContainerUtil.getFirstItem(JSResolveUtil.findReferencedModulesIfRequireCall(callExpression));
    }

    @NotNull
    public static Collection<PsiElement> findReferencedModulesIfRequireCall(@NotNull JSCallExpression callExpression) {
        JSExpression[] arguments;
        JSReferenceExpression methodNameReferenced;
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findReferencedModulesIfRequireCall"));
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName(methodNameReferenced = (JSReferenceExpression)methodExpression, "require") && (arguments = callExpression.getArguments()).length > 0 && arguments[0] instanceof JSLiteralExpression) {
            PsiElement resolve;
            PsiReference[] references = arguments[arguments.length - 1].getReferences();
            PsiReference lastCommonJSModule = null;
            for (PsiReference reference : references) {
                if (reference instanceof JSTextReference.JSDeclarationModuleReference) {
                    Collection<PsiElement> results = JSResolveUtil.getResultsForDeclarationModuleReference(reference);
                    if (results == null) continue;
                    Collection<PsiElement> collection = results;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findReferencedModulesIfRequireCall"));
                    }
                    return collection;
                }
                lastCommonJSModule = reference;
            }
            if (lastCommonJSModule != null && ((resolve = lastCommonJSModule.resolve()) instanceof JSFile || resolve instanceof JsonFile)) {
                List list = ContainerUtil.createMaybeSingletonList((Object)resolve);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findReferencedModulesIfRequireCall"));
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "findReferencedModulesIfRequireCall"));
        }
        return list;
    }

    @Nullable
    public static Collection<PsiElement> getResultsForDeclarationModuleReference(PsiReference reference) {
        Collection<Object> elements = reference instanceof PsiPolyVariantReference ? JSResolveResult.toElements(((PsiPolyVariantReference)reference).multiResolve(false)) : ContainerUtil.createMaybeSingletonList((Object)reference.resolve());
        ArrayList results = ContainerUtil.newArrayList();
        for (PsiElement psiElement : elements) {
            if (!TypeScriptPsiUtil.isTopLevelContainer(psiElement)) continue;
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(psiElement);
            results.add(assignment != null ? assignment : psiElement);
        }
        if (results.size() > 0) {
            return results;
        }
        return null;
    }

    @NotNull
    public static PsiElement getExportedElement(@NotNull JSFile file) {
        Collection<JSPsiElementBase> elements;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getExportedElement"));
        }
        String qName = "module.exports";
        JSType innerType = file.getExportsInnerAlias();
        if (innerType instanceof JSNamedType && ((JSNamedType)innerType).isStaticOrInstance() == JSContext.STATIC) {
            qName = JSTypeUtils.getQualifiedNameMatchingType(innerType, false);
        }
        if (qName != null && (elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, GlobalSearchScope.fileScope((PsiFile)file))).size() == 1) {
            PsiElement psiElement = (PsiElement)elements.iterator().next();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getExportedElement"));
            }
            return psiElement;
        }
        JSFile jSFile = file;
        if (jSFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getExportedElement"));
        }
        return jSFile;
    }

    public static boolean isEventListenerCall(JSCallExpression e) {
        String methodName;
        JSExpression methodExpression = e.getMethodExpression();
        return methodExpression instanceof JSReferenceExpression && ("addEventListener".equals(methodName = ((JSReferenceExpression)methodExpression).getReferenceName()) || "removeEventListener".equals(methodName));
    }

    @NotNull
    public static Collection<PsiElement> getResolvedElements(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getResolvedElements"));
        }
        if (ref instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)ref).multiResolve(false);
            SmartList elements = new SmartList();
            for (ResolveResult result : results) {
                if (!result.isValidResult()) continue;
                elements.add((Object)result.getElement());
            }
            SmartList smartList = elements;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getResolvedElements"));
            }
            return smartList;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)ref.resolve());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil", "getResolvedElements"));
        }
        return list;
    }

    public static abstract class MyNamespaceProcessor
    implements JSTypeEvaluateManager.NamespaceProcessor {
        private final Set<JSPsiElementBase> myFunctions;
        private final LinkedList<String> myDescendants = new LinkedList();
        private final Set<String> myProcessed = new THashSet();
        protected JSPsiElementBase function;
        private final boolean myFindAll;

        public MyNamespaceProcessor(Set<JSPsiElementBase> functions, boolean findAll) {
            this.myFunctions = functions;
            this.myFindAll = findAll;
        }

        @Override
        public boolean process(String serializedType, VirtualFile file) {
            JSType type = JSTypeUtils.createType(serializedType, JSTypeSource.EMPTY);
            if (type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC) {
                return true;
            }
            String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
            JSPsiElementBase context = this.myFunctions.iterator().next();
            if (!this.myFindAll && this.myProcessed.contains(qName)) {
                return true;
            }
            if (this.myProcessed.add(qName)) {
                this.myDescendants.add(qName);
            }
            Collection<JSPsiElementBase> elements = null;
            GlobalSearchScope scope = GlobalSearchScope.fileScope((Project)context.getProject(), (VirtualFile)file);
            boolean result = false;
            Iterator<JSPsiElementBase> functionIterator = this.myFunctions.iterator();
            while (functionIterator.hasNext()) {
                Collection<JSPsiElementBase> elementsToProcess;
                this.function = functionIterator.next();
                if (JSSymbolUtil.isConstructorSymbol(this.function)) {
                    if (elements == null) {
                        elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, scope);
                    }
                    elementsToProcess = elements;
                } else {
                    String descendantName = this.function.getName();
                    elementsToProcess = new ArrayList<JSPsiElementBase>();
                    if (descendantName != null) {
                        String memberName = qName + "." + descendantName;
                        Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(memberName, scope);
                        elementsToProcess.addAll(members);
                    }
                }
                boolean skipImplicitElements = false;
                for (JSPsiElementBase elementToProcess : elementsToProcess) {
                    if (elementToProcess instanceof JSImplicitElement) continue;
                    skipImplicitElements = true;
                    break;
                }
                boolean b = true;
                for (JSPsiElementBase elementToProcess : elementsToProcess) {
                    if (skipImplicitElements && elementToProcess instanceof JSImplicitElement) continue;
                    b &= this.doProcess((PsiElement)elementToProcess);
                }
                if (!b) {
                    functionIterator.remove();
                }
                result |= b;
            }
            return result;
        }

        protected abstract boolean doProcess(PsiElement var1);

        public void processDescendantsOf(String qName, PsiElement context) {
            ProgressManager.checkCanceled();
            boolean b = JSTypeEvaluateManager.iterateSubclasses(context, qName, this);
            while (b && !this.myDescendants.isEmpty()) {
                ProgressManager.checkCanceled();
                b = JSTypeEvaluateManager.iterateSubclasses(context, this.myDescendants.removeFirst(), this);
            }
        }
    }

    private static class NonJsonScope
    extends ProjectAndLibrariesScope {
        public NonJsonScope(Project project) {
            super(project);
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$NonJsonScope", "contains"));
            }
            return file.getFileType() != JsonFileType.INSTANCE && super.contains(file);
        }

        public boolean isSearchOutsideRootModel() {
            return true;
        }
    }

    public static class VisitAllTypesProcessor
    extends ResolveProcessor {
        private final Processor<JSClass> myProcessor;
        private final boolean myVisitInterfaces;

        public VisitAllTypesProcessor(Processor<JSClass> processor, boolean visitInterfaces) {
            super((String)null);
            this.myProcessor = processor;
            this.setLocalResolve(true);
            this.setTypeContext(true);
            this.setToProcessHierarchy(true);
            this.setToProcessMembers(false);
            this.myVisitInterfaces = visitInterfaces;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$VisitAllTypesProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$VisitAllTypesProcessor", "execute"));
            }
            if (element instanceof JSClass) {
                JSClass clazz = (JSClass)element;
                if (!this.myProcessor.process((Object)clazz)) {
                    return false;
                }
                if (this.myVisitInterfaces) {
                    for (JSClass im : clazz.getImplementedInterfaces()) {
                        if (im.processDeclarations((PsiScopeProcessor)this, state, (PsiElement)im, (PsiElement)im)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }

    public static abstract class CollectMethodsToImplementProcessor
    extends ResolveProcessor {
        private final String myName;
        private final boolean myAllMethods;

        public CollectMethodsToImplementProcessor(String name, PsiElement context, boolean allMethods) {
            super(null, context);
            this.myName = name;
            this.myAllMethods = allMethods;
            this.setToSkipClassDeclarationsOnce(true);
            this.setToProcessHierarchy(true);
            this.setToProcessMembers(false);
            this.setTypeContext(true);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$CollectMethodsToImplementProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$CollectMethodsToImplementProcessor", "execute"));
            }
            if (!(element instanceof JSClass)) {
                return true;
            }
            ResultSink sink = this.createResultSink();
            if (sink == null) {
                return false;
            }
            SinkResolveProcessor<ResultSink> processor = new SinkResolveProcessor<ResultSink>(sink){
                {
                    super(sink);
                    this.setToProcessHierarchy(true);
                    this.setSkipImplicitDeclarations(true);
                }

                @Override
                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$CollectMethodsToImplementProcessor$1", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$CollectMethodsToImplementProcessor$1", "execute"));
                    }
                    if (element instanceof JSFunction) {
                        if ("Object".equals(((JSClass)JSResolveUtil.findParent(element)).getQualifiedName()) || ((JSFunction)element).isConstructor()) {
                            return true;
                        }
                    } else {
                        if (element instanceof TypeScriptPropertySignature) {
                            JSTypeDeclaration type = ((TypeScriptPropertySignature)element).getTypeDeclaration();
                            return !(type instanceof JSFunction) || super.execute((PsiElement)type, state);
                        }
                        return true;
                    }
                    return super.execute(element, state);
                }
            };
            List implicitlyImplemented = element instanceof JSClassBase ? ((JSClassBase)element).getImplicitlyDeclaredInterfaces() : Collections.emptyList();
            for (JSClass implementedInterface : ((JSClass)element).getImplementedInterfaces()) {
                boolean b;
                if (!implementedInterface.isInterface() || implicitlyImplemented.contains(implementedInterface) || (b = implementedInterface.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)implementedInterface, (PsiElement)implementedInterface))) continue;
                this.process(processor);
                if (!this.myAllMethods) break;
            }
            if (this.myName == null && processor.getResults() != null) {
                this.process(processor);
            }
            return false;
        }

        protected abstract boolean process(SinkResolveProcessor<?> var1);

        protected ResultSink createResultSink() {
            return this.myName != null ? new ResolveResultSink(this.place, this.myName) : null;
        }
    }

    public static interface MetaDataProcessor {
        public boolean process(@NotNull JSAttribute var1);

        public boolean handleOtherElement(PsiElement var1, PsiElement var2, @Nullable Ref<PsiElement> var3);
    }

    public static interface OverrideHandler {
        public boolean process(@NotNull List<JSPsiElementBase> var1, PsiElement var2, String var3);
    }

    public static class RelevantDefsUserDataCache
    extends UserDataCache<CachedValue<TIntObjectHashMap<Object>>, JSElement, Object> {
        protected CachedValue<TIntObjectHashMap<Object>> compute(final JSElement jsElement, Object o) {
            return CachedValuesManager.getManager((Project)jsElement.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<TIntObjectHashMap<Object>>(){

                public CachedValueProvider.Result<TIntObjectHashMap<Object>> compute() {
                    TIntObjectHashMap relevantDefs = new TIntObjectHashMap();
                    MyJSElementVisitor elementVisitor = new MyJSElementVisitor(jsElement, (TIntObjectHashMap<Object>)relevantDefs);
                    elementVisitor.startVisiting(jsElement);
                    return new CachedValueProvider.Result((Object)relevantDefs, new Object[]{jsElement});
                }
            }, false);
        }

        private static class MyJSElementVisitor
        extends JSRecursiveWalkingElementVisitor {
            private Set<JSFile> visitedIncludes;
            private final TIntObjectHashMap<Object> myRelevantDefs;
            private final JSElement myBase;
            private JSElement context;
            private final boolean isTypeScript;

            public MyJSElementVisitor(JSElement base, TIntObjectHashMap<Object> relevantDefs) {
                this.myRelevantDefs = relevantDefs;
                this.myBase = base;
                this.context = base;
                this.isTypeScript = DialectDetector.isTypeScript((PsiElement)base);
            }

            private void startVisiting(JSElement jsElement) {
                TypeScriptObjectType body;
                PsiElement first = null;
                PsiElement[] arrayElementsToScan = null;
                DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)jsElement);
                if (jsElement instanceof JSFunction) {
                    Object object = body = this.isTypeScript ? JSResolveUtil.getSourceElements((PsiElement)jsElement) : ((JSFunction)jsElement).getBody();
                    if (((JSSourceElement[])body).length > 0 && body[0] instanceof JSBlockStatement) {
                        ASTNode node = body[0].getNode().getFirstChildNode();
                        first = node != null ? node.getPsi() : null;
                    }
                } else if (this.isTypeScript && jsElement instanceof TypeScriptInterface) {
                    body = ((TypeScriptInterface)jsElement).getBody();
                    if (body != null) {
                        arrayElementsToScan = new PsiElement[]{body};
                    }
                } else if (jsElement instanceof JSClass || jsElement instanceof JSPackageStatement || jsElement instanceof TypeScriptModule) {
                    arrayElementsToScan = JSResolveUtil.getSourceElements((PsiElement)jsElement);
                } else if (jsElement instanceof TypeScriptVariable) {
                    PsiElement[] typeElement = ((TypeScriptVariable)jsElement).getTypeElement();
                    if (typeElement instanceof TypeScriptObjectType) {
                        arrayElementsToScan = new PsiElement[]{typeElement};
                    }
                } else if (jsElement instanceof JSVariable) {
                    arrayElementsToScan = PsiElement.EMPTY_ARRAY;
                } else if (jsElement instanceof JSObjectLiteralExpression) {
                    arrayElementsToScan = ((JSObjectLiteralExpression)jsElement).getProperties();
                } else if (jsElement instanceof JSFile && (dialect == DialectOptionHolder.ECMA_4 || dialect != null && dialect.isTypeScript)) {
                    arrayElementsToScan = JSResolveUtil.getSourceElements((PsiElement)jsElement);
                } else if (jsElement instanceof JSVarStatement) {
                    arrayElementsToScan = ((JSVarStatement)jsElement).getVariables();
                } else {
                    first = jsElement.getFirstChild();
                }
                if (arrayElementsToScan != null) {
                    for (PsiElement elt : arrayElementsToScan) {
                        elt.accept((PsiElementVisitor)this);
                    }
                } else {
                    for (PsiElement e = first; e != null; e = e.getNextSibling()) {
                        if (!(e instanceof JSSourceElement) && !(e instanceof JSVariable) && !(e instanceof JSProperty) && !(e instanceof JSDestructuringContainer) && !(e instanceof PsiComment)) continue;
                        e.accept((PsiElementVisitor)this);
                    }
                }
            }

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
            }

            public void visitJSExpressionStatement(JSExpressionStatement node) {
                JSExpression expression = node.getExpression();
                if (expression instanceof JSLiteralExpression && (JSResolveUtil.SINGLE_QUOTED_USE_STRICT.equals(expression.getText()) || JSResolveUtil.QUOTED_USE_STRICT.equals(expression.getText()))) {
                    this.addRelevantDef((JSElement)new ImplicitJSVariableImpl(JSResolveUtil.USE_STRICT, (JSType)null, (PsiElement)node));
                }
                if (expression != null) {
                    this.visitJSExpression(expression);
                }
            }

            public void visitJSVariable(JSVariable node) {
                if (node.hasBlockScope()) {
                    return;
                }
                if (node instanceof ActionScriptVariableImpl && ((ActionScriptVariableImpl)node).hasQualifiedName()) {
                    return;
                }
                this.processUseDirectiveInAttrList((JSAttributeListOwner)node);
                this.addRelevantDef((JSElement)node);
            }

            private void processUseDirectiveInAttrList(JSAttributeListOwner node) {
                JSAttributeList attributeList = node.getAttributeList();
                if (attributeList != null) {
                    PsiElement elt;
                    JSAttributeListStub stub = (JSAttributeListStub)attributeList.getStub();
                    if (stub != null) {
                        StubElement useNamespaceDirectiveInStub = stub.findChildStubByType(JSStubElementTypes.USE_NAMESPACE_DIRECTIVE);
                        elt = useNamespaceDirectiveInStub != null ? useNamespaceDirectiveInStub.getPsi() : null;
                    } else {
                        ASTNode useNs = attributeList.getNode().findChildByType(JSStubElementTypes.USE_NAMESPACE_DIRECTIVE);
                        PsiElement psiElement = elt = useNs != null ? useNs.getPsi() : null;
                    }
                    if (elt != null) {
                        elt.accept((PsiElementVisitor)this);
                    }
                }
            }

            public void visitJSIncludeDirective(JSIncludeDirective includeDirective) {
                PsiFile _file = includeDirective.resolveFile();
                if (!(_file instanceof JSFile) || this.myBase.getContainingFile() == _file) {
                    return;
                }
                JSFile file = (JSFile)_file;
                if (this.visitedIncludes != null && this.visitedIncludes.contains(file)) {
                    return;
                }
                if (this.visitedIncludes == null) {
                    this.visitedIncludes = new THashSet();
                }
                this.visitedIncludes.add(file);
                JSElement prevContext = this.context;
                this.context = file;
                this.context.putUserData(contextKey, (Object)this.myBase);
                this.startVisiting((JSElement)file);
                this.context = prevContext;
            }

            public void visitJSVarStatement(JSVarStatement node) {
                for (JSVariable var : node.getVariables()) {
                    var.accept((PsiElementVisitor)this);
                }
            }

            public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
                JSExpression expression = node.getStubSafeExpression();
                if (expression instanceof JSClassExpression) {
                    this.visitJSClass((JSClass)expression);
                }
            }

            public void visitTypeScriptExportAssignment(TypeScriptExportAssignment exportAssignment) {
            }

            public void visitJSParameter(JSParameter node) {
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
            }

            public void visitJSProperty(JSProperty node) {
                this.addRelevantDef((JSElement)node);
            }

            public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
            }

            public void visitJSClass(JSClass aClass) {
                this.processUseDirectiveInAttrList((JSAttributeListOwner)aClass);
                this.addRelevantDef((JSElement)aClass);
            }

            public void visitJSPackageStatement(JSPackageStatement packageStatement) {
            }

            public void visitTypeScriptModule(TypeScriptModule module) {
                this.addRelevantDef((JSElement)module);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                if (node instanceof ActionScriptFunctionImpl && ((ActionScriptFunctionImpl)node).hasQualifiedName()) {
                    return;
                }
                this.processUseDirectiveInAttrList((JSAttributeListOwner)node);
                this.addRelevantDef((JSElement)node);
                if (this.isTypeScript) {
                    for (JSParameter parameter : node.getParameterVariables()) {
                        if (!TypeScriptPsiUtil.isClassMember(parameter)) continue;
                        this.addRelevantDef((JSElement)parameter);
                    }
                }
            }

            public void visitJSNamespaceDeclaration(JSNamespaceDeclaration namespaceDeclaration) {
                this.addRelevantDef((JSElement)namespaceDeclaration);
            }

            public void visitJSImportStatement(JSImportStatement importStatement) {
            }

            public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
                this.addRelevantDef((JSElement)importStatement);
            }

            public void visitTypeScriptObjectType(TypeScriptObjectType objectType) {
                for (TypeScriptTypeMember member : objectType.getTypeMembers()) {
                    if (!(member instanceof JSNamedElement)) continue;
                    this.addRelevantDef((JSElement)member);
                }
            }

            public void visitJSUseNamespaceDirective(JSUseNamespaceDirective useNamespaceDirective) {
                String namespaceToBeUsed = useNamespaceDirective.getNamespaceToBeUsed();
                if (namespaceToBeUsed != null) {
                    this.addNamedElement((JSElement)useNamespaceDirective, namespaceToBeUsed.hashCode());
                }
            }

            public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
                ES6ImportedBinding[] bindings;
                for (ES6ImportedBinding eS6ImportedBinding : bindings = importDeclaration.getImportedBindings()) {
                    this.addRelevantDef((JSElement)eS6ImportedBinding);
                }
                for (ES6ImportedBinding eS6ImportedBinding : importDeclaration.getImportSpecifiers()) {
                    ES6ImportSpecifierAlias alias = eS6ImportedBinding.getAlias();
                    if (alias != null) {
                        this.addRelevantDef((JSElement)alias);
                        continue;
                    }
                    this.addNamedElement((JSElement)eS6ImportedBinding, eS6ImportedBinding.getReferenceName().hashCode());
                }
            }

            public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
                for (ES6ExportSpecifier specifier : exportDeclaration.getExportSpecifiers()) {
                    ES6ExportSpecifierAlias alias = specifier.getAlias();
                    if (alias != null) {
                        this.addRelevantDef((JSElement)alias);
                        continue;
                    }
                    this.addNamedElement((JSElement)specifier, specifier.getReferenceName().hashCode());
                }
            }

            public void visitComment(PsiComment comment) {
                if (!JSDirectiveCommentUtil.isDirectiveCommentTokenType(comment)) {
                    return;
                }
                String text = comment.getText();
                int bodyStartIndex = JSDirectiveCommentUtil.getGlobalDirectiveBodyStartIndex(text);
                if (bodyStartIndex > 0 && bodyStartIndex <= text.length() - 2) {
                    text = text.substring(bodyStartIndex, text.length() - 2);
                    StringTokenizer t = new StringTokenizer(text, ",");
                    while (t.hasMoreElements()) {
                        String s = t.nextElement();
                        int i = s.indexOf(58);
                        boolean readOnly = true;
                        if (i != -1) {
                            readOnly = !Boolean.parseBoolean(s.substring(i + 1).trim());
                            s = s.substring(0, i);
                        }
                        if (!StringUtil.isJavaIdentifier((String)(s = s.trim()))) continue;
                        EnumSet<JSImplicitElement.Property> properties = EnumSet.of(JSImplicitElement.Property.MinorImportance);
                        if (readOnly) {
                            properties.add(JSImplicitElement.Property.Constant);
                        }
                        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(s, (PsiElement)comment).setProperties(properties).setType(JSImplicitElement.Type.Variable);
                        this.addRelevantDef((JSElement)new JSImplicitElementImpl(builder));
                    }
                }
            }

            private void addRelevantDef(@NotNull JSElement node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$RelevantDefsUserDataCache$MyJSElementVisitor", "addRelevantDef"));
                }
                String name = node.getName();
                if (name != null) {
                    int key = name.hashCode();
                    this.addNamedElement(node, key);
                }
            }

            private void addNamedElement(JSElement node, int key) {
                Object o = this.myRelevantDefs.get(key);
                if (o == null) {
                    this.myRelevantDefs.put(key, (Object)node);
                } else if (o instanceof JSElement) {
                    JSElement[] newO = new JSElement[]{(JSElement)o, node};
                    this.myRelevantDefs.put(key, (Object)newO);
                } else {
                    JSElement[] oldO = (JSElement[])o;
                    JSElement[] newO = new JSElement[oldO.length + 1];
                    System.arraycopy(oldO, 0, newO, 0, oldO.length);
                    newO[oldO.length] = node;
                    this.myRelevantDefs.put(key, (Object)newO);
                }
            }
        }
    }

    public static interface Resolver<T extends PsiPolyVariantReference> {
        public ResolveResult[] doResolve();
    }

    public static interface AllowFileLocalSymbols {
    }

    public static abstract class ImplicitVariableProvider
    extends UserDataCache<CachedValue<List<JSVariable>>, XmlFile, Object> {
        protected CachedValue<List<JSVariable>> compute(final XmlFile xmlFile, Object p) {
            return CachedValuesManager.getManager((Project)xmlFile.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<List<JSVariable>>(){

                public CachedValueProvider.Result<List<JSVariable>> compute() {
                    SmartList vars = new SmartList();
                    this.doComputeVars((List<JSVariable>)vars, xmlFile);
                    return new CachedValueProvider.Result((Object)vars, new Object[]{xmlFile});
                }
            }, false);
        }

        protected abstract void doComputeVars(List<JSVariable> var1, XmlFile var2);
    }

    public static abstract class JSInjectedFilesVisitor
    implements PsiLanguageInjectionHost.InjectedPsiVisitor,
    XmlBackedJSClass.InjectedFileVisitor {
        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
            if (injectedPsi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$JSInjectedFilesVisitor", "visit"));
            }
            if (places == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$JSInjectedFilesVisitor", "visit"));
            }
            if (injectedPsi instanceof JSFile) {
                this.process((JSFile)injectedPsi);
            }
        }

        protected abstract void process(JSFile var1);

        public void visit(XmlTag rootTag, JSFile file) {
            this.process(file);
        }
    }

    public static abstract class StructureResolveProcessor
    extends ResolveProcessor
    implements Processor<PsiNamedElement> {
        private static final ResolveProcessor.ProcessingOptions ourProcessingOptions = new StructureProcessingOptions();

        public StructureResolveProcessor(String name) {
            super(name);
            this.setLocalResolve(true);
            this.setSkipImplicitDeclarations(true);
            this.setProcessingOptions(ourProcessingOptions);
        }

        public boolean process(PsiNamedElement psiNamedElement) {
            PsiFile containingFile;
            PsiElement context;
            boolean b = true;
            if (psiNamedElement instanceof JSElement && (b = psiNamedElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), (PsiElement)psiNamedElement, (PsiElement)psiNamedElement)) && psiNamedElement instanceof JSFile && (context = psiNamedElement.getContext()) != null && (containingFile = context.getContainingFile()) instanceof XmlFile) {
                b = JSResolveUtil.processAllGlobalsInXmlFile(this, (XmlFile)containingFile, context);
            }
            return b;
        }

        public static class StructureProcessingOptions
        extends ResolveProcessor.ProcessingOptions {
            @Override
            public boolean toProcessFunctionArguments() {
                return false;
            }

            @Override
            public boolean toProcessFunctionBodyDeclarations(@Nullable PsiElement lastParent, @NotNull JSFunction fun) {
                if (fun == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$StructureResolveProcessor$StructureProcessingOptions", "toProcessFunctionBodyDeclarations"));
                }
                return lastParent != null;
            }

            @Override
            public boolean toProcessPackageContent(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
                return lastParent != null;
            }
        }
    }

    public static enum GlobalSymbolsAcceptanceState {
        ACCEPT_ONLY_CLASSES,
        ACCEPT_NO_CLASSES,
        ACCEPT_NAMESPACE_DECLARATIONS,
        WHATEVER;

    }

    public static class GenericSignature {
        public final String genericType;
        public final String elementType;
        public static GenericSignature EMPTY = new GenericSignature(null, null);

        public GenericSignature(String _type, String _genericType) {
            this.elementType = _type;
            this.genericType = _genericType;
        }

        public static String build(String typeName, @Nullable GenericSignature genericSignature) {
            if (genericSignature == null) {
                return typeName;
            }
            return typeName + ".<" + genericSignature.genericType + ">";
        }
    }

    static enum AssignableTypeStatus {
        OK,
        LANG_IMPLICIT_COERCION,
        COMPILE_TIME_FAIL;

    }
}

