/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluator {
    protected static final PsiElement EXPLICIT_TYPE_MARKER_ELEMENT = PsiUtilCore.NULL_PSI_ELEMENT;
    private static final ThreadLocal<JSEvaluateContext> contextHolder = new ThreadLocal();
    public static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE = 20;
    protected final JSEvaluateContext myContext;
    protected final JSTypeProcessor myTypeProcessor;
    private final boolean myEcma;

    public JSTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor, boolean ecma) {
        this.myContext = context;
        this.myTypeProcessor = processor;
        this.myEcma = ecma;
    }

    @Nullable
    public static JSType forceEvaluateType(PsiElement target, JSExpression expr, PsiFile targetFile) {
        BaseJSSymbolProcessor.SimpleTypeProcessor typeProcessor = new BaseJSSymbolProcessor.SimpleTypeProcessor(target);
        JSEvaluateContext context = contextHolder.get();
        if (context != null) {
            context.removeProcessingItem((PsiElement)expr);
            JSTypeEvaluator.evaluateTypes(expr, targetFile, typeProcessor);
            context.addProcessingItem((PsiElement)expr);
        } else {
            JSTypeEvaluator.evaluateTypes(expr, targetFile, typeProcessor);
        }
        return typeProcessor.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluateTypes(JSExpression expr, PsiFile targetFile, JSTypeProcessor typeProcessor) {
        JSEvaluateContext context = contextHolder.get();
        boolean contextHolderInitialized = false;
        if (context == null) {
            context = new JSEvaluateContext(targetFile);
            contextHolder.set(context);
            contextHolderInitialized = true;
        } else {
            if (context.isAlreadyProcessingItem((PsiElement)expr)) {
                if (typeProcessor instanceof QualifiedItemProcessor) {
                    ((QualifiedItemProcessor)typeProcessor).resolved = QualifiedItemProcessor.TypeResolveState.Undefined;
                }
                return;
            }
            context.addProcessingItem((PsiElement)expr);
        }
        try {
            boolean ecma = targetFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
            JSTypeEvaluator typeEvaluator = JSDialectSpecificHandlersFactory.forElement((PsiElement)context.targetFile).newTypeEvaluator(contextHolderInitialized ? context : new JSEvaluateContext(targetFile), typeProcessor, ecma);
            typeEvaluator.evaluateTypes(expr);
        }
        finally {
            if (!contextHolderInitialized) {
                context.removeProcessingItem((PsiElement)expr);
            }
            if (contextHolderInitialized) {
                contextHolder.set(null);
            }
        }
    }

    @Nullable
    public static JSTypeEvaluationResult getExpressionType(final @NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getExpressionType"));
        }
        JSEvaluateContext context = contextHolder.get();
        if (context != null && context.isAlreadyProcessingItem((PsiElement)expression)) {
            return null;
        }
        return (JSTypeEvaluationResult)CachedValuesManager.getCachedValue((PsiElement)expression, (CachedValueProvider)new CachedValueProvider<JSTypeEvaluationResult>(){

            @Nullable
            public CachedValueProvider.Result<JSTypeEvaluationResult> compute() {
                BaseJSSymbolProcessor.SimpleTypeProcessor typeProcessor = new BaseJSSymbolProcessor.SimpleTypeProcessor();
                JSTypeEvaluator.evaluateTypes(expression, expression.getContainingFile(), typeProcessor);
                JSTypeEvaluationResult type = typeProcessor.getResult();
                return CachedValueProvider.Result.create((Object)type, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    private void addTypeEvaluationResultElement(@NotNull JSTypeEvaluationResult.JSTypeEvaluationResultElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeEvaluationResultElement"));
        }
        JSType type = element.getType();
        JSSymbolNamespace namespace = element.getNamespace();
        PsiElement source = element.getSource();
        if (type != null) {
            this.addType(type, source);
        } else if (namespace != null) {
            this.addNamespace((JSNamespace)namespace, source);
        } else {
            assert (source != null);
            this.myTypeProcessor.processResolvedElement(source, element.getEvaluationContext());
        }
    }

    public void addType(@Nullable JSType _type, @Nullable PsiElement source) {
        if (_type == null) {
            return;
        }
        JSTypeEvaluator.applyContextAndProcess(_type, this.myContext, source, this.myTypeProcessor);
    }

    public static void applyContextAndProcess(@NotNull JSType _type, @NotNull JSEvaluateContext context, PsiElement source, @NotNull JSTypeProcessor processor) {
        TypeScriptTypeArgumentList typeArgumentsList;
        JSElement peek;
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcess"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcess"));
        }
        if (_type instanceof JSTypeofTypeImpl) {
            _type = ((JSTypeofTypeImpl)_type).evaluateType();
        }
        if (!context.isJSElementsToApplyEmpty() && (peek = context.peekJSElementToApply()) instanceof TypeScriptNewExpression && (typeArgumentsList = ((TypeScriptNewExpression)peek).getTypeArguments()) != null) {
            Object[] typeArguments = typeArgumentsList.getTypeArguments();
            _type = new JSGenericTypeImpl(_type.getSource(), _type, ContainerUtil.map((Object[])typeArguments, TypeScriptTypeParser.MAP_DECLARATION_TO_TYPE));
        }
        if (CommonJSUtil.isModuleType(_type = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(_type, (JSExpression)context.getProcessedExpression(), null))) {
            JSContext jsContext = _type instanceof JSNamedType ? ((JSNamedType)_type).isStaticOrInstance() : JSContext.UNKNOWN;
            PsiFile scope = _type.getSource().getScope();
            if (scope != null) {
                JSTypeEvaluator.addDefaultExportNamespaces((PsiElement)scope, jsContext, context, processor);
            }
        }
        if (!context.isJSElementsToApplyEmpty()) {
            JSElement pop = context.popJSElementToApply();
            if (pop instanceof JSCallExpression) {
                JSType returnType = JSTypeUtils.tryGetReturnType(_type, (JSCallExpression)pop);
                if (returnType == null && !(pop instanceof JSNewExpression)) {
                    returnType = JSAnyType.get((PsiElement)pop, false);
                }
                if (returnType != null) {
                    JSTypeEvaluator.applyContextAndProcess(returnType, context, source, processor);
                }
            }
            context.pushJSElementToApply(pop);
            return;
        }
        JSType type = context.isTypeGuessed() && _type.getSource().isExplicitlyDeclared() ? JSTypeUtils.copyWithExplicitlyDeclaredRecursive(_type, false) : _type;
        processor.process(type, context, source);
    }

    protected void addType(String type, PsiElement source) {
        PsiElement scope = source;
        if (scope == null) {
            scope = this.myTypeProcessor.getTarget();
        }
        if (scope == null) {
            scope = this.myContext.targetFile;
        }
        this.addType(JSNamedType.createType(type, JSTypeSourceFactory.createTypeSource(scope, false), JSContext.UNKNOWN), source);
    }

    protected void addNamespace(@NotNull JSNamespace namespace, @Nullable PsiElement source) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addNamespace"));
        }
        JSTypeEvaluator.applyContextAndProcessNamespace(namespace, this.myContext, source, this.myTypeProcessor);
    }

    static void applyContextAndProcessNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessNamespace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessNamespace"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "applyContextAndProcessNamespace"));
        }
        if (context.wasPrototypeReferenced()) {
            namespace = JSNamespaceImpl.withContext(namespace, JSContext.INSTANCE);
        }
        JSNewExpression poppedCallExpression = null;
        if (context.peekJSElementToApply() instanceof JSNewExpression) {
            poppedCallExpression = (JSNewExpression)context.popJSElementToApply();
            namespace = JSNamespaceImpl.withContext(namespace, JSContext.INSTANCE);
        }
        if (context.isJSElementsToApplyEmpty()) {
            JSSymbolNamespaceImpl symbolNamespace = new JSSymbolNamespaceImpl(namespace.getQualifiedName(), namespace.getJSContext(), namespace.isExplicitlyDeclared(), false);
            processor.processNamespace(symbolNamespace, context, source);
        }
        if (poppedCallExpression != null) {
            context.pushJSElementToApply((JSElement)poppedCallExpression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateTypes(JSExpression rawqualifier) {
        JSClass jsClass;
        JSPrefixExpression prefixExpression;
        JSType typecast;
        if (rawqualifier != null && (typecast = JSDocumentationUtils.findTypeFromInlineComment((PsiElement)rawqualifier)) != null) {
            this.addType(typecast, null);
            return;
        }
        if (rawqualifier instanceof JSDefinitionExpression) {
            rawqualifier = ((JSDefinitionExpression)rawqualifier).getExpression();
        }
        if (rawqualifier instanceof JSReferenceExpression) {
            if (this.myContext.isAlreadyProcessingItem((PsiElement)rawqualifier)) {
                return;
            }
            if (((JSReferenceExpression)rawqualifier).getQualifier() == null && rawqualifier.getNode().findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true)), (PsiElement)rawqualifier);
                return;
            }
            this.myContext.addProcessingItem((PsiElement)rawqualifier);
            JSReferenceExpression oldQualifier = this.myContext.getProcessedExpression();
            try {
                JSReferenceExpression expression = (JSReferenceExpression)rawqualifier;
                this.myContext.setProcessedExpression(expression);
                this.processRefExpr(expression);
            }
            finally {
                this.myContext.setProcessedExpression(oldQualifier);
                this.myContext.removeProcessingItem((PsiElement)rawqualifier);
            }
        } else if (rawqualifier instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)rawqualifier);
        } else if (rawqualifier instanceof JSCallExpression) {
            JSExpression expressionToEvaluate = this.evaluateCallExpressionTypes((JSCallExpression)rawqualifier);
            if (expressionToEvaluate != rawqualifier) {
                this.myContext.pushJSElementToApply((JSElement)rawqualifier);
                this.evaluateTypes(expressionToEvaluate);
                this.myContext.popJSElementToApply();
            }
        } else if (rawqualifier instanceof JSPrefixExpression) {
            JSType promiseComponentType;
            JSType type;
            prefixExpression = (JSPrefixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            String evaluatedType = null;
            if (JSTokenTypes.EXCL == sign || JSTokenTypes.DELETE_KEYWORD == sign) {
                evaluatedType = "boolean";
            } else if (JSTokenTypes.PLUS == sign || JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.TILDE == sign || JSTokenTypes.MINUSMINUS == sign || JSTokenTypes.MINUS == sign) {
                if (this.myEcma) {
                    type = JSResolveUtil.getExpressionJSType(prefixExpression.getExpression());
                    if (type != null) {
                        evaluatedType = type.getTypeText();
                    }
                } else {
                    evaluatedType = "number";
                }
            } else if (JSTokenTypes.TYPEOF_KEYWORD == sign) {
                evaluatedType = "string";
            } else if (JSTokenTypes.AWAIT_KEYWORD == sign && (type = JSResolveUtil.getExpressionJSType(prefixExpression.getExpression())) != null && (promiseComponentType = JSTypeUtils.getPromiseComponentType(type)) != null) {
                this.addType(promiseComponentType, (PsiElement)rawqualifier);
                return;
            }
            if (evaluatedType != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                JSType type2 = JSNamedType.createType(evaluatedType, source, JSContext.INSTANCE);
                this.addType(type2, (PsiElement)rawqualifier);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
            }
        } else if (rawqualifier instanceof JSPostfixExpression) {
            prefixExpression = (JSPostfixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            if (JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.MINUSMINUS == sign) {
                if (this.myEcma) {
                    this.simpleEvalType(rawqualifier, prefixExpression.getExpression());
                } else {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false);
                    this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
                }
            }
        } else if (rawqualifier instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)rawqualifier;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression rOperand = binaryExpression.getROperand();
            JSExpression lOperand = binaryExpression.getLOperand();
            if (lOperand != null && rOperand != null) {
                if (sign == JSTokenTypes.AS_KEYWORD) {
                    this.resolveAsBinaryOperationExpression(rawqualifier, rOperand);
                } else if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(sign) || JSTokenTypes.EQUALITY_OPERATIONS.contains(sign) || sign == JSTokenTypes.IS_KEYWORD) {
                    this.addType(new JSBooleanType(true, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false), JSTypeContext.INSTANCE), null);
                } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(sign) || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.OROR) {
                    if (sign == JSTokenTypes.DIV || !this.myEcma && (sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.MINUS || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign))) {
                        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false);
                        this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
                    } else {
                        JSType lProcType = JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(lOperand));
                        JSType rProcType = JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(rOperand));
                        if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND) {
                            if (lProcType != null) {
                                this.addType(lProcType, (PsiElement)rawqualifier);
                            }
                            if (rProcType != null) {
                                this.addType(rProcType, (PsiElement)rawqualifier);
                            }
                            if (lProcType == null && rProcType == null) {
                                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                            }
                        } else {
                            JSPrimitiveType evaluatedType = null;
                            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)binaryExpression);
                            if (lProcType instanceof JSStringType || rProcType instanceof JSStringType) {
                                evaluatedType = new JSStringType(true, typeSource, JSTypeContext.INSTANCE);
                            } else if ((lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
                                evaluatedType = new JSIntType(true, typeSource, JSTypeContext.INSTANCE);
                            } else if ((lProcType instanceof JSNumberType || lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSNumberType || rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
                                evaluatedType = new JSNumberType(true, typeSource, JSTypeContext.INSTANCE);
                            }
                            if (evaluatedType != null) {
                                this.addType(evaluatedType, (PsiElement)rawqualifier);
                            } else {
                                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                            }
                        }
                    }
                } else if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(sign)) {
                    JSTypeEvaluationResult result = null;
                    if (this.myEcma) {
                        result = JSTypeEvaluator.getExpressionType(lOperand);
                    }
                    if (result == null) {
                        result = JSTypeEvaluator.getExpressionType(rOperand);
                    }
                    if (result != null) {
                        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : result.getResults()) {
                            this.addTypeEvaluationResultElement(element);
                        }
                    } else {
                        this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                    }
                } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(sign)) {
                    this.simpleEvalType(rawqualifier, lOperand);
                }
            }
        } else if (rawqualifier instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression(rawqualifier);
        } else if (rawqualifier instanceof JSArrayLiteralExpression) {
            JSExpression[] expressions = ((JSArrayLiteralExpression)rawqualifier).getExpressions();
            JSType type = expressions.length > 0 ? this.getArrayTypeFromExpressions(rawqualifier, expressions) : JSNamedType.createType("Array", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
            this.addType(type, (PsiElement)rawqualifier);
            if (this.myTypeProcessor instanceof ResolveProcessor) {
                ((ResolveProcessor)((Object)this.myTypeProcessor)).execute((PsiElement)rawqualifier, ResolveState.initial());
            }
        } else if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            this.evalComponentTypeFromArrayExpression(rawqualifier, ((JSIndexedPropertyAccessExpression)rawqualifier).getQualifier());
        } else if (rawqualifier instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)rawqualifier, this.isFromCurrentFile((PsiElement)rawqualifier));
        } else if (rawqualifier instanceof JSParenthesizedExpression) {
            this.evaluateTypes(((JSParenthesizedExpression)rawqualifier).getInnerExpression());
        } else if (rawqualifier instanceof JSThisExpression) {
            jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier, true);
            if (jsClass != null) {
                String name = jsClass.getQualifiedName();
                if (name != null) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                    JSContext staticOrInstance = JSResolveUtil.calculateStaticFromContext((PsiElement)rawqualifier) ? JSContext.STATIC : JSContext.INSTANCE;
                    this.addType(JSNamedType.createType(name, typeSource, staticOrInstance), (PsiElement)jsClass);
                }
            } else {
                PsiElement thisScope = JSPsiImplUtils.getExecutionScope((PsiElement)rawqualifier);
                JSType type = JSDocumentationUtils.findContextType(thisScope);
                if (type != null) {
                    this.addType(type, null);
                } else {
                    JSType thisType = JSContextResolver.resolveContext((PsiElement)rawqualifier).getType();
                    if (thisType != null) {
                        this.addType(thisType, (PsiElement)rawqualifier);
                    } else if (thisScope instanceof JSFunctionExpression && thisScope.getParent() instanceof JSArgumentList) {
                        JSType funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)thisScope));
                        if ((funcType = JSTypeUtils.getValuableType(funcType)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)funcType).getThisType()) != null) {
                            this.addType(thisType, (PsiElement)rawqualifier);
                        }
                    }
                    if (thisType == null) {
                        this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                    }
                }
            }
        } else if (rawqualifier instanceof JSSuperExpression) {
            jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier);
            this.processSuperQualifierExpression((JSSuperExpression)rawqualifier, jsClass);
        } else if (rawqualifier instanceof JSFunctionExpression) {
            this.processFunction((JSFunction)((JSFunctionExpression)rawqualifier));
        } else if (rawqualifier instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)rawqualifier;
            JSExpression thenPart = conditionalExpression.getThen();
            JSExpression elsePart = conditionalExpression.getElse();
            JSType thenType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, thenPart);
            JSType elseType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, elsePart);
            if (thenType != null || elseType != null) {
                JSType common = null;
                if (elseType == null) {
                    common = thenType;
                }
                if (thenType == null) {
                    common = elseType;
                }
                if (common == null) {
                    common = thenType instanceof JSAnyType ? JSTypeEvaluator.replaceTypeSourceByNotExplicitly((JSExpression)conditionalExpression, elseType) : (elseType instanceof JSAnyType ? JSTypeEvaluator.replaceTypeSourceByNotExplicitly((JSExpression)conditionalExpression, thenType) : JSTypeUtils.getCommonType(thenType, elseType, DialectDetector.dialectOfElement((PsiElement)conditionalExpression)));
                }
                this.addType(common, (PsiElement)conditionalExpression);
            }
        } else if (!this.evaluateDialectSpecificTypes(rawqualifier) && rawqualifier != null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    private void resolveAsBinaryOperationExpression(JSExpression rawqualifier, JSExpression rOperand) {
        PsiElement resolve;
        boolean isClassCast = false;
        if (rOperand instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSVariable && "Class".equals(((JSVariable)resolve).getTypeString())) {
            isClassCast = true;
        }
        if (isClassCast) {
            this.addType("*", (PsiElement)rawqualifier);
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rOperand);
            this.addType(JSTypeUtils.createType(JSImportHandlingUtil.resolveTypeName(rOperand.getText(), (PsiElement)rOperand), source), null);
        }
    }

    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, JSClass jsClass) {
        JSClass[] classes;
        if (jsClass != null && (classes = jsClass.getSuperClasses()).length > 0) {
            JSClass aClass = classes[0];
            this.addType(aClass.getQualifiedName(), (PsiElement)aClass);
        }
    }

    @NotNull
    private static JSType replaceTypeSourceByNotExplicitly(JSExpression conditionalExpression, JSType partType) {
        JSType jSType = JSTypeUtils.copyWithExplicitlyDeclaredRecursive(partType, false);
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "replaceTypeSourceByNotExplicitly"));
        }
        return jSType;
    }

    @Nullable
    private JSType getConditionalPartTypeOrAny(JSExpression conditionalExpression, JSExpression part) {
        JSType partType = null;
        if (part != null && (partType = JSResolveUtil.getExpressionJSType(part)) == null) {
            partType = JSAnyType.get((PsiElement)conditionalExpression, false);
        }
        return partType;
    }

    @NotNull
    private JSType getArrayTypeFromExpressions(JSExpression rawqualifier, JSExpression[] expressions) {
        JSArrayTypeImpl type;
        JSAnyType commonType = null;
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)rawqualifier);
        for (JSExpression expression : expressions) {
            JSType exprType;
            JSType jSType = exprType = expression != null ? JSTypeEvaluator.getTypeFromConstant(expression, this.myEcma) : JSNamedType.createType("null", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
            if (exprType != null && !isTypeScript) {
                exprType = JSTypeUtils.getNonValueType(exprType);
            }
            if (exprType == null && isTypeScript) {
                if (expression instanceof JSObjectLiteralExpression) {
                    exprType = JSTypeEvaluator.getObjectLiteralType((JSObjectLiteralExpression)expression, true);
                }
                if (exprType == null) {
                    exprType = new JSTypeofTypeImpl(expression, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true));
                }
            }
            JSType jSType2 = commonType = commonType != null && exprType != null ? JSTypeUtils.getCommonType(commonType, exprType, DialectDetector.dialectOfElement((PsiElement)rawqualifier)) : exprType;
            if (commonType instanceof JSAnyType) break;
        }
        if (commonType == null) {
            commonType = JSAnyType.get((PsiElement)rawqualifier, false);
        }
        JSArrayTypeImpl jSArrayTypeImpl = type = new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true));
        if (jSArrayTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getArrayTypeFromExpressions"));
        }
        return jSArrayTypeImpl;
    }

    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        return false;
    }

    protected void evaluateNewExpressionTypes(JSNewExpression newExpression) {
        JSExpression methodExpr = newExpression.getMethodExpression();
        this.myContext.pushJSElementToApply((JSElement)newExpression);
        this.evaluateTypes(methodExpr);
        this.myContext.popJSElementToApply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSExpression evaluateCallExpressionTypes(JSCallExpression callExpression) {
        boolean proceedWithReference = true;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            boolean isTypeScript;
            JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
            String referencedName = invoked.getReferenceName();
            DialectOptionHolder dialect = DialectDetector.dialectOfFile(callExpression.getContainingFile());
            boolean bl = isTypeScript = dialect != null && dialect.isTypeScript;
            if ("create".equals(referencedName) && dialect != null && dialect.isJavaScript()) {
                JSExpression[] arguments;
                JSExpression firstArgument;
                JSType type;
                JSFunctionItem functionItem;
                boolean hasExplicitReturnType = false;
                PsiElement resolve = invoked.resolve();
                if (resolve != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)methodExpression)) != null && JSTypeUtils.isStrictType(type = functionItem.getReturnType())) {
                    hasExplicitReturnType = true;
                }
                JSExpression jSExpression = firstArgument = (arguments = callExpression.getArguments()).length > 0 ? arguments[0] : null;
                if (!hasExplicitReturnType && (firstArgument instanceof JSLiteralExpression && ((JSLiteralExpression)firstArgument).isQuotedLiteral() || firstArgument instanceof JSReferenceExpression)) {
                    String typeString;
                    String string = typeString = firstArgument instanceof JSReferenceExpression ? JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)firstArgument))) : StringUtil.unquoteString((String)firstArgument.getText());
                    if (typeString != null) {
                        JSType type2 = JSNamedType.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)firstArgument), JSTypeContext.UNKNOWN);
                        this.addType(type2, (PsiElement)firstArgument);
                    }
                    proceedWithReference = false;
                }
            } else if (!isTypeScript && ("apply".equals(referencedName) || "call".equals(referencedName))) {
                JSExpression qualifier = invoked.getQualifier();
                if (qualifier != null) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = invoked.multiResolve(false)) {
                        String fileName;
                        PsiElement element = result.getElement();
                        if (element == null || !"ECMAScript.js2".equals(fileName = element.getContainingFile().getName()) && !"EcmaScript.js".equals(fileName) && !JavaScriptIndex.LIBS_D_TS.contains(fileName)) continue;
                        methodExpression = qualifier;
                    }
                }
            } else if (!isTypeScript && ("reduce".equals(referencedName) || "reduceRight".equals(referencedName))) {
                JSExpression[] expressions;
                JSExpression qualifier = invoked.getQualifier();
                if (qualifier instanceof JSArrayLiteralExpression && (expressions = ((JSArrayLiteralExpression)qualifier).getExpressions()).length > 0 && expressions[0] != null) {
                    methodExpression = expressions[0];
                }
            } else {
                Collection<PsiElement> modules = JSResolveUtil.findReferencedModulesIfRequireCall(callExpression);
                if (!modules.isEmpty()) {
                    JSReferenceExpression previousProcessedExpression = this.myContext.getProcessedExpression();
                    try {
                        boolean oldIsTypeGuessed = this.myContext.isTypeGuessed();
                        if (isTypeScript) {
                            this.myContext.setTypeIsGuessed(true);
                        }
                        this.myContext.setProcessedExpression(invoked);
                        for (PsiElement module : modules) {
                            this.addModuleFromRequire(module, callExpression);
                        }
                        if (isTypeScript) {
                            this.myContext.setTypeIsGuessed(oldIsTypeGuessed);
                        }
                    }
                    finally {
                        this.myContext.setProcessedExpression(previousProcessedExpression);
                    }
                    return callExpression;
                }
            }
        }
        if (proceedWithReference) {
            return methodExpression;
        }
        return callExpression;
    }

    protected void addModuleFromRequire(PsiElement module, JSCallExpression callExpression) {
        this.addTypeFromExternalModuleReferenceResolveResult(module);
    }

    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return;
        }
        if (resolve instanceof JSFile) {
            this.addTypeFromModuleFile((JSFile)resolve);
        } else if (resolve instanceof JsonFile) {
            this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
        } else {
            this.addTypeFromResolveResult(resolve, false);
        }
    }

    private void addTypeFromModuleFile(@NotNull JSFile jsFile) {
        PsiFile placeFile;
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromModuleFile"));
        }
        this.myTypeProcessor.processResolvedElement((PsiElement)jsFile, this.myContext);
        PsiElement exportedElement = JSResolveUtil.getExportedElement(jsFile);
        JSReferenceExpression place = this.myContext.getProcessedExpression();
        PsiFile psiFile = placeFile = place != null ? place.getContainingFile() : null;
        if (exportedElement == jsFile && jsFile.hasES6Syntax() && placeFile instanceof JSFile && DialectDetector.isJavaScript((PsiElement)placeFile) && !((JSFile)placeFile).hasES6Syntax()) {
            JSElement defaultExport = ES6PsiUtil.findDefaultExport((JSElement)jsFile);
            if (defaultExport instanceof ES6ExportDefaultAssignment) {
                String reference = ((ES6ExportDefaultAssignment)defaultExport).getInitializerReference();
                if (reference != null) {
                    PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(reference, (PsiElement)defaultExport);
                    if (localResolve != null) {
                        exportedElement = localResolve;
                    }
                } else {
                    JSExpression expression = ((ES6ExportDefaultAssignment)defaultExport).getStubSafeExpression();
                    if (expression != null) {
                        exportedElement = expression;
                    }
                }
            } else if (defaultExport != null) {
                exportedElement = defaultExport;
            }
        }
        if (exportedElement != jsFile) {
            this.addTypeFromResolveResult(exportedElement, false);
        }
    }

    public static void addDefaultExportNamespaces(@NotNull PsiElement source, @NotNull JSContext jsContext, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addDefaultExportNamespaces"));
        }
        if (jsContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsContext", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addDefaultExportNamespaces"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addDefaultExportNamespaces"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addDefaultExportNamespaces"));
        }
        JSNamespaceImpl moduleExports = new JSNamespaceImpl(JSQualifiedNameImpl.create("exports", JSQualifiedNameImpl.create("module", null)), jsContext, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(moduleExports, context, source, processor);
        JSNamespaceImpl exports = new JSNamespaceImpl(JSQualifiedNameImpl.create("exports", null), jsContext, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(exports, context, source, processor);
    }

    protected boolean processFunction(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "processFunction"));
        }
        boolean hasSomeType = false;
        boolean inCall = this.myContext.peekJSElementToApply() instanceof JSCallExpression;
        if (function.isGetProperty()) {
            JSType returnType = JSFunctionImpl.getReturnTypeInContext(function, (PsiElement)this.myContext.getProcessedExpression());
            if (returnType != null) {
                this.addType(returnType, null);
            }
            hasSomeType = returnType != null;
        } else if (function.isSetProperty()) {
            JSType parameterType = JSResolveUtil.getTypeFromSetAccessor((JSFunctionItem)function);
            if (parameterType != null) {
                this.addType(parameterType, null);
            }
            hasSomeType = parameterType != null;
        } else if (!inCall) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)function);
            if (source.getLanguage() == JSTypeSource.SourceLanguage.TS) {
                this.addType(TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl(function), (PsiElement)function);
            } else if (this.isFromCurrentFile((PsiElement)function) && JSPsiImplUtils.isArrowFunction(function) != null) {
                JSExpression returned = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function);
                JSFunctionTypeImpl type = new JSFunctionTypeImpl(source, ContainerUtil.emptyList(), JSResolveUtil.getExpressionJSType(returned));
                this.addType(type, (PsiElement)function);
            } else {
                JSType functionType;
                if (source.getLanguage() == JSTypeSource.SourceLanguage.JS) {
                    String name = function.getQualifiedName();
                    JSContext staticOrInstance = this.myContext.wasPrototypeReferenced() ? JSContext.INSTANCE : JSContext.STATIC;
                    functionType = name != null ? JSNamedType.createType(name, source, staticOrInstance) : JSNamedType.createType("Function", source, JSContext.INSTANCE);
                } else {
                    functionType = JSNamedType.createType("Function", source, JSContext.INSTANCE);
                }
                if (this.myContext.wasPrototypeReferenced()) {
                    this.addType(JSNamedType.createType("Object", source, JSContext.INSTANCE), (PsiElement)function);
                }
                this.addType(functionType, (PsiElement)function);
            }
            hasSomeType = true;
        } else {
            JSType s = null;
            JSElement pop = this.myContext.popJSElementToApply();
            assert (pop instanceof JSCallExpression) : "inCall is invalid";
            JSCallExpression callExpression = (JSCallExpression)pop;
            boolean isNewCall = callExpression instanceof JSNewExpression;
            if (isNewCall) {
                PsiElement parentClass;
                if (function.isConstructor() && (parentClass = JSResolveUtil.findParent((PsiElement)function)) instanceof JSClass) {
                    JSClass clazz = (JSClass)parentClass;
                    this.addType(clazz.getQualifiedName(), (PsiElement)clazz);
                    hasSomeType = true;
                } else {
                    String name = JSTypeEvaluator.getElementQName((JSNamedElement)function);
                    if (name != null) {
                        s = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)function), JSTypeContext.INSTANCE);
                    }
                }
            } else {
                s = JSFunctionImpl.getReturnTypeInContext(function, (PsiElement)this.myContext.getProcessedExpression());
                if (!DialectDetector.isTypeScript((PsiElement)function)) {
                    Collection<JSObjectLiteralExpression> objectLiterals = JSStubBasedPsiTreeUtil.findReturnedExpressions(function, JSObjectLiteralExpression.class);
                    for (JSObjectLiteralExpression objectLiteral : objectLiterals) {
                        this.addTypeFromObjectLiteralExpression(objectLiteral, false);
                    }
                    if (!objectLiterals.isEmpty() && (s instanceof JSAnyType || s instanceof JSObjectType)) {
                        s = null;
                    }
                }
            }
            if (s != null) {
                s = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(s, callExpression.getMethodExpression(), (PsiElement)function);
                this.addType(s, null);
                hasSomeType = true;
            }
            this.myContext.pushJSElementToApply((JSElement)callExpression);
        }
        return hasSomeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefExpr(JSReferenceExpression expression) {
        JSNamespaceEvaluationResult ns;
        JSNamespaceEvaluationResult ns2;
        JSExpression exprQualifier;
        boolean prototypeWasReferenced = this.myContext.wasPrototypeReferenced();
        if ("prototype".equals(expression.getReferenceName()) && !DialectDetector.isTypeScript((PsiElement)expression) && (exprQualifier = expression.getQualifier()) instanceof JSReferenceExpression) {
            expression = (JSReferenceExpression)exprQualifier;
            this.myContext.setPrototypeWasReferenced(true);
        }
        boolean unqualified = expression.getQualifier() == null;
        ResolveResult[] resolveResults = this.getResolveResultsFromQualifier(expression);
        boolean hasSomeType = false;
        if (unqualified && (ns2 = this.evaluateNamespaceLocally(expression)) != null) {
            ns2 = ns2.withExplicitlyDeclared(false);
            this.addNamespace(ns2, (PsiElement)expression);
            JSElement exprForClassExtending = ns2.getSource();
            if (exprForClassExtending instanceof JSReferenceExpression) {
                this.addAdditionalTypes((JSReferenceExpression)exprForClassExtending, (JSReferenceExpression)exprForClassExtending);
            }
            hasSomeType = true;
        }
        if (resolveResults.length > 0 && !JSTypeEvaluator.shouldSkipProcessing(resolveResults)) {
            boolean wasGuessed = this.myContext.isTypeGuessed();
            JSReferenceExpression previousProcessedExpression = this.myContext.getProcessedExpression();
            try {
                this.myContext.setTypeIsGuessed(wasGuessed || !this.qualifierTypeIsExplicitlyDeclared(expression.getQualifier()));
                this.myContext.setProcessedExpression(expression);
                for (ResolveResult r : resolveResults) {
                    hasSomeType &= this.addTypeFromResolveResult(r.getElement(), hasSomeType);
                }
            }
            finally {
                this.myContext.setTypeIsGuessed(wasGuessed);
                this.myContext.setProcessedExpression(previousProcessedExpression);
            }
        } else if (!hasSomeType) {
            JSType typeFromReferenceExpression = JSSymbolUtil.createTypeFromReferenceExpression(expression, JSTypeContext.STATIC);
            if (typeFromReferenceExpression != null && this.myContext.peekJSElementToApply() instanceof JSNewExpression) {
                this.addType(typeFromReferenceExpression, (PsiElement)expression);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)expression);
            }
        }
        JSReferenceExpression localQualifier = JSUtils.findRefExprThatStartCallChaining(expression);
        if (!this.myEcma && (ns = JSSymbolUtil.evaluateNamespaceLocally(localQualifier)) != null && ns.getSource() instanceof JSReferenceExpression) {
            localQualifier = (JSReferenceExpression)ns.getSource();
        }
        this.addAdditionalTypes(localQualifier, expression);
        this.myContext.setPrototypeWasReferenced(prototypeWasReferenced);
    }

    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        ResolveResult[] resolveResultArray = qualifier.multiResolve(false);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getResolveResultsFromQualifier"));
        }
        return resolveResultArray;
    }

    @Nullable
    protected JSNamespaceEvaluationResult evaluateNamespaceLocally(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateNamespaceLocally"));
        }
        return this.myEcma || DialectDetector.isTypeScript((PsiElement)expression) ? null : JSSymbolUtil.evaluateNamespaceLocally(expression);
    }

    private static boolean shouldSkipProcessing(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "shouldSkipProcessing"));
        }
        if (resolveResults.length < 20) {
            return false;
        }
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (element instanceof TypeScriptModule || element instanceof TypeScriptInterface || element instanceof TypeScriptClass) continue;
            return true;
        }
        return false;
    }

    protected boolean addTypeFromResolveResult(@NotNull PsiElement resolveResult, boolean hasSomeType) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromResolveResult"));
        }
        this.myContext.setSource(resolveResult);
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            if (!handler.addTypeFromResolveResult(this, resolveResult, hasSomeType)) continue;
            return true;
        }
        if (resolveResult instanceof JSVariable) {
            this.addTypeFromVariableResolveResult((JSVariable)resolveResult);
        } else {
            hasSomeType = this.addTypeFromElementResolveResult(resolveResult, hasSomeType);
        }
        return hasSomeType;
    }

    protected boolean qualifierTypeIsExplicitlyDeclared(@Nullable JSExpression qualifier) {
        return true;
    }

    protected void addTypeFromVariableResolveResult(@NotNull JSVariable jsVariable) {
        boolean haveExplicitType;
        String name;
        if (jsVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsVariable", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromVariableResolveResult"));
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        boolean wasGuessed = this.myContext.isTypeGuessed();
        JSType parameterType = jsVariable.getType();
        if (jsVariable instanceof JSParameter && this.isFromCurrentFile((PsiElement)jsVariable)) {
            if (parameterType == null && this.addTypeFromAmdModuleReference((JSParameter)jsVariable)) {
                return;
            }
            if (parameterType == null) {
                parameterType = JSContextTypeEvaluator.getParameterType((JSParameter)jsVariable);
            }
        }
        if (jsVariable instanceof JSParameter && ((JSParameter)jsVariable).isRest()) {
            JSTypeSource typeSource = parameterType != null ? parameterType.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)jsVariable, ((JSParameter)jsVariable).getTypeDecorator().isExplicitlyDeclared());
            parameterType = new JSArrayTypeImpl(parameterType, typeSource);
        }
        parameterType = this.substituteThisType(parameterType, jsVariable);
        if (expression != null && JSTypeGuardChecker.isAvailable((PsiElement)expression, parameterType) && (name = jsVariable.getName()) != null) {
            parameterType = new JSTypeGuardChecker((PsiElement)expression, parameterType, name).getNarrowedType();
        }
        if (haveExplicitType = this.useVariableType(parameterType)) {
            this.addType(parameterType, EXPLICIT_TYPE_MARKER_ELEMENT);
        }
        if (!haveExplicitType) {
            PsiElement parent = jsVariable.getParent();
            while (parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty) {
                if (parent instanceof JSDestructuringArray || parent instanceof JSDestructuringProperty) {
                    this.myContext.pushJSElementToApply((JSElement)parent);
                }
                parent = parent.getParent();
            }
            JSFunctionExpression functionExpression = jsVariable.tryGetFunctionExpressionInitializer();
            if (functionExpression != null) {
                this.processFunction((JSFunction)functionExpression);
            } else if (this.isFromCurrentFile((PsiElement)jsVariable)) {
                JSExpression initializer;
                JSExpression jSExpression = initializer = jsVariable.hasInitializer() ? jsVariable.getInitializer() : null;
                if (initializer != null) {
                    boolean inCall;
                    boolean bl = inCall = !this.myContext.isJSElementsToApplyEmpty();
                    if (!inCall && initializer instanceof JSLiteralExpression && initializer.getNode().findChildByType(JSTokenTypes.NULL_KEYWORD) != null) {
                        this.addType(JSAnyType.get((PsiElement)initializer, false), (PsiElement)initializer);
                    } else {
                        this.myContext.setTypeIsGuessed(true);
                        this.evaluateCachedTypes(initializer);
                    }
                } else {
                    PsiElement grandParent;
                    boolean hasSomeInfoAboutVar = false;
                    if (expression.getQualifier() == null) {
                        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(expression.getText(), true, new ResolveResultSink(null, expression.getText()));
                        hasSomeInfoAboutVar = this.findDef(expression, processor);
                    }
                    if (!hasSomeInfoAboutVar && parameterType == null && (grandParent = jsVariable.getParent().getParent()) instanceof JSForInStatement && jsVariable.getParent() == ((JSForInStatement)grandParent).getDeclarationStatement()) {
                        parameterType = this.getLoopVarType(expression, (PsiElement)jsVariable, (JSForInStatement)grandParent);
                    }
                    if (!hasSomeInfoAboutVar && parameterType == null) {
                        this.myTypeProcessor.setUnknownElement((PsiElement)jsVariable);
                    }
                }
            }
        }
        if (!haveExplicitType || !JSTypeUtils.isStrictType(parameterType)) {
            this.addNamespaceFromQualifiedNamedElement((JSQualifiedNamedElement)jsVariable);
        }
        this.myContext.setTypeIsGuessed(wasGuessed);
    }

    protected JSType substituteThisType(JSType type, JSVariable jsVariable) {
        return type;
    }

    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        PsiReference[] references;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromAmdModuleReference"));
        }
        boolean result = false;
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(parameter);
        if (amdModuleReference != null && (references = amdModuleReference.getReferences()).length > 0) {
            PsiElement resolve = references[references.length - 1].resolve();
            if (resolve instanceof JSFile) {
                this.addTypeFromModuleFile((JSFile)resolve);
                result = true;
            } else if (resolve instanceof JSImplicitElement && JSAmdPsiUtil.isAmdModuleName((JSImplicitElement)resolve)) {
                PsiElement parent = resolve.getParent();
                assert (parent instanceof JSLiteralExpression);
                String moduleName = ((JSImplicitElement)resolve).getName();
                JSType type = JSNamedType.createType(moduleName, JSTypeSourceFactory.createTypeSource(resolve, true), JSContext.STATIC);
                this.addType(type, EXPLICIT_TYPE_MARKER_ELEMENT);
                result = true;
            }
        }
        return result;
    }

    protected boolean useVariableType(JSType type) {
        return type != null;
    }

    protected boolean isFromCurrentFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "isFromCurrentFile"));
        }
        JSReferenceExpression context = this.myContext.getProcessedExpression();
        if (context == null) {
            context = this.myContext.targetFile;
        }
        return context != null && context.getContainingFile().isEquivalentTo((PsiElement)element.getContainingFile());
    }

    protected void evaluateCachedTypes(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "evaluateCachedTypes"));
        }
        if (this.myContext.wasPrototypeReferenced() || !this.myContext.isJSElementsToApplyEmpty()) {
            this.evaluateTypes(expression);
            return;
        }
        JSTypeEvaluationResult result = JSTypeEvaluator.getExpressionType(expression);
        if (result != null) {
            List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                this.addTypeEvaluationResultElement(element);
            }
        }
    }

    protected boolean addTypeFromElementResolveResult(PsiElement resolveResult, boolean hasSomeType) {
        if (resolveResult instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolveResult;
            boolean typeAdded = false;
            String typeString = implicitElement.getTypeString();
            if (typeString != null) {
                JSType type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource(resolveResult, true));
                this.addType(type, resolveResult);
                typeAdded = true;
            }
            if (!typeAdded && implicitElement.getType().providesNamespace()) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(resolveResult, implicitElement.isNamespaceExplicitlyDeclared());
                JSType jsType = JSNamedType.createType(implicitElement.getQualifiedName(), typeSource, JSContext.STATIC);
                this.addType(jsType, resolveResult);
            } else {
                JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)implicitElement), JSContext.STATIC, implicitElement.isNamespaceExplicitlyDeclared());
                this.addNamespace(namespace, resolveResult);
            }
            return true;
        }
        if (resolveResult instanceof JSProperty) {
            hasSomeType |= this.addTypeFromProperty((JSProperty)resolveResult);
        } else if (resolveResult instanceof JSClass || resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor() && resolveResult.getParent() instanceof JSClass) {
            this.addTypeFromClass(resolveResult, null);
            hasSomeType = true;
        } else if (resolveResult instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)resolveResult, false);
        } else if (resolveResult instanceof JSDefinitionExpression) {
            JSType parameterType = null;
            PsiElement resolveResultParent = resolveResult.getParent();
            if (resolveResultParent instanceof JSForInStatement && resolveResult == ((JSForInStatement)resolveResultParent).getVariableExpression()) {
                parameterType = this.getLoopVarType(this.myContext.getProcessedExpression(), resolveResult, (JSForInStatement)resolveResultParent);
            }
            if (parameterType == null) {
                this.addTypeFromDefExpr((JSDefinitionExpression)resolveResult);
            }
            hasSomeType = true;
        } else if (this.addTypeFromDialectSpecificElements(resolveResult)) {
            hasSomeType = true;
        } else if (resolveResult instanceof JSFunction) {
            if (this.processFunction((JSFunction)resolveResult)) {
                hasSomeType = true;
            }
        } else if (resolveResult instanceof JSNamedElement) {
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)resolveResult);
            if (name != null) {
                JSType jsType = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(resolveResult), JSContext.STATIC);
                this.addType(jsType, resolveResult);
            }
        } else if (resolveResult instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression((JSExpression)resolveResult);
            hasSomeType = true;
        } else if (resolveResult instanceof JSExpressionStatement) {
            String s = JSDocumentationUtils.findType(resolveResult);
            if (BaseJSSymbolProcessor.isValidType(s)) {
                this.addType(JSImportHandlingUtil.resolveTypeName(s, resolveResult), null);
                hasSomeType = true;
            }
        } else if (resolveResult instanceof JsonElement) {
            this.myTypeProcessor.processResolvedElement(resolveResult, this.myContext);
            hasSomeType = true;
        }
        if (!hasSomeType && resolveResult != null) {
            this.myTypeProcessor.setUnknownElement(resolveResult);
        }
        return hasSomeType;
    }

    private boolean addTypeFromProperty(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromProperty"));
        }
        boolean typeAdded = false;
        JSType jsType = property.getType();
        if (jsType != null) {
            this.addType(jsType, (PsiElement)property);
            typeAdded = true;
        } else if (this.tryAddTypeFromInitializerReference((PsiElement)property)) {
            typeAdded = true;
        } else {
            JSExpression value;
            String qualifiedName;
            JSFunction functionInitializer = property.tryGetFunctionInitializer();
            JSObjectLiteralExpression objectLiteralExpression = property.getObjectLiteralExpressionInitializer();
            boolean providesNamespace = functionInitializer != null && !functionInitializer.isGetProperty() && !functionInitializer.isSetProperty() || objectLiteralExpression != null;
            boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)property);
            if (!isTypeScript && providesNamespace && (qualifiedName = property.getQualifiedName()) != null) {
                JSType type = JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)property, false), JSContext.STATIC);
                this.addType(type, (PsiElement)property);
                typeAdded = true;
            }
            if (functionInitializer != null || objectLiteralExpression != null) {
                boolean wasGuessed = this.myContext.isTypeGuessed();
                this.myContext.setTypeIsGuessed(!isTypeScript);
                if (functionInitializer != null) {
                    typeAdded |= this.processFunction(functionInitializer);
                } else {
                    this.addTypeFromObjectLiteralExpression(objectLiteralExpression, false);
                }
                this.myContext.setTypeIsGuessed(wasGuessed);
            } else if (this.isFromCurrentFile((PsiElement)property) && (value = property.getValue()) != null) {
                this.evaluateCachedTypes(value);
            }
        }
        return typeAdded;
    }

    protected void addNamespaceFromQualifiedNamedElement(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addNamespaceFromQualifiedNamedElement"));
        }
        JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)element), JSContext.STATIC, false);
        this.addNamespace(namespace, (PsiElement)element);
    }

    protected void addTypeFromClass(@NotNull PsiElement resolveResult, @Nullable PsiElement constructor) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromClass"));
        }
    }

    private JSType getLoopVarType(@Nullable JSReferenceExpression expression, PsiElement element, JSForInStatement forInStatement) {
        JSType parameterType;
        if (forInStatement.isForEach()) {
            parameterType = this.evalComponentTypeFromArrayExpression((JSExpression)expression, forInStatement.getCollectionExpression());
        } else {
            parameterType = JSNamedType.createType("string", JSTypeSourceFactory.createTypeSource(element, DialectDetector.isTypeScript(element)), JSContext.INSTANCE);
            this.addType(parameterType, element);
        }
        return parameterType;
    }

    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        return false;
    }

    @Nullable
    public JSType evalComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        JSTypeEvaluationResult result;
        if (collectionExpression != null && (result = JSTypeEvaluator.getExpressionType(collectionExpression)) != null) {
            List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
            if (this.myTypeProcessor instanceof ResolveProcessor) {
                for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                    PsiElement source = element.getSource();
                    if (!(source instanceof JSArrayLiteralExpression)) continue;
                    for (JSExpression expr : ((JSArrayLiteralExpression)source).getExpressions()) {
                        if (!(expr instanceof JSObjectLiteralExpression)) continue;
                        this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expr, false);
                    }
                }
            }
            return this.addComponentTypeFromProcessor(rawqualifier, result.getType());
        }
        return null;
    }

    @Nullable
    protected JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) != null) {
            if (type instanceof JSCompositeTypeImpl) {
                for (JSType typeOption : ((JSCompositeTypeImpl)type).getTypes()) {
                    this.addComponentTypeFromProcessor(rawqualifier, typeOption);
                }
                return null;
            }
            JSTypeSource source = type.getSource();
            if ((type = JSTypeUtils.getComponentType(type)) == null) {
                type = JSAnyType.get((PsiElement)rawqualifier, false);
            }
            type = JSTypeUtils.copyWithNewSource(type, source);
            this.addType(type, (PsiElement)rawqualifier);
            return type;
        }
        return null;
    }

    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromLiteralExpression"));
        }
        JSType type = JSTypeEvaluator.getTypeFromConstant(rawqualifier, this.myEcma);
        if (type != null) {
            this.addType(type, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    public static JSType getTypeFromConstant(@NotNull JSExpression rawqualifier, boolean ecma) {
        String literalText;
        String text;
        String type;
        if (rawqualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawqualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getTypeFromConstant"));
        }
        ASTNode childNode = rawqualifier.getNode().getFirstChildNode();
        IElementType constantType = childNode.getElementType();
        String string = constantType == JSTokenTypes.STRING_LITERAL || constantType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL || constantType == JSTokenTypes.BACKQUOTE ? "string" : (constantType == JSTokenTypes.NUMERIC_LITERAL ? "number" : (constantType == JSTokenTypes.REGEXP_LITERAL ? "RegExp" : (constantType == JSTokenTypes.XML_START_TAG_START ? "XML" : (constantType == JSTokenTypes.XML_START_TAG_LIST ? "XMLList" : (constantType == JSTokenTypes.TRUE_KEYWORD || constantType == JSTokenTypes.FALSE_KEYWORD ? "boolean" : (constantType == JSTokenTypes.NULL_KEYWORD && !ecma ? "null" : (type = constantType == JSTokenTypes.UNDEFINED_KEYWORD && !ecma ? "undefined" : null)))))));
        if (type == "number" && ecma && (text = childNode.getText()).indexOf(46) == -1) {
            type = "int";
        }
        if ((type == "XMLList" || type == "XML") && DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            type = null;
        }
        if (type == "string" && (literalText = childNode.getText()).length() >= 2) {
            return new JSStringLiteralTypeImpl(literalText.substring(1, literalText.length() - 1), JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true));
        }
        if (type != null) {
            return JSNamedType.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        }
        return null;
    }

    private void addAdditionalTypes(@NotNull JSReferenceExpression localQualifier, @NotNull JSReferenceExpression qualifier) {
        JSTypeSource typeSource;
        JSElement peek;
        if (localQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localQualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addAdditionalTypes"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addAdditionalTypes"));
        }
        if (DialectDetector.isTypeScript((PsiElement)localQualifier)) {
            return;
        }
        String localQualifierText = localQualifier.getText();
        if ("$".equals(localQualifierText) || "jQuery.$".equals(localQualifierText)) {
            peek = this.myContext.peekJSElementToApply();
            if (peek instanceof JSCallExpression) {
                this.myContext.popJSElementToApply();
            }
            typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)localQualifier, false);
            this.addType(JSNamedType.createType("jQuery", typeSource, JSContext.UNKNOWN), (PsiElement)localQualifier);
            if (peek instanceof JSCallExpression) {
                this.myContext.pushJSElementToApply(peek);
            }
        }
        if ("$".equals(qualifier.getText())) {
            peek = this.myContext.peekJSElementToApply();
            if (peek instanceof JSCallExpression) {
                this.myContext.popJSElementToApply();
            }
            typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)localQualifier, false);
            this.addType(JSNamedType.createType("HTMLElement", typeSource, JSContext.UNKNOWN), (PsiElement)localQualifier);
            if (peek instanceof JSCallExpression) {
                this.myContext.pushJSElementToApply(peek);
            }
        } else if ("getComponentById".equals(qualifier.getReferencedName())) {
            this.tryAddBindowsType(qualifier);
        }
    }

    private void tryAddBindowsType(JSReferenceExpression qualifier) {
        JSIndexContent content;
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies;
        PsiFile containingFile;
        PsiElement element = qualifier.getParent();
        if (!(element instanceof JSCallExpression)) {
            return;
        }
        JSArgumentList argumentList = ((JSCallExpression)element).getArgumentList();
        if (argumentList == null) {
            return;
        }
        JSExpression[] expressions = argumentList.getArguments();
        if (expressions.length == 0 || !(expressions[0] instanceof JSLiteralExpression)) {
            return;
        }
        String val = StringUtil.stripQuotesAroundValue((String)expressions[0].getText());
        PsiElement contextElement = qualifier.getContainingFile().getContext();
        if (contextElement != null && JSTypeEvaluator.isBindowsXml(containingFile = contextElement.getContainingFile()) && (proxies = (content = JSIndexContent.get(containingFile)).getImplicitElements().get(val)) != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                XmlTag tag;
                PsiElement elementAtOffset = new JSOffsetBasedImplicitElement(proxy.getBuilder(), proxy.getOffset(), containingFile).getElementAtOffset();
                if (elementAtOffset == null || (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, XmlTag.class)) == null) continue;
                JSType type = JSNamedType.createType("Bi" + tag.getLocalName(), JSTypeSourceFactory.createTypeSource(elementAtOffset), JSContext.UNKNOWN);
                this.myTypeProcessor.process(type, this.myContext, elementAtOffset);
            }
        }
    }

    public static boolean isBindowsXml(PsiFile containingFile) {
        return containingFile.getName().endsWith(".xml") && containingFile instanceof XmlFile;
    }

    @Nullable
    private static String getElementQName(JSNamedElement psiElement) {
        String name = null;
        if (psiElement instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        if (name == null) {
            name = psiElement.getName();
        }
        return name;
    }

    private void addTypeFromObjectLiteralExpression(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        if (this.myContext.peekJSElementToApply() instanceof JSDestructuringProperty) {
            JSDestructuringProperty pop = (JSDestructuringProperty)this.myContext.popJSElementToApply();
            String name = pop.getName();
            JSProperty property = expression.findProperty(name);
            if (property != null) {
                this.addTypeFromProperty(property);
            }
            this.myContext.pushJSElementToApply((JSElement)pop);
            return;
        }
        JSRecordType recordType = JSTypeEvaluator.getObjectLiteralType(expression, evaluatePropertyTypes);
        this.myTypeProcessor.process((JSType)recordType, contextHolder.get(), (PsiElement)expression);
        for (String extendedType : expression.getExtendedTypes()) {
            JSNamespace namespace = JSNamespaceImpl.fromNamepath(extendedType, true);
            this.addNamespace(namespace, (PsiElement)expression);
        }
    }

    @NotNull
    private static JSRecordType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSProperty[] properties = expression.getProperties();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, DialectDetector.isTypeScript((PsiElement)expression));
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        for (JSProperty property : properties) {
            String name = property.getName();
            if (name == null && property instanceof JSComputedPropertyNameOwner) {
                name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)property);
            }
            if (name == null) continue;
            TypeScriptJSFunctionTypeImpl type = null;
            if (evaluatePropertyTypes) {
                type = property instanceof ES6FunctionProperty ? TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl((JSFunction)((ES6FunctionProperty)property)) : JSResolveUtil.getExpressionJSType(property.getValue());
            }
            typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, (PsiElement)property));
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(typeSource, typeMembers);
        if (jSRecordTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "getObjectLiteralType"));
        }
        return jSRecordTypeImpl;
    }

    private boolean findDef(@NotNull JSReferenceExpression qualifier, @NotNull SinkResolveProcessor processor) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "findDef"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "findDef"));
        }
        PsiElement parent = qualifier.getParent();
        JSResolveUtil.treeWalkUp(processor, (PsiElement)qualifier, parent, (PsiElement)qualifier);
        PsiElement jsElement = processor.getResult();
        if (jsElement instanceof JSDefinitionExpression) {
            this.addTypeFromDefExpr((JSDefinitionExpression)jsElement);
            return true;
        }
        return false;
    }

    private void addTypeFromDefExpr(@NotNull JSDefinitionExpression psiElement) {
        JSExpression expr;
        JSFunctionExpression initializer;
        boolean canHaveType;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "addTypeFromDefExpr"));
        }
        JSType jsType = psiElement.getType();
        if (jsType != null) {
            this.addType(jsType, (PsiElement)psiElement);
            if (jsType.getSource().isExplicitlyDeclared()) {
                return;
            }
        }
        boolean bl = canHaveType = (initializer = psiElement.tryGetFunctionExpressionInitializer()) != null && !this.myContext.isJSElementsToApplyEmpty();
        if (canHaveType && this.processFunction((JSFunction)initializer)) {
            return;
        }
        String type = psiElement.getQualifiedName();
        boolean initializerProcessed = false;
        if (this.isFromCurrentFile((PsiElement)psiElement) && !this.myContext.ensureProcessed(type) && (expr = JSPsiImplUtils.getRightmostOperand(psiElement)) != null) {
            this.evaluateCachedTypes(expr);
            initializerProcessed = true;
        }
        if (!canHaveType && jsType == null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)psiElement);
        }
        if (!initializerProcessed && this.tryAddTypeFromInitializerReference((PsiElement)psiElement)) {
            return;
        }
        if (psiElement.isNamespaceExplicitlyDeclared() && type != null) {
            JSContext jsContext = this.myContext.wasPrototypeReferenced() ? JSContext.INSTANCE : JSContext.STATIC;
            JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)psiElement);
            boolean explicitType = comment != null && comment.hasNamespaceTag();
            JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(type), jsContext, explicitType);
            this.addNamespace(namespace, (PsiElement)(explicitType ? EXPLICIT_TYPE_MARKER_ELEMENT : psiElement));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAddTypeFromInitializerReference(@NotNull PsiElement resolveResult) {
        String initializerReference;
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator", "tryAddTypeFromInitializerReference"));
        }
        String string = resolveResult instanceof JSDefinitionExpression ? ((JSDefinitionExpression)resolveResult).getInitializerReference() : (resolveResult instanceof JSProperty ? ((JSProperty)resolveResult).getInitializerReference() : (initializerReference = resolveResult instanceof JSVariable ? ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText() : null));
        if (initializerReference == null || StringUtil.isQuotedString((String)initializerReference)) {
            return false;
        }
        PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult.getParent());
        if (localResolve instanceof JSQualifiedNamedElement) {
            if (this.myContext.isAlreadyProcessingItem(localResolve)) {
                return true;
            }
            try {
                this.myContext.addProcessingItem(localResolve);
                this.addTypeFromResolveResult(localResolve, false);
            }
            finally {
                this.myContext.removeProcessingItem(localResolve);
            }
            return true;
        }
        return false;
    }

    private void simpleEvalType(JSExpression rawqualifier, JSExpression lOperand) {
        JSType evaluatedType = JSResolveUtil.getExpressionJSType(lOperand);
        if (evaluatedType != null) {
            this.addType(evaluatedType, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }
}

