/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.validation.UnusedImportsUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveResultSink
extends ResultSink {
    private final String myName;
    private PsiElement myCandidateResult;
    private String myCandidateResultProblem;
    private List<JSImportStatement> myImportsUsed;
    private List<String> myResolveStatus;
    private final boolean myAcceptAllResults;

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "<init>"));
        }
        this(place, name, false);
    }

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name, boolean acceptAllResults) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "<init>"));
        }
        super(place);
        this.myName = name;
        this.myAcceptAllResults = acceptAllResults;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public PsiElement getResult() {
        PsiElement result = super.getResult();
        if (result == null && this.myCandidateResult != null) {
            assert (super.getResults() == null);
            return this.myCandidateResult;
        }
        return result;
    }

    public PsiElement getCompleteResult() {
        return super.getResult();
    }

    @Override
    public List<PsiElement> getResults() {
        SmartList results = super.getResults();
        if (results == null && super.getResult() == null && this.myCandidateResult != null) {
            results = new SmartList();
            results.add(this.myCandidateResult);
            this.myResolveStatus = new SmartList();
            this.myResolveStatus.add(this.myCandidateResultProblem);
        }
        return results;
    }

    @Override
    public boolean accepts(PsiElement element) {
        if (element instanceof PsiNamedElement && !this.myName.equals(ResolveProcessor.getName(element))) {
            return false;
        }
        if (element instanceof ES6ImportExportSpecifier && !this.myName.equals(((ES6ImportExportSpecifier)element).getReferenceName())) {
            return false;
        }
        return super.accepts(element);
    }

    @Override
    public boolean addResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        ReadWriteAccessDetector.Access expressionAccess;
        JSFunction fun;
        List<PsiElement> results = super.getResults();
        int previousResultsSize = results != null ? results.size() : 0;
        this.fillImports(element, state, resolveProcessor, previousResultsSize);
        if (this.myAcceptAllResults) {
            super.addResult(element, state, resolveProcessor);
            return true;
        }
        boolean stopProcessing = true;
        PsiElement elementForPropertyProcessing = element;
        if (element instanceof JSProperty) {
            elementForPropertyProcessing = ((JSProperty)element).tryGetFunctionInitializer();
        }
        if (this.place != null && elementForPropertyProcessing instanceof JSFunction && ((fun = (JSFunction)elementForPropertyProcessing).isGetProperty() || fun.isSetProperty()) && (expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(this.place)) == ReadWriteAccessDetector.Access.ReadWrite) {
            PsiElement psiElement;
            if (previousResultsSize == 0) {
                stopProcessing = false;
            }
            if (previousResultsSize == 1 && (psiElement = results.get(0)) instanceof JSFunction) {
                JSFunction prevFun = (JSFunction)psiElement;
                if (prevFun.isGetProperty() && fun.isGetProperty()) {
                    return true;
                }
                if (prevFun.isSetProperty() && fun.isSetProperty()) {
                    return true;
                }
            }
            if (previousResultsSize == 2) {
                return true;
            }
        }
        super.addResult(element, state, resolveProcessor);
        return !stopProcessing;
    }

    public void fillImports(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor, int previousResultsSize) {
        JSImportStatement s = state != null ? (JSImportStatement)state.get(ResolveProcessor.IMPORT_KEY) : null;
        if ((s = this.checkQualifiedNameHasNecessaryImport(element, s, previousResultsSize, resolveProcessor)) != null || this.myImportsUsed != null) {
            if (this.myImportsUsed == null) {
                this.myImportsUsed = new SmartList();
                for (int i = 0; i < previousResultsSize; ++i) {
                    this.myImportsUsed.add(null);
                }
            }
            this.myImportsUsed.add(s);
        }
    }

    private JSImportStatement checkQualifiedNameHasNecessaryImport(PsiElement element, JSImportStatement s, int previousResultsSize, SinkResolveProcessor resolveProcessor) {
        PsiElement placeTopParent;
        if (s == null && this.isActionScript() && (element instanceof JSClass || element instanceof JSFunction || element instanceof JSVariable || element instanceof JSNamespaceDeclaration) && (placeTopParent = resolveProcessor.getPlaceTopParent()) instanceof JSReferenceExpression && !(placeTopParent.getParent() instanceof JSImportStatement)) {
            String qName;
            if (placeTopParent.getParent() instanceof JSNewExpression && element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
                element = element.getParent();
            }
            String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
            if (qName != null && qName.indexOf(46) != -1 && !JSResolveUtil.getPackageName(element).equals(JSResolveUtil.getPackageNameFromPlace(this.place)) && !UnusedImportsUtil.isSomeNodeThatShouldNotHaveImportsWhenQualified((JSReferenceExpression)placeTopParent, element)) {
                boolean noImportNoResolve;
                SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(this.myName, new ResolveResultSink(null, this.myName)){

                    @Override
                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$1", "execute"));
                        }
                        if (element instanceof JSQualifiedNamedElement) {
                            if (!qName.equals(((JSQualifiedNamedElement)element).getQualifiedName())) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                        return super.execute(element, state);
                    }
                };
                processor.putUserData(ResolveProcessor.ASKING_FOR_QUALIFIED_IMPORT, qName);
                PsiNamedElement importOwner = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)placeTopParent, (Class[])new Class[]{JSFunction.class, JSFile.class, JSPackageStatement.class, JSClass.class});
                if (importOwner != null) {
                    PsiElement elt = PsiTreeUtil.getChildOfAnyType((PsiElement)importOwner, (Class[])new Class[]{PsiWhiteSpace.class});
                    if (elt == null) {
                        elt = importOwner.getFirstChild();
                    }
                    JSResolveUtil.treeWalkUp(processor, (PsiElement)importOwner, elt, this.place);
                }
                boolean bl = noImportNoResolve = processor.getResult() == null;
                if (noImportNoResolve) {
                    if (this.myResolveStatus == null) {
                        this.myResolveStatus = new ArrayList<String>(3);
                        for (int i = 0; i < previousResultsSize; ++i) {
                            this.myResolveStatus.add(null);
                        }
                    }
                    this.myResolveStatus.add("javascript.qualified.name.is.not.imported.message");
                } else {
                    ResolveResult[] resultsAsResolveResults = ((ResolveResultSink)processor.getResultSink()).getResultsAsResolveResults();
                    if (resultsAsResolveResults.length != 0) {
                        s = ((JSResolveResult)resultsAsResolveResults[0]).getImportUsed();
                    }
                }
            }
        }
        return s;
    }

    @Override
    public int getResultCount() {
        int resultCount = super.getResultCount();
        if (resultCount == 0 && this.myCandidateResult != null) {
            resultCount = 1;
        }
        return resultCount;
    }

    public ResolveResult[] getResultsAsResolveResults() {
        List<PsiElement> processorResults = this.getResults();
        if (processorResults == null || processorResults.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        TIntHashSet es6ImportsUsed = new TIntHashSet();
        processorResults = ResolveResultSink.resolveImportExportSpecifiers(processorResults, es6ImportsUsed);
        ResolveResult[] results = new ResolveResult[processorResults.size()];
        for (int i = 0; i < results.length; ++i) {
            PsiElement element = processorResults.get(i);
            results[i] = new JSResolveResult(element, this.myImportsUsed != null ? this.myImportsUsed.get(i) : null, this.myResolveStatus != null ? this.myResolveStatus.get(i) : null, es6ImportsUsed.contains(i));
        }
        return results;
    }

    private static List<PsiElement> resolveImportExportSpecifiers(List<PsiElement> results, TIntHashSet outES6ImportsUsed) {
        Collection newCollection = null;
        for (int i = 0; i < results.size(); ++i) {
            PsiElement element = results.get(i);
            if (element instanceof ES6ImportExportSpecifier) {
                ResolveResult[] newResults = ((PsiPolyVariantReference)element).multiResolve(false);
                if (newResults.length == 0) {
                    if (newCollection == null) continue;
                    newCollection.add(element);
                    continue;
                }
                if (newCollection == null) {
                    newCollection = ContainerUtil.newLinkedHashSet();
                    if (i > 0) {
                        newCollection.addAll(results.subList(0, i - 1));
                    }
                }
                for (ResolveResult result : newResults) {
                    outES6ImportsUsed.add(newCollection.size());
                    PsiElement resultElement = result.getElement();
                    newCollection.add(resultElement);
                }
                continue;
            }
            if (newCollection == null) continue;
            newCollection.add(element);
        }
        return newCollection == null ? results : ContainerUtil.newArrayList(newCollection);
    }

    @NotNull
    public List<ResolveResult> getCompleteResults() {
        List<PsiElement> processorResults = super.getResults();
        if (processorResults == null || processorResults.isEmpty()) {
            List<ResolveResult> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "getCompleteResults"));
            }
            return list;
        }
        ArrayList<ResolveResult> results = new ArrayList<ResolveResult>(processorResults.size());
        for (int i = 0; i < processorResults.size(); ++i) {
            PsiElement element = processorResults.get(i);
            results.add(new JSResolveResult(element, this.myImportsUsed != null ? this.myImportsUsed.get(i) : null, this.myResolveStatus != null ? this.myResolveStatus.get(i) : null));
        }
        ArrayList<ResolveResult> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/ResolveResultSink", "getCompleteResults"));
        }
        return arrayList;
    }

    @Nullable
    public JSResolveResult getCandidateResult() {
        return this.myCandidateResult != null ? new JSResolveResult(this.myCandidateResult, null, this.myCandidateResultProblem) : null;
    }

    @Override
    public void addPossibleCandidateResult(PsiElement element, @Nullable String problemKey) {
        this.myCandidateResult = element;
        this.myCandidateResultProblem = problemKey;
    }
}

