/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SinkResolveProcessor<T extends ResultSink>
extends ResolveProcessor {
    private boolean myToStopOnAssignment;
    @NotNull
    private final T myResultSink;
    private PsiElement placeTopParent;
    private String myPackageName;
    private boolean myForcedPackage;
    private boolean myCheckArgumentTypes;

    public SinkResolveProcessor(@NotNull T sink) {
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor", "<init>"));
        }
        this(((ResultSink)sink).getName(), ((ResultSink)sink).place, sink);
    }

    public SinkResolveProcessor(String name, boolean toStopOnAssignment, @NotNull T sink) {
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor", "<init>"));
        }
        this(name, sink);
        this.myToStopOnAssignment = toStopOnAssignment;
    }

    public SinkResolveProcessor(String name, T sink) {
        this(name, null, sink);
    }

    public SinkResolveProcessor(String name, PsiElement _place, @NotNull T sink) {
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor", "<init>"));
        }
        super(name, _place);
        this.myResultSink = sink;
    }

    public PsiElement getResult() {
        return ((ResultSink)this.myResultSink).getResult();
    }

    @Nullable
    public List<PsiElement> getResults() {
        return ((ResultSink)this.myResultSink).getResults();
    }

    public PsiElement getPlaceTopParent() {
        return this.placeTopParent;
    }

    public void setForcedPackageName(String forcedPackageName) {
        this.myPackageName = forcedPackageName;
        this.myForcedPackage = forcedPackageName != null;
    }

    public void setCheckArgumentTypes(boolean checkArgumentTypes) {
        this.myCheckArgumentTypes = checkArgumentTypes;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        PsiElement parent;
        ASTNode nameIdentifier;
        block37: {
            block36: {
                PsiElement function;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor", "execute"));
                }
                if (!((ResultSink)this.myResultSink).accepts(element)) {
                    return true;
                }
                if (!this.accessibilityProcessingHandler.accepts(element, this)) {
                    return true;
                }
                if (this.myCheckArgumentTypes) {
                    function = this.checkParameterTypes(element);
                    if (function == null) {
                        return false;
                    }
                    element = function;
                }
                if (this.place != null && element instanceof JSFunction && !(element instanceof JSFunctionExpression)) {
                    function = (JSFunction)element;
                    ReadWriteAccessDetector.Access context = this.doSetterProcessing(this.place);
                    if (context == ReadWriteAccessDetector.Access.Write || this.place instanceof JSFunction && ((JSFunction)this.place).isSetProperty()) {
                        JSClass clazz;
                        if (!(!function.isGetProperty() || this.myName == null && this.place.getParent() instanceof JSExpressionStatement && (clazz = JSUtils.getMemberContainingClass(function)) instanceof JSClass && clazz.findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.SETTER) == null)) {
                            this.addPossibleCandidateResult(element, "javascript.property.is.read.only.message");
                            return true;
                        }
                    } else if (context == ReadWriteAccessDetector.Access.Read && function.isSetProperty() && !(this.place instanceof PsiFile) && !(this.place instanceof JSClass)) {
                        this.addPossibleCandidateResult(element, "javascript.property.is.write.only.message");
                        return true;
                    }
                }
                if (this.place != null && element instanceof JSProperty) {
                    JSProperty property = (JSProperty)element;
                    ReadWriteAccessDetector.Access access = this.doSetterProcessing(this.place);
                    if (access == ReadWriteAccessDetector.Access.Write && property.isGetProperty()) {
                        this.addPossibleCandidateResult(element, "javascript.property.is.read.only.message");
                        return true;
                    }
                    if (access == ReadWriteAccessDetector.Access.Read && property.isSetProperty()) {
                        this.addPossibleCandidateResult(element, "javascript.property.is.write.only.message");
                        return true;
                    }
                }
                if (this.place == null || !SinkResolveProcessor.completeConstructorName(this.place) && !(this.place instanceof JSSuperExpression)) break block36;
                if (element instanceof JSClass && this.myName != null) {
                    JSFunction constructor;
                    if (this.myCheckArgumentTypes) {
                        ResolveResult resolveResult = TypeScriptUtil.resolveConstructorMatchingArguments((JSClass)element, this.place);
                        if (!resolveResult.isValidResult()) {
                            this.addPossibleCandidateResult(resolveResult.getElement(), "javascript.argument.types.mismatch");
                            return true;
                        }
                        PsiElement constrOrClass = resolveResult.getElement();
                        constructor = constrOrClass instanceof JSFunction && JSResolveUtil.findParent(constrOrClass) == element ? (JSFunction)constrOrClass : null;
                    } else {
                        constructor = ((JSClass)element).getConstructor();
                    }
                    if (constructor != null) {
                        element = constructor;
                    }
                    break block37;
                } else if (element instanceof JSFunction && ((JSFunction)element).isConstructor() && this.myName == null) {
                    return true;
                }
                break block37;
            }
            if (element instanceof JSFunction && ((JSFunction)element).isConstructor() && JSResolveUtil.findParent(element) instanceof JSClass && !(this.place instanceof JSClass)) {
                return true;
            }
        }
        if (this.nearestVarWeAreIn == element) {
            if (!(this.myResultSink instanceof ResolveResultSink)) return true;
            if (!SinkResolveProcessor.isSpecialCallResolveCaseEcmaScript(this.place, this.place != null ? this.place.getParent() : null)) {
                return true;
            }
        }
        if (this.placeTopParent == null && this.place != null) {
            this.placeTopParent = JSResolveUtil.getTopReferenceExpression(this.place);
        }
        if (this.placeTopParent instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)this.placeTopParent) && this.place != this.placeTopParent && !JSResolveUtil.isInsideArtificialAttrList((JSReferenceExpression)this.placeTopParent)) {
            if (element instanceof JSVariable) return true;
            if (element instanceof JSFunction) {
                return true;
            }
        }
        boolean checkStopOnMatch = false;
        boolean doStopOnMatch = false;
        PsiElement elementToCheck = element;
        if (elementToCheck instanceof JSFunctionExpression && ((nameIdentifier = ((JSFunctionExpression)element).findNameIdentifier()) == null || nameIdentifier.getPsi().getParent() != element) && (parent = elementToCheck.getParent()) instanceof JSAssignmentExpression) {
            elementToCheck = ((JSAssignmentExpression)parent).getLOperand();
        }
        if (elementToCheck instanceof JSDefinitionExpression && !this.isProcessingFromIndices()) {
            boolean toProcess = false;
            JSExpression expression = ((JSDefinitionExpression)elementToCheck).getExpression();
            if (!(this.accessibilityProcessingHandler.isProcessStatics() || !(expression instanceof JSReferenceExpression) || ((JSReferenceExpression)expression).getQualifier() != null || ((ResultSink)this.myResultSink).isActionScript() || !this.myToStopOnAssignment && JSResolveUtil.isEcmaScript5(element))) {
                toProcess = true;
            }
            if (!toProcess) {
                return true;
            }
            checkStopOnMatch = true;
            doStopOnMatch = this.myToStopOnAssignment;
        }
        if (!(element instanceof PsiNamedElement)) {
            if (!(element instanceof ES6ImportSpecifier)) return true;
            if (!this.isSpecifierAcceptable((ES6ImportExportSpecifier)((ES6ImportSpecifier)element))) return true;
            return ((ResultSink)this.myResultSink).addResult(element, state, this);
        }
        element = SinkResolveProcessor.getElement(element);
        if (checkStopOnMatch && !doStopOnMatch) {
            this.addPossibleCandidateResult(element, null);
            return true;
        }
        if (this.myPackageName == null) {
            String string = this.myPackageName = this.place != null ? JSResolveUtil.getPackageNameFromPlace(this.place) : "";
        }
        if (this.myForcedPackage) {
            if (JSResolveUtil.isAccessibleFromPackage(element, this.myPackageName)) return ((ResultSink)this.myResultSink).addResult(element, state, this);
        } else if (JSResolveUtil.isAccessibleFromCurrentPackage(element, this.myPackageName, this.place)) return ((ResultSink)this.myResultSink).addResult(element, state, this);
        this.elementIsNotAccessible(element);
        return true;
    }

    protected boolean isSpecifierAcceptable(ES6ImportExportSpecifier specifier) {
        return true;
    }

    public void addPossibleCandidateResult(PsiElement element, String s) {
        ((ResultSink)this.myResultSink).addPossibleCandidateResult(element, s);
    }

    protected void elementIsNotAccessible(PsiElement element) {
        this.addPossibleCandidateResult(element, "javascript.element.is.not.accessible.message");
    }

    @Override
    protected void startingParent(PsiElement associated) {
        ((ResultSink)this.myResultSink).startingParent(associated, this);
        super.startingParent(associated);
    }

    protected PsiElement checkParameterTypes(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor", "checkParameterTypes"));
        }
        return element;
    }

    private ReadWriteAccessDetector.Access doSetterProcessing(PsiElement place) {
        if (this.myName == null && place.getParent() instanceof JSExpressionStatement) {
            return ReadWriteAccessDetector.Access.Write;
        }
        return place != null ? JSReadWriteAccessDetector.ourInstance.getExpressionAccess(place) : ReadWriteAccessDetector.Access.Read;
    }

    private static PsiElement getElement(PsiElement element) {
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getAttribute("name").getValueElement().getChildren()[1];
        }
        return element;
    }

    public ResolveResult[] getResultsAsResolveResults() {
        return ((ResolveResultSink)this.myResultSink).getResultsAsResolveResults();
    }

    public void addResult(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor", "addResult"));
        }
        ((ResultSink)this.myResultSink).addResult(element, ResolveState.initial(), this);
    }

    @NotNull
    public final T getResultSink() {
        T t = this.myResultSink;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/SinkResolveProcessor", "getResultSink"));
        }
        return t;
    }

    @Override
    public boolean skipTopLevelItems() {
        return ((ResultSink)this.myResultSink).skipTopLevelItems();
    }

    @Override
    public boolean needTopLevelClassName(String name) {
        return ((ResultSink)this.myResultSink).needTopLevelClassName(name);
    }
}

