/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportValueAccessibilityChecker
extends JSAccessibilityChecker {
    public static final ES6ExportValueAccessibilityChecker INSTANCE = new ES6ExportValueAccessibilityChecker();
    private static final Collection<Class<? extends JSElement>> myClasses = ContainerUtil.newArrayList((Object[])new Class[]{ES6ExportSpecifier.class, ES6ExportSpecifierAlias.class});

    @Override
    @NotNull
    protected Collection<Class<? extends JSElement>> getSuitableClasses() {
        Collection<Class<? extends JSElement>> collection = myClasses;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/accessibility/ES6ExportValueAccessibilityChecker", "getSuitableClasses"));
        }
        return collection;
    }

    @Override
    @Nullable
    protected String checkImpl(@Nullable PsiElement place, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/accessibility/ES6ExportValueAccessibilityChecker", "checkImpl"));
        }
        if (place != null && element.getContainingFile().isEquivalentTo((PsiElement)place.getContainingFile())) {
            return "javascript.element.is.export.only";
        }
        return null;
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor resolveProcessor) {
        return handler.isAcceptOnlyExportedSymbols();
    }
}

