/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.NullableEnumStructureElement;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileCachedData {
    private static final BooleanStructureElement COMMON_JS_FLAG = new BooleanStructureElement();
    private static final NullableEnumStructureElement<JSTestFileType> TEST_FILE_FLAG = new NullableEnumStructureElement<JSTestFileType>(JSTestFileType.class);
    private static final BooleanStructureElement HAS_ES6_SYNTAX_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(COMMON_JS_FLAG, TEST_FILE_FLAG, HAS_ES6_SYNTAX_FLAG);
    private byte myFlags;
    private Set<String> myReferencedPaths;
    private Map<String, String> myImportReferences;
    private JSType myExportsInnerAlias;

    public void setIsCommonJSModule() {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, COMMON_JS_FLAG, true, this.myFlags);
    }

    public void setTestFileType(@Nullable JSTestFileType testFileType) {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, TEST_FILE_FLAG, testFileType, this.myFlags);
    }

    public void setHasES6Syntax() {
        this.myFlags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_ES6_SYNTAX_FLAG, true, this.myFlags);
    }

    public void setReferencedPaths(Set<String> referencedPaths) {
        this.myReferencedPaths = referencedPaths;
    }

    public void setImportReferences(Map<String, String> importReferences) {
        this.myImportReferences = importReferences;
    }

    public boolean isCommonJSModule() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, COMMON_JS_FLAG, this.myFlags);
    }

    @Nullable
    public JSTestFileType getTestFileType() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, TEST_FILE_FLAG, this.myFlags);
    }

    public boolean hasES6Syntax() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_ES6_SYNTAX_FLAG, this.myFlags);
    }

    @NotNull
    public Set<String> getReferencedPaths() {
        Set<String> set = this.myReferencedPaths != null ? this.myReferencedPaths : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData", "getReferencedPaths"));
        }
        return set;
    }

    public void addReferencedPath(String filePath) {
        if (this.myReferencedPaths == null) {
            this.myReferencedPaths = new THashSet();
        }
        this.myReferencedPaths.add(filePath);
    }

    @NotNull
    public Map<String, String> getImportReferences() {
        Map<String, String> map = this.myImportReferences != null ? this.myImportReferences : Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData", "getImportReferences"));
        }
        return map;
    }

    public void addImportReference(@NotNull String importName, @NotNull String value) {
        if (importName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importName", "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData", "addImportReference"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData", "addImportReference"));
        }
        if (this.myImportReferences == null) {
            this.myImportReferences = new THashMap();
        }
        this.myImportReferences.put(importName, value);
    }

    @Nullable
    public JSType getExportsInnerAlias() {
        return this.myExportsInnerAlias;
    }

    public void setExportsInnerAlias(JSType exportsInnerAlias) {
        this.myExportsInnerAlias = exportsInnerAlias;
    }

    public void serialize(@NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/psi/stubs/impl/JSFileCachedData", "serialize"));
        }
        dataStream.writeByte((int)this.myFlags);
        Set<String> referencedPaths = this.getReferencedPaths();
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)referencedPaths.size());
        for (String referencedFile : referencedPaths) {
            dataStream.writeUTFFast(referencedFile);
        }
        Map<String, String> importReferences = this.getImportReferences();
        DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)importReferences.size());
        for (Map.Entry<String, String> importReference : importReferences.entrySet()) {
            dataStream.writeUTFFast(importReference.getKey());
            dataStream.writeUTFFast(importReference.getValue());
        }
        dataStream.writeUTFFast(this.myExportsInnerAlias != null ? this.myExportsInnerAlias.getTypeText(JSType.TypeTextFormat.SERIALIZED) : "");
    }

    public static JSFileCachedData deserialize(StubInputStream dataStream) throws IOException {
        JSFileCachedData cachedData = new JSFileCachedData();
        cachedData.myFlags = dataStream.readByte();
        int referencedFilesCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        THashSet referencedPaths = new THashSet(referencedFilesCount);
        for (int i = 0; i < referencedFilesCount; ++i) {
            String referencedFile = dataStream.readUTFFast();
            referencedPaths.add(referencedFile);
        }
        cachedData.setReferencedPaths((Set<String>)referencedPaths);
        int importsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
        THashMap importReferences = new THashMap(importsCount);
        for (int i = 0; i < importsCount; ++i) {
            String importQName = dataStream.readUTFFast();
            String importReference = dataStream.readUTFFast();
            importReferences.put(importQName, importReference);
        }
        cachedData.setImportReferences((Map<String, String>)importReferences);
        String exportsInnerAliasString = dataStream.readUTFFast();
        cachedData.setExportsInnerAlias(JSTypeUtils.createType(exportsInnerAliasString, JSTypeSource.EMPTY));
        return cachedData;
    }
}

