/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileStubImpl
extends PsiFileStubImpl<JSFile>
implements PsiFileStub<JSFile> {
    private final Language myLanguage;
    @Nullable
    private volatile JSFileCachedData myData;

    public JSFileStubImpl(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubImpl", "<init>"));
        }
        super((PsiFile)file);
        this.myLanguage = file.getLanguage();
        if (file instanceof JSFileBaseImpl) {
            this.myData = ((JSFileBaseImpl)file).tryGetCachedData();
        }
    }

    public JSFileStubImpl(Language language, @NotNull JSFileCachedData cachedData) {
        if (cachedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedData", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubImpl", "<init>"));
        }
        super(null);
        this.myLanguage = language;
        this.myData = cachedData;
    }

    public IStubFileElementType getType() {
        return JSFileElementType.getByLanguage(this.myLanguage);
    }

    @Nullable
    public JSFileCachedData getCachedData() {
        return this.myData;
    }

    public void setCachedData(@NotNull JSFileCachedData cachedData) {
        if (cachedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedData", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubImpl", "setCachedData"));
        }
        this.myData = cachedData;
    }

    public Language getLanguage() {
        return this.myLanguage;
    }
}

